/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.criteria.FlexibleConstraintCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.ToolBox;

public class MaxConsecutiveDaysFlexibleConstraint
extends FlexibleConstraint {
    private int iMaxDays;

    public MaxConsecutiveDaysFlexibleConstraint(Long id, String owner, String preference, String reference) {
        super(id, owner, preference, reference);
        Matcher matcher = Pattern.compile(FlexibleConstraint.FlexibleConstraintType.MAX_CONSECUTIVE_DAYS.getPattern()).matcher(reference);
        if (matcher.find()) {
            this.iMaxDays = Integer.parseInt(matcher.group(2));
            this.iConstraintType = FlexibleConstraint.FlexibleConstraintType.MAX_CONSECUTIVE_DAYS;
        }
    }

    @Override
    public double getNrViolations(Assignment<Lecture, Placement> assignment, Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        return ((MaxConsecutiveDaysFlexibleConstraintContext)this.getContext(assignment)).nrViolations(assignments, conflicts);
    }

    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!this.isHard()) {
            return;
        }
        MaxConsecutiveDaysFlexibleConstraintContext context = (MaxConsecutiveDaysFlexibleConstraintContext)this.getContext(assignment);
        while (context.nrDays(value, conflicts) > this.iMaxDays && !conflicts.contains((Object)value)) {
            Set<Lecture> candidates = context.candidates(value, conflicts);
            if (candidates == null) {
                conflicts.add(value);
                return;
            }
            for (Lecture candidate : candidates) {
                Placement conflict = (Placement)assignment.getValue((Variable)candidate);
                if (conflict == null) continue;
                conflicts.add(conflict);
            }
        }
    }

    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement value) {
        if (!this.isHard()) {
            return false;
        }
        return ((MaxConsecutiveDaysFlexibleConstraintContext)this.getContext(assignment)).nrDays(value, null) > this.iMaxDays;
    }

    @Override
    public FlexibleConstraint.FlexibleConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new MaxConsecutiveDaysFlexibleConstraintContext(assignment);
    }

    public class MaxConsecutiveDaysFlexibleConstraintContext
    extends FlexibleConstraint.FlexibleConstraintContext {
        private Map<BitSet, Set<Lecture>[]> iWeekDayAssignments = null;
        private Set<Lecture>[] iDayAssignments = null;

        public MaxConsecutiveDaysFlexibleConstraintContext(Assignment<Lecture, Placement> assignment) {
            Criterion criterion;
            for (BitSet week : MaxConsecutiveDaysFlexibleConstraint.this.getWeeks()) {
                Set<Lecture>[] dayAssignments = this.getDayAssignments(week);
                for (Lecture variable : MaxConsecutiveDaysFlexibleConstraint.this.variables()) {
                    Placement value = (Placement)assignment.getValue((Variable)variable);
                    if (value == null) continue;
                    for (int i = 0; i < dayAssignments.length; ++i) {
                        if (!this.overlaps(week, i, value)) continue;
                        dayAssignments[i].add((Lecture)value.variable());
                    }
                }
            }
            if (!MaxConsecutiveDaysFlexibleConstraint.this.isHard() && (criterion = MaxConsecutiveDaysFlexibleConstraint.this.getModel().getCriterion(FlexibleConstraintCriterion.class)) != null) {
                double pref = this.nrViolations(null, null);
                this.iLastPreference = pref == 0.0 ? (double)(-Math.abs(MaxConsecutiveDaysFlexibleConstraint.this.iPreference)) : (double)Math.abs(MaxConsecutiveDaysFlexibleConstraint.this.iPreference) * pref;
                criterion.inc(assignment, this.iLastPreference);
            }
        }

        protected boolean overlaps(BitSet week, int dayOfWeek, Placement value) {
            if (value == null || value.getTimeLocation() == null) {
                return false;
            }
            if (MaxConsecutiveDaysFlexibleConstraint.this.isPreciseDateComputation()) {
                return value.getTimeLocation().hasDate(dayOfWeek, week, MaxConsecutiveDaysFlexibleConstraint.this.getDayOfWeekOffset());
            }
            if (week != null && !value.getTimeLocation().getWeekCode().intersects(week)) {
                return false;
            }
            return (value.getTimeLocation().getDayCode() & Constants.DAY_CODES[dayOfWeek]) != 0;
        }

        protected Set<Lecture>[] getDayAssignments(BitSet week) {
            Set<Lecture>[] dayAssignments;
            if (week == null) {
                if (this.iDayAssignments == null) {
                    this.iDayAssignments = new Set[Constants.NR_DAYS];
                    for (int i = 0; i < this.iDayAssignments.length; ++i) {
                        this.iDayAssignments[i] = new HashSet<Lecture>();
                    }
                }
                return this.iDayAssignments;
            }
            if (this.iWeekDayAssignments == null) {
                this.iWeekDayAssignments = new HashMap<BitSet, Set<Lecture>[]>();
            }
            if ((dayAssignments = this.iWeekDayAssignments.get(week)) == null) {
                dayAssignments = new Set[Constants.NR_DAYS];
                for (int i = 0; i < dayAssignments.length; ++i) {
                    dayAssignments[i] = new HashSet<Lecture>();
                }
                this.iWeekDayAssignments.put(week, dayAssignments);
            }
            return dayAssignments;
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            for (BitSet week : MaxConsecutiveDaysFlexibleConstraint.this.getWeeks()) {
                Set<Lecture>[] dayAssignments = this.getDayAssignments(week);
                for (int i = 0; i < dayAssignments.length; ++i) {
                    if (!this.overlaps(week, i, value)) continue;
                    dayAssignments[i].add((Lecture)value.variable());
                }
            }
            this.updateCriterion(assignment);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement value) {
            for (BitSet week : MaxConsecutiveDaysFlexibleConstraint.this.getWeeks()) {
                Set<Lecture>[] dayAssignments = this.getDayAssignments(week);
                for (int i = 0; i < dayAssignments.length; ++i) {
                    if (!this.overlaps(week, i, value)) continue;
                    dayAssignments[i].remove(value.variable());
                }
            }
            this.updateCriterion(assignment);
        }

        public int nrDays(BitSet week, Placement value, Set<Placement> conflicts) {
            Set<Lecture>[] dayAssignments = this.getDayAssignments(week);
            Integer min = null;
            Integer max = null;
            for (int i = 0; i < dayAssignments.length; ++i) {
                int cnt = dayAssignments[i].size();
                if (value != null) {
                    if (this.overlaps(week, i, value)) {
                        ++cnt;
                    }
                    if (dayAssignments[i].contains(value.variable())) {
                        --cnt;
                    }
                }
                if (conflicts != null) {
                    for (Placement conflict : conflicts) {
                        if (value != null && ((Lecture)conflict.variable()).equals(value.variable()) || !dayAssignments[i].contains(conflict.variable())) continue;
                        --cnt;
                    }
                }
                if (cnt <= 0) continue;
                if (min == null) {
                    min = i;
                }
                max = i;
            }
            if (min == null) {
                return 0;
            }
            return max - min + 1;
        }

        public int nrDays(Placement value, Set<Placement> conflicts) {
            int ret = 0;
            for (BitSet week : MaxConsecutiveDaysFlexibleConstraint.this.getWeeks()) {
                int days = this.nrDays(week, value, conflicts);
                if (days <= ret) continue;
                ret = days;
            }
            return ret;
        }

        public Set<Lecture> candidates(Placement value, Set<Placement> conflicts) {
            for (BitSet week : MaxConsecutiveDaysFlexibleConstraint.this.getWeeks()) {
                Set<Lecture>[] dayAssignments = this.getDayAssignments(week);
                Integer min = null;
                Integer max = null;
                Integer minThisPl = null;
                Integer maxThisPl = null;
                for (int i = 0; i < dayAssignments.length; ++i) {
                    int cnt = dayAssignments[i].size();
                    if (this.overlaps(week, i, value)) {
                        if (minThisPl == null) {
                            minThisPl = i;
                        }
                        maxThisPl = i;
                        ++cnt;
                    }
                    if (dayAssignments[i].contains(value.variable())) {
                        --cnt;
                    }
                    for (Placement conflict : conflicts) {
                        if (((Lecture)conflict.variable()).equals(value.variable()) || !dayAssignments[i].contains(conflict.variable())) continue;
                        --cnt;
                    }
                    if (cnt <= 0) continue;
                    if (min == null) {
                        min = i;
                    }
                    max = i;
                }
                if (min == null || max - min + 1 <= MaxConsecutiveDaysFlexibleConstraint.this.iMaxDays) continue;
                if (!(minThisPl != null && min >= minThisPl || maxThisPl != null && maxThisPl >= max)) {
                    if (ToolBox.random() <= 0.5) {
                        return dayAssignments[min];
                    }
                    return dayAssignments[max];
                }
                if (minThisPl == null || min < minThisPl) {
                    return dayAssignments[min];
                }
                if (maxThisPl != null && maxThisPl >= max) continue;
                return dayAssignments[max];
            }
            return null;
        }

        public int nrViolations(BitSet week, HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
            Set<Lecture>[] dayAssignments = this.getDayAssignments(week);
            Integer min = null;
            Integer max = null;
            for (int i = 0; i < dayAssignments.length; ++i) {
                int cnt = dayAssignments[i].size();
                if (assignments != null) {
                    for (Map.Entry entry : assignments.entrySet()) {
                        Placement assignment = (Placement)((Object)entry.getValue());
                        if (assignment == null || !this.overlaps(week, i, assignment)) continue;
                        ++cnt;
                    }
                }
                if (conflicts != null) {
                    for (Placement placement : conflicts) {
                        if (assignments != null && assignments.containsKey(placement.variable()) || !dayAssignments[i].contains(placement.variable())) continue;
                        --cnt;
                    }
                }
                if (cnt <= 0) continue;
                if (min == null) {
                    min = i;
                }
                max = i;
            }
            if (min == null) {
                return 0;
            }
            return max - min + 1 <= MaxConsecutiveDaysFlexibleConstraint.this.iMaxDays ? 0 : max - min + 1 - MaxConsecutiveDaysFlexibleConstraint.this.iMaxDays;
        }

        public int nrViolations(HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
            int ret = 0;
            for (BitSet week : MaxConsecutiveDaysFlexibleConstraint.this.getWeeks()) {
                ret += this.nrViolations(week, assignments, conflicts);
            }
            return ret;
        }
    }
}

