/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.text.DecimalFormat;
import java.util.ArrayList;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;

public class ExamPeriodUsage {
    private ExamModel iModel = null;
    public static int[] sLimits = new int[]{10, 50, 100, 200};
    private static DecimalFormat sDF = new DecimalFormat("0.00");

    public ExamPeriodUsage(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        ArrayList<CSVFile.CSVField> header = new ArrayList<CSVFile.CSVField>();
        header.add(new CSVFile.CSVField((Object)"Period"));
        header.add(new CSVFile.CSVField((Object)"Date"));
        header.add(new CSVFile.CSVField((Object)"Time"));
        header.add(new CSVFile.CSVField((Object)"Weight"));
        header.add(new CSVFile.CSVField((Object)"NrExams"));
        header.add(new CSVFile.CSVField((Object)"Students"));
        for (int i = 0; i < sLimits.length; ++i) {
            header.add(new CSVFile.CSVField((Object)("NrExams>=" + sLimits[i])));
        }
        header.add(new CSVFile.CSVField((Object)"AvgPeriod"));
        header.add(new CSVFile.CSVField((Object)"WgAvgPeriod"));
        csv.setHeader(header);
        for (ExamPeriod period : this.iModel.getPeriods()) {
            int nrExams = 0;
            int nrStudents = 0;
            int[] nrExamsLim = new int[sLimits.length];
            int totAvgPer = 0;
            int nrAvgPer = 0;
            int totWgAvgPer = 0;
            for (int i = 0; i < sLimits.length; ++i) {
                nrExamsLim[i] = 0;
            }
            for (Exam exam : this.iModel.variables()) {
                ExamPlacement placement = (ExamPlacement)assignment.getValue((Variable)exam);
                if (placement == null || !placement.getPeriod().equals(period)) continue;
                ++nrExams;
                nrStudents += exam.getStudents().size();
                if (exam.getAveragePeriod() >= 0) {
                    totAvgPer += exam.getAveragePeriod();
                    ++nrAvgPer;
                    totWgAvgPer += exam.getAveragePeriod() * exam.getStudents().size();
                }
                for (int i = 0; i < sLimits.length; ++i) {
                    if (exam.getStudents().size() < sLimits[i]) continue;
                    int n = i;
                    nrExamsLim[n] = nrExamsLim[n] + 1;
                }
            }
            ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
            line.add(new CSVFile.CSVField(period.getIndex() + 1));
            line.add(new CSVFile.CSVField((Object)period.getDayStr()));
            line.add(new CSVFile.CSVField((Object)period.getTimeStr()));
            line.add(new CSVFile.CSVField(period.getPenalty()));
            line.add(new CSVFile.CSVField(nrExams));
            line.add(new CSVFile.CSVField(nrStudents));
            for (int i = 0; i < sLimits.length; ++i) {
                line.add(new CSVFile.CSVField(nrExamsLim[i]));
            }
            if (nrAvgPer > 0) {
                line.add(new CSVFile.CSVField((Object)sDF.format((double)totAvgPer / (double)nrAvgPer)));
                line.add(new CSVFile.CSVField((Object)sDF.format((double)totWgAvgPer / (double)nrAvgPer)));
            }
            csv.addLine(line);
        }
        return csv;
    }
}

