/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.reservation;

import org.cpsolver.ifs.util.Query;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.reservation.Reservation;

public class UniversalOverride
extends Reservation {
    private double iLimit;
    private String iFilter;
    private boolean iOverride;
    private transient Query iStudentQuery;
    public static final int DEFAULT_PRIORITY = 350;
    public static final boolean DEFAULT_MUST_BE_USED = false;
    public static final boolean DEFAULT_CAN_ASSIGN_OVER_LIMIT = false;
    public static final boolean DEFAULT_ALLOW_OVERLAP = false;

    public UniversalOverride(long id, boolean override, double limit, Offering offering, String filter) {
        super(id, offering, 350, false, false, false);
        this.iOverride = override;
        this.iLimit = limit;
        this.iFilter = filter;
    }

    @Override
    public boolean mustBeUsed() {
        if (this.iOverride) {
            return this.mustBeUsedIgnoreExpiration();
        }
        return super.mustBeUsed();
    }

    @Override
    public double getReservationLimit() {
        return this.iLimit;
    }

    public void setReservationLimit(double limit) {
        this.iLimit = limit;
    }

    public boolean isOverride() {
        return this.iOverride;
    }

    public String getFilter() {
        return this.iFilter;
    }

    @Override
    public boolean isApplicable(Student student, Course course) {
        return this.iFilter != null && !this.iFilter.isEmpty() && this.getStudentQuery().match(new StudentMatcher(student, course));
    }

    public Query getStudentQuery() {
        if (this.iStudentQuery == null) {
            this.iStudentQuery = new Query(this.iFilter);
        }
        return this.iStudentQuery;
    }

    public static class StudentMatcher
    implements Query.TermMatcher {
        private Student iStudent;
        private Course iCourse;

        public StudentMatcher(Student student, Course course) {
            this.iStudent = student;
            this.iCourse = course;
        }

        public StudentMatcher(Student student) {
            this(student, null);
        }

        public Student student() {
            return this.iStudent;
        }

        @Override
        public boolean match(String attr, String term) {
            block27: {
                block43: {
                    block42: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        block37: {
                                            block36: {
                                                block35: {
                                                    block34: {
                                                        block33: {
                                                            block32: {
                                                                block31: {
                                                                    block30: {
                                                                        block29: {
                                                                            block28: {
                                                                                block26: {
                                                                                    if (attr == null && term.isEmpty()) {
                                                                                        return true;
                                                                                    }
                                                                                    if ("limit".equals(attr)) {
                                                                                        return true;
                                                                                    }
                                                                                    if (!"area".equals(attr)) break block26;
                                                                                    for (AreaClassificationMajor acm : this.student().getAreaClassificationMajors()) {
                                                                                        if (!this.like(acm.getArea(), term)) continue;
                                                                                        return true;
                                                                                    }
                                                                                    break block27;
                                                                                }
                                                                                if (!"clasf".equals(attr) && !"classification".equals(attr)) break block28;
                                                                                for (AreaClassificationMajor acm : this.student().getAreaClassificationMajors()) {
                                                                                    if (!this.like(acm.getClassification(), term)) continue;
                                                                                    return true;
                                                                                }
                                                                                break block27;
                                                                            }
                                                                            if (!"campus".equals(attr)) break block29;
                                                                            for (AreaClassificationMajor acm : this.student().getAreaClassificationMajors()) {
                                                                                if (!this.like(acm.getCampus(), term)) continue;
                                                                                return true;
                                                                            }
                                                                            break block27;
                                                                        }
                                                                        if (!"major".equals(attr)) break block30;
                                                                        for (AreaClassificationMajor acm : this.student().getAreaClassificationMajors()) {
                                                                            if (!this.like(acm.getMajor(), term)) continue;
                                                                            return true;
                                                                        }
                                                                        break block27;
                                                                    }
                                                                    if (!"group".equals(attr)) break block31;
                                                                    for (StudentGroup aac : this.student().getGroups()) {
                                                                        if (!this.like(aac.getReference(), term)) continue;
                                                                        return true;
                                                                    }
                                                                    break block27;
                                                                }
                                                                if (!"accommodation".equals(attr)) break block32;
                                                                for (String aac : this.student().getAccommodations()) {
                                                                    if (!this.like(aac, term)) continue;
                                                                    return true;
                                                                }
                                                                break block27;
                                                            }
                                                            if ("student".equals(attr)) {
                                                                return this.has(this.student().getName(), term) || this.eq(this.student().getExternalId(), term) || this.eq(this.student().getName(), term);
                                                            }
                                                            if ("advisor".equals(attr)) {
                                                                for (Instructor a : this.student().getAdvisors()) {
                                                                    if (!this.eq(a.getExternalId(), term)) continue;
                                                                    return true;
                                                                }
                                                                return false;
                                                            }
                                                            if (!"minor".equals(attr)) break block33;
                                                            for (AreaClassificationMajor acm : this.student().getAreaClassificationMinors()) {
                                                                if (!this.like(acm.getMajor(), term)) continue;
                                                                return true;
                                                            }
                                                            break block27;
                                                        }
                                                        if ("status".equals(attr)) {
                                                            if ("default".equalsIgnoreCase(term) || "Not Set".equalsIgnoreCase(term)) {
                                                                return this.student().getStatus() == null;
                                                            }
                                                            return this.like(this.student().getStatus(), term);
                                                        }
                                                        if (!"concentration".equals(attr)) break block34;
                                                        for (AreaClassificationMajor acm : this.student().getAreaClassificationMajors()) {
                                                            if (!this.like(acm.getConcentration(), term)) continue;
                                                            return true;
                                                        }
                                                        break block27;
                                                    }
                                                    if (!"degree".equals(attr)) break block35;
                                                    for (AreaClassificationMajor acm : this.student().getAreaClassificationMajors()) {
                                                        if (!this.like(acm.getDegree(), term)) continue;
                                                        return true;
                                                    }
                                                    break block27;
                                                }
                                                if (!"program".equals(attr)) break block36;
                                                for (AreaClassificationMajor acm : this.student().getAreaClassificationMajors()) {
                                                    if (!this.like(acm.getProgram(), term)) continue;
                                                    return true;
                                                }
                                                break block27;
                                            }
                                            if (!"primary-area".equals(attr)) break block37;
                                            AreaClassificationMajor acm = this.student().getPrimaryMajor();
                                            if (acm != null && this.like(acm.getArea(), term)) {
                                                return true;
                                            }
                                            break block27;
                                        }
                                        if (!"primary-clasf".equals(attr) && !"primary-classification".equals(attr)) break block38;
                                        AreaClassificationMajor acm = this.student().getPrimaryMajor();
                                        if (acm != null && this.like(acm.getClassification(), term)) {
                                            return true;
                                        }
                                        break block27;
                                    }
                                    if (!"primary-major".equals(attr)) break block39;
                                    AreaClassificationMajor acm = this.student().getPrimaryMajor();
                                    if (acm != null && this.like(acm.getMajor(), term)) {
                                        return true;
                                    }
                                    break block27;
                                }
                                if (!"primary-concentration".equals(attr)) break block40;
                                AreaClassificationMajor acm = this.student().getPrimaryMajor();
                                if (acm != null && this.like(acm.getConcentration(), term)) {
                                    return true;
                                }
                                break block27;
                            }
                            if (!"primary-degree".equals(attr)) break block41;
                            AreaClassificationMajor acm = this.student().getPrimaryMajor();
                            if (acm != null && this.like(acm.getDegree(), term)) {
                                return true;
                            }
                            break block27;
                        }
                        if (!"primary-program".equals(attr)) break block42;
                        AreaClassificationMajor acm = this.student().getPrimaryMajor();
                        if (acm != null && this.like(acm.getProgram(), term)) {
                            return true;
                        }
                        break block27;
                    }
                    if (!"primary-campus".equals(attr)) break block43;
                    AreaClassificationMajor acm = this.student().getPrimaryMajor();
                    if (acm != null && this.like(acm.getCampus(), term)) {
                        return true;
                    }
                    break block27;
                }
                if ("course".equals(attr)) {
                    return this.iCourse != null && this.like(this.iCourse.getName(), term);
                }
                if (attr == null) break block27;
                for (StudentGroup aac : this.student().getGroups()) {
                    if (!this.eq(aac.getType(), attr.replace('_', ' ')) || !this.like(aac.getReference(), term)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" |,")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }

        private boolean like(String name, String term) {
            if (name == null) {
                return false;
            }
            if (term.indexOf(37) >= 0) {
                return name.matches("(?i)" + term.replaceAll("%", ".*"));
            }
            return name.equalsIgnoreCase(term);
        }
    }
}

