/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics;

import java.util.Iterator;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.RoundRobinNeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.filter.PriortyStudentFilter;
import org.cpsolver.studentsct.heuristics.RestoreBestSolution;
import org.cpsolver.studentsct.heuristics.RouletteWheelRequestSelection;
import org.cpsolver.studentsct.heuristics.selection.AssignInitialSelection;
import org.cpsolver.studentsct.heuristics.selection.BacktrackSelection;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.heuristics.selection.CriticalBacktrackSelection;
import org.cpsolver.studentsct.heuristics.selection.CriticalCoursesBranchAndBoundSelection;
import org.cpsolver.studentsct.heuristics.selection.CriticalStandardSelection;
import org.cpsolver.studentsct.heuristics.selection.MinCreditBranchAndBoundSelection;
import org.cpsolver.studentsct.heuristics.selection.PriorityConstructionSelection;
import org.cpsolver.studentsct.heuristics.selection.RandomUnassignmentSelection;
import org.cpsolver.studentsct.heuristics.selection.ResectionIncompleteStudentsSelection;
import org.cpsolver.studentsct.heuristics.selection.ResectionUnassignedStudentsSelection;
import org.cpsolver.studentsct.heuristics.selection.RndUnProblStudSelection;
import org.cpsolver.studentsct.heuristics.selection.ShuffleStudentsSelection;
import org.cpsolver.studentsct.heuristics.selection.StandardSelection;
import org.cpsolver.studentsct.heuristics.selection.StudentEnrollmentSwapSelection;
import org.cpsolver.studentsct.heuristics.selection.SwapStudentSelection;
import org.cpsolver.studentsct.heuristics.selection.UnassignedRequestSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class StudentSctNeighbourSelection
extends RoundRobinNeighbourSelection<Request, Enrollment>
implements SolverListener<Request, Enrollment> {
    private boolean iUseConstruction = false;
    private boolean iUseCriticalCoursesSelection = true;
    private boolean iUseMinCreditSelection = true;
    private boolean iMPP = false;
    private boolean iShuffleStudentsSelection = false;
    private boolean iPriorityStudentsFirstSelection = true;
    private boolean iPriorityStudentsFirstAllIn = true;
    private int iPriorityRounds = 1;
    private int iCriticalRounds = 1;
    private boolean iPriorityLastRoundAllStudents = false;

    public StudentSctNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
        this.iUseConstruction = properties.getPropertyBoolean("Sectioning.UsePriorityConstruction", this.iUseConstruction);
        this.iUseCriticalCoursesSelection = properties.getPropertyBoolean("Sectioning.UseCriticalCoursesSelection", this.iUseCriticalCoursesSelection);
        this.iUseMinCreditSelection = properties.getPropertyBoolean("Sectioning.UseMinCreditSelection", this.iUseMinCreditSelection);
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        this.iShuffleStudentsSelection = properties.getPropertyBoolean("Shuffle.Enabled", true) && properties.getPropertyBoolean("Load.RequestGroups", false);
        this.iPriorityStudentsFirstSelection = properties.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection", this.iPriorityStudentsFirstSelection);
        this.iPriorityStudentsFirstAllIn = properties.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection.AllIn", this.iPriorityStudentsFirstAllIn);
        this.iCriticalRounds = properties.getPropertyInt("Sectioning.CriticalRounds", this.iCriticalRounds);
        this.iPriorityRounds = properties.getPropertyInt("Sectioning.PriorityRounds", this.iPriorityRounds);
        this.iPriorityLastRoundAllStudents = properties.getPropertyBoolean("Sectioning.PriorityLastRoundAllStudents", this.iPriorityLastRoundAllStudents);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        super.init(solver);
        this.setup(solver);
        solver.setUpdateProgress(false);
        Iterator<SolverListener<Request, Enrollment>> i = solver.getSolverListeners().iterator();
        while (i.hasNext()) {
            SolverListener<Request, Enrollment> listener = i.next();
            if (!(listener instanceof StudentSctNeighbourSelection)) continue;
            i.remove();
        }
        solver.addSolverListener(this);
    }

    public void setup(Solver<Request, Enrollment> solver) {
        PriortyStudentFilter filter;
        boolean includeHigherPriority;
        int pr;
        if (this.iMPP) {
            this.registerSelection(new AssignInitialSelection(solver.getProperties()));
        }
        if (this.iPriorityStudentsFirstSelection && this.iPriorityStudentsFirstAllIn) {
            if (this.iUseCriticalCoursesSelection) {
                for (Enum enum_ : Student.StudentPriority.values()) {
                    if (enum_ == Student.StudentPriority.Normal) break;
                    for (pr = 0; pr < this.iPriorityRounds; ++pr) {
                        includeHigherPriority = this.iPriorityLastRoundAllStudents && enum_.ordinal() > 0 && pr + 1 == this.iPriorityRounds;
                        filter = new PriortyStudentFilter((Student.StudentPriority)enum_, includeHigherPriority);
                        for (Request.RequestPriority rp : Request.RequestPriority.values()) {
                            for (int cr = 0; cr < this.iCriticalRounds; ++cr) {
                                this.registerSelection(new CriticalCoursesBranchAndBoundSelection(solver.getProperties(), rp).withFilter(filter));
                                this.registerSelection(new CriticalBacktrackSelection(solver.getProperties(), rp).withFilter(filter));
                                this.registerSelection(new CriticalStandardSelection(solver.getProperties(), new UnassignedRequestSelection().withFilter(filter), this.getValueSelection(), rp));
                                this.registerSelection(new CriticalBacktrackSelection(solver.getProperties(), rp).withFilter(filter));
                            }
                        }
                    }
                }
            } else {
                for (Enum enum_ : Student.StudentPriority.values()) {
                    if (enum_ == Student.StudentPriority.Normal) break;
                    for (pr = 0; pr < this.iPriorityRounds; ++pr) {
                        includeHigherPriority = this.iPriorityLastRoundAllStudents && enum_.ordinal() > 0 && pr + 1 == this.iPriorityRounds;
                        filter = new PriortyStudentFilter((Student.StudentPriority)enum_, includeHigherPriority);
                        this.registerSelection(new BranchBoundSelection(solver.getProperties()).withFilter(filter));
                        this.registerSelection(new BacktrackSelection(solver.getProperties()).withFilter(filter));
                        this.registerSelection(new StandardSelection(solver.getProperties(), new UnassignedRequestSelection().withFilter(filter), this.getValueSelection()));
                        this.registerSelection(new BacktrackSelection(solver.getProperties()).withFilter(filter));
                    }
                }
            }
        }
        if (this.iUseCriticalCoursesSelection) {
            for (Enum enum_ : Request.RequestPriority.values()) {
                if (enum_ == Request.RequestPriority.Normal) break;
                for (int cr = 0; cr < this.iCriticalRounds; ++cr) {
                    this.registerSelection(new CriticalCoursesBranchAndBoundSelection(solver.getProperties(), (Request.RequestPriority)enum_));
                    this.registerSelection(new CriticalBacktrackSelection(solver.getProperties(), (Request.RequestPriority)enum_));
                    this.registerSelection(new CriticalStandardSelection(solver.getProperties(), this.getValueSelection(), (Request.RequestPriority)enum_));
                    this.registerSelection(new CriticalBacktrackSelection(solver.getProperties(), (Request.RequestPriority)enum_));
                }
            }
        }
        if (this.iPriorityStudentsFirstSelection && !this.iPriorityStudentsFirstAllIn) {
            for (Enum enum_ : Student.StudentPriority.values()) {
                if (enum_ == Student.StudentPriority.Normal) break;
                if (((StudentSectioningModel)solver.currentSolution().getModel()).getNbrStudents((Student.StudentPriority)enum_) == 0) continue;
                for (pr = 0; pr < this.iPriorityRounds; ++pr) {
                    includeHigherPriority = this.iPriorityLastRoundAllStudents && enum_.ordinal() > 0 && pr + 1 == this.iPriorityRounds;
                    filter = new PriortyStudentFilter((Student.StudentPriority)enum_, includeHigherPriority);
                    this.registerSelection(new BranchBoundSelection(solver.getProperties()).withFilter(filter));
                    this.registerSelection(new BacktrackSelection(solver.getProperties()).withFilter(filter));
                    this.registerSelection(new StandardSelection(solver.getProperties(), new UnassignedRequestSelection().withFilter(filter), this.getValueSelection()));
                    this.registerSelection(new BacktrackSelection(solver.getProperties()).withFilter(filter));
                }
            }
        }
        if (this.iUseMinCreditSelection) {
            this.registerSelection(new MinCreditBranchAndBoundSelection(solver.getProperties()));
        }
        this.registerSelection(this.iUseConstruction && !this.iUseMinCreditSelection ? new PriorityConstructionSelection(solver.getProperties()) : new BranchBoundSelection(solver.getProperties()));
        this.registerSelection(new SwapStudentSelection(solver.getProperties()));
        this.registerSelection(new BacktrackSelection(solver.getProperties()));
        this.registerSelection(new StudentEnrollmentSwapSelection(solver.getProperties()));
        this.registerSelection(new StandardSelection(solver.getProperties(), this.getVariableSelection(), this.getValueSelection()));
        SwapStudentSelection swapStudentSelection = new SwapStudentSelection(solver.getProperties());
        this.registerSelection(swapStudentSelection);
        this.registerSelection(new RndUnProblStudSelection(solver.getProperties(), swapStudentSelection));
        this.registerSelection(new ResectionIncompleteStudentsSelection(solver.getProperties()));
        this.registerSelection(new ResectionUnassignedStudentsSelection(solver.getProperties()));
        this.registerSelection(new SwapStudentSelection(solver.getProperties()));
        this.registerSelection(new StandardSelection(solver.getProperties(), new RouletteWheelRequestSelection(solver.getProperties()), this.getValueSelection()));
        this.registerSelection(new SwapStudentSelection(solver.getProperties()));
        this.registerSelection(new StudentEnrollmentSwapSelection(solver.getProperties()));
        this.registerSelection(new BacktrackSelection(solver.getProperties()));
        if (this.iShuffleStudentsSelection) {
            this.registerSelection(new ShuffleStudentsSelection(solver.getProperties()));
            this.registerSelection(new BacktrackSelection(solver.getProperties()));
        }
        this.registerSelection(new RestoreBestSolution(solver.getProperties()));
        this.registerSelection(new BacktrackSelection(solver.getProperties()));
        this.registerSelection(new BranchBoundSelection(solver.getProperties()));
        this.registerSelection(new RandomUnassignmentSelection(solver.getProperties()));
    }

    @Override
    public void changeSelection(int selectionIndex) {
        super.changeSelection(selectionIndex);
    }

    @Override
    public boolean variableSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable) {
        return true;
    }

    @Override
    public boolean valueSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable, Enrollment value) {
        return true;
    }

    @Override
    public boolean neighbourSelected(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        return true;
    }

    @Override
    public void neighbourFailed(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        NeighbourSelection selection = this.getSelection();
        if (selection instanceof SolverListener) {
            ((SolverListener)((Object)selection)).neighbourFailed(assignment, iteration, neighbour);
        }
    }
}

