/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class LargeExamsPenalty
extends ExamCriterion {
    private int iLargeSize = -1;
    private double iLargePeriod = 0.67;

    @Override
    public String getWeightName() {
        return "Exams.LargeWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "largeWeight";
    }

    @Override
    public void getXmlParameters(Map<String, String> params) {
        params.put(this.getXmlWeightName(), String.valueOf(this.getWeight()));
        params.put("largeSize", String.valueOf(this.getLargeSize()));
        params.put("largePeriod", String.valueOf(this.getLargePeriod()));
    }

    @Override
    public void setXmlParameters(Map<String, String> params) {
        try {
            this.setWeight(Double.valueOf(params.get(this.getXmlWeightName())));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.setLargeSize(Integer.valueOf(params.get("largeSize")));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.setLargePeriod(Double.valueOf(params.get("largePeriod")));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0;
    }

    @Override
    public void configure(DataProperties properties) {
        super.configure(properties);
        this.iLargeSize = properties.getPropertyInt("Exams.LargeSize", this.iLargeSize);
        this.iLargePeriod = properties.getPropertyDouble("Exams.LargePeriod", this.iLargePeriod);
    }

    public int getLargeSize() {
        return this.iLargeSize;
    }

    public void setLargeSize(int largeSize) {
        this.iLargeSize = largeSize;
    }

    public double getLargePeriod() {
        return this.iLargePeriod;
    }

    public void setLargePeriod(double largePeriod) {
        this.iLargePeriod = largePeriod;
    }

    public int getLargePeriodIndex() {
        return (int)Math.round((double)((ExamModel)this.getModel()).getPeriods().size() * this.iLargePeriod);
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        if (this.getLargeSize() < 0 || exam.getSize() < this.getLargeSize()) {
            return 0.0;
        }
        return value.getPeriod().getIndex() >= this.getLargePeriodIndex() ? 1 : 0;
    }

    @Override
    public double[] getBounds(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Exam exam : variables) {
            if (this.getLargeSize() < 0 || exam.getSize() < this.getLargeSize()) continue;
            bounds[1] = bounds[1] + 1.0;
        }
        return bounds;
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.getValue(assignment) <= 0.0 ? "" : "LP:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

