/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.split;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.exam.criteria.RoomPenalty;
import org.cpsolver.exam.criteria.RoomSizePenalty;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.exam.split.ExamSplitter;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class ExamSplitMoves
implements NeighbourSelection<Exam, ExamPlacement> {
    private static Logger sLog = LogManager.getLogger(ExamSplitMoves.class);
    private ExamSplitter iSplitter = null;

    public ExamSplitMoves(DataProperties properties) {
    }

    public void init(Solver<Exam, ExamPlacement> solver) {
        this.iSplitter = (ExamSplitter)solver.currentSolution().getModel().getCriterion(ExamSplitter.class);
        if (this.iSplitter == null) {
            throw new RuntimeException("ExamSplitter criterion needs to be used as well.");
        }
    }

    public Set<ExamRoomPlacement> findBestAvailableRooms(Assignment<Exam, ExamPlacement> assignment, Exam exam, ExamPeriodPlacement period, int examSize) {
        if (exam.getMaxRooms() == 0) {
            return new HashSet<ExamRoomPlacement>();
        }
        double sw = exam.getModel().getCriterion(RoomSizePenalty.class).getWeight();
        double pw = exam.getModel().getCriterion(RoomPenalty.class).getWeight();
        block0: for (int nrRooms = 1; nrRooms <= exam.getMaxRooms(); ++nrRooms) {
            int size;
            int bestSize;
            HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
            for (size = 0; rooms.size() < nrRooms && size < examSize; size += bestSize) {
                int minSize = (examSize - size) / (nrRooms - rooms.size());
                ExamRoomPlacement best = null;
                double bestWeight = 0.0;
                bestSize = 0;
                for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                    if (!room.isAvailable(period.getPeriod()) || !room.getRoom().getPlacements(assignment, period.getPeriod()).isEmpty() || rooms.contains(room)) continue;
                    int s = room.getSize(exam.hasAltSeating());
                    if (s < minSize) break;
                    int p = room.getPenalty(period.getPeriod());
                    double w = pw * (double)p + sw * (double)(s - minSize);
                    double d = 0.0;
                    if (!rooms.isEmpty()) {
                        for (ExamRoomPlacement r : rooms) {
                            d += r.getDistanceInMeters(room);
                        }
                        w += d / (double)rooms.size();
                    }
                    if (best != null && !(bestWeight > w)) continue;
                    best = room;
                    bestSize = s;
                    bestWeight = w;
                }
                if (best == null) continue block0;
                rooms.add(best);
            }
            if (size < examSize) continue;
            return rooms;
        }
        return null;
    }

    public ExamSplitNeighbour bestSplit(Assignment<Exam, ExamPlacement> assignment, Exam exam) {
        ExamSplitNeighbour split = null;
        ExamPlacement placement = (ExamPlacement)assignment.getValue((Variable)exam);
        int px = ToolBox.random((int)exam.getPeriodPlacements().size());
        for (int p = 0; p < exam.getPeriodPlacements().size(); ++p) {
            Set<ExamRoomPlacement> rooms;
            ExamPeriodPlacement period = exam.getPeriodPlacements().get((p + px) % exam.getPeriodPlacements().size());
            if (placement != null && placement.getPeriod().equals(period.getPeriod())) continue;
            ExamSplitNeighbour s = new ExamSplitNeighbour(assignment, exam, new ExamPlacement(exam, period, null));
            if (split != null && !(s.value(assignment) < split.value(assignment)) || (rooms = this.findBestAvailableRooms(assignment, exam, period, s.nrStudents())) == null) continue;
            s.placement().getRoomPlacements().addAll(rooms);
            split = s;
        }
        return split;
    }

    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        ExamMergeNeighbour merge;
        ExamSplitNeighbour split;
        ExamShuffleNeighbour shuffle;
        Exam exam = (Exam)((Object)ToolBox.random((Collection)solution.getAssignment().assignedVariables()));
        Assignment assignment = solution.getAssignment();
        Exam parent = this.iSplitter.parent(exam);
        List<Exam> children = this.iSplitter.children(parent);
        if (children != null && !children.isEmpty() && (shuffle = new ExamShuffleNeighbour((Assignment<Exam, ExamPlacement>)assignment, exam)).value((Assignment<Exam, ExamPlacement>)assignment) < 0.0) {
            return shuffle;
        }
        if (this.iSplitter.canSplit(exam) && (split = this.bestSplit((Assignment<Exam, ExamPlacement>)solution.getAssignment(), exam)) != null && split.value((Assignment<Exam, ExamPlacement>)assignment) < 0.0) {
            return split;
        }
        if (this.iSplitter.canMerge(exam) && (merge = new ExamMergeNeighbour((Assignment<Exam, ExamPlacement>)assignment, exam)).value((Assignment<Exam, ExamPlacement>)assignment) < 0.0) {
            return merge;
        }
        return null;
    }

    protected class ExamShuffleNeighbour
    implements Neighbour<Exam, ExamPlacement> {
        private Exam iExam;
        private double iValue = 0.0;

        public ExamShuffleNeighbour(Assignment<Exam, ExamPlacement> assignment, Exam exam) {
            this.iExam = exam;
            Exam parent = ExamSplitMoves.this.iSplitter.parent(exam);
            List<Exam> children = ExamSplitMoves.this.iSplitter.children(parent);
            for (ExamStudent student : parent.getStudents()) {
                Double delta = null;
                for (Exam x : children) {
                    double d = ExamSplitMoves.this.iSplitter.delta(assignment, student, (ExamPlacement)assignment.getValue((Variable)parent), (ExamPlacement)assignment.getValue((Variable)x));
                    if (delta != null && !(d < delta)) continue;
                    delta = d;
                }
                if (delta == null || !(delta < 0.0)) continue;
                this.iValue += delta.doubleValue();
            }
            for (Exam child : children) {
                for (ExamStudent student : child.getStudents()) {
                    double delta = ExamSplitMoves.this.iSplitter.delta(assignment, student, (ExamPlacement)assignment.getValue((Variable)child), (ExamPlacement)assignment.getValue((Variable)parent));
                    for (Exam x : children) {
                        double d;
                        if (x.equals((Object)child) || !((d = ExamSplitMoves.this.iSplitter.delta(assignment, student, (ExamPlacement)assignment.getValue((Variable)child), (ExamPlacement)assignment.getValue((Variable)x))) < delta)) continue;
                        delta = d;
                    }
                    if (!(delta < 0.0)) continue;
                    this.iValue += delta;
                }
            }
        }

        public void assign(Assignment<Exam, ExamPlacement> assignment, long iteration) {
            sLog.info("Shuffling " + this.iExam.getName() + " (" + ((ExamPlacement)assignment.getValue((Variable)this.iExam)).getName() + ", value: " + this.iValue + ")");
            ExamSplitMoves.this.iSplitter.shuffle(assignment, this.iExam, iteration);
        }

        public double value(Assignment<Exam, ExamPlacement> assignment) {
            return this.iValue;
        }

        public Exam exam() {
            return this.iExam;
        }

        public Map<Exam, ExamPlacement> assignments() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExamMergeNeighbour
    implements Neighbour<Exam, ExamPlacement> {
        private Exam iExam;
        private double iValue = 0.0;

        public ExamMergeNeighbour(Assignment<Exam, ExamPlacement> assignment, Exam exam) {
            this.iExam = exam;
            Exam parent = ExamSplitMoves.this.iSplitter.parent(exam);
            List<Exam> children = ExamSplitMoves.this.iSplitter.children(parent);
            for (ExamStudent student : exam.getStudents()) {
                double delta = ExamSplitMoves.this.iSplitter.delta(assignment, student, (ExamPlacement)assignment.getValue((Variable)exam), (ExamPlacement)assignment.getValue((Variable)parent));
                for (Exam child : children) {
                    double d;
                    if (child.equals((Object)exam) || !((d = ExamSplitMoves.this.iSplitter.delta(assignment, student, (ExamPlacement)assignment.getValue((Variable)exam), (ExamPlacement)assignment.getValue((Variable)child))) < delta)) continue;
                    delta = d;
                }
                this.iValue += delta;
            }
            this.iValue -= ExamSplitMoves.this.iSplitter.getWeight();
        }

        public void assign(Assignment<Exam, ExamPlacement> assignment, long iteration) {
            sLog.info("Mergning " + this.iExam.getName() + " (" + ((ExamPlacement)assignment.getValue((Variable)this.iExam)).getName() + ", value: " + this.iValue + ")");
            ExamSplitMoves.this.iSplitter.merge(assignment, this.iExam, iteration);
        }

        public double value(Assignment<Exam, ExamPlacement> assignment) {
            return this.iValue;
        }

        public int nrStudents() {
            return this.iExam.getStudents().size();
        }

        public Exam exam() {
            return this.iExam;
        }

        public Map<Exam, ExamPlacement> assignments() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExamSplitNeighbour
    implements Neighbour<Exam, ExamPlacement> {
        private Exam iExam;
        private ExamPlacement iPlacement;
        private double iValue = 0.0;
        private int iNrStudents = 0;

        public ExamSplitNeighbour(Assignment<Exam, ExamPlacement> assignment, Exam exam, ExamPlacement placement) {
            this.iExam = exam;
            this.iPlacement = placement;
            Exam parent = ExamSplitMoves.this.iSplitter.parent(exam);
            List<Exam> children = ExamSplitMoves.this.iSplitter.children(parent);
            for (ExamStudent student : parent.getStudents()) {
                double delta = ExamSplitMoves.this.iSplitter.delta(assignment, student, (ExamPlacement)assignment.getValue((Variable)parent), placement);
                if (!(delta < 0.0)) continue;
                this.iValue += delta;
                ++this.iNrStudents;
            }
            if (children != null) {
                for (Exam child : children) {
                    for (ExamStudent student : child.getStudents()) {
                        double delta = ExamSplitMoves.this.iSplitter.delta(assignment, student, (ExamPlacement)assignment.getValue((Variable)child), placement);
                        if (!(delta < 0.0)) continue;
                        this.iValue += delta;
                        ++this.iNrStudents;
                    }
                }
            }
            this.iValue += ExamSplitMoves.this.iSplitter.getWeight();
        }

        public void assign(Assignment<Exam, ExamPlacement> assignment, long iteration) {
            sLog.info("Splitting " + this.iExam.getName() + " (" + ((ExamPlacement)assignment.getValue((Variable)this.iExam)).getName() + ", " + this.iPlacement.getName() + ", value: " + this.iValue + ")");
            ExamSplitMoves.this.iSplitter.split(assignment, this.iExam, iteration, this.iPlacement);
        }

        public double value(Assignment<Exam, ExamPlacement> assignment) {
            return this.iValue;
        }

        public int nrStudents() {
            return this.iNrStudents;
        }

        public Exam exam() {
            return this.iExam;
        }

        public ExamPlacement placement() {
            return this.iPlacement;
        }

        public Map<Exam, ExamPlacement> assignments() {
            throw new UnsupportedOperationException();
        }
    }
}

