/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DataProperties;

public class IgnoredCommittedStudentConflict
extends StudentConflict {
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.IgnoredCommitedStudentConflictWeight", 0.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrIgnoredCommitedStudConfsWeight";
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && IgnoredCommittedStudentConflict.ignore(l1, l2) && IgnoredCommittedStudentConflict.committed(l1, l2);
    }

    public int countCommittedConflicts(Student student, Placement placement) {
        if (student.getCommitedPlacements() == null) {
            return 0;
        }
        int conflicts = 0;
        Lecture lecture = (Lecture)placement.variable();
        for (Placement commitedPlacement : student.getCommitedPlacements()) {
            Lecture commitedLecture = (Lecture)commitedPlacement.variable();
            if (lecture.getSchedulingSubpartId() != null && lecture.getSchedulingSubpartId().equals(commitedLecture.getSchedulingSubpartId()) || !IgnoredCommittedStudentConflict.ignore(lecture, commitedLecture) || !IgnoredCommittedStudentConflict.overlaps(placement, commitedPlacement) && !IgnoredCommittedStudentConflict.distance(this.getMetrics(), placement, commitedPlacement)) continue;
            ++conflicts;
        }
        if (conflicts == 0) {
            return 0;
        }
        double w = student.getOfferingWeight(((Lecture)placement.variable()).getConfiguration());
        return (int)Math.round(student.avg(w, 1.0) * (double)conflicts);
    }

    public double countCommittedConflicts(Placement placement) {
        double ret = 0.0;
        Lecture lecture = (Lecture)placement.variable();
        for (Student student : lecture.students()) {
            ret += (double)this.countCommittedConflicts(student, placement);
        }
        return ret;
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double[] bounds = super.getBounds(assignment, variables);
        for (Lecture lecture : variables) {
            Double max = null;
            for (Placement placement : lecture.values(assignment)) {
                if (max == null) {
                    max = this.countCommittedConflicts(placement);
                    continue;
                }
                max = Math.max(max, this.countCommittedConflicts(placement));
            }
            if (max == null) continue;
            bounds[0] = bounds[0] + max;
        }
        return bounds;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = super.getValue(assignment, value, conflicts);
        ret += this.countCommittedConflicts(value);
        if (this.iIncludeConflicts && conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= this.countCommittedConflicts(conflict);
            }
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double ret = super.getValue(assignment, variables);
        for (Lecture lect : variables) {
            Placement plac = (Placement)assignment.getValue((Variable)lect);
            if (plac == null) continue;
            ret += this.countCommittedConflicts(plac);
        }
        return Math.round(ret);
    }
}

