/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.ConstraintListener;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.IdGenerator;

public abstract class Constraint<V extends Variable<V, T>, T extends Value<V, T>>
implements Comparable<Constraint<V, T>> {
    private static IdGenerator iIdGenerator = new IdGenerator();
    protected long iId = -1L;
    private List<V> iVariables = new ArrayList<V>();
    private Model<V, T> iModel = null;
    protected List<ConstraintListener<V, T>> iConstraintListeners = null;

    public Constraint() {
        this.iId = iIdGenerator.newId();
    }

    public Model<V, T> getModel() {
        return this.iModel;
    }

    public void setModel(Model<V, T> model) {
        this.iModel = model;
    }

    public List<V> variables() {
        return this.iVariables;
    }

    public Collection<V> assignedVariables(Assignment<V, T> assignment) {
        ArrayList<Variable> assigned = new ArrayList<Variable>();
        for (Variable v : this.variables()) {
            if (assignment.getValue(v) == null) continue;
            assigned.add(v);
        }
        return assigned;
    }

    public int countVariables() {
        return this.variables().size();
    }

    public int countAssignedVariables(Assignment<V, T> assignment) {
        return this.assignedVariables(assignment).size();
    }

    public void addVariable(V variable) {
        this.iVariables.add(variable);
        ((Variable)variable).addContstraint(this);
    }

    public void removeVariable(V variable) {
        ((Variable)variable).removeContstraint(this);
        this.iVariables.remove(variable);
    }

    public abstract void computeConflicts(Assignment<V, T> var1, T var2, Set<T> var3);

    public boolean isConsistent(T value1, T value2) {
        return true;
    }

    public boolean inConflict(Assignment<V, T> assignment, T value) {
        HashSet conflicts = new HashSet();
        this.computeConflicts(assignment, value, conflicts);
        return !conflicts.isEmpty();
    }

    public void assigned(Assignment<V, T> assignment, long iteration, T value) {
        HashSet conf = null;
        if (this.isHard()) {
            conf = new HashSet();
            this.computeConflictsNoForwardCheck(assignment, value, conf);
        }
        if (this.iConstraintListeners != null) {
            for (ConstraintListener<V, T> listener : this.iConstraintListeners) {
                listener.constraintBeforeAssigned(assignment, iteration, this, value, conf);
            }
        }
        if (conf != null) {
            for (Value conflictValue : conf) {
                if (conflictValue.equals(value)) continue;
                assignment.unassign(iteration, conflictValue.variable());
            }
        }
        if (this.iConstraintListeners != null) {
            for (ConstraintListener<V, T> listener : this.iConstraintListeners) {
                listener.constraintAfterAssigned(assignment, iteration, this, value, conf);
            }
        }
    }

    protected void computeConflictsNoForwardCheck(Assignment<V, T> assignment, T value, Set<T> conflicts) {
        this.computeConflicts(assignment, value, conflicts);
    }

    public void unassigned(Assignment<V, T> assignment, long iteration, T value) {
    }

    public void addConstraintListener(ConstraintListener<V, T> listener) {
        if (this.iConstraintListeners == null) {
            this.iConstraintListeners = new ArrayList<ConstraintListener<V, T>>();
        }
        this.iConstraintListeners.add(listener);
    }

    public void removeConstraintListener(ConstraintListener<V, T> listener) {
        if (this.iConstraintListeners != null) {
            this.iConstraintListeners.remove(listener);
        }
    }

    public List<ConstraintListener<V, T>> constraintListeners() {
        return this.iConstraintListeners;
    }

    public long getId() {
        return this.iId;
    }

    public String getName() {
        return String.valueOf(this.iId);
    }

    public String getDescription() {
        return null;
    }

    public int hashCode() {
        return (int)this.iId;
    }

    public boolean isHard() {
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Constraint)) {
            return false;
        }
        return this.getId() == ((Constraint)o).getId();
    }

    @Override
    public int compareTo(Constraint<V, T> c) {
        return this.getId() < c.getId() ? -1 : (this.getId() == c.getId() ? 0 : 1);
    }
}

