/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.util.DataProperties;

public class MinimizeNumberOfUsedGroupsOfTime
extends ConstraintWithContext<Lecture, Placement, MinimizeNumberOfUsedGroupsOfTimeContext>
implements WeakeningConstraint<Lecture, Placement> {
    private int iUnassignmentsToWeaken = 250;
    private GroupOfTime[] iGroupsOfTime;
    private String iName = null;
    public static GroupOfTime[] sGroups2of5h = new GroupOfTime[]{new GroupOfTime(Constants.time2slot(7, 30), Constants.time2slot(12, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(12, 30), Constants.time2slot(17, 30), Constants.DAY_CODE_ALL)};
    public static GroupOfTime[] sGroups3of3h = new GroupOfTime[]{new GroupOfTime(Constants.time2slot(7, 30), Constants.time2slot(10, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(10, 30), Constants.time2slot(14, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(14, 30), Constants.time2slot(17, 30), Constants.DAY_CODE_ALL)};
    public static GroupOfTime[] sGroups5of2h = new GroupOfTime[]{new GroupOfTime(Constants.time2slot(7, 30), Constants.time2slot(9, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(9, 30), Constants.time2slot(11, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(11, 30), Constants.time2slot(13, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(13, 30), Constants.time2slot(15, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(15, 30), Constants.time2slot(17, 30), Constants.DAY_CODE_ALL)};
    public static GroupOfTime[] sGroups10of1h = new GroupOfTime[]{new GroupOfTime(Constants.time2slot(7, 30), Constants.time2slot(8, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(8, 30), Constants.time2slot(9, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(9, 30), Constants.time2slot(10, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(10, 30), Constants.time2slot(11, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(11, 30), Constants.time2slot(12, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(12, 30), Constants.time2slot(13, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(13, 30), Constants.time2slot(14, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(14, 30), Constants.time2slot(15, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(15, 30), Constants.time2slot(16, 30), Constants.DAY_CODE_ALL), new GroupOfTime(Constants.time2slot(16, 30), Constants.time2slot(17, 30), Constants.DAY_CODE_ALL)};

    public MinimizeNumberOfUsedGroupsOfTime(DataProperties config, String name, GroupOfTime[] groupsOfTime) {
        this.iGroupsOfTime = groupsOfTime;
        this.iUnassignmentsToWeaken = config.getPropertyInt("MinimizeNumberOfUsedGroupsOfTime.Unassignments2Weaken", this.iUnassignmentsToWeaken);
        this.iName = name;
    }

    public int estimateLimit() {
        int nrSlotsUsed = 0;
        int minSlotsUsed = 0;
        boolean firstLecture = true;
        for (Lecture lecture : this.variables()) {
            boolean first = true;
            int minSlotsUsedThisLecture = 0;
            for (TimeLocation time : lecture.timeLocations()) {
                int min = 0;
                for (int i = 0; i < this.iGroupsOfTime.length; ++i) {
                    if (!this.iGroupsOfTime[i].overlap(time)) continue;
                    ++min;
                }
                if (first) {
                    nrSlotsUsed += time.getLength() * time.getNrMeetings();
                    minSlotsUsedThisLecture = min;
                    first = false;
                    continue;
                }
                minSlotsUsedThisLecture = Math.min(minSlotsUsedThisLecture, min);
            }
            if (firstLecture) {
                minSlotsUsed = minSlotsUsedThisLecture;
                firstLecture = false;
                continue;
            }
            minSlotsUsed = Math.min(minSlotsUsed, minSlotsUsedThisLecture);
        }
        return Math.max(Math.max(1, (int)Math.ceil((double)nrSlotsUsed / (double)this.iGroupsOfTime[0].size())), minSlotsUsed);
    }

    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement placement, Set<Placement> conflicts) {
        MinimizeNumberOfUsedGroupsOfTimeContext context = (MinimizeNumberOfUsedGroupsOfTimeContext)this.getContext(assignment);
        int overLimit = context.getOverLimit(placement);
        if (overLimit > 0) {
            int i;
            TimeLocation time = placement.getTimeLocation();
            ArrayList adepts = new ArrayList();
            for (i = 0; i < this.iGroupsOfTime.length; ++i) {
                GroupOfTime groupOfTime = this.iGroupsOfTime[i];
                Set<Placement> usage = context.getUsage(i);
                if (groupOfTime.overlap(time) || usage.isEmpty()) continue;
                boolean canUnassign = true;
                ArrayList<Placement> placementsToUnassign = new ArrayList<Placement>(usage.size());
                for (Placement p : usage) {
                    Lecture l = (Lecture)p.variable();
                    if (l.isCommitted()) {
                        canUnassign = false;
                        break;
                    }
                    if (conflicts.contains((Object)p)) continue;
                    placementsToUnassign.add(p);
                }
                if (!canUnassign) continue;
                adepts.add(placementsToUnassign);
            }
            if (adepts.size() < overLimit) {
                conflicts.add(placement);
            } else {
                Collections.sort(adepts, new Comparator<List<Placement>>(){

                    @Override
                    public int compare(List<Placement> c1, List<Placement> c2) {
                        return Double.compare(c1.size(), c2.size());
                    }
                });
                for (i = 0; i < overLimit; ++i) {
                    conflicts.addAll((Collection)adepts.get(i));
                }
            }
        }
    }

    public String getConstraintName() {
        return "MIN_GRUSE(" + this.iName + ")";
    }

    public String getName() {
        return "Minimize number of used groups of time (" + this.iName + ")";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Minimize Use Of " + Constants.SLOT_LENGTH_MIN * (this.iGroupsOfTime[0].getEndSlot() - this.iGroupsOfTime[0].getStartSlot()) + "min Groups between ");
        Iterator e = this.variables().iterator();
        while (e.hasNext()) {
            Lecture v = (Lecture)((Object)e.next());
            sb.append(v.getName());
            if (!e.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public void weaken(Assignment<Lecture, Placement> assignment) {
        ((MinimizeNumberOfUsedGroupsOfTimeContext)this.getContext(assignment)).weaken();
    }

    public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
        ((MinimizeNumberOfUsedGroupsOfTimeContext)this.getContext(assignment)).weaken(value);
    }

    public MinimizeNumberOfUsedGroupsOfTimeContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new MinimizeNumberOfUsedGroupsOfTimeContext(assignment);
    }

    public class MinimizeNumberOfUsedGroupsOfTimeContext
    implements AssignmentConstraintContext<Lecture, Placement> {
        private long iUnassignment = 0L;
        private int iLimit = 1;
        private Set<Placement>[] iUsage;

        public MinimizeNumberOfUsedGroupsOfTimeContext(Assignment<Lecture, Placement> assignment) {
            this.iUsage = new HashSet[MinimizeNumberOfUsedGroupsOfTime.this.iGroupsOfTime.length];
            for (int i = 0; i < this.iUsage.length; ++i) {
                this.iUsage[i] = new HashSet<Placement>();
            }
            for (Lecture lecture : MinimizeNumberOfUsedGroupsOfTime.this.variables()) {
                Placement placement = (Placement)assignment.getValue((Variable)lecture);
                if (placement == null) continue;
                this.assigned(assignment, placement);
            }
            this.iLimit = Math.max(this.currentUsage(), MinimizeNumberOfUsedGroupsOfTime.this.estimateLimit());
        }

        public void assigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            TimeLocation time = placement.getTimeLocation();
            for (int i = 0; i < MinimizeNumberOfUsedGroupsOfTime.this.iGroupsOfTime.length; ++i) {
                GroupOfTime groupOfTime = MinimizeNumberOfUsedGroupsOfTime.this.iGroupsOfTime[i];
                Set<Placement> usage = this.iUsage[i];
                if (!groupOfTime.overlap(time)) continue;
                usage.add(placement);
            }
        }

        public void unassigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            TimeLocation time = placement.getTimeLocation();
            for (int i = 0; i < MinimizeNumberOfUsedGroupsOfTime.this.iGroupsOfTime.length; ++i) {
                GroupOfTime groupOfTime = MinimizeNumberOfUsedGroupsOfTime.this.iGroupsOfTime[i];
                Set<Placement> usage = this.iUsage[i];
                if (!groupOfTime.overlap(time)) continue;
                usage.remove((Object)placement);
            }
        }

        public int currentUsage() {
            int ret = 0;
            for (int i = 0; i < this.iUsage.length; ++i) {
                if (this.iUsage[i].isEmpty()) continue;
                ++ret;
            }
            return ret;
        }

        public boolean isOverLimit(Placement placement) {
            return this.getOverLimit(placement) > 0;
        }

        public int getOverLimit(Placement placement) {
            if (MinimizeNumberOfUsedGroupsOfTime.this.iUnassignmentsToWeaken == 0) {
                return 0;
            }
            Lecture lecture = (Lecture)placement.variable();
            TimeLocation time = placement.getTimeLocation();
            if (lecture.isCommitted()) {
                return 0;
            }
            int usage = 0;
            for (int i = 0; i < MinimizeNumberOfUsedGroupsOfTime.this.iGroupsOfTime.length; ++i) {
                GroupOfTime groupOfTime = MinimizeNumberOfUsedGroupsOfTime.this.iGroupsOfTime[i];
                if (this.iUsage[i].isEmpty() && !groupOfTime.overlap(time)) continue;
                ++usage;
            }
            return usage - this.iLimit;
        }

        public void weaken() {
            ++this.iUnassignment;
            if (MinimizeNumberOfUsedGroupsOfTime.this.iUnassignmentsToWeaken > 0 && this.iUnassignment % (long)MinimizeNumberOfUsedGroupsOfTime.this.iUnassignmentsToWeaken == 0L) {
                ++this.iLimit;
            }
        }

        public void weaken(Placement value) {
            if (this.isOverLimit(value)) {
                this.iLimit += this.getOverLimit(value);
            }
        }

        public Set<Placement> getUsage(int slot) {
            return this.iUsage[slot];
        }
    }

    private static class GroupOfTime {
        private int iStartSlot = 0;
        private int iEndSlot = 0;
        private int iDays = 0;

        public GroupOfTime(int startSlot, int endSlot, int days) {
            this.iStartSlot = startSlot;
            this.iEndSlot = endSlot;
            this.iDays = days;
        }

        public int getStartSlot() {
            return this.iStartSlot;
        }

        public int getEndSlot() {
            return this.iEndSlot;
        }

        public int getDays() {
            return this.iDays;
        }

        public int nrDays() {
            int ret = 0;
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                if ((this.getDays() & Constants.DAY_CODES[i]) == 0) continue;
                ++ret;
            }
            return ret;
        }

        public int size() {
            return (this.getEndSlot() - this.getStartSlot()) * this.nrDays();
        }

        public boolean overlap(TimeLocation timeLocation) {
            int start;
            if ((timeLocation.getDayCode() & this.iDays) == 0) {
                return false;
            }
            int end = Math.min(this.iEndSlot, timeLocation.getStartSlot() + timeLocation.getLength());
            int nrSharedSlots = end < (start = Math.max(this.iStartSlot, timeLocation.getStartSlot())) ? 0 : end - start;
            return nrSharedSlots > 0;
        }
    }
}

