/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.reservation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.reservation.Reservation;

public class IndividualReservation
extends Reservation {
    private Set<Long> iStudentIds = new HashSet<Long>();
    public static final int DEFAULT_PRIORITY = 100;
    public static final boolean DEFAULT_MUST_BE_USED = true;
    public static final boolean DEFAULT_CAN_ASSIGN_OVER_LIMIT = true;
    public static final boolean DEFAULT_ALLOW_OVERLAP = true;

    protected IndividualReservation(long id, Offering offering, int priority, boolean mustBeUsed, boolean canAssignOverLimit, boolean allowOverlap, Long ... studentIds) {
        super(id, offering, priority, mustBeUsed, canAssignOverLimit, allowOverlap);
        for (Long studentId : studentIds) {
            this.iStudentIds.add(studentId);
        }
    }

    public IndividualReservation(long id, Offering offering, Long ... studentIds) {
        this(id, offering, 100, true, true, true, studentIds);
    }

    protected IndividualReservation(long id, Offering offering, int priority, boolean mustBeUsed, boolean canAssignOverLimit, boolean allowOverlap, Collection<Long> studentIds) {
        super(id, offering, priority, mustBeUsed, canAssignOverLimit, allowOverlap);
        this.iStudentIds.addAll(studentIds);
    }

    public IndividualReservation(long id, Offering offering, Collection<Long> studentIds) {
        this(id, offering, 100, true, true, true, studentIds);
    }

    @Override
    public boolean isApplicable(Student student) {
        return this.iStudentIds.contains(student.getId());
    }

    public Set<Long> getStudentIds() {
        return this.iStudentIds;
    }

    @Override
    public double getReservationLimit() {
        return this.iStudentIds.size();
    }
}

