/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.util.CSVFile;

public class ExamRoomSchedule {
    ExamModel iModel = null;

    public ExamRoomSchedule(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Room"), new CSVFile.CSVField((Object)"Cap"), new CSVFile.CSVField((Object)"AltCap"), new CSVFile.CSVField((Object)"Period"), new CSVFile.CSVField((Object)"Date"), new CSVFile.CSVField((Object)"Time"), new CSVFile.CSVField((Object)"Exam"), new CSVFile.CSVField((Object)"Enrl")});
        ArrayList<ExamRoom> rooms = new ArrayList<ExamRoom>(this.iModel.getRooms());
        Collections.sort(rooms, new Comparator<ExamRoom>(){

            @Override
            public int compare(ExamRoom r1, ExamRoom r2) {
                int cmp = -Double.compare(r1.getSize(), r2.getSize());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = -Double.compare(r1.getAltSize(), r2.getAltSize());
                if (cmp != 0) {
                    return cmp;
                }
                return r1.compareTo((Constraint<Exam, ExamPlacement>)r2);
            }
        });
        for (ExamRoom room : rooms) {
            boolean first = true;
            int day = -1;
            for (ExamPeriod period : this.iModel.getPeriods()) {
                for (ExamPlacement placement : room.getPlacements(assignment, period)) {
                    Exam exam = (Exam)placement.variable();
                    csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)(first ? room.getName() : "")), new CSVFile.CSVField((Object)(first ? "" + room.getSize() : "")), new CSVFile.CSVField((Object)(first ? "" + room.getAltSize() : "")), new CSVFile.CSVField(period.getIndex() + 1), new CSVFile.CSVField((Object)(day == period.getDay() ? "" : period.getDayStr())), new CSVFile.CSVField((Object)period.getTimeStr()), new CSVFile.CSVField((Object)exam.getName()), new CSVFile.CSVField(exam.getStudents().size())});
                    first = false;
                    day = period.getDay();
                }
            }
        }
        return csv;
    }
}

