/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria.additional;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class StudentMoreThan1ADayConflicts
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exams.MoreThanOneADayWeight";
    }

    public double getWeightDefault(DataProperties config) {
        return 1.0;
    }

    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        ExamPeriod period = value.getPeriod();
        Map<ExamStudent, Set<Exam>> students = ((ExamModel)this.getModel()).getStudentsOfDay(assignment, period);
        for (ExamStudent s : exam.getStudents()) {
            int nrExams;
            Set<Exam> exams = students.get((Object)s);
            if (exams == null || exams.isEmpty() || (nrExams = exams.size() + (exams.contains((Object)exam) ? 0 : 1)) <= 1) continue;
            ++penalty;
        }
        return penalty;
    }

    public String getName() {
        return "More Than 1 A Day Conflicts";
    }

    @Override
    public String getXmlWeightName() {
        return "moreThanOneADayWeight";
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment)));
        }
    }

    public double getValue(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> variables) {
        int ret = 0;
        ExamModel m = (ExamModel)this.getModel();
        HashSet<Integer> days = new HashSet<Integer>();
        for (ExamPeriod p : m.getPeriods()) {
            if (!days.add(p.getDay())) continue;
            Map<ExamStudent, Set<Exam>> students = ((ExamModel)this.getModel()).getStudentsOfDay(assignment, p);
            for (Set<Exam> exams : students.values()) {
                int nrExams = exams.size();
                if (nrExams <= 1) continue;
                ret += nrExams - 1;
            }
        }
        return ret;
    }

    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "M1D:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

