/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class PeriodSizePenalty
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exams.PeriodSizeWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "periodSizeWeight";
    }

    public double getWeightDefault(DataProperties config) {
        return 1.0;
    }

    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        return value.getPeriodPlacement().getPenalty() * (((Exam)value.variable()).getSize() + 1);
    }

    public String getName() {
        return "Period&times;Size Penalty";
    }

    @Override
    public double[] getBounds(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Exam exam : variables) {
            if (exam.getPeriodPlacements().isEmpty()) continue;
            int minSizePenalty = Integer.MAX_VALUE;
            int maxSizePenalty = Integer.MIN_VALUE;
            for (ExamPeriodPlacement periodPlacement : exam.getPeriodPlacements()) {
                minSizePenalty = Math.min(minSizePenalty, periodPlacement.getPenalty() * (exam.getSize() + 1));
                maxSizePenalty = Math.max(maxSizePenalty, periodPlacement.getPenalty() * (exam.getSize() + 1));
            }
            bounds[0] = bounds[0] + (double)minSizePenalty;
            bounds[1] = bounds[1] + (double)maxSizePenalty;
        }
        return bounds;
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment) / (double)assignment.nrAssignedVariables()));
        }
    }

    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "PS:" + sDoubleFormat.format(this.getValue(assignment) / (double)assignment.nrAssignedVariables());
    }
}

