/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.extension;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.assignment.context.ExtensionWithContext;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.ModelListener;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Unavailability;

public class StudentQuality
extends ExtensionWithContext<Request, Enrollment, StudentQualityContext>
implements ModelListener<Request, Enrollment>,
CanInheritContext<Request, Enrollment, StudentQualityContext>,
InfoProvider<Request, Enrollment> {
    private static Logger sLog = LogManager.getLogger(StudentQuality.class);
    private Context iContext;

    public StudentQuality(Solver<Request, Enrollment> solver, DataProperties properties) {
        super(solver, properties);
        if (solver != null) {
            StudentSectioningModel model = (StudentSectioningModel)solver.currentSolution().getModel();
            this.iContext = new Context(model.getDistanceMetric(), properties);
            model.setStudentQuality(this, false);
        } else {
            this.iContext = new Context(null, properties);
        }
    }

    public StudentQuality(DistanceMetric metrics, DataProperties properties) {
        super(null, properties);
        this.iContext = new Context(metrics, properties);
    }

    public DistanceMetric getDistanceMetric() {
        return this.iContext.getDistanceMetric();
    }

    public boolean isDebug() {
        return this.iContext.isDebug();
    }

    public Context getStudentQualityContext() {
        return this.iContext;
    }

    public int penalty(Type type, Enrollment e1, Enrollment e2) {
        if (!e1.getStudent().equals(e2.getStudent()) || !type.isApplicable(this.iContext, e1.getStudent(), e1.getRequest(), e2.getRequest())) {
            return 0;
        }
        int cnt = 0;
        for (SctAssignment s1 : e1.getAssignments()) {
            for (SctAssignment s2 : e2.getAssignments()) {
                cnt += type.penalty(this.iContext, e1.getStudent(), s1, s2);
            }
        }
        return cnt;
    }

    public Set<Conflict> conflicts(Type type, Enrollment e1, Enrollment e2) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        if (!e1.getStudent().equals(e2.getStudent()) || !type.isApplicable(this.iContext, e1.getStudent(), e1.getRequest(), e2.getRequest())) {
            return ret;
        }
        for (SctAssignment s1 : e1.getAssignments()) {
            for (SctAssignment s2 : e2.getAssignments()) {
                int penalty = type.penalty(this.iContext, e1.getStudent(), s1, s2);
                if (penalty == 0) continue;
                ret.add(new Conflict(e1.getStudent(), type, penalty, e1, s1, e2, s2));
            }
        }
        return ret;
    }

    public Set<Conflict> conflicts(Enrollment e1, Enrollment e2) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        for (Type type : this.iContext.getTypes()) {
            if (!e1.getStudent().equals(e2.getStudent()) || !type.isApplicable(this.iContext, e1.getStudent(), e1.getRequest(), e2.getRequest())) continue;
            for (SctAssignment s1 : e1.getAssignments()) {
                for (SctAssignment s2 : e2.getAssignments()) {
                    int penalty = type.penalty(this.iContext, e1.getStudent(), s1, s2);
                    if (penalty == 0) continue;
                    ret.add(new Conflict(e1.getStudent(), type, penalty, e1, s1, e2, s2));
                }
            }
        }
        return ret;
    }

    public Set<Conflict> conflicts(Type type, Enrollment e1) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        boolean applicable = type.isApplicable(this.iContext, e1.getStudent(), e1.getRequest(), e1.getRequest());
        for (SctAssignment s1 : e1.getAssignments()) {
            int penalty;
            if (applicable) {
                for (SctAssignment sctAssignment : e1.getAssignments()) {
                    if (s1.getId() >= sctAssignment.getId() || (penalty = type.penalty(this.iContext, e1.getStudent(), s1, sctAssignment)) == 0) continue;
                    ret.add(new Conflict(e1.getStudent(), type, penalty, e1, s1, e1, sctAssignment));
                }
            }
            for (SctAssignment sctAssignment : type.other(this.iContext, e1)) {
                penalty = type.penalty(this.iContext, e1.getStudent(), s1, sctAssignment);
                if (penalty == 0) continue;
                ret.add(new Conflict(e1.getStudent(), type, penalty, e1, s1, sctAssignment));
            }
        }
        return ret;
    }

    public Set<Conflict> conflicts(Enrollment e1) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        for (Type type : this.iContext.getTypes()) {
            boolean applicable = type.isApplicable(this.iContext, e1.getStudent(), e1.getRequest(), e1.getRequest());
            for (SctAssignment s1 : e1.getAssignments()) {
                int penalty;
                if (applicable) {
                    for (SctAssignment sctAssignment : e1.getAssignments()) {
                        if (s1.getId() >= sctAssignment.getId() || (penalty = type.penalty(this.iContext, e1.getStudent(), s1, sctAssignment)) == 0) continue;
                        ret.add(new Conflict(e1.getStudent(), type, penalty, e1, s1, e1, sctAssignment));
                    }
                }
                for (SctAssignment sctAssignment : type.other(this.iContext, e1)) {
                    penalty = type.penalty(this.iContext, e1.getStudent(), s1, sctAssignment);
                    if (penalty == 0) continue;
                    ret.add(new Conflict(e1.getStudent(), type, penalty, e1, s1, sctAssignment));
                }
            }
        }
        return ret;
    }

    public int penalty(Type type, Enrollment e1) {
        int penalty = 0;
        boolean applicable = type.isApplicable(this.iContext, e1.getStudent(), e1.getRequest(), e1.getRequest());
        for (SctAssignment s1 : e1.getAssignments()) {
            if (applicable) {
                for (SctAssignment sctAssignment : e1.getAssignments()) {
                    if (s1.getId() >= sctAssignment.getId()) continue;
                    penalty += type.penalty(this.iContext, e1.getStudent(), s1, sctAssignment);
                }
            }
            for (SctAssignment sctAssignment : type.other(this.iContext, e1)) {
                penalty += type.penalty(this.iContext, e1.getStudent(), s1, sctAssignment);
            }
        }
        return penalty;
    }

    public boolean isApplicable(Type type, Student student, Request r1, Request r2) {
        return type.isApplicable(this.iContext, student, r1, r2);
    }

    public int getTotalPenalty(Type type, Assignment<Request, Enrollment> assignment) {
        return ((StudentQualityContext)this.getContext(assignment)).getTotalPenalty(type);
    }

    public int getTotalPenalty(Assignment<Request, Enrollment> assignment, Type ... types) {
        int ret = 0;
        for (Type type : types) {
            ret += ((StudentQualityContext)this.getContext(assignment)).getTotalPenalty(type);
        }
        return ret;
    }

    public void checkTotalPenalty(Assignment<Request, Enrollment> assignment) {
        for (Type type : this.iContext.getTypes()) {
            this.checkTotalPenalty(type, assignment);
        }
    }

    public void checkTotalPenalty(Type type, Assignment<Request, Enrollment> assignment) {
        ((StudentQualityContext)this.getContext(assignment)).checkTotalPenalty(type, assignment);
    }

    public Set<Conflict> getAllConflicts(Type type, Assignment<Request, Enrollment> assignment) {
        return ((StudentQualityContext)this.getContext(assignment)).getAllConflicts(type);
    }

    public Set<Conflict> allConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        HashSet<Conflict> conflicts = new HashSet<Conflict>();
        for (Type t : this.iContext.getTypes()) {
            conflicts.addAll(this.conflicts(t, enrollment));
            for (Request request : enrollment.getStudent().getRequests()) {
                if (request.equals((Object)enrollment.getRequest()) || assignment.getValue((Variable)request) == null) continue;
                conflicts.addAll(this.conflicts(t, enrollment, (Enrollment)assignment.getValue((Variable)request)));
            }
        }
        return conflicts;
    }

    public void beforeAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
        ((StudentQualityContext)this.getContext(assignment)).beforeAssigned(assignment, iteration, value);
    }

    public void afterAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
        ((StudentQualityContext)this.getContext(assignment)).afterAssigned(assignment, iteration, value);
    }

    public void afterUnassigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
        ((StudentQualityContext)this.getContext(assignment)).afterUnassigned(assignment, iteration, value);
    }

    public StudentQualityContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new StudentQualityContext(assignment);
    }

    public StudentQualityContext inheritAssignmentContext(Assignment<Request, Enrollment> assignment, StudentQualityContext parentContext) {
        return new StudentQualityContext(parentContext);
    }

    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info) {
        StudentQualityContext cx = (StudentQualityContext)this.getContext(assignment);
        if (this.iContext.isDebug()) {
            for (Type type : this.iContext.getTypes()) {
                info.put("[Schedule Quality] " + type.getName(), String.valueOf(cx.getTotalPenalty(type)));
            }
        }
    }

    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info, Collection<Request> variables) {
    }

    public String toString(Assignment<Request, Enrollment> assignment) {
        String ret = "";
        StudentQualityContext cx = (StudentQualityContext)this.getContext(assignment);
        for (Type type : this.iContext.getTypes()) {
            int p = cx.getTotalPenalty(type);
            if (p == 0) continue;
            ret = ret + (ret.isEmpty() ? "" : ", ") + type.getAbbv() + ": " + p;
        }
        return ret;
    }

    public boolean hasDistanceConflict(Student student, Section s1, Section s2) {
        if (student.isNeedShortDistances()) {
            return Type.ShortDistance.inConflict(this.iContext, s1, s2);
        }
        return Type.Distance.inConflict(this.iContext, s1, s2);
    }

    public static class Online
    implements Iterable<Section> {
        private Enrollment iEnrollment;
        private boolean iOnline;

        public Online(Enrollment enrollment, boolean online) {
            this.iEnrollment = enrollment;
            this.iOnline = online;
        }

        protected boolean skip(Section section) {
            return this.iOnline != section.isOnline();
        }

        @Override
        public Iterator<Section> iterator() {
            return new Iterator<Section>(){
                Iterator<Section> i;
                Section next;
                boolean hasNext;
                {
                    this.i = iEnrollment.getSections().iterator();
                    this.next = null;
                    this.hasNext = this.nextSection();
                }

                private boolean nextSection() {
                    while (this.i.hasNext()) {
                        Section r = this.i.next();
                        if (this.skip(r)) continue;
                        this.next = r;
                        return true;
                    }
                    return false;
                }

                @Override
                public Section next() {
                    try {
                        Section section = this.next;
                        return section;
                    }
                    finally {
                        this.hasNext = this.nextSection();
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class FreeTimes
    implements Iterable<FreeTimeRequest> {
        private Student iStudent;

        public FreeTimes(Student student) {
            this.iStudent = student;
        }

        @Override
        public Iterator<FreeTimeRequest> iterator() {
            return new Iterator<FreeTimeRequest>(){
                Iterator<Request> i;
                FreeTimeRequest next;
                boolean hasNext;
                {
                    this.i = iStudent.getRequests().iterator();
                    this.next = null;
                    this.hasNext = this.nextFreeTime();
                }

                private boolean nextFreeTime() {
                    while (this.i.hasNext()) {
                        Request r = this.i.next();
                        if (!(r instanceof FreeTimeRequest)) continue;
                        this.next = (FreeTimeRequest)r;
                        return true;
                    }
                    return false;
                }

                @Override
                public FreeTimeRequest next() {
                    try {
                        FreeTimeRequest freeTimeRequest = this.next;
                        return freeTimeRequest;
                    }
                    finally {
                        this.hasNext = this.nextFreeTime();
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class SingleTimeIterable
    implements Iterable<SingleTime> {
        private SingleTime iTime = null;

        public SingleTimeIterable(int start, int end) {
            if (start < end) {
                this.iTime = new SingleTime(start, end);
            }
        }

        @Override
        public Iterator<SingleTime> iterator() {
            return new Iterator<SingleTime>(){

                @Override
                public SingleTime next() {
                    SingleTime ret = iTime;
                    iTime = null;
                    return ret;
                }

                @Override
                public boolean hasNext() {
                    return iTime != null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class SingleTime
    implements SctAssignment {
        private TimeLocation iTime = null;

        public SingleTime(int start, int end) {
            this.iTime = new TimeLocation(127, start, end - start, 0, 0.0, 0, null, null, new BitSet(), 0);
        }

        @Override
        public TimeLocation getTime() {
            return this.iTime;
        }

        @Override
        public List<RoomLocation> getRooms() {
            return null;
        }

        @Override
        public int getNrRooms() {
            return 0;
        }

        @Override
        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        }

        @Override
        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        }

        @Override
        public Set<Enrollment> getEnrollments(Assignment<Request, Enrollment> assignment) {
            return null;
        }

        @Override
        public boolean isAllowOverlap() {
            return false;
        }

        @Override
        public long getId() {
            return -1L;
        }

        @Override
        public int compareById(SctAssignment a) {
            return 0;
        }

        @Override
        public boolean isOverlapping(SctAssignment assignment) {
            return assignment.getTime() != null && this.getTime().shareDays(assignment.getTime()) && this.getTime().shareHours(assignment.getTime());
        }

        @Override
        public boolean isOverlapping(Set<? extends SctAssignment> assignments) {
            for (SctAssignment sctAssignment : assignments) {
                if (!this.isOverlapping(sctAssignment)) continue;
                return true;
            }
            return false;
        }
    }

    public static class Unavailabilities
    implements Iterable<Unavailability> {
        private Student iStudent;

        public Unavailabilities(Student student) {
            this.iStudent = student;
        }

        @Override
        public Iterator<Unavailability> iterator() {
            return this.iStudent.getUnavailabilities().iterator();
        }
    }

    public static class Nothing
    implements Iterable<SctAssignment> {
        @Override
        public Iterator<SctAssignment> iterator() {
            return new Iterator<SctAssignment>(){

                @Override
                public SctAssignment next() {
                    return null;
                }

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public class StudentQualityContext
    implements AssignmentConstraintContext<Request, Enrollment> {
        private int[] iTotalPenalty = new int[Type.values().length];
        private Set<Conflict>[] iAllConflicts = null;
        private Request iOldVariable = null;
        private Enrollment iUnassignedValue = null;

        public StudentQualityContext(Assignment<Request, Enrollment> assignment) {
            for (Type t : StudentQuality.this.iContext.getTypes()) {
                this.iTotalPenalty[t.ordinal()] = this.countTotalPenalty(t, assignment);
            }
            if (StudentQuality.this.iContext.isDebug()) {
                this.iAllConflicts = new Set[Type.values().length];
                for (Type t : StudentQuality.this.iContext.getTypes()) {
                    this.iAllConflicts[t.ordinal()] = this.computeAllConflicts(t, assignment);
                }
            }
            StudentSectioningModel.StudentSectioningModelContext cx = (StudentSectioningModel.StudentSectioningModelContext)((StudentSectioningModel)StudentQuality.this.getModel()).getContext(assignment);
            for (Type t : StudentQuality.this.iContext.getTypes()) {
                for (Conflict c : this.computeAllConflicts(t, assignment)) {
                    cx.add(assignment, c);
                }
            }
        }

        public StudentQualityContext(StudentQualityContext parent) {
            for (Type t : StudentQuality.this.iContext.getTypes()) {
                this.iTotalPenalty[t.ordinal()] = parent.iTotalPenalty[t.ordinal()];
            }
            if (StudentQuality.this.iContext.isDebug()) {
                this.iAllConflicts = new Set[Type.values().length];
                for (Type t : StudentQuality.this.iContext.getTypes()) {
                    this.iAllConflicts[t.ordinal()] = new HashSet<Conflict>(parent.iAllConflicts[t.ordinal()]);
                }
            }
        }

        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment value) {
            StudentSectioningModel.StudentSectioningModelContext cx = (StudentSectioningModel.StudentSectioningModelContext)((StudentSectioningModel)StudentQuality.this.getModel()).getContext(assignment);
            for (Type type : StudentQuality.this.iContext.getTypes()) {
                int n = type.ordinal();
                this.iTotalPenalty[n] = this.iTotalPenalty[n] + this.allPenalty(type, assignment, value);
                for (Conflict c : this.allConflicts(type, assignment, value)) {
                    cx.add(assignment, c);
                }
            }
            if (StudentQuality.this.iContext.isDebug()) {
                sLog.debug("A:" + value.variable() + " := " + (Object)((Object)value));
                for (Type type : StudentQuality.this.iContext.getTypes()) {
                    int inc = this.allPenalty(type, assignment, value);
                    if (inc == 0) continue;
                    sLog.debug("-- " + (Object)((Object)type) + " +" + inc + " A: " + value.variable() + " := " + (Object)((Object)value));
                    for (Conflict c : this.allConflicts(type, assignment, value)) {
                        sLog.debug("  -- " + c);
                        this.iAllConflicts[type.ordinal()].add(c);
                        inc -= c.getPenalty();
                    }
                    if (inc == 0) continue;
                    sLog.error((Object)((Object)type) + ": Different penalty for the assigned value (difference: " + inc + ")!");
                }
            }
        }

        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment value) {
            StudentSectioningModel.StudentSectioningModelContext cx = (StudentSectioningModel.StudentSectioningModelContext)((StudentSectioningModel)StudentQuality.this.getModel()).getContext(assignment);
            for (Type type : StudentQuality.this.iContext.getTypes()) {
                int n = type.ordinal();
                this.iTotalPenalty[n] = this.iTotalPenalty[n] - this.allPenalty(type, assignment, value);
                for (Conflict c : this.allConflicts(type, assignment, value)) {
                    cx.remove(assignment, c);
                }
            }
            if (StudentQuality.this.iContext.isDebug()) {
                sLog.debug("U:" + value.variable() + " := " + (Object)((Object)value));
                for (Type type : StudentQuality.this.iContext.getTypes()) {
                    int dec = this.allPenalty(type, assignment, value);
                    if (dec == 0) continue;
                    sLog.debug("--  " + (Object)((Object)type) + " -" + dec + " U: " + value.variable() + " := " + (Object)((Object)value));
                    for (Conflict c : this.allConflicts(type, assignment, value)) {
                        sLog.debug("  -- " + c);
                        this.iAllConflicts[type.ordinal()].remove(c);
                        dec -= c.getPenalty();
                    }
                    if (dec == 0) continue;
                    sLog.error((Object)((Object)type) + ":Different penalty for the unassigned value (difference: " + dec + ")!");
                }
            }
        }

        public void beforeAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
            if (value != null) {
                Enrollment old = (Enrollment)assignment.getValue(value.variable());
                if (old != null) {
                    this.iUnassignedValue = old;
                    this.unassigned(assignment, old);
                }
                this.iOldVariable = (Request)value.variable();
            }
        }

        public void afterAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
            this.iOldVariable = null;
            this.iUnassignedValue = null;
            if (value != null) {
                this.assigned(assignment, value);
            }
        }

        public void afterUnassigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
            if (value != null && !value.equals((Object)this.iUnassignedValue)) {
                this.unassigned(assignment, value);
            }
        }

        public Set<Conflict> getAllConflicts(Type type) {
            return this.iAllConflicts[type.ordinal()];
        }

        public int getTotalPenalty(Type type) {
            return this.iTotalPenalty[type.ordinal()];
        }

        public void checkTotalPenalty(Type type, Assignment<Request, Enrollment> assignment) {
            int total = this.countTotalPenalty(type, assignment);
            if (total != this.iTotalPenalty[type.ordinal()]) {
                sLog.error((Object)((Object)type) + " penalty does not match for (actual: " + total + ", count: " + this.iTotalPenalty[type.ordinal()] + ")!");
                this.iTotalPenalty[type.ordinal()] = total;
                if (StudentQuality.this.iContext.isDebug()) {
                    Set<Conflict> conflicts = this.computeAllConflicts(type, assignment);
                    for (Conflict c : conflicts) {
                        if (this.iAllConflicts[type.ordinal()].contains(c)) continue;
                        sLog.debug("  +add+ " + c);
                    }
                    for (Conflict c : this.iAllConflicts[type.ordinal()]) {
                        if (conflicts.contains(c)) continue;
                        sLog.debug("  -rem- " + c);
                    }
                    for (Conflict c : conflicts) {
                        for (Conflict d : this.iAllConflicts[type.ordinal()]) {
                            if (!c.equals(d) || c.getPenalty() == d.getPenalty()) continue;
                            sLog.debug("  -dif- " + c + " (other: " + d.getPenalty() + ")");
                        }
                    }
                    this.iAllConflicts[type.ordinal()] = conflicts;
                }
            }
        }

        public int countTotalPenalty(Type type, Assignment<Request, Enrollment> assignment) {
            int total = 0;
            for (Request r1 : StudentQuality.this.getModel().variables()) {
                Enrollment e1 = (Enrollment)assignment.getValue((Variable)r1);
                if (e1 == null || r1.equals((Object)this.iOldVariable)) continue;
                for (Request r2 : r1.getStudent().getRequests()) {
                    Enrollment e2 = (Enrollment)assignment.getValue((Variable)r2);
                    if (e2 == null || r1.getId() >= r2.getId() || r2.equals((Object)this.iOldVariable) || !type.isApplicable(StudentQuality.this.iContext, r1.getStudent(), r1, r2)) continue;
                    total += StudentQuality.this.penalty(type, e1, e2);
                }
                total += StudentQuality.this.penalty(type, e1);
            }
            return total;
        }

        public Set<Conflict> computeAllConflicts(Type type, Assignment<Request, Enrollment> assignment) {
            HashSet<Conflict> ret = new HashSet<Conflict>();
            for (Request r1 : StudentQuality.this.getModel().variables()) {
                Enrollment e1 = (Enrollment)assignment.getValue((Variable)r1);
                if (e1 == null || r1.equals((Object)this.iOldVariable)) continue;
                for (Request r2 : r1.getStudent().getRequests()) {
                    Enrollment e2 = (Enrollment)assignment.getValue((Variable)r2);
                    if (e2 == null || r1.getId() >= r2.getId() || r2.equals((Object)this.iOldVariable) || !type.isApplicable(StudentQuality.this.iContext, r1.getStudent(), r1, r2)) continue;
                    ret.addAll(StudentQuality.this.conflicts(type, e1, e2));
                }
                ret.addAll(StudentQuality.this.conflicts(type, e1));
            }
            return ret;
        }

        public Set<Conflict> allConflicts(Type type, Assignment<Request, Enrollment> assignment, Student student) {
            HashSet<Conflict> ret = new HashSet<Conflict>();
            for (Request r1 : student.getRequests()) {
                Enrollment e1 = (Enrollment)assignment.getValue((Variable)r1);
                if (e1 == null) continue;
                for (Request r2 : student.getRequests()) {
                    Enrollment e2 = (Enrollment)assignment.getValue((Variable)r2);
                    if (e2 == null || r1.getId() >= r2.getId() || !type.isApplicable(StudentQuality.this.iContext, r1.getStudent(), r1, r2)) continue;
                    ret.addAll(StudentQuality.this.conflicts(type, e1, e2));
                }
                ret.addAll(StudentQuality.this.conflicts(type, e1));
            }
            return ret;
        }

        public Set<Conflict> allConflicts(Type type, Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            HashSet<Conflict> ret = new HashSet<Conflict>();
            for (Request request : enrollment.getStudent().getRequests()) {
                if (request.equals((Object)enrollment.getRequest()) || assignment.getValue((Variable)request) == null || request.equals((Object)this.iOldVariable)) continue;
                ret.addAll(StudentQuality.this.conflicts(type, enrollment, (Enrollment)assignment.getValue((Variable)request)));
            }
            ret.addAll(StudentQuality.this.conflicts(type, enrollment));
            return ret;
        }

        public int allPenalty(Type type, Assignment<Request, Enrollment> assignment, Student student) {
            int penalty = 0;
            for (Request r1 : student.getRequests()) {
                Enrollment e1 = (Enrollment)assignment.getValue((Variable)r1);
                if (e1 == null) continue;
                for (Request r2 : student.getRequests()) {
                    Enrollment e2 = (Enrollment)assignment.getValue((Variable)r2);
                    if (e2 == null || r1.getId() >= r2.getId() || !type.isApplicable(StudentQuality.this.iContext, r1.getStudent(), r1, r2)) continue;
                    penalty += StudentQuality.this.penalty(type, e1, e2);
                }
                penalty += StudentQuality.this.penalty(type, e1);
            }
            return penalty;
        }

        public int allPenalty(Type type, Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            int penalty = 0;
            for (Request request : enrollment.getStudent().getRequests()) {
                if (request.equals((Object)enrollment.getRequest()) || assignment.getValue((Variable)request) == null || request.equals((Object)this.iOldVariable) || !type.isApplicable(StudentQuality.this.iContext, enrollment.getStudent(), (Request)enrollment.variable(), request)) continue;
                penalty += StudentQuality.this.penalty(type, enrollment, (Enrollment)assignment.getValue((Variable)request));
            }
            return penalty += StudentQuality.this.penalty(type, enrollment);
        }
    }

    public static class Context {
        private List<Type> iTypes = null;
        private DistanceMetric iDistanceMetric = null;
        private boolean iDebug = false;
        protected double iTimeOverlapMaxLimit = 0.5;
        private int iLunchStart;
        private int iLunchEnd;
        private int iLunchLength;
        private int iMaxTravelGap;
        private int iWorkDayLimit;
        private int iBackToBackDistance;
        private int iEarlySlot;
        private int iLateSlot;
        private int iAccBackToBackDistance;
        private String iFreeTimeAccommodation = "FT";
        private String iBackToBackAccommodation = "BTB";
        private String iBreakBetweenClassesAccommodation = "BBC";
        private ReentrantReadWriteLock iLock = new ReentrantReadWriteLock();
        private Integer iUnavailabilityMaxTravelTime = null;
        private DistanceMetric iUnavailabilityDistanceMetric = null;
        private Map<Long, Map<Long, Integer>> iDistanceCache = new HashMap<Long, Map<Long, Integer>>();
        private Map<Long, Map<Long, Integer>> iUnavailabilityDistanceCache = new HashMap<Long, Map<Long, Integer>>();

        public Context(DistanceMetric dm, DataProperties config) {
            this.iDistanceMetric = dm == null ? new DistanceMetric(config) : dm;
            this.iDebug = config.getPropertyBoolean("StudentQuality.Debug", false);
            this.iTimeOverlapMaxLimit = config.getPropertyDouble("StudentWeights.TimeOverlapMaxLimit", this.iTimeOverlapMaxLimit);
            this.iLunchStart = config.getPropertyInt("StudentLunch.StartSlot", 132);
            this.iLunchEnd = config.getPropertyInt("StudentLunch.EndStart", 156);
            this.iLunchLength = config.getPropertyInt("StudentLunch.Length", 6);
            this.iMaxTravelGap = config.getPropertyInt("TravelTime.MaxTravelGap", 12);
            this.iWorkDayLimit = config.getPropertyInt("WorkDay.WorkDayLimit", 72);
            this.iBackToBackDistance = config.getPropertyInt("StudentWeights.BackToBackDistance", 6);
            this.iAccBackToBackDistance = config.getPropertyInt("Accommodations.BackToBackDistance", 6);
            this.iEarlySlot = config.getPropertyInt("WorkDay.EarlySlot", 102);
            this.iLateSlot = config.getPropertyInt("WorkDay.LateSlot", 210);
            this.iFreeTimeAccommodation = config.getProperty("Accommodations.FreeTimeReference", this.iFreeTimeAccommodation);
            this.iBackToBackAccommodation = config.getProperty("Accommodations.BackToBackReference", this.iBackToBackAccommodation);
            this.iBreakBetweenClassesAccommodation = config.getProperty("Accommodations.BreakBetweenClassesReference", this.iBreakBetweenClassesAccommodation);
            this.iTypes = new ArrayList<Type>();
            for (Type t : Type.values()) {
                if (config.getPropertyDouble(t.getWeightName(), t.getWeightDefault()) == 0.0) continue;
                this.iTypes.add(t);
            }
            this.iUnavailabilityMaxTravelTime = config.getPropertyInteger("Distances.UnavailabilityMaxTravelTimeInMinutes", null);
            if (this.iUnavailabilityMaxTravelTime != null && this.iUnavailabilityMaxTravelTime.intValue() != this.iDistanceMetric.getMaxTravelDistanceInMinutes()) {
                this.iUnavailabilityDistanceMetric = new DistanceMetric(this.iDistanceMetric);
                this.iUnavailabilityDistanceMetric.setMaxTravelDistanceInMinutes(this.iUnavailabilityMaxTravelTime.intValue());
                this.iUnavailabilityDistanceMetric.setComputeDistanceConflictsBetweenNonBTBClasses(true);
            }
        }

        public DistanceMetric getDistanceMetric() {
            return this.iDistanceMetric;
        }

        public DistanceMetric getUnavailabilityDistanceMetric() {
            return this.iUnavailabilityDistanceMetric == null ? this.iDistanceMetric : this.iUnavailabilityDistanceMetric;
        }

        public boolean isDebug() {
            return this.iDebug;
        }

        public double getTimeOverlapMaxLimit() {
            return this.iTimeOverlapMaxLimit;
        }

        public int getLunchStart() {
            return this.iLunchStart;
        }

        public int getLunchEnd() {
            return this.iLunchEnd;
        }

        public int getLunchLength() {
            return this.iLunchLength;
        }

        public int getMaxTravelGap() {
            return this.iMaxTravelGap;
        }

        public int getWorkDayLimit() {
            return this.iWorkDayLimit;
        }

        public int getBackToBackDistance() {
            return this.iBackToBackDistance;
        }

        public int getAccBackToBackDistance() {
            return this.iAccBackToBackDistance;
        }

        public int getEarlySlot() {
            return this.iEarlySlot;
        }

        public int getLateSlot() {
            return this.iLateSlot;
        }

        public String getFreeTimeAccommodation() {
            return this.iFreeTimeAccommodation;
        }

        public String getBackToBackAccommodation() {
            return this.iBackToBackAccommodation;
        }

        public String getBreakBetweenClassesAccommodation() {
            return this.iBreakBetweenClassesAccommodation;
        }

        public List<Type> getTypes() {
            return this.iTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer getDistanceInMinutesFromCache(RoomLocation r1, RoomLocation r2) {
            ReentrantReadWriteLock.ReadLock lock = this.iLock.readLock();
            lock.lock();
            try {
                Map<Long, Integer> other2distance = this.iDistanceCache.get(r1.getId());
                Integer n = other2distance == null ? null : other2distance.get(r2.getId());
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setDistanceInMinutesFromCache(RoomLocation r1, RoomLocation r2, Integer distance) {
            ReentrantReadWriteLock.WriteLock lock = this.iLock.writeLock();
            lock.lock();
            try {
                Map<Long, Integer> other2distance = this.iDistanceCache.get(r1.getId());
                if (other2distance == null) {
                    other2distance = new HashMap<Long, Integer>();
                    this.iDistanceCache.put(r1.getId(), other2distance);
                }
                other2distance.put(r2.getId(), distance);
            }
            finally {
                lock.unlock();
            }
        }

        protected int getDistanceInMinutes(RoomLocation r1, RoomLocation r2) {
            if (r1.getId().compareTo(r2.getId()) > 0) {
                return this.getDistanceInMinutes(r2, r1);
            }
            if (r1.getId().equals(r2.getId()) || r1.getIgnoreTooFar() || r2.getIgnoreTooFar()) {
                return 0;
            }
            if (r1.getPosX() == null || r1.getPosY() == null || r2.getPosX() == null || r2.getPosY() == null) {
                return this.iDistanceMetric.getMaxTravelDistanceInMinutes();
            }
            Integer distance = this.getDistanceInMinutesFromCache(r1, r2);
            if (distance == null) {
                distance = this.iDistanceMetric.getDistanceInMinutes(r1.getId(), r1.getPosX(), r1.getPosY(), r2.getId(), r2.getPosX(), r2.getPosY());
                this.setDistanceInMinutesFromCache(r1, r2, distance);
            }
            return distance;
        }

        public int getDistanceInMinutes(Placement p1, Placement p2) {
            if (p1.isMultiRoom()) {
                if (p2.isMultiRoom()) {
                    int dist = 0;
                    for (RoomLocation r1 : p1.getRoomLocations()) {
                        for (RoomLocation r2 : p2.getRoomLocations()) {
                            dist = Math.max(dist, this.getDistanceInMinutes(r1, r2));
                        }
                    }
                    return dist;
                }
                if (p2.getRoomLocation() == null) {
                    return 0;
                }
                int dist = 0;
                for (RoomLocation r1 : p1.getRoomLocations()) {
                    dist = Math.max(dist, this.getDistanceInMinutes(r1, p2.getRoomLocation()));
                }
                return dist;
            }
            if (p2.isMultiRoom()) {
                if (p1.getRoomLocation() == null) {
                    return 0;
                }
                int dist = 0;
                for (RoomLocation r2 : p2.getRoomLocations()) {
                    dist = Math.max(dist, this.getDistanceInMinutes(p1.getRoomLocation(), r2));
                }
                return dist;
            }
            if (p1.getRoomLocation() == null || p2.getRoomLocation() == null) {
                return 0;
            }
            return this.getDistanceInMinutes(p1.getRoomLocation(), p2.getRoomLocation());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer getUnavailabilityDistanceInMinutesFromCache(RoomLocation r1, RoomLocation r2) {
            ReentrantReadWriteLock.ReadLock lock = this.iLock.readLock();
            lock.lock();
            try {
                Map<Long, Integer> other2distance = this.iUnavailabilityDistanceCache.get(r1.getId());
                Integer n = other2distance == null ? null : other2distance.get(r2.getId());
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setUnavailabilityDistanceInMinutesFromCache(RoomLocation r1, RoomLocation r2, Integer distance) {
            ReentrantReadWriteLock.WriteLock lock = this.iLock.writeLock();
            lock.lock();
            try {
                Map<Long, Integer> other2distance = this.iUnavailabilityDistanceCache.get(r1.getId());
                if (other2distance == null) {
                    other2distance = new HashMap<Long, Integer>();
                    this.iUnavailabilityDistanceCache.put(r1.getId(), other2distance);
                }
                other2distance.put(r2.getId(), distance);
            }
            finally {
                lock.unlock();
            }
        }

        protected int getUnavailabilityDistanceInMinutes(RoomLocation r1, RoomLocation r2) {
            if (this.iUnavailabilityDistanceMetric == null) {
                return this.getDistanceInMinutes(r1, r2);
            }
            if (r1.getId().compareTo(r2.getId()) > 0) {
                return this.getUnavailabilityDistanceInMinutes(r2, r1);
            }
            if (r1.getId().equals(r2.getId()) || r1.getIgnoreTooFar() || r2.getIgnoreTooFar()) {
                return 0;
            }
            if (r1.getPosX() == null || r1.getPosY() == null || r2.getPosX() == null || r2.getPosY() == null) {
                return this.iUnavailabilityDistanceMetric.getMaxTravelDistanceInMinutes();
            }
            Integer distance = this.getUnavailabilityDistanceInMinutesFromCache(r1, r2);
            if (distance == null) {
                distance = this.iUnavailabilityDistanceMetric.getDistanceInMinutes(r1.getId(), r1.getPosX(), r1.getPosY(), r2.getId(), r2.getPosX(), r2.getPosY());
                this.setUnavailabilityDistanceInMinutesFromCache(r1, r2, distance);
            }
            return distance;
        }

        public int getUnavailabilityDistanceInMinutes(Placement p1, Unavailability p2) {
            if (p1.isMultiRoom()) {
                int dist = 0;
                for (RoomLocation r1 : p1.getRoomLocations()) {
                    for (RoomLocation r2 : p2.getRooms()) {
                        dist = Math.max(dist, this.getUnavailabilityDistanceInMinutes(r1, r2));
                    }
                }
                return dist;
            }
            if (p1.getRoomLocation() == null) {
                return 0;
            }
            int dist = 0;
            for (RoomLocation r2 : p2.getRooms()) {
                dist = Math.max(dist, this.getUnavailabilityDistanceInMinutes(p1.getRoomLocation(), r2));
            }
            return dist;
        }
    }

    public class Conflict {
        private Type iType;
        private int iPenalty;
        private Student iStudent;
        private SctAssignment iA1;
        private SctAssignment iA2;
        private Enrollment iE1;
        private Enrollment iE2;
        private int iHashCode;

        public Conflict(Student student, Type type, int penalty, Enrollment e1, SctAssignment a1, Enrollment e2, SctAssignment a2) {
            this.iStudent = student;
            if (a1.compareById(a2) < 0) {
                this.iA1 = a1;
                this.iA2 = a2;
                this.iE1 = e1;
                this.iE2 = e2;
            } else {
                this.iA1 = a2;
                this.iA2 = a1;
                this.iE1 = e2;
                this.iE2 = e1;
            }
            this.iHashCode = (this.iStudent.getId() + ":" + this.iA1.getId() + ":" + this.iA2.getId()).hashCode();
            this.iType = type;
            this.iPenalty = penalty;
        }

        public Conflict(Student student, Type type, int penalty, Enrollment e1, SctAssignment a1, SctAssignment a2) {
            this(student, type, penalty, e1, a1, a2 instanceof FreeTimeRequest ? ((FreeTimeRequest)a2).createEnrollment() : (a2 instanceof Unavailability ? ((Unavailability)a2).createEnrollment() : e1), a2);
        }

        public Student getStudent() {
            return this.iStudent;
        }

        public SctAssignment getS1() {
            return this.iA1;
        }

        public SctAssignment getS2() {
            return this.iA2;
        }

        public Request getR1() {
            return this.iE1.getRequest();
        }

        public double getR1Weight() {
            return this.iE1.getRequest() == null ? 0.0 : this.iE1.getRequest().getWeight();
        }

        public double getR2Weight() {
            return this.iE2.getRequest() == null ? 0.0 : this.iE2.getRequest().getWeight();
        }

        public Request getR2() {
            return this.iE2.getRequest();
        }

        public Enrollment getE1() {
            return this.iE1;
        }

        public Enrollment getE2() {
            return this.iE2;
        }

        public int hashCode() {
            return this.iHashCode;
        }

        public int getPenalty() {
            return this.iPenalty;
        }

        public Enrollment getOther(Enrollment enrollment) {
            return this.getE1().getRequest().equals((Object)enrollment.getRequest()) ? this.getE2() : this.getE1();
        }

        public double getWeight(Enrollment e) {
            return this.iType.getWeight(StudentQuality.this.iContext, this, e);
        }

        public double getWeight() {
            return (this.iType.getWeight(StudentQuality.this.iContext, this, this.iE1) + this.iType.getWeight(StudentQuality.this.iContext, this, this.iE2)) / 2.0;
        }

        public Type getType() {
            return this.iType;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Conflict)) {
                return false;
            }
            Conflict c = (Conflict)o;
            return this.getType() == c.getType() && this.getStudent().equals(c.getStudent()) && this.getS1().equals(c.getS1()) && this.getS2().equals(c.getS2());
        }

        public String toString() {
            return this.getStudent() + ": (" + (Object)((Object)this.getType()) + ", p:" + this.getPenalty() + ") " + this.getS1() + " -- " + this.getS2();
        }
    }

    public static interface Quality {
        public boolean isApplicable(Context var1, Student var2, Request var3, Request var4);

        public boolean inConflict(Context var1, SctAssignment var2, SctAssignment var3);

        public int penalty(Context var1, Student var2, SctAssignment var3, SctAssignment var4);

        public Iterable<? extends SctAssignment> other(Context var1, Enrollment var2);

        public double getWeight(Context var1, Conflict var2, Enrollment var3);
    }

    public static enum Type {
        CourseTimeOverlap(WeightType.BOTH, "StudentWeights.TimeOverlapFactor", 0.5, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return r1 instanceof CourseRequest && r2 instanceof CourseRequest;
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                if (a1.getTime() == null || a2.getTime() == null) {
                    return false;
                }
                if (((Section)a1).isToIgnoreStudentConflictsWith(a2.getId())) {
                    return false;
                }
                return a1.getTime().hasIntersection(a2.getTime());
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return Math.min(cx.getTimeOverlapMaxLimit() * (double)c.getPenalty() / (double)e.getNrSlots(), cx.getTimeOverlapMaxLimit());
            }
        }),
        FreeTimeOverlap(WeightType.REQUEST, "StudentWeights.TimeOverlapFactor", 0.5, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return false;
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                if (a1.getTime() == null || a2.getTime() == null) {
                    return false;
                }
                return a1.getTime().hasIntersection(a2.getTime());
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return e.isCourseRequest() ? new FreeTimes(e.getStudent()) : new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return Math.min(cx.getTimeOverlapMaxLimit() * (double)c.getPenalty() / (double)c.getE1().getNrSlots(), cx.getTimeOverlapMaxLimit());
            }
        }),
        Unavailability(WeightType.REQUEST, "StudentWeights.TimeOverlapFactor", 0.5, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return false;
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                if (a1.getTime() == null || a2.getTime() == null) {
                    return false;
                }
                return a1.getTime().hasIntersection(a2.getTime());
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return e.isCourseRequest() ? new Unavailabilities(e.getStudent()) : new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return Math.min(cx.getTimeOverlapMaxLimit() * (double)c.getPenalty() / (double)c.getE1().getNrSlots(), cx.getTimeOverlapMaxLimit());
            }
        }),
        Distance(WeightType.LOWER, "StudentWeights.DistanceConflict", 0.01, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return r1 instanceof CourseRequest && r2 instanceof CourseRequest;
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment sa1, SctAssignment sa2) {
                int dist;
                TimeLocation t2;
                Section s1 = (Section)sa1;
                Section s2 = (Section)sa2;
                if (s1.getPlacement() == null || s2.getPlacement() == null) {
                    return false;
                }
                TimeLocation t1 = s1.getTime();
                if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
                    return false;
                }
                int a1 = t1.getStartSlot();
                int a2 = t2.getStartSlot();
                return cx.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses() ? (a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength())) : (a1 + t1.getNrSlotsPerMeeting() == a2 ? (dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > t1.getBreakTime() : a2 + t2.getNrSlotsPerMeeting() == a1 && (dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > t2.getBreakTime());
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                return this.inConflict(cx, a1, a2) ? 1 : 0;
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return c.getPenalty();
            }
        }),
        ShortDistance(WeightType.LOWER, "StudentWeights.ShortDistanceConflict", 0.1, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return student.isNeedShortDistances() && r1 instanceof CourseRequest && r2 instanceof CourseRequest;
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment sa1, SctAssignment sa2) {
                int dist;
                TimeLocation t2;
                Section s1 = (Section)sa1;
                Section s2 = (Section)sa2;
                if (s1.getPlacement() == null || s2.getPlacement() == null) {
                    return false;
                }
                TimeLocation t1 = s1.getTime();
                if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
                    return false;
                }
                int a1 = t1.getStartSlot();
                int a2 = t2.getStartSlot();
                return cx.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses() ? (a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength())) : (a1 + t1.getNrSlotsPerMeeting() == a2 ? (dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > 0 : a2 + t2.getNrSlotsPerMeeting() == a1 && (dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > 0);
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                return this.inConflict(cx, a1, a2) ? 1 : 0;
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return c.getPenalty();
            }
        }),
        LunchBreak(WeightType.BOTH, "StudentWeights.LunchBreakFactor", 0.005, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return r1 instanceof CourseRequest && r2 instanceof CourseRequest && !student.isDummy();
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                TimeLocation t2;
                if (a1.getTime() == null || a2.getTime() == null) {
                    return false;
                }
                if (((Section)a1).isToIgnoreStudentConflictsWith(a2.getId())) {
                    return false;
                }
                if (a1.getTime().hasIntersection(a2.getTime())) {
                    return false;
                }
                TimeLocation t1 = a1.getTime();
                if (!t1.shareDays(t2 = a2.getTime()) || !t1.shareWeeks(t2)) {
                    return false;
                }
                int s1 = t1.getStartSlot();
                int s2 = t2.getStartSlot();
                int e1 = t1.getStartSlot() + t1.getNrSlotsPerMeeting();
                int e2 = t2.getStartSlot() + t2.getNrSlotsPerMeeting();
                return e1 + cx.getLunchLength() > s2 && e2 + cx.getLunchLength() > s1 && e1 > cx.getLunchStart() && cx.getLunchEnd() > s1 && e2 > cx.getLunchStart() && cx.getLunchEnd() > s2;
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime());
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return c.getPenalty();
            }
        }),
        TravelTime(WeightType.BOTH, "StudentWeights.TravelTimeFactor", 0.001, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return r1 instanceof CourseRequest && r2 instanceof CourseRequest && !student.isDummy();
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment sa1, SctAssignment sa2) {
                TimeLocation t2;
                Section s1 = (Section)sa1;
                Section s2 = (Section)sa2;
                if (s1.getPlacement() == null || s2.getPlacement() == null) {
                    return false;
                }
                TimeLocation t1 = s1.getTime();
                if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
                    return false;
                }
                int a1 = t1.getStartSlot();
                int a2 = t2.getStartSlot();
                if (a1 + t1.getNrSlotsPerMeeting() <= a2) {
                    int gap = a2 - (a1 + t1.getNrSlotsPerMeeting());
                    int dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement());
                    return gap < cx.getMaxTravelGap() && dist > 0 || gap < 2 * cx.getMaxTravelGap() && dist > t1.getBreakTime();
                }
                if (a2 + t2.getNrSlotsPerMeeting() <= a1) {
                    int gap = a1 - (a2 + t2.getNrSlotsPerMeeting());
                    int dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement());
                    return gap < cx.getMaxTravelGap() && dist > 0 || gap < 2 * cx.getMaxTravelGap() && dist > t2.getBreakTime();
                }
                return false;
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment sa1, SctAssignment sa2) {
                TimeLocation t2;
                Section s1 = (Section)sa1;
                Section s2 = (Section)sa2;
                if (s1.getPlacement() == null || s2.getPlacement() == null) {
                    return 0;
                }
                TimeLocation t1 = s1.getTime();
                if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
                    return 0;
                }
                int a1 = t1.getStartSlot();
                int a2 = t2.getStartSlot();
                if (a1 + t1.getNrSlotsPerMeeting() <= a2) {
                    int gap = a2 - (a1 + t1.getNrSlotsPerMeeting());
                    int dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement());
                    if (gap < cx.getMaxTravelGap() && dist > 0 || gap < 2 * cx.getMaxTravelGap() && dist > t1.getBreakTime()) {
                        return dist;
                    }
                } else if (a2 + t2.getNrSlotsPerMeeting() <= a1) {
                    int gap = a1 - (a2 + t2.getNrSlotsPerMeeting());
                    int dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement());
                    if (gap < cx.getMaxTravelGap() && dist > 0 || gap < 2 * cx.getMaxTravelGap() && dist > t2.getBreakTime()) {
                        return dist;
                    }
                }
                return 0;
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return c.getPenalty();
            }
        }),
        BackToBack(WeightType.BOTH, "StudentWeights.BackToBackFactor", -1.0E-4, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return r1 instanceof CourseRequest && r2 instanceof CourseRequest && !student.isDummy() && (student.getBackToBackPreference() == Student.BackToBackPreference.BTB_PREFERRED || student.getBackToBackPreference() == Student.BackToBackPreference.BTB_DISCOURAGED);
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                TimeLocation t1 = a1.getTime();
                TimeLocation t2 = a2.getTime();
                if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
                    return false;
                }
                if (t1.getStartSlot() + t1.getNrSlotsPerMeeting() <= t2.getStartSlot()) {
                    int dist = t2.getStartSlot() - (t1.getStartSlot() + t1.getNrSlotsPerMeeting());
                    return dist <= cx.getBackToBackDistance();
                }
                if (t2.getStartSlot() + t2.getNrSlotsPerMeeting() <= t1.getStartSlot()) {
                    int dist = t1.getStartSlot() - (t2.getStartSlot() + t2.getNrSlotsPerMeeting());
                    return dist <= cx.getBackToBackDistance();
                }
                return false;
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                if (s.getBackToBackPreference() == Student.BackToBackPreference.BTB_PREFERRED) {
                    return a1.getTime().nrSharedDays(a2.getTime());
                }
                if (s.getBackToBackPreference() == Student.BackToBackPreference.BTB_DISCOURAGED) {
                    return -a1.getTime().nrSharedDays(a2.getTime());
                }
                return 0;
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return c.getPenalty();
            }
        }),
        WorkDay(WeightType.BOTH, "StudentWeights.WorkDayFactor", 0.01, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return r1 instanceof CourseRequest && r2 instanceof CourseRequest && !student.isDummy();
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                TimeLocation t1 = a1.getTime();
                TimeLocation t2 = a2.getTime();
                if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
                    return false;
                }
                int dist = Math.max(t1.getStartSlot() + t1.getLength(), t2.getStartSlot() + t2.getLength()) - Math.min(t1.getStartSlot(), t2.getStartSlot());
                return dist > cx.getWorkDayLimit();
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                TimeLocation t1 = a1.getTime();
                TimeLocation t2 = a2.getTime();
                if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
                    return 0;
                }
                int dist = Math.max(t1.getStartSlot() + t1.getLength(), t2.getStartSlot() + t2.getLength()) - Math.min(t1.getStartSlot(), t2.getStartSlot());
                if (dist > cx.getWorkDayLimit()) {
                    return a1.getTime().nrSharedDays(a2.getTime()) * (dist - cx.getWorkDayLimit());
                }
                return 0;
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return (double)c.getPenalty() / 12.0;
            }
        }),
        TooEarly(WeightType.REQUEST, "StudentWeights.TooEarlyFactor", 0.05, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return false;
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                if (a1.getTime() == null || a2.getTime() == null) {
                    return false;
                }
                return a1.getTime().shareDays(a2.getTime()) && a1.getTime().shareHours(a2.getTime());
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return e.isCourseRequest() && !e.getStudent().isDummy() ? new SingleTimeIterable(0, cx.getEarlySlot()) : new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return Math.min(cx.getTimeOverlapMaxLimit() * (double)c.getPenalty() / (double)c.getE1().getNrSlots(), cx.getTimeOverlapMaxLimit());
            }
        }),
        TooLate(WeightType.REQUEST, "StudentWeights.TooLateFactor", 0.025, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return false;
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                if (a1.getTime() == null || a2.getTime() == null) {
                    return false;
                }
                return a1.getTime().shareDays(a2.getTime()) && a1.getTime().shareHours(a2.getTime());
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return e.isCourseRequest() && !e.getStudent().isDummy() ? new SingleTimeIterable(cx.getLateSlot(), 288) : new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return Math.min(cx.getTimeOverlapMaxLimit() * (double)c.getPenalty() / (double)c.getE1().getNrSlots(), cx.getTimeOverlapMaxLimit());
            }
        }),
        Modality(WeightType.REQUEST, "StudentWeights.ModalityFactor", 0.05, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return false;
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                return a1.equals(a2);
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                return this.inConflict(cx, a1, a2) ? 1 : 0;
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                if (!e.isCourseRequest() || e.getStudent().isDummy()) {
                    return new Nothing();
                }
                if (e.getStudent().getModalityPreference() == Student.ModalityPreference.ONLINE_PREFERRED) {
                    return new Online(e, false);
                }
                if (e.getStudent().getModalityPreference() == Student.ModalityPreference.ONILNE_DISCOURAGED) {
                    return new Online(e, true);
                }
                return new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return (double)c.getPenalty() / (double)e.getSections().size();
            }
        }),
        AccFreeTimeOverlap(WeightType.REQUEST, "Accommodations.FreeTimeOverlapFactor", 0.5, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return false;
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                if (a1.getTime() == null || a2.getTime() == null) {
                    return false;
                }
                return a1.getTime().hasIntersection(a2.getTime());
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                if (!e.getStudent().hasAccommodation(cx.getFreeTimeAccommodation())) {
                    return new Nothing();
                }
                return e.isCourseRequest() ? new FreeTimes(e.getStudent()) : new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return Math.min(cx.getTimeOverlapMaxLimit() * (double)c.getPenalty() / (double)c.getE1().getNrSlots(), cx.getTimeOverlapMaxLimit());
            }
        }),
        AccBackToBack(WeightType.BOTH, "Accommodations.BackToBackFactor", 0.001, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return r1 instanceof CourseRequest && r2 instanceof CourseRequest && !student.isDummy() && student.hasAccommodation(cx.getBackToBackAccommodation());
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                TimeLocation t1 = a1.getTime();
                TimeLocation t2 = a2.getTime();
                if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
                    return false;
                }
                if (t1.getStartSlot() + t1.getNrSlotsPerMeeting() <= t2.getStartSlot()) {
                    int dist = t2.getStartSlot() - (t1.getStartSlot() + t1.getNrSlotsPerMeeting());
                    return dist > cx.getBackToBackDistance();
                }
                if (t2.getStartSlot() + t2.getNrSlotsPerMeeting() <= t1.getStartSlot()) {
                    int dist = t1.getStartSlot() - (t2.getStartSlot() + t2.getNrSlotsPerMeeting());
                    return dist > cx.getBackToBackDistance();
                }
                return false;
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime());
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return c.getPenalty();
            }
        }),
        AccBreaksBetweenClasses(WeightType.BOTH, "Accommodations.BreaksBetweenClassesFactor", 0.001, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return r1 instanceof CourseRequest && r2 instanceof CourseRequest && !student.isDummy() && student.hasAccommodation(cx.getBreakBetweenClassesAccommodation());
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
                TimeLocation t1 = a1.getTime();
                TimeLocation t2 = a2.getTime();
                if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
                    return false;
                }
                if (t1.getStartSlot() + t1.getNrSlotsPerMeeting() <= t2.getStartSlot()) {
                    int dist = t2.getStartSlot() - (t1.getStartSlot() + t1.getNrSlotsPerMeeting());
                    return dist <= cx.getBackToBackDistance();
                }
                if (t2.getStartSlot() + t2.getNrSlotsPerMeeting() <= t1.getStartSlot()) {
                    int dist = t1.getStartSlot() - (t2.getStartSlot() + t2.getNrSlotsPerMeeting());
                    return dist <= cx.getBackToBackDistance();
                }
                return false;
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime());
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return c.getPenalty();
            }
        }),
        UnavailabilityDistance(WeightType.REQUEST, "StudentWeights.UnavailabilityDistanceConflict", 0.1, new Quality(){

            @Override
            public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
                return false;
            }

            @Override
            public boolean inConflict(Context cx, SctAssignment sa1, SctAssignment sa2) {
                int dist;
                TimeLocation t2;
                Section s1 = (Section)sa1;
                Unavailability s2 = (Unavailability)sa2;
                if (s1.getPlacement() == null || s2.getTime() == null || s2.getNrRooms() == 0) {
                    return false;
                }
                TimeLocation t1 = s1.getTime();
                if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
                    return false;
                }
                int a1 = t1.getStartSlot();
                int a2 = t2.getStartSlot();
                return a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist = cx.getUnavailabilityDistanceInMinutes(s1.getPlacement(), s2)) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = cx.getUnavailabilityDistanceInMinutes(s1.getPlacement(), s2)) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength());
            }

            @Override
            public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(cx, a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime());
            }

            @Override
            public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
                return e.isCourseRequest() ? new Unavailabilities(e.getStudent()) : new Nothing();
            }

            @Override
            public double getWeight(Context cx, Conflict c, Enrollment e) {
                return c.getPenalty();
            }
        });

        private WeightType iType;
        private Quality iQuality;
        private String iWeightName;
        private double iWeightDefault;

        private Type(WeightType type, String weightName, double weightDefault, Quality quality) {
            this.iQuality = quality;
            this.iType = type;
            this.iWeightName = weightName;
            this.iWeightDefault = weightDefault;
        }

        public boolean isApplicable(Context cx, Student student, Request r1, Request r2) {
            return this.iQuality.isApplicable(cx, student, r1, r2);
        }

        public boolean inConflict(Context cx, SctAssignment a1, SctAssignment a2) {
            return this.iQuality.inConflict(cx, a1, a2);
        }

        public int penalty(Context cx, Student s, SctAssignment a1, SctAssignment a2) {
            return this.iQuality.penalty(cx, s, a1, a2);
        }

        public Iterable<? extends SctAssignment> other(Context cx, Enrollment e) {
            return this.iQuality.other(cx, e);
        }

        public double getWeight(Context cx, Conflict c, Enrollment e) {
            return this.iQuality.getWeight(cx, c, e);
        }

        public String getName() {
            return this.name().replaceAll("(?<=[^A-Z0-9])([A-Z0-9])", " $1");
        }

        public String getAbbv() {
            return this.getName().replaceAll("[a-z ]", "");
        }

        public WeightType getType() {
            return this.iType;
        }

        public String getWeightName() {
            return this.iWeightName;
        }

        public double getWeightDefault() {
            return this.iWeightDefault;
        }
    }

    public static enum WeightType {
        HIGHER,
        LOWER,
        BOTH,
        REQUEST;

    }
}

