/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Unavailability;

public class HardDistanceConflicts
extends GlobalConstraint<Request, Enrollment> {
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        int dist;
        int a2;
        int a1;
        TimeLocation t2;
        TimeLocation t1;
        if (((Request)enrollment.variable()).getModel() == null || !(((Request)enrollment.variable()).getModel() instanceof StudentSectioningModel)) {
            return;
        }
        StudentSectioningModel model = (StudentSectioningModel)((Request)enrollment.variable()).getModel();
        StudentQuality studentQuality = model.getStudentQuality();
        if (studentQuality == null) {
            return;
        }
        StudentQuality.Context cx = studentQuality.getStudentQualityContext();
        if (enrollment.getReservation() != null && enrollment.getReservation().isAllowOverlap()) {
            return;
        }
        Student student = enrollment.getStudent();
        if (student.getUnavailabilities().isEmpty()) {
            return;
        }
        Config config = enrollment.getConfig();
        if (config == null) {
            return;
        }
        if (cx.getUnavailabilityDistanceMetric().isHardDistanceConflictsEnabled()) {
            for (Section s1 : enrollment.getSections()) {
                if (!s1.hasTime() || s1.getNrRooms() == 0 || s1.isAllowOverlap()) continue;
                for (Unavailability unavailability : student.getUnavailabilities()) {
                    if (unavailability.getTime() == null || unavailability.getNrRooms() == 0 || !(t1 = s1.getTime()).shareDays(t2 = unavailability.getTime()) || !t1.shareWeeks(t2)) continue;
                    a1 = t1.getStartSlot();
                    a2 = t2.getStartSlot();
                    if (a1 + t1.getNrSlotsPerMeeting() <= a2) {
                        dist = cx.getUnavailabilityDistanceInMinutes(s1.getPlacement(), unavailability);
                        if (dist < cx.getUnavailabilityDistanceMetric().getDistanceHardLimitInMinutes() || dist <= t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) + cx.getUnavailabilityDistanceMetric().getAllowedDistanceInMinutes()) continue;
                        conflicts.add(enrollment);
                        return;
                    }
                    if (a2 + t2.getNrSlotsPerMeeting() > a1 || (dist = cx.getUnavailabilityDistanceInMinutes(s1.getPlacement(), unavailability)) < cx.getUnavailabilityDistanceMetric().getDistanceHardLimitInMinutes() || dist <= t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength()) + cx.getUnavailabilityDistanceMetric().getAllowedDistanceInMinutes()) continue;
                    conflicts.add(enrollment);
                    return;
                }
            }
        }
        if (cx.getDistanceMetric().isHardDistanceConflictsEnabled()) {
            for (Section s1 : enrollment.getSections()) {
                if (!s1.hasTime() || s1.getNrRooms() == 0 || s1.isAllowOverlap()) continue;
                for (Section section : enrollment.getSections()) {
                    if (s1.getId() >= section.getId() || !section.hasTime() || section.getNrRooms() == 0 || section.isAllowOverlap() || s1.isToIgnoreStudentConflictsWith(section.getId()) || !(t1 = s1.getTime()).shareDays(t2 = section.getTime()) || !t1.shareWeeks(t2)) continue;
                    a1 = t1.getStartSlot();
                    a2 = t2.getStartSlot();
                    if (cx.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) {
                        if (a1 + t1.getNrSlotsPerMeeting() <= a2) {
                            dist = cx.getDistanceInMinutes(s1.getPlacement(), section.getPlacement());
                            if (dist < cx.getDistanceMetric().getDistanceHardLimitInMinutes() || dist <= t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) + cx.getDistanceMetric().getAllowedDistanceInMinutes()) continue;
                            conflicts.add(enrollment);
                            return;
                        }
                        if (a2 + t2.getNrSlotsPerMeeting() > a1 || (dist = cx.getDistanceInMinutes(s1.getPlacement(), section.getPlacement())) < cx.getDistanceMetric().getDistanceHardLimitInMinutes() || dist <= t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength()) + cx.getDistanceMetric().getAllowedDistanceInMinutes()) continue;
                        conflicts.add(enrollment);
                        return;
                    }
                    if (a1 + t1.getNrSlotsPerMeeting() == a2) {
                        dist = cx.getDistanceInMinutes(s1.getPlacement(), section.getPlacement());
                        if (dist < cx.getDistanceMetric().getDistanceHardLimitInMinutes() || dist <= t1.getBreakTime() + cx.getDistanceMetric().getAllowedDistanceInMinutes()) continue;
                        conflicts.add(enrollment);
                        return;
                    }
                    if (a2 + t2.getNrSlotsPerMeeting() != a1 || (dist = cx.getDistanceInMinutes(s1.getPlacement(), section.getPlacement())) < cx.getDistanceMetric().getDistanceHardLimitInMinutes() || dist <= t2.getBreakTime() + cx.getDistanceMetric().getAllowedDistanceInMinutes()) continue;
                    conflicts.add(enrollment);
                    return;
                }
            }
            block4: for (Request other : student.getRequests()) {
                Enrollment e2;
                if (other.equals(enrollment.variable()) || (e2 = (Enrollment)other.getAssignment(assignment)) == null || conflicts.contains((Object)e2) || e2.getReservation() != null && e2.getReservation().isAllowOverlap()) continue;
                for (Section s1 : enrollment.getSections()) {
                    if (!s1.hasTime() || s1.getNrRooms() == 0 || s1.isAllowOverlap()) continue;
                    for (Section s2 : e2.getSections()) {
                        int dist2;
                        TimeLocation t22;
                        TimeLocation t12;
                        if (!s2.hasTime() || s2.getNrRooms() == 0 || s2.isAllowOverlap() || s1.isToIgnoreStudentConflictsWith(s2.getId()) || !(t12 = s1.getTime()).shareDays(t22 = s2.getTime()) || !t12.shareWeeks(t22)) continue;
                        int a12 = t12.getStartSlot();
                        int a22 = t22.getStartSlot();
                        if (cx.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) {
                            if (a12 + t12.getNrSlotsPerMeeting() <= a22) {
                                int dist22 = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement());
                                if (dist22 < cx.getDistanceMetric().getDistanceHardLimitInMinutes() || dist22 <= t12.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a22 - a12 - t12.getLength()) + cx.getDistanceMetric().getAllowedDistanceInMinutes()) continue;
                                conflicts.add(e2);
                                continue block4;
                            }
                            if (a22 + t22.getNrSlotsPerMeeting() > a12 || (dist2 = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) < cx.getDistanceMetric().getDistanceHardLimitInMinutes() || dist2 <= t22.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a12 - a22 - t22.getLength()) + cx.getDistanceMetric().getAllowedDistanceInMinutes()) continue;
                            conflicts.add(e2);
                            continue block4;
                        }
                        if (a12 + t12.getNrSlotsPerMeeting() == a22) {
                            dist2 = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement());
                            if (dist2 < cx.getDistanceMetric().getDistanceHardLimitInMinutes() || dist2 <= t12.getBreakTime() + cx.getDistanceMetric().getAllowedDistanceInMinutes()) continue;
                            conflicts.add(e2);
                            continue block4;
                        }
                        if (a22 + t22.getNrSlotsPerMeeting() != a12 || (dist2 = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) < cx.getDistanceMetric().getDistanceHardLimitInMinutes() || dist2 <= t22.getBreakTime() + cx.getDistanceMetric().getAllowedDistanceInMinutes()) continue;
                        conflicts.add(e2);
                        continue block4;
                    }
                }
            }
        }
    }

    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        int dist;
        int a2;
        int a1;
        TimeLocation t2;
        TimeLocation t1;
        if (((Request)enrollment.variable()).getModel() == null || !(((Request)enrollment.variable()).getModel() instanceof StudentSectioningModel)) {
            return false;
        }
        StudentSectioningModel model = (StudentSectioningModel)((Request)enrollment.variable()).getModel();
        StudentQuality studentQuality = model.getStudentQuality();
        if (studentQuality == null) {
            return false;
        }
        StudentQuality.Context cx = studentQuality.getStudentQualityContext();
        if (enrollment.getReservation() != null && enrollment.getReservation().isAllowOverlap()) {
            return false;
        }
        Student student = enrollment.getStudent();
        if (student.getUnavailabilities().isEmpty()) {
            return false;
        }
        Config config = enrollment.getConfig();
        if (config == null) {
            return false;
        }
        if (cx.getUnavailabilityDistanceMetric().isHardDistanceConflictsEnabled()) {
            for (Section s1 : enrollment.getSections()) {
                if (!s1.hasTime() || s1.getNrRooms() == 0 || s1.isAllowOverlap()) continue;
                for (Unavailability unavailability : student.getUnavailabilities()) {
                    if (unavailability.getTime() == null || unavailability.getNrRooms() == 0 || unavailability.isAllowOverlap() || !(t1 = s1.getTime()).shareDays(t2 = unavailability.getTime()) || !t1.shareWeeks(t2)) continue;
                    a1 = t1.getStartSlot();
                    a2 = t2.getStartSlot();
                    if (!(a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist = cx.getUnavailabilityDistanceInMinutes(s1.getPlacement(), unavailability)) >= cx.getUnavailabilityDistanceMetric().getDistanceHardLimitInMinutes() && dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) + cx.getUnavailabilityDistanceMetric().getAllowedDistanceInMinutes() : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = cx.getUnavailabilityDistanceInMinutes(s1.getPlacement(), unavailability)) >= cx.getUnavailabilityDistanceMetric().getDistanceHardLimitInMinutes() && dist > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength()) + cx.getUnavailabilityDistanceMetric().getAllowedDistanceInMinutes())) continue;
                    return true;
                }
            }
        }
        if (cx.getDistanceMetric().isHardDistanceConflictsEnabled()) {
            for (Section s1 : enrollment.getSections()) {
                if (!s1.hasTime() || s1.getNrRooms() == 0 || s1.isAllowOverlap()) continue;
                for (Section section : enrollment.getSections()) {
                    if (s1.getId() >= section.getId() || !section.hasTime() || section.getNrRooms() == 0 || section.isAllowOverlap() || s1.isToIgnoreStudentConflictsWith(section.getId()) || !(t1 = s1.getTime()).shareDays(t2 = section.getTime()) || !t1.shareWeeks(t2)) continue;
                    a1 = t1.getStartSlot();
                    a2 = t2.getStartSlot();
                    if (!(cx.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses() ? (a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist = cx.getDistanceInMinutes(s1.getPlacement(), section.getPlacement())) >= cx.getDistanceMetric().getDistanceHardLimitInMinutes() && dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) + cx.getDistanceMetric().getAllowedDistanceInMinutes() : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = cx.getDistanceInMinutes(s1.getPlacement(), section.getPlacement())) >= cx.getDistanceMetric().getDistanceHardLimitInMinutes() && dist > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength()) + cx.getDistanceMetric().getAllowedDistanceInMinutes()) : (a1 + t1.getNrSlotsPerMeeting() == a2 ? (dist = cx.getDistanceInMinutes(s1.getPlacement(), section.getPlacement())) >= cx.getDistanceMetric().getDistanceHardLimitInMinutes() && dist > t1.getBreakTime() + cx.getDistanceMetric().getAllowedDistanceInMinutes() : a2 + t2.getNrSlotsPerMeeting() == a1 && (dist = cx.getDistanceInMinutes(s1.getPlacement(), section.getPlacement())) >= cx.getDistanceMetric().getDistanceHardLimitInMinutes() && dist > t2.getBreakTime() + cx.getDistanceMetric().getAllowedDistanceInMinutes()))) continue;
                    return true;
                }
            }
            for (Request other : student.getRequests()) {
                Enrollment e2;
                if (other.equals(enrollment.variable()) || (e2 = (Enrollment)other.getAssignment(assignment)) == null || e2.getReservation() != null && e2.getReservation().isAllowOverlap()) continue;
                for (Section s1 : enrollment.getSections()) {
                    if (!s1.hasTime() || s1.getNrRooms() == 0 || s1.isAllowOverlap()) continue;
                    for (Section s2 : e2.getSections()) {
                        int dist2;
                        int dist22;
                        TimeLocation t22;
                        TimeLocation t12;
                        if (!s2.hasTime() || s2.getNrRooms() == 0 || s2.isAllowOverlap() || s1.isToIgnoreStudentConflictsWith(s2.getId()) || !(t12 = s1.getTime()).shareDays(t22 = s2.getTime()) || !t12.shareWeeks(t22)) continue;
                        int a12 = t12.getStartSlot();
                        int a22 = t22.getStartSlot();
                        if (!(cx.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses() ? (a12 + t12.getNrSlotsPerMeeting() <= a22 ? (dist22 = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) >= cx.getDistanceMetric().getDistanceHardLimitInMinutes() && dist22 > t12.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a22 - a12 - t12.getLength()) + cx.getDistanceMetric().getAllowedDistanceInMinutes() : a22 + t22.getNrSlotsPerMeeting() <= a12 && (dist2 = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) >= cx.getDistanceMetric().getDistanceHardLimitInMinutes() && dist2 > t22.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a12 - a22 - t22.getLength()) + cx.getDistanceMetric().getAllowedDistanceInMinutes()) : (a12 + t12.getNrSlotsPerMeeting() == a22 ? (dist2 = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) >= cx.getDistanceMetric().getDistanceHardLimitInMinutes() && dist2 > t12.getBreakTime() + cx.getDistanceMetric().getAllowedDistanceInMinutes() : a22 + t22.getNrSlotsPerMeeting() == a12 && (dist2 = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) >= cx.getDistanceMetric().getDistanceHardLimitInMinutes() && dist2 > t22.getBreakTime() + cx.getDistanceMetric().getAllowedDistanceInMinutes()))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean inConflict(StudentQuality sq, Section s1, Unavailability s2) {
        int dist;
        TimeLocation t2;
        if (sq == null || s1 == null || s2 == null) {
            return false;
        }
        if (s1.getPlacement() == null || s2.getTime() == null || s2.getNrRooms() == 0 || s1.isAllowOverlap() || s2.isAllowOverlap()) {
            return false;
        }
        StudentQuality.Context cx = sq.getStudentQualityContext();
        if (!cx.getUnavailabilityDistanceMetric().isHardDistanceConflictsEnabled()) {
            return false;
        }
        TimeLocation t1 = s1.getTime();
        if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getStartSlot();
        int a2 = t2.getStartSlot();
        return a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist = cx.getUnavailabilityDistanceInMinutes(s1.getPlacement(), s2)) >= cx.getUnavailabilityDistanceMetric().getDistanceHardLimitInMinutes() && dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) + cx.getUnavailabilityDistanceMetric().getAllowedDistanceInMinutes() : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = cx.getUnavailabilityDistanceInMinutes(s1.getPlacement(), s2)) >= cx.getUnavailabilityDistanceMetric().getDistanceHardLimitInMinutes() && dist > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength()) + cx.getUnavailabilityDistanceMetric().getAllowedDistanceInMinutes();
    }

    public static boolean inConflict(StudentQuality sq, Section s1, Section s2) {
        int dist;
        TimeLocation t2;
        if (sq == null || s1 == null || s2 == null) {
            return false;
        }
        if (s1.getPlacement() == null || s2.getPlacement() == null || s1.isAllowOverlap() || s2.isAllowOverlap() || s1.isToIgnoreStudentConflictsWith(s2.getId())) {
            return false;
        }
        StudentQuality.Context cx = sq.getStudentQualityContext();
        if (!cx.getDistanceMetric().isHardDistanceConflictsEnabled()) {
            return false;
        }
        TimeLocation t1 = s1.getTime();
        if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getStartSlot();
        int a2 = t2.getStartSlot();
        return a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) >= cx.getDistanceMetric().getDistanceHardLimitInMinutes() && dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) + cx.getDistanceMetric().getAllowedDistanceInMinutes() : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = cx.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) >= cx.getDistanceMetric().getDistanceHardLimitInMinutes() && dist > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength()) + cx.getDistanceMetric().getAllowedDistanceInMinutes();
    }

    public static boolean inConflict(StudentQuality sq, SctAssignment s1, Enrollment e) {
        if (sq == null || s1 == null || e == null) {
            return false;
        }
        if (!sq.getStudentQualityContext().getDistanceMetric().isHardDistanceConflictsEnabled()) {
            return false;
        }
        if (e.getReservation() != null && e.getReservation().isAllowOverlap()) {
            return false;
        }
        if (s1 instanceof Section && e.getCourse() != null) {
            for (SctAssignment s2 : e.getAssignments()) {
                if (!(s2 instanceof Section) || !HardDistanceConflicts.inConflict(sq, (Section)s1, (Section)s2)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "DistanceConflict";
    }
}

