/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.model;

import java.util.ArrayList;
import java.util.List;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.ToolBox;

public class Placement
extends Value<Lecture, Placement> {
    private TimeLocation iTimeLocation;
    private RoomLocation iRoomLocation;
    private List<RoomLocation> iRoomLocations = null;
    private Long iAssignmentId = null;
    private int iHashCode = 0;
    private Double iTimePenalty = null;
    private Integer iRoomPenalty = null;
    private transient Object iAssignment = null;

    public Placement(Lecture lecture, TimeLocation timeLocation, RoomLocation roomLocation) {
        super((Variable)lecture);
        this.iTimeLocation = timeLocation;
        this.iRoomLocation = roomLocation;
        if (this.iRoomLocation == null) {
            this.iRoomLocations = new ArrayList<RoomLocation>(0);
        }
        this.iHashCode = this.getName().hashCode();
    }

    public Placement(Lecture lecture, TimeLocation timeLocation, List<RoomLocation> roomLocations) {
        super((Variable)lecture);
        this.iTimeLocation = timeLocation;
        RoomLocation roomLocation = this.iRoomLocation = roomLocations.isEmpty() ? null : roomLocations.get(0);
        if (roomLocations.size() != 1) {
            this.iRoomLocations = new ArrayList<RoomLocation>(roomLocations);
        }
        if (this.iRoomLocations != null && this.iRoomLocations.size() > 1) {
            boolean hasPreferenceByIndex = false;
            for (RoomLocation r : this.iRoomLocations) {
                if (!r.hasPreferenceByIndex()) continue;
                hasPreferenceByIndex = true;
                break;
            }
            if (hasPreferenceByIndex) {
                this.fixRoomOrder(0, roomLocations, new RoomLocation[this.iRoomLocations.size()], PreferenceCombination.getDefault(), null);
            }
        }
        this.iHashCode = this.getName().hashCode();
    }

    private Integer fixRoomOrder(int idx, List<RoomLocation> rooms, RoomLocation[] current, PreferenceCombination preference, Integer bestSoFar) {
        if (idx == current.length) {
            if (bestSoFar == null || preference.getPreferenceInt() < bestSoFar) {
                this.iRoomLocations.clear();
                for (RoomLocation r : current) {
                    this.iRoomLocations.add(r);
                }
                return preference.getPreferenceInt();
            }
        } else {
            block1: for (RoomLocation r : rooms) {
                for (int i = 0; i < idx; ++i) {
                    if (r.equals(current[i])) continue block1;
                }
                PreferenceCombination pc = preference.clonePreferenceCombination();
                pc.addPreferenceInt(r.getPreference(idx));
                if (pc.isProhibited()) continue;
                current[idx] = r;
                bestSoFar = this.fixRoomOrder(idx + 1, rooms, current, pc, bestSoFar);
            }
        }
        return bestSoFar;
    }

    public TimeLocation getTimeLocation() {
        return this.iTimeLocation;
    }

    public RoomLocation getRoomLocation() {
        return this.iRoomLocation;
    }

    public List<RoomLocation> getRoomLocations() {
        return this.iRoomLocations;
    }

    public List<Long> getBuildingIds() {
        if (this.isMultiRoom()) {
            ArrayList<Long> ret = new ArrayList<Long>(this.iRoomLocations.size());
            for (RoomLocation r : this.iRoomLocations) {
                ret.add(r.getBuildingId());
            }
            return ret;
        }
        ArrayList<Long> ret = new ArrayList<Long>(1);
        ret.add(this.iRoomLocation.getBuildingId());
        return ret;
    }

    public List<Long> getRoomIds() {
        if (this.isMultiRoom()) {
            ArrayList<Long> ret = new ArrayList<Long>(this.iRoomLocations.size());
            for (RoomLocation r : this.iRoomLocations) {
                ret.add(r.getId());
            }
            return ret;
        }
        ArrayList<Long> ret = new ArrayList<Long>(1);
        ret.add(this.iRoomLocation.getId());
        return ret;
    }

    public List<String> getRoomNames() {
        if (this.isMultiRoom()) {
            ArrayList<String> ret = new ArrayList<String>(this.iRoomLocations.size());
            for (RoomLocation r : this.iRoomLocations) {
                ret.add(r.getName());
            }
            return ret;
        }
        ArrayList<String> ret = new ArrayList<String>(1);
        if (this.iRoomLocation != null) {
            ret.add(this.iRoomLocation.getName());
        }
        return ret;
    }

    public List<Integer> getRoomPrefs() {
        if (this.isMultiRoom()) {
            ArrayList<Integer> ret = new ArrayList<Integer>(this.iRoomLocations.size());
            int roomIndex = 0;
            for (RoomLocation r : this.iRoomLocations) {
                ret.add(r.getPreference(roomIndex++));
            }
            return ret;
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(1);
        if (this.iRoomLocation != null) {
            ret.add(this.iRoomLocation.getPreference());
        }
        return ret;
    }

    public boolean isMultiRoom() {
        return this.iRoomLocations != null && this.iRoomLocations.size() != 1;
    }

    public RoomLocation getRoomLocation(Long roomId) {
        if (this.isMultiRoom()) {
            for (RoomLocation r : this.iRoomLocations) {
                if (!r.getId().equals(roomId)) continue;
                return r;
            }
        } else if (this.iRoomLocation != null && this.iRoomLocation.getId().equals(roomId)) {
            return this.iRoomLocation;
        }
        return null;
    }

    public int getRoomLocationIndex(Long roomId) {
        if (this.isMultiRoom()) {
            int idx = 0;
            for (RoomLocation r : this.iRoomLocations) {
                if (r.getId().equals(roomId)) {
                    return idx;
                }
                ++idx;
            }
        } else if (this.iRoomLocation != null && this.iRoomLocation.getId().equals(roomId)) {
            return 0;
        }
        return -1;
    }

    public boolean hasRoomLocation(Long roomId) {
        if (this.isMultiRoom()) {
            for (RoomLocation r : this.iRoomLocations) {
                if (!r.getId().equals(roomId)) continue;
                return true;
            }
            return false;
        }
        return this.iRoomLocation != null && this.iRoomLocation.getId().equals(roomId);
    }

    public String getRoomName(String delim) {
        if (this.isMultiRoom()) {
            StringBuffer sb = new StringBuffer();
            for (RoomLocation r : this.iRoomLocations) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(r.getName());
            }
            return sb.toString();
        }
        return this.getRoomLocation() == null ? "" : this.getRoomLocation().getName();
    }

    public String getName() {
        return this.getName(true);
    }

    public String getName(boolean useAmPm) {
        Lecture lecture = (Lecture)this.variable();
        return this.getTimeLocation().getName(useAmPm) + " " + this.getRoomName(", ") + (lecture != null && lecture.getInstructorName() != null ? " " + lecture.getInstructorName() : "");
    }

    public String getLongName(boolean useAmPm) {
        Lecture lecture = (Lecture)this.variable();
        if (this.isMultiRoom()) {
            StringBuffer sb = new StringBuffer();
            for (RoomLocation r : this.iRoomLocations) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(r.getName());
            }
            return this.getTimeLocation().getLongName(useAmPm) + " " + sb + (lecture != null && lecture.getInstructorName() != null ? " " + lecture.getInstructorName() : "");
        }
        return this.getTimeLocation().getLongName(useAmPm) + (this.getRoomLocation() == null ? "" : " " + this.getRoomLocation().getName()) + (lecture != null && lecture.getInstructorName() != null ? " " + lecture.getInstructorName() : "");
    }

    @Deprecated
    public String getLongName() {
        return this.getLongName(true);
    }

    public boolean sameRooms(Placement placement) {
        if (placement.isMultiRoom() != this.isMultiRoom()) {
            return false;
        }
        if (this.isMultiRoom()) {
            if (placement.getRoomLocations().size() != this.getRoomLocations().size()) {
                return false;
            }
            return placement.getRoomLocations().containsAll(this.getRoomLocations());
        }
        if (placement.getRoomLocation() == null) {
            return this.getRoomLocation() == null;
        }
        return placement.getRoomLocation().equals(this.getRoomLocation());
    }

    public boolean shareRooms(Placement placement) {
        if (this.isMultiRoom()) {
            if (placement.isMultiRoom()) {
                for (RoomLocation rl : this.getRoomLocations()) {
                    if (rl.getRoomConstraint() == null || !rl.getRoomConstraint().getConstraint() || !placement.getRoomLocations().contains(rl)) continue;
                    return true;
                }
                return false;
            }
            if (placement.getRoomLocation().getRoomConstraint() == null || !placement.getRoomLocation().getRoomConstraint().getConstraint()) {
                return false;
            }
            return this.getRoomLocations().contains(placement.getRoomLocation());
        }
        if (this.getRoomLocation().getRoomConstraint() == null || !this.getRoomLocation().getRoomConstraint().getConstraint()) {
            return false;
        }
        if (placement.isMultiRoom()) {
            return placement.getRoomLocations().contains(this.getRoomLocation());
        }
        return this.getRoomLocation().equals(placement.getRoomLocation());
    }

    public int nrDifferentRooms(Placement placement) {
        if (this.isMultiRoom()) {
            int ret = 0;
            for (RoomLocation r : this.getRoomLocations()) {
                if (placement.getRoomLocations().contains(r)) continue;
                ++ret;
            }
            return ret;
        }
        return placement.getRoomLocation().equals(this.getRoomLocation()) ? 0 : 1;
    }

    public int nrDifferentBuildings(Placement placement) {
        if (this.isMultiRoom()) {
            int ret = 0;
            for (RoomLocation r : this.getRoomLocations()) {
                boolean contains = false;
                for (RoomLocation q : placement.getRoomLocations()) {
                    if (!ToolBox.equals((Object)r.getBuildingId(), (Object)q.getBuildingId())) continue;
                    contains = true;
                }
                if (contains) continue;
                ++ret;
            }
            return ret;
        }
        return ToolBox.equals((Object)placement.getRoomLocation().getBuildingId(), (Object)this.getRoomLocation().getBuildingId()) ? 0 : 1;
    }

    public int sumRoomPreference() {
        if (this.isMultiRoom()) {
            int ret = 0;
            int roomIndex = 0;
            for (RoomLocation r : this.getRoomLocations()) {
                ret += r.getPreference(roomIndex++);
            }
            return ret;
        }
        return this.getRoomLocation().getPreference();
    }

    public int getRoomPreference() {
        if (this.isMultiRoom()) {
            PreferenceCombination p = PreferenceCombination.getDefault();
            int roomIndex = 0;
            for (RoomLocation r : this.getRoomLocations()) {
                p.addPreferenceInt(r.getPreference(roomIndex++));
            }
            return p.getPreferenceInt();
        }
        return this.getRoomLocation().getPreference();
    }

    public int getRoomSize() {
        if (this.isMultiRoom()) {
            if (this.getRoomLocations().isEmpty()) {
                return 0;
            }
            if (this.variable() != null && ((Lecture)this.variable()).isSplitAttendance()) {
                int roomSize = 0;
                for (RoomLocation r : this.getRoomLocations()) {
                    roomSize += r.getRoomSize();
                }
                return roomSize;
            }
            int roomSize = Integer.MAX_VALUE;
            for (RoomLocation r : this.getRoomLocations()) {
                roomSize = Math.min(roomSize, r.getRoomSize());
            }
            return roomSize;
        }
        return this.getRoomLocation().getRoomSize();
    }

    public boolean isHard(Assignment<Lecture, Placement> assignment) {
        if ("P".equals(Constants.preferenceLevel2preference(this.getTimeLocation().getPreference()))) {
            return true;
        }
        if (this.isRoomProhibited()) {
            return true;
        }
        Lecture lecture = (Lecture)this.variable();
        for (GroupConstraint gc : lecture.hardGroupSoftConstraints()) {
            if (gc.isSatisfied(assignment)) continue;
            if ("P".equals(gc.getPrologPreference())) {
                return true;
            }
            if (!"R".equals(gc.getPrologPreference())) continue;
            return true;
        }
        return false;
    }

    public boolean isRoomProhibited() {
        if (this.isMultiRoom()) {
            int roomIndex = 0;
            for (RoomLocation r : this.getRoomLocations()) {
                if (!"P".equals(Constants.preferenceLevel2preference(r.getPreference(roomIndex++)))) continue;
                return true;
            }
        } else if (this.getRoomLocation() != null && "P".equals(Constants.preferenceLevel2preference(this.getRoomLocation().getPreference()))) {
            return true;
        }
        return false;
    }

    public boolean sameTime(Placement placement) {
        return placement.getTimeLocation().equals(this.getTimeLocation());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Placement)) {
            return false;
        }
        Placement placement = (Placement)((Object)object);
        if (placement.getId() == this.getId()) {
            return true;
        }
        Lecture lecture = (Lecture)placement.variable();
        Lecture thisLecture = (Lecture)this.variable();
        if (lecture != null && thisLecture != null && !lecture.getClassId().equals(thisLecture.getClassId())) {
            return false;
        }
        if (!this.sameRooms(placement)) {
            return false;
        }
        return this.sameTime(placement);
    }

    public int hashCode() {
        return this.iHashCode;
    }

    public String toString() {
        return ((Lecture)this.variable()).getName() + " " + this.getName();
    }

    public static double getDistanceInMeters(DistanceMetric m, Placement p1, Placement p2) {
        if (p1.isMultiRoom()) {
            if (p2.isMultiRoom()) {
                double dist = 0.0;
                for (RoomLocation r1 : p1.getRoomLocations()) {
                    for (RoomLocation r2 : p2.getRoomLocations()) {
                        dist = Math.max(dist, r1.getDistanceInMeters(m, r2));
                    }
                }
                return dist;
            }
            if (p2.getRoomLocation() == null) {
                return 0.0;
            }
            double dist = 0.0;
            for (RoomLocation r1 : p1.getRoomLocations()) {
                dist = Math.max(dist, r1.getDistanceInMeters(m, p2.getRoomLocation()));
            }
            return dist;
        }
        if (p2.isMultiRoom()) {
            if (p1.getRoomLocation() == null) {
                return 0.0;
            }
            double dist = 0.0;
            for (RoomLocation r2 : p2.getRoomLocations()) {
                dist = Math.max(dist, p1.getRoomLocation().getDistanceInMeters(m, r2));
            }
            return dist;
        }
        if (p1.getRoomLocation() == null || p2.getRoomLocation() == null) {
            return 0.0;
        }
        return p1.getRoomLocation().getDistanceInMeters(m, p2.getRoomLocation());
    }

    public static int getDistanceInMinutes(DistanceMetric m, Placement p1, Placement p2) {
        if (p1.isMultiRoom()) {
            if (p2.isMultiRoom()) {
                int dist = 0;
                for (RoomLocation r1 : p1.getRoomLocations()) {
                    for (RoomLocation r2 : p2.getRoomLocations()) {
                        dist = Math.max(dist, r1.getDistanceInMinutes(m, r2));
                    }
                }
                return dist;
            }
            if (p2.getRoomLocation() == null) {
                return 0;
            }
            int dist = 0;
            for (RoomLocation r1 : p1.getRoomLocations()) {
                dist = Math.max(dist, r1.getDistanceInMinutes(m, p2.getRoomLocation()));
            }
            return dist;
        }
        if (p2.isMultiRoom()) {
            if (p1.getRoomLocation() == null) {
                return 0;
            }
            int dist = 0;
            for (RoomLocation r2 : p2.getRoomLocations()) {
                dist = Math.max(dist, p1.getRoomLocation().getDistanceInMinutes(m, r2));
            }
            return dist;
        }
        if (p1.getRoomLocation() == null || p2.getRoomLocation() == null) {
            return 0;
        }
        return p1.getRoomLocation().getDistanceInMinutes(m, p2.getRoomLocation());
    }

    public int getCommitedConflicts() {
        int ret = 0;
        Lecture lecture = (Lecture)this.variable();
        for (Student student : lecture.students()) {
            ret += student.countConflictPlacements(this);
        }
        return ret;
    }

    public Long getAssignmentId() {
        return this.iAssignmentId;
    }

    public void setAssignmentId(Long assignmentId) {
        this.iAssignmentId = assignmentId;
    }

    public boolean canShareRooms(Placement other) {
        return ((Lecture)this.variable()).canShareRoom((Lecture)other.variable());
    }

    public boolean isValid() {
        Lecture lecture = (Lecture)this.variable();
        if (!lecture.isValid(this)) {
            return false;
        }
        for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
            if (ic.isAvailable(lecture, this) || !ic.isHard()) continue;
            return false;
        }
        if (lecture.getNrRooms() > 0) {
            if (this.isMultiRoom()) {
                for (RoomLocation roomLocation : this.getRoomLocations()) {
                    if (roomLocation.getRoomConstraint() == null || roomLocation.getRoomConstraint().isAvailable(lecture, this.getTimeLocation(), lecture.getScheduler())) continue;
                    return false;
                }
            } else if (this.getRoomLocation().getRoomConstraint() != null && !this.getRoomLocation().getRoomConstraint().isAvailable(lecture, this.getTimeLocation(), lecture.getScheduler())) {
                return false;
            }
        }
        return true;
    }

    public String getNotValidReason(Assignment<Lecture, Placement> assignment, boolean useAmPm) {
        Lecture lecture = (Lecture)this.variable();
        String reason = lecture.getNotValidReason(assignment, this, useAmPm);
        if (reason != null) {
            return reason;
        }
        for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
            if (ic.isAvailable(lecture, this) || !ic.isHard()) continue;
            if (!ic.isAvailable(lecture, this.getTimeLocation())) {
                for (Placement c : ic.getUnavailabilities()) {
                    if (((Lecture)c.variable()).getId() < 0L && lecture.getDepartment() != null && ((Lecture)c.variable()).getDepartment() != null && !((Lecture)c.variable()).getDepartment().equals(lecture.getDepartment()) || !c.getTimeLocation().hasIntersection(this.getTimeLocation()) || lecture.canShareRoom((Lecture)c.variable())) continue;
                    return "instructor " + ic.getName() + " not available at " + this.getTimeLocation().getLongName(useAmPm) + " due to " + ((Lecture)c.variable()).getName();
                }
                return "instructor " + ic.getName() + " not available at " + this.getTimeLocation().getLongName(useAmPm);
            }
            return "placement " + this.getTimeLocation().getLongName(useAmPm) + " " + this.getRoomName(", ") + " is too far for instructor " + ic.getName();
        }
        if (lecture.getNrRooms() > 0) {
            if (this.isMultiRoom()) {
                for (RoomLocation roomLocation : this.getRoomLocations()) {
                    if (roomLocation.getRoomConstraint() == null || roomLocation.getRoomConstraint().isAvailable(lecture, this.getTimeLocation(), lecture.getScheduler())) continue;
                    if (roomLocation.getRoomConstraint().getAvailableArray() != null) {
                        TimeLocation.IntEnumeration e = this.getTimeLocation().getSlots();
                        while (e.hasMoreElements()) {
                            int slot = (Integer)e.nextElement();
                            if (roomLocation.getRoomConstraint().getAvailableArray()[slot] == null) continue;
                            for (Placement c : roomLocation.getRoomConstraint().getAvailableArray()[slot]) {
                                if (!c.getTimeLocation().hasIntersection(this.getTimeLocation()) || lecture.canShareRoom((Lecture)c.variable())) continue;
                                return "room " + roomLocation.getName() + " not available at " + this.getTimeLocation().getLongName(useAmPm) + " due to " + ((Lecture)c.variable()).getName();
                            }
                        }
                    }
                    return "room " + roomLocation.getName() + " not available at " + this.getTimeLocation().getLongName(useAmPm);
                }
            } else {
                if (this.getRoomLocation().getRoomConstraint() != null && !this.getRoomLocation().getRoomConstraint().isAvailable(lecture, this.getTimeLocation(), lecture.getScheduler()) && this.getRoomLocation().getRoomConstraint().getAvailableArray() != null) {
                    TimeLocation.IntEnumeration e = this.getTimeLocation().getSlots();
                    while (e.hasMoreElements()) {
                        int slot = (Integer)e.nextElement();
                        if (this.getRoomLocation().getRoomConstraint().getAvailableArray()[slot] == null) continue;
                        for (Placement c : this.getRoomLocation().getRoomConstraint().getAvailableArray()[slot]) {
                            if (!c.getTimeLocation().hasIntersection(this.getTimeLocation()) || lecture.canShareRoom((Lecture)c.variable())) continue;
                            return "room " + this.getRoomLocation().getName() + " not available at " + this.getTimeLocation().getLongName(useAmPm) + " due to " + ((Lecture)c.variable()).getName();
                        }
                    }
                }
                return "room " + this.getRoomLocation().getName() + " not available at " + this.getTimeLocation().getLongName(useAmPm);
            }
        }
        return reason;
    }

    @Deprecated
    public String getNotValidReason(Assignment<Lecture, Placement> assignment) {
        return this.getNotValidReason(assignment, true);
    }

    public int getNrRooms() {
        if (this.iRoomLocations != null) {
            return this.iRoomLocations.size();
        }
        return this.iRoomLocation == null ? 0 : 1;
    }

    public int getSpreadPenalty(Assignment<Lecture, Placement> assignment) {
        int spread = 0;
        for (SpreadConstraint sc : ((Lecture)this.variable()).getSpreadConstraints()) {
            spread += sc.getPenalty(assignment, this);
        }
        return spread;
    }

    public int getMaxSpreadPenalty(Assignment<Lecture, Placement> assignment) {
        int spread = 0;
        for (SpreadConstraint sc : ((Lecture)this.variable()).getSpreadConstraints()) {
            spread += sc.getMaxPenalty(assignment, this);
        }
        return spread;
    }

    public double toDouble(Assignment<Lecture, Placement> assignment) {
        double ret = 0.0;
        for (Criterion criterion : ((Lecture)this.variable()).getModel().getCriteria()) {
            ret += criterion.getWeightedValue(assignment, (Value)this, null);
        }
        return ret;
    }

    public Object getAssignment() {
        return this.iAssignment;
    }

    public void setAssignment(Object assignment) {
        this.iAssignment = assignment;
    }

    public double getTimePenalty() {
        if (this.iTimeLocation == null) {
            return 0.0;
        }
        if (this.iTimePenalty == null) {
            double[] bounds = ((Lecture)this.variable()).getMinMaxTimePreference();
            double npref = this.iTimeLocation.getNormalizedPreference();
            if (this.iTimeLocation.getPreference() < Constants.sPreferenceLevelRequired / 2) {
                npref = bounds[0];
            } else if (this.iTimeLocation.getPreference() > Constants.sPreferenceLevelProhibited / 2) {
                npref = bounds[1];
            }
            this.iTimePenalty = npref - bounds[0];
        }
        return this.iTimePenalty;
    }

    public int getRoomPenalty() {
        if (this.getNrRooms() == 0) {
            return 0;
        }
        if (this.iRoomPenalty == null) {
            int pref = this.getRoomPreference();
            int[] bounds = ((Lecture)this.variable()).getMinMaxRoomPreference();
            if (pref < Constants.sPreferenceLevelRequired / 2) {
                pref = bounds[0];
            }
            if (pref > Constants.sPreferenceLevelProhibited / 2) {
                pref = bounds[1];
            }
            this.iRoomPenalty = pref - bounds[0];
        }
        return this.iRoomPenalty;
    }
}

