/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.text.DecimalFormat;
import java.util.List;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;

public class ExamStudentDirectConflicts {
    private ExamModel iModel = null;

    public ExamStudentDirectConflicts(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Exam 1"), new CSVFile.CSVField((Object)"Enrl 1"), new CSVFile.CSVField((Object)"Period 1"), new CSVFile.CSVField((Object)"Date 1"), new CSVFile.CSVField((Object)"Time 1"), new CSVFile.CSVField((Object)"Exam 2"), new CSVFile.CSVField((Object)"Enrl 2"), new CSVFile.CSVField((Object)"Direct"), new CSVFile.CSVField((Object)"Direct [%]")});
        DecimalFormat df = new DecimalFormat("0.0");
        for (Exam ex1 : this.iModel.variables()) {
            ExamPlacement p1 = (ExamPlacement)assignment.getValue((Variable)ex1);
            if (p1 == null) continue;
            for (Exam ex2 : this.iModel.variables()) {
                List<ExamStudent> students;
                ExamPlacement p2;
                if (ex1.getId() >= ex2.getId() || (p2 = (ExamPlacement)assignment.getValue((Variable)ex2)) == null || !p2.getPeriod().equals(p1.getPeriod()) || (students = ex1.getJointEnrollments().get((Object)ex2)) == null || students.isEmpty()) continue;
                csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)ex1.getName()), new CSVFile.CSVField(ex1.getStudents().size()), new CSVFile.CSVField(p1.getPeriod().getIndex() + 1), new CSVFile.CSVField((Object)p1.getPeriod().getDayStr()), new CSVFile.CSVField((Object)p1.getPeriod().getTimeStr()), new CSVFile.CSVField((Object)ex2.getName()), new CSVFile.CSVField(ex2.getStudents().size()), new CSVFile.CSVField(students.size()), new CSVFile.CSVField((Object)df.format(100.0 * (double)students.size() / (double)Math.min(ex1.getStudents().size(), ex2.getStudents().size())))});
            }
        }
        return csv;
    }
}

