/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;

public class SuggestionsBranchAndBound {
    private Hashtable<CourseRequest, Set<Section>> iRequiredSections = null;
    private Set<FreeTimeRequest> iRequiredFreeTimes = null;
    private Hashtable<CourseRequest, Set<Section>> iPreferredSections = null;
    private Request iSelectedRequest = null;
    private Section iSelectedSection = null;
    private Student iStudent = null;
    private TreeSet<Suggestion> iSuggestions = new TreeSet();
    private int iMaxDepth = 4;
    private long iTimeout = 5000L;
    private int iMaxSuggestions = 20;
    private long iT0;
    private long iT1;
    private boolean iTimeoutReached = false;
    private int iNrSolutionsSeen = 0;
    private OnlineSectioningModel iModel;
    private Assignment<Request, Enrollment> iAssignment;
    private Hashtable<Request, List<Enrollment>> iValues = new Hashtable();
    private long iLastSuggestionId = 0L;
    private SuggestionFilter iFilter = null;
    protected MultiCriteriaBranchAndBoundSelection.SelectionComparator iComparator = null;
    protected int iMatched = 0;
    protected double iMaxSectionsWithPenalty = 0.0;

    public SuggestionsBranchAndBound(DataProperties properties, Student student, Assignment<Request, Enrollment> assignment, Hashtable<CourseRequest, Set<Section>> requiredSections, Set<FreeTimeRequest> requiredFreeTimes, Hashtable<CourseRequest, Set<Section>> preferredSections, Request selectedRequest, Section selectedSection, SuggestionFilter filter, double maxSectionsWithPenalty) {
        this.iRequiredSections = requiredSections;
        this.iRequiredFreeTimes = requiredFreeTimes;
        this.iPreferredSections = preferredSections;
        this.iSelectedRequest = selectedRequest;
        this.iSelectedSection = selectedSection;
        this.iStudent = student;
        this.iModel = (OnlineSectioningModel)selectedRequest.getModel();
        this.iAssignment = assignment;
        this.iMaxDepth = properties.getPropertyInt("Suggestions.MaxDepth", this.iMaxDepth);
        this.iTimeout = properties.getPropertyLong("Suggestions.Timeout", this.iTimeout);
        this.iMaxSuggestions = properties.getPropertyInt("Suggestions.MaxSuggestions", this.iMaxSuggestions);
        this.iMaxSectionsWithPenalty = maxSectionsWithPenalty;
        this.iFilter = filter;
        this.iComparator = new MultiCriteriaBranchAndBoundSelection.SelectionComparator(){
            private HashMap<Enrollment, Double> iValues = new HashMap();

            private Double value(Enrollment e) {
                Double value = this.iValues.get((Object)e);
                if (value == null) {
                    value = SuggestionsBranchAndBound.this.iModel.getStudentQuality() != null ? Double.valueOf(SuggestionsBranchAndBound.this.iModel.getStudentWeights().getWeight((Assignment<Request, Enrollment>)SuggestionsBranchAndBound.this.iAssignment, e, SuggestionsBranchAndBound.this.iModel.getStudentQuality().conflicts(e))) : Double.valueOf(SuggestionsBranchAndBound.this.iModel.getStudentWeights().getWeight((Assignment<Request, Enrollment>)SuggestionsBranchAndBound.this.iAssignment, e, SuggestionsBranchAndBound.this.iModel.getDistanceConflict() == null ? null : SuggestionsBranchAndBound.this.iModel.getDistanceConflict().conflicts(e), SuggestionsBranchAndBound.this.iModel.getTimeOverlaps() == null ? null : SuggestionsBranchAndBound.this.iModel.getTimeOverlaps().conflicts(e)));
                    this.iValues.put(e, value);
                }
                return value;
            }

            @Override
            public int compare(Assignment<Request, Enrollment> a, Enrollment e1, Enrollment e2) {
                return this.value(e2).compareTo(this.value(e1));
            }
        };
    }

    public long getTime() {
        return this.iT1 - this.iT0;
    }

    public boolean isTimeoutReached() {
        return this.iTimeoutReached;
    }

    public int getNrSolutionsSeen() {
        return this.iNrSolutionsSeen;
    }

    public TreeSet<Suggestion> computeSuggestions() {
        this.iT0 = System.currentTimeMillis();
        this.iTimeoutReached = false;
        this.iNrSolutionsSeen = 0;
        this.iSuggestions.clear();
        ArrayList<Request> requests2resolve = new ArrayList<Request>();
        requests2resolve.add(this.iSelectedRequest);
        TreeSet<Request> altRequests2resolve = new TreeSet<Request>();
        for (Map.Entry<CourseRequest, Set<Section>> entry : this.iPreferredSections.entrySet()) {
            CourseRequest request = entry.getKey();
            Set<Section> sections = entry.getValue();
            if (!sections.isEmpty() && sections.size() == sections.iterator().next().getSubpart().getConfig().getSubparts().size()) {
                this.iAssignment.assign(0L, (Value)request.createEnrollment(this.iAssignment, sections));
                continue;
            }
            if (request.equals((Object)this.iSelectedRequest)) continue;
            if (sections.isEmpty()) {
                altRequests2resolve.add(request);
                continue;
            }
            requests2resolve.add(request);
        }
        for (Request request : this.iStudent.getRequests()) {
            FreeTimeRequest ft;
            Enrollment enrollment;
            if (this.iAssignment.getValue((Variable)request) != null || !(request instanceof FreeTimeRequest) || !this.iModel.conflictValues(this.iAssignment, enrollment = (ft = (FreeTimeRequest)request).createEnrollment()).isEmpty()) continue;
            this.iAssignment.assign(0L, (Value)enrollment);
        }
        for (Request request : this.iStudent.getRequests()) {
            request.setInitialAssignment(this.iAssignment.getValue((Variable)request));
        }
        this.backtrack(requests2resolve, altRequests2resolve, 0, this.iMaxDepth, false);
        this.iT1 = System.currentTimeMillis();
        return this.iSuggestions;
    }

    protected void backtrack(ArrayList<Request> requests2resolve, TreeSet<Request> altRequests2resolve, int idx, int depth, boolean alt) {
        int nrUnassigned;
        if (!this.iTimeoutReached && this.iTimeout > 0L && System.currentTimeMillis() - this.iT0 > this.iTimeout) {
            this.iTimeoutReached = true;
        }
        if ((nrUnassigned = requests2resolve.size() - idx) == 0) {
            ArrayList<FreeTimeRequest> okFreeTimes = new ArrayList<FreeTimeRequest>();
            double sectionsWithPenalty = 0.0;
            for (Request r : this.iStudent.getRequests()) {
                FreeTimeRequest ft;
                Object enrollment;
                Enrollment e = (Enrollment)this.iAssignment.getValue((Variable)r);
                if (this.iMaxSectionsWithPenalty >= 0.0 && e != null && r instanceof CourseRequest) {
                    for (Section s : e.getSections()) {
                        sectionsWithPenalty += this.iModel.getOverExpected(this.iAssignment, s, r);
                    }
                }
                if (e == null && r instanceof FreeTimeRequest && this.iModel.conflictValues(this.iAssignment, (Value)(enrollment = (ft = (FreeTimeRequest)r).createEnrollment())).isEmpty()) {
                    this.iAssignment.assign(0L, (Value)enrollment);
                    okFreeTimes.add(ft);
                }
                if (e == null || !e.isCourseRequest() || !e.getSections().isEmpty()) continue;
                Double minPenalty = null;
                enrollment = this.values(e.getRequest()).iterator();
                while (enrollment.hasNext()) {
                    Enrollment other = (Enrollment)((Object)enrollment.next());
                    if (!this.isAllowed(other) || e.equals((Object)other)) continue;
                    double penalty = 0.0;
                    for (Section s : other.getSections()) {
                        penalty += this.iModel.getOverExpected(this.iAssignment, s, other.getRequest());
                    }
                    if (minPenalty == null || minPenalty > penalty) {
                        minPenalty = penalty;
                    }
                    if (minPenalty != 0.0) continue;
                    break;
                }
                if (minPenalty == null) continue;
                sectionsWithPenalty += minPenalty.doubleValue();
            }
            if (this.iMaxSectionsWithPenalty >= 0.0 && sectionsWithPenalty > this.iMaxSectionsWithPenalty) {
                return;
            }
            Suggestion s = new Suggestion(requests2resolve);
            if (this.iSuggestions.size() >= this.iMaxSuggestions && this.iSuggestions.last().compareTo(s) <= 0) {
                return;
            }
            if (this.iMatched != 1) {
                Iterator<Suggestion> i = this.iSuggestions.iterator();
                while (i.hasNext()) {
                    Suggestion x = i.next();
                    if (!x.sameSelectedSection()) continue;
                    if (x.compareTo(s) <= 0) {
                        return;
                    }
                    i.remove();
                }
            }
            s.init();
            this.iSuggestions.add(s);
            if (this.iSuggestions.size() > this.iMaxSuggestions) {
                this.iSuggestions.remove(this.iSuggestions.last());
            }
            for (FreeTimeRequest ft : okFreeTimes) {
                this.iAssignment.unassign(0L, (Variable)ft);
            }
            return;
        }
        if (!this.canContinue(requests2resolve, idx, depth)) {
            return;
        }
        Request request = requests2resolve.get(idx);
        for (Enrollment enrollment : this.values(request)) {
            Set conflicts;
            if (!this.canContinueEvaluation()) break;
            if (!this.isAllowed(enrollment) || enrollment.equals(this.iAssignment.getValue((Variable)request)) || enrollment.getAssignments().isEmpty() && alt || !this.checkBound(requests2resolve, idx, depth, enrollment, conflicts = this.iModel.conflictValues(this.iAssignment, enrollment))) continue;
            Enrollment current = (Enrollment)this.iAssignment.getValue((Variable)request);
            ArrayList<Request> newVariables2resolve = new ArrayList<Request>(requests2resolve);
            for (Enrollment conflict : conflicts) {
                this.iAssignment.unassign(0L, conflict.variable());
                if (newVariables2resolve.contains(conflict.variable())) continue;
                newVariables2resolve.add((Request)conflict.variable());
            }
            if (current != null) {
                this.iAssignment.unassign(0L, current.variable());
            }
            this.iAssignment.assign(0L, (Value)enrollment);
            if (enrollment.getAssignments().isEmpty()) {
                if (altRequests2resolve != null && !altRequests2resolve.isEmpty()) {
                    Suggestion lastBefore = this.iSuggestions.isEmpty() ? null : this.iSuggestions.last();
                    int sizeBefore = this.iSuggestions.size();
                    for (Request r : altRequests2resolve) {
                        newVariables2resolve.add(r);
                        this.backtrack(newVariables2resolve, null, idx + 1, depth, true);
                        newVariables2resolve.remove((Object)r);
                    }
                    Suggestion lastAfter = this.iSuggestions.isEmpty() ? null : this.iSuggestions.last();
                    int sizeAfter = this.iSuggestions.size();
                    if (sizeBefore == sizeAfter && (sizeAfter < this.iMaxSuggestions || sizeAfter == 0 || lastAfter.compareTo(lastBefore) == 0)) {
                        this.backtrack(newVariables2resolve, altRequests2resolve, idx + 1, depth - 1, alt);
                    }
                } else {
                    this.backtrack(newVariables2resolve, altRequests2resolve, idx + 1, depth - 1, alt);
                }
            } else {
                this.backtrack(newVariables2resolve, altRequests2resolve, idx + 1, depth - 1, alt);
            }
            if (current == null) {
                this.iAssignment.unassign(0L, (Variable)request);
            } else {
                this.iAssignment.assign(0L, (Value)current);
            }
            for (Enrollment conflict : conflicts) {
                this.iAssignment.assign(0L, (Value)conflict);
            }
        }
    }

    protected List<Enrollment> values(Request request) {
        if (!request.equals((Object)this.iSelectedRequest) && !request.getStudent().canAssign(this.iAssignment, request)) {
            if (this.canLeaveUnassigned(request)) {
                ArrayList<Enrollment> values = new ArrayList<Enrollment>();
                Config config = null;
                if (request instanceof CourseRequest) {
                    config = ((CourseRequest)request).getCourses().get(0).getOffering().getConfigs().get(0);
                }
                values.add(new Enrollment(request, 0, config, new HashSet(), this.iAssignment));
                return values;
            }
            return new ArrayList<Enrollment>();
        }
        List<Enrollment> values = this.iValues.get((Object)request);
        if (values != null) {
            return values;
        }
        if (request instanceof CourseRequest) {
            CourseRequest cr = (CourseRequest)request;
            List<Enrollment> list = values = cr.equals((Object)this.iSelectedRequest) ? cr.getAvaiableEnrollments(this.iAssignment) : cr.getAvaiableEnrollmentsSkipSameTime(this.iAssignment);
            if (cr.equals((Object)this.iSelectedRequest)) {
                Collections.sort(values, new Comparator<Enrollment>(){

                    @Override
                    public int compare(Enrollment e1, Enrollment e2) {
                        int s1 = 0;
                        for (Section section : e1.getSections()) {
                            if (!((CourseRequest)SuggestionsBranchAndBound.this.iSelectedRequest).isSelected(section)) continue;
                            ++s1;
                        }
                        int s2 = 0;
                        for (Section s : e2.getSections()) {
                            if (!((CourseRequest)SuggestionsBranchAndBound.this.iSelectedRequest).isSelected(s)) continue;
                            ++s2;
                        }
                        if (s1 != s2) {
                            return s1 > s2 ? -1 : 1;
                        }
                        if (e1.getRequest().getInitialAssignment() != null) {
                            Enrollment enrollment = (Enrollment)e1.getRequest().getInitialAssignment();
                            int x1 = 0;
                            if (enrollment.getCourse().equals((Object)e1.getCourse())) {
                                x1 += 100;
                            }
                            if (enrollment.getConfig().equals((Object)e1.getConfig())) {
                                x1 += 10;
                                block2: for (Section section : enrollment.getSections()) {
                                    for (Section s : e1.getSections()) {
                                        if (s.getSubpart().getId() != section.getSubpart().getId()) continue;
                                        if (!ToolBox.equals((Object)section.getTime(), (Object)s.getTime()) || !ToolBox.equals(section.getRooms(), s.getRooms())) continue block2;
                                        ++x1;
                                        continue block2;
                                    }
                                }
                            }
                            int x2 = 0;
                            if (enrollment.getCourse().equals((Object)e2.getCourse())) {
                                x2 += 100;
                            }
                            if (enrollment.getConfig().equals((Object)e2.getConfig())) {
                                x2 += 10;
                                block4: for (Section section : enrollment.getSections()) {
                                    for (Section s : e2.getSections()) {
                                        if (s.getSubpart().getId() != section.getSubpart().getId()) continue;
                                        if (!ToolBox.equals((Object)section.getTime(), (Object)s.getTime()) || !ToolBox.equals(section.getRooms(), s.getRooms())) continue block4;
                                        ++x2;
                                        continue block4;
                                    }
                                }
                            }
                            if (x1 != x2) {
                                return x1 > x2 ? -1 : 1;
                            }
                        }
                        return SuggestionsBranchAndBound.this.iComparator.compare((Assignment<Request, Enrollment>)SuggestionsBranchAndBound.this.iAssignment, e1, e2);
                    }
                });
            } else {
                Collections.sort(values, new Comparator<Enrollment>(){

                    @Override
                    public int compare(Enrollment e1, Enrollment e2) {
                        return SuggestionsBranchAndBound.this.iComparator.compare((Assignment<Request, Enrollment>)SuggestionsBranchAndBound.this.iAssignment, e1, e2);
                    }
                });
            }
        } else {
            values = new ArrayList<Enrollment>();
            values.add(((FreeTimeRequest)request).createEnrollment());
        }
        if (this.canLeaveUnassigned(request)) {
            Config config = null;
            if (request instanceof CourseRequest) {
                config = ((CourseRequest)request).getCourses().get(0).getOffering().getConfigs().get(0);
            }
            values.add(new Enrollment(request, 0, config, new HashSet(), this.iAssignment));
        }
        this.iValues.put(request, values);
        if (request.equals((Object)this.iSelectedRequest) && this.iFilter != null && request instanceof CourseRequest) {
            Iterator<Enrollment> i = values.iterator();
            while (i.hasNext()) {
                Enrollment enrollment = i.next();
                if (enrollment.getAssignments() == null || enrollment.getAssignments().isEmpty()) continue;
                boolean match = false;
                for (Section section : enrollment.getSections()) {
                    if (this.iSelectedSection != null) {
                        if (section.getSubpart().getId() == this.iSelectedSection.getSubpart().getId() && this.iFilter.match(enrollment.getCourse(), section)) {
                            match = true;
                            break;
                        }
                        if (section.getSubpart().getConfig().getId() == this.iSelectedSection.getSubpart().getConfig().getId() || !section.getSubpart().getInstructionalType().equals(this.iSelectedSection.getSubpart().getInstructionalType()) || !this.iFilter.match(enrollment.getCourse(), section)) continue;
                        match = true;
                        break;
                    }
                    if (!this.iFilter.match(enrollment.getCourse(), section)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                i.remove();
            }
        }
        if (request.equals((Object)this.iSelectedRequest)) {
            this.iMatched = values.size();
        }
        return values;
    }

    protected boolean canContinue(ArrayList<Request> requests2resolve, int idx, int depth) {
        if (depth <= 0) {
            return false;
        }
        return !this.iTimeoutReached;
    }

    protected boolean canContinueEvaluation() {
        return !this.iTimeoutReached;
    }

    protected boolean checkBound(ArrayList<Request> requests2resolve, int idx, int depth, Enrollment value, Set<Enrollment> conflicts) {
        if (this.iMaxSectionsWithPenalty < 0.0 && idx > 0 && !conflicts.isEmpty()) {
            return false;
        }
        int nrUnassigned = requests2resolve.size() - idx;
        if (nrUnassigned + conflicts.size() > depth) {
            return false;
        }
        for (Enrollment conflict : conflicts) {
            int confIdx = requests2resolve.indexOf(conflict.variable());
            if (confIdx < 0 || confIdx > idx) continue;
            return false;
        }
        if (this.iMaxSectionsWithPenalty >= 0.0) {
            double sectionsWithPenalty = 0.0;
            for (Request r : this.iStudent.getRequests()) {
                Enrollment e = (Enrollment)this.iAssignment.getValue((Variable)r);
                if (r.equals(value.variable())) {
                    e = value;
                } else if (conflicts.contains((Object)e)) {
                    e = null;
                }
                if (e == null || !e.isCourseRequest()) continue;
                sectionsWithPenalty += this.iModel.getOverExpected(this.iAssignment, e, value, conflicts);
            }
            if (sectionsWithPenalty > this.iMaxSectionsWithPenalty) {
                return false;
            }
        }
        return true;
    }

    public boolean isAllowed(Enrollment enrollment) {
        Set<Section> required;
        if (this.iRequiredSections != null && enrollment.getRequest() instanceof CourseRequest && (required = this.iRequiredSections.get((Object)enrollment.getRequest())) != null && !required.isEmpty()) {
            if (enrollment.getAssignments() == null) {
                return false;
            }
            for (Section r : required) {
                if (enrollment.getAssignments().contains(r)) continue;
                return false;
            }
        }
        if (enrollment.getRequest().equals((Object)this.iSelectedRequest)) {
            if (enrollment.getAssignments() == null || enrollment.getAssignments().isEmpty()) {
                return false;
            }
            if (this.iSelectedSection != null && enrollment.getAssignments().contains(this.iSelectedSection)) {
                return false;
            }
        }
        return true;
    }

    public boolean canLeaveUnassigned(Request request) {
        Set<Section> required;
        if (request instanceof CourseRequest ? this.iRequiredSections != null && (required = this.iRequiredSections.get((Object)request)) != null && !required.isEmpty() : this.iRequiredFreeTimes.contains((Object)request)) {
            return false;
        }
        return !request.equals((Object)this.iSelectedRequest);
    }

    protected int compare(Assignment<Request, Enrollment> assignment, Suggestion s1, Suggestion s2) {
        return Double.compare(s1.getValue(), s2.getValue());
    }

    public int getNrMatched() {
        return this.iMatched;
    }

    static /* synthetic */ long access$308(SuggestionsBranchAndBound x0) {
        return x0.iLastSuggestionId++;
    }

    public static interface SuggestionFilter {
        public boolean match(Course var1, Section var2);
    }

    public class SectionAssignmentComparator
    implements Comparator<Section> {
        @Override
        public int compare(Section a, Section b) {
            int cmp;
            String r2;
            TimeLocation t2;
            TimeLocation t1 = a == null ? null : a.getTime();
            TimeLocation timeLocation = t2 = b == null ? null : b.getTime();
            if (t1 != null && t2 != null) {
                for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                    if ((t1.getDayCode() & Constants.DAY_CODES[i]) != 0) {
                        if ((t2.getDayCode() & Constants.DAY_CODES[i]) != 0) continue;
                        return -1;
                    }
                    if ((t2.getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                    return 1;
                }
                int cmp2 = Double.compare(t1.getStartSlot(), t2.getStartSlot());
                if (cmp2 != 0) {
                    return cmp2;
                }
            }
            String r1 = a == null || a.getRooms() == null ? null : a.getRooms().toString();
            String string = r2 = b == null || b.getRooms() == null ? null : b.getRooms().toString();
            if (r1 != null && r2 != null && (cmp = r1.compareToIgnoreCase(r2)) != 0) {
                return cmp;
            }
            return 0;
        }
    }

    public class EnrollmentSectionComparator
    implements Comparator<Section> {
        public boolean isParent(Section s1, Section s2) {
            Section p1 = s1.getParent();
            if (p1 == null) {
                return false;
            }
            if (p1.equals(s2)) {
                return true;
            }
            return this.isParent(p1, s2);
        }

        @Override
        public int compare(Section a, Section b) {
            if (SuggestionsBranchAndBound.this.iSelectedSection != null && SuggestionsBranchAndBound.this.iSelectedSection.getSubpart().getId() == a.getSubpart().getId()) {
                return -1;
            }
            if (SuggestionsBranchAndBound.this.iSelectedSection != null && SuggestionsBranchAndBound.this.iSelectedSection.getSubpart().getId() == b.getSubpart().getId()) {
                return 1;
            }
            if (this.isParent(a, b)) {
                return 1;
            }
            if (this.isParent(b, a)) {
                return -1;
            }
            int cmp = a.getSubpart().getInstructionalType().compareToIgnoreCase(b.getSubpart().getInstructionalType());
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(a.getId(), b.getId());
        }
    }

    public class Suggestion
    implements Comparable<Suggestion> {
        private double iValue = 0.0;
        private int iNrUnassigned = 0;
        private int iUnassignedPriority = 0;
        private int iNrChanges = 0;
        private long iId = SuggestionsBranchAndBound.access$308(SuggestionsBranchAndBound.this);
        private Enrollment[] iEnrollments;
        private Section iSelectedEnrollment = null;
        private boolean iSelectedEnrollmentChangeTime = false;
        private TreeSet<Section> iSelectedSections = new TreeSet<Section>(new EnrollmentSectionComparator());
        private int iSelectedChoice = 0;

        public Suggestion(ArrayList<Request> resolvedRequests) {
            Enrollment enrollment;
            for (Request request : resolvedRequests) {
                Enrollment enrollment2 = (Enrollment)SuggestionsBranchAndBound.this.iAssignment.getValue((Variable)request);
                if (enrollment2.getAssignments().isEmpty()) {
                    ++this.iNrUnassigned;
                    this.iUnassignedPriority += request.getPriority();
                }
                this.iValue += enrollment2.getAssignments() == null || enrollment2.getAssignments().isEmpty() ? 0.0 : enrollment2.toDouble((Assignment<Request, Enrollment>)SuggestionsBranchAndBound.this.iAssignment, false);
                if (request.getInitialAssignment() == null || !enrollment2.isCourseRequest()) continue;
                Enrollment original = (Enrollment)request.getInitialAssignment();
                for (Section section : enrollment2.getSections()) {
                    Section originalSection = null;
                    for (Section x : original.getSections()) {
                        if (x.getSubpart().getId() != section.getSubpart().getId()) continue;
                        originalSection = x;
                        break;
                    }
                    if (originalSection != null && ToolBox.equals((Object)section.getTime(), (Object)originalSection.getTime()) && ToolBox.equals(section.getRooms(), originalSection.getRooms())) continue;
                    ++this.iNrChanges;
                }
                if (!enrollment2.getCourse().equals((Object)((Enrollment)request.getInitialAssignment()).getCourse())) {
                    this.iNrChanges += 100 * (1 + enrollment2.getTruePriority());
                }
                if (enrollment2.getConfig().equals((Object)((Enrollment)request.getInitialAssignment()).getConfig())) continue;
                this.iNrChanges += 10;
            }
            if (SuggestionsBranchAndBound.this.iSelectedRequest != null && SuggestionsBranchAndBound.this.iSelectedSection != null && (enrollment = (Enrollment)SuggestionsBranchAndBound.this.iAssignment.getValue((Variable)SuggestionsBranchAndBound.this.iSelectedRequest)).getAssignments() != null && !enrollment.getAssignments().isEmpty()) {
                for (Section section : enrollment.getSections()) {
                    if (section.getSubpart().getId() == SuggestionsBranchAndBound.this.iSelectedSection.getSubpart().getId()) {
                        this.iSelectedEnrollment = section;
                        break;
                    }
                    if (section.getSubpart().getConfig().getId() == SuggestionsBranchAndBound.this.iSelectedSection.getSubpart().getConfig().getId() || !section.getSubpart().getInstructionalType().equals(SuggestionsBranchAndBound.this.iSelectedSection.getSubpart().getInstructionalType())) continue;
                    this.iSelectedEnrollment = section;
                    break;
                }
            }
            if (this.iSelectedEnrollment != null) {
                boolean bl = this.iSelectedEnrollmentChangeTime = !ToolBox.equals((Object)this.iSelectedEnrollment.getTime(), (Object)SuggestionsBranchAndBound.this.iSelectedSection.getTime());
            }
            if (SuggestionsBranchAndBound.this.iSelectedRequest != null && (enrollment = (Enrollment)SuggestionsBranchAndBound.this.iAssignment.getValue((Variable)SuggestionsBranchAndBound.this.iSelectedRequest)).isCourseRequest() && enrollment.getAssignments() != null && !enrollment.getAssignments().isEmpty()) {
                this.iSelectedSections.addAll(enrollment.getSections());
                this.iSelectedChoice = ((CourseRequest)SuggestionsBranchAndBound.this.iSelectedRequest).getCourses().indexOf((Object)enrollment.getCourse());
            }
        }

        public void init() {
            this.iEnrollments = new Enrollment[SuggestionsBranchAndBound.this.iStudent.getRequests().size()];
            for (int i = 0; i < SuggestionsBranchAndBound.this.iStudent.getRequests().size(); ++i) {
                Request r = SuggestionsBranchAndBound.this.iStudent.getRequests().get(i);
                this.iEnrollments[i] = (Enrollment)SuggestionsBranchAndBound.this.iAssignment.getValue((Variable)r);
                if (this.iEnrollments[i] != null) continue;
                Config c = null;
                if (r instanceof CourseRequest) {
                    c = ((CourseRequest)r).getCourses().get(0).getOffering().getConfigs().get(0);
                }
                this.iEnrollments[i] = new Enrollment(r, 0, c, null, (Assignment<Request, Enrollment>)SuggestionsBranchAndBound.this.iAssignment);
            }
        }

        public Enrollment[] getEnrollments() {
            return this.iEnrollments;
        }

        public double getValue() {
            return this.iValue;
        }

        public int getNrUnassigned() {
            return this.iNrUnassigned;
        }

        public double getAverageUnassignedPriority() {
            return (double)this.iUnassignedPriority / (double)this.iNrUnassigned;
        }

        public int getNrChanges() {
            return this.iNrChanges;
        }

        public boolean sameSelectedSection() {
            if (SuggestionsBranchAndBound.this.iSelectedRequest != null && this.iSelectedEnrollment != null) {
                Enrollment enrollment = (Enrollment)SuggestionsBranchAndBound.this.iAssignment.getValue((Variable)SuggestionsBranchAndBound.this.iSelectedRequest);
                if (enrollment != null && enrollment.getAssignments().contains(this.iSelectedEnrollment)) {
                    return true;
                }
                if (this.iSelectedEnrollmentChangeTime && SuggestionsBranchAndBound.this.iSelectedSection.getSubpart().getSections().size() > SuggestionsBranchAndBound.this.iMaxSuggestions) {
                    Section selectedEnrollment = null;
                    for (Section section : enrollment.getSections()) {
                        if (section.getSubpart().getId() == SuggestionsBranchAndBound.this.iSelectedSection.getSubpart().getId()) {
                            selectedEnrollment = section;
                            break;
                        }
                        if (section.getSubpart().getConfig().getId() == SuggestionsBranchAndBound.this.iSelectedSection.getSubpart().getConfig().getId() || !section.getSubpart().getInstructionalType().equals(SuggestionsBranchAndBound.this.iSelectedSection.getSubpart().getInstructionalType())) continue;
                        selectedEnrollment = section;
                        break;
                    }
                    if (selectedEnrollment != null && ToolBox.equals((Object)selectedEnrollment.getTime(), (Object)this.iSelectedEnrollment.getTime())) {
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int compareTo(Suggestion suggestion) {
            int cmp = Double.compare(this.getNrUnassigned(), suggestion.getNrUnassigned());
            if (cmp != 0) {
                return cmp;
            }
            if (this.getNrUnassigned() > 0 && (cmp = Double.compare(suggestion.getAverageUnassignedPriority(), this.getAverageUnassignedPriority())) != 0) {
                return cmp;
            }
            if (SuggestionsBranchAndBound.this.iSelectedRequest != null && SuggestionsBranchAndBound.this.iSelectedRequest instanceof CourseRequest) {
                int s1 = 0;
                for (Section section : this.iSelectedSections) {
                    if (!((CourseRequest)SuggestionsBranchAndBound.this.iSelectedRequest).isSelected(section)) continue;
                    ++s1;
                }
                int s2 = 0;
                for (Section s : suggestion.iSelectedSections) {
                    if (!((CourseRequest)SuggestionsBranchAndBound.this.iSelectedRequest).isSelected(s)) continue;
                    ++s2;
                }
                if (s1 != s2) {
                    return s1 > s2 ? -1 : 1;
                }
            }
            if ((cmp = Double.compare(this.getNrChanges(), suggestion.getNrChanges())) != 0) {
                return cmp;
            }
            cmp = Double.compare(this.iSelectedChoice, suggestion.iSelectedChoice);
            if (cmp != 0) {
                return cmp;
            }
            Iterator<Section> i1 = this.iSelectedSections.iterator();
            Iterator<Section> i2 = suggestion.iSelectedSections.iterator();
            SectionAssignmentComparator sectionAssignmentComparator = new SectionAssignmentComparator();
            while (i1.hasNext() && i2.hasNext()) {
                cmp = sectionAssignmentComparator.compare(i1.next(), i2.next());
                if (cmp == 0) continue;
                return cmp;
            }
            cmp = SuggestionsBranchAndBound.this.compare((Assignment<Request, Enrollment>)SuggestionsBranchAndBound.this.iAssignment, this, suggestion);
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(this.iId, suggestion.iId);
        }
    }
}

