/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.reservation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.reservation.Restriction;

public class IndividualRestriction
extends Restriction {
    private Set<Long> iStudentIds = new HashSet<Long>();

    public IndividualRestriction(long id, Offering offering, Long ... studentIds) {
        super(id, offering);
        for (Long studentId : studentIds) {
            this.iStudentIds.add(studentId);
        }
    }

    public IndividualRestriction(long id, Offering offering, Collection<Long> studentIds) {
        super(id, offering);
        this.iStudentIds.addAll(studentIds);
    }

    @Override
    public boolean isApplicable(Student student) {
        return this.iStudentIds.contains(student.getId());
    }

    public Set<Long> getStudentIds() {
        return this.iStudentIds;
    }
}

