/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.exam.criteria.StudentBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentDistanceBackToBackConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamOwner;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;

public class ExamStudentConflictsBySectionCourse {
    private ExamModel iModel = null;

    public ExamStudentConflictsBySectionCourse(ExamModel model) {
        this.iModel = model;
    }

    private List<ExamOwner> getOwners(Exam exam) {
        if (!exam.getOwners().isEmpty()) {
            return exam.getOwners();
        }
        ExamOwner cs = new ExamOwner(exam, exam.getId(), exam.getName());
        cs.getStudents().addAll(exam.getStudents());
        ArrayList<ExamOwner> ret = new ArrayList<ExamOwner>(1);
        ret.add(cs);
        return ret;
    }

    private List<ExamOwner> getOwners(Exam exam, ExamStudent student) {
        ArrayList<ExamOwner> ret = new ArrayList<ExamOwner>(exam.getOwners(student));
        if (ret.isEmpty()) {
            ExamOwner cs = new ExamOwner(exam, exam.getId(), exam.getName());
            cs.getStudents().add(student);
            ret.add(cs);
        }
        Collections.sort(ret);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Section/Course"), new CSVFile.CSVField((Object)"Period"), new CSVFile.CSVField((Object)"Day"), new CSVFile.CSVField((Object)"Time"), new CSVFile.CSVField((Object)"Room"), new CSVFile.CSVField((Object)"Student"), new CSVFile.CSVField((Object)"Type"), new CSVFile.CSVField((Object)"Section/Course"), new CSVFile.CSVField((Object)"Period"), new CSVFile.CSVField((Object)"Time"), new CSVFile.CSVField((Object)"Room"), new CSVFile.CSVField((Object)"Distance")});
        boolean isDayBreakBackToBack = ((StudentBackToBackConflicts)this.iModel.getCriterion(StudentBackToBackConflicts.class)).isDayBreakBackToBack();
        double backToBackDistance = ((StudentDistanceBackToBackConflicts)this.iModel.getCriterion(StudentDistanceBackToBackConflicts.class)).getBackToBackDistance();
        TreeSet<ExamOwner> courseSections = new TreeSet<ExamOwner>();
        for (Exam exam : this.iModel.variables()) {
            courseSections.addAll(this.getOwners(exam));
        }
        for (ExamOwner cs : courseSections) {
            Exam exam = cs.getExam();
            ExamPlacement placement = (ExamPlacement)assignment.getValue((Variable)exam);
            if (placement == null) continue;
            String roomsThisExam = "";
            for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                if (roomsThisExam.length() > 0) {
                    roomsThisExam = roomsThisExam + ", ";
                }
                roomsThisExam = roomsThisExam + room.getName();
            }
            ExamPeriod period = placement.getPeriod();
            boolean csPrinted = false;
            ArrayList<ExamStudent> students = new ArrayList<ExamStudent>(cs.getStudents());
            Collections.sort(students, new Comparator<ExamStudent>(){

                @Override
                public int compare(ExamStudent s1, ExamStudent s2) {
                    int cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return Double.compare(s1.getId(), s2.getId());
                }
            });
            for (ExamStudent student : students) {
                int nrExamsADay;
                boolean typePrinted;
                boolean stdPrinted = false;
                int nrExams = student.getExams(assignment, period).size();
                if (nrExams > 1) {
                    typePrinted = false;
                    for (Exam otherExam : student.getExams(assignment, period)) {
                        if (otherExam.equals((Object)exam)) continue;
                        ExamPlacement otherPlacement = (ExamPlacement)assignment.getValue((Variable)otherExam);
                        ExamPeriod otherPeriod = otherPlacement.getPeriod();
                        String roomsOtherExam = "";
                        for (ExamRoomPlacement examRoomPlacement : otherPlacement.getRoomPlacements()) {
                            if (roomsOtherExam.length() > 0) {
                                roomsOtherExam = roomsOtherExam + ", ";
                            }
                            roomsOtherExam = roomsOtherExam + examRoomPlacement.getName();
                        }
                        boolean otherPrinted = false;
                        for (Object ocs : this.getOwners(otherExam, student)) {
                            csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)(csPrinted ? "" : cs.getName())), new CSVFile.CSVField((Object)(csPrinted ? "" : String.valueOf(1 + period.getIndex()))), new CSVFile.CSVField((Object)(csPrinted ? "" : period.getDayStr())), new CSVFile.CSVField((Object)(csPrinted ? "" : period.getTimeStr())), new CSVFile.CSVField((Object)(csPrinted ? "" : roomsThisExam)), new CSVFile.CSVField((Object)(stdPrinted ? "" : student.getName())), new CSVFile.CSVField((Object)(typePrinted ? "" : "direct")), new CSVFile.CSVField((Object)((ExamOwner)ocs).getName()), new CSVFile.CSVField((Object)(otherPrinted ? "" : String.valueOf(1 + otherPeriod.getIndex()))), new CSVFile.CSVField((Object)(otherPrinted ? "" : otherPeriod.getTimeStr())), new CSVFile.CSVField((Object)(otherPrinted ? "" : roomsOtherExam))});
                            csPrinted = true;
                            stdPrinted = true;
                            typePrinted = true;
                            otherPrinted = true;
                        }
                    }
                }
                if (nrExams > 0) {
                    typePrinted = false;
                    ArrayList<ExamPeriod> periods = new ArrayList<ExamPeriod>(2);
                    if (!(period.prev() == null || student.getExams(assignment, period.prev()).isEmpty() || isDayBreakBackToBack && period.prev().getDay() != period.getDay())) {
                        periods.add(period.prev());
                    }
                    if (!(period.next() == null || student.getExams(assignment, period.next()).isEmpty() || isDayBreakBackToBack && period.next().getDay() != period.getDay())) {
                        periods.add(period.next());
                    }
                    for (ExamPeriod otherPeriod : periods) {
                        for (Exam otherExam : student.getExams(assignment, otherPeriod)) {
                            double dist;
                            void var26_33;
                            Object ocs;
                            ExamPlacement otherPlacement = (ExamPlacement)assignment.getValue((Variable)otherExam);
                            String string = "";
                            ocs = otherPlacement.getRoomPlacements().iterator();
                            while (ocs.hasNext()) {
                                void var26_35;
                                ExamRoomPlacement room = (ExamRoomPlacement)ocs.next();
                                if (var26_33.length() > 0) {
                                    String string2 = (String)var26_33 + ", ";
                                }
                                String string3 = (String)var26_35 + room.getName();
                            }
                            String distStr = "";
                            if (backToBackDistance >= 0.0 && (dist = placement.getDistanceInMeters(otherPlacement)) > 0.0) {
                                distStr = String.valueOf(dist);
                            }
                            boolean otherPrinted = false;
                            for (ExamOwner ocs2 : this.getOwners(otherExam, student)) {
                                csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)(csPrinted ? "" : cs.getName())), new CSVFile.CSVField((Object)(csPrinted ? "" : String.valueOf(1 + period.getIndex()))), new CSVFile.CSVField((Object)(csPrinted ? "" : period.getDayStr())), new CSVFile.CSVField((Object)(csPrinted ? "" : period.getTimeStr())), new CSVFile.CSVField((Object)(csPrinted ? "" : roomsThisExam)), new CSVFile.CSVField((Object)(stdPrinted ? "" : student.getName())), new CSVFile.CSVField((Object)(typePrinted ? "" : "back-to-back")), new CSVFile.CSVField((Object)ocs2.getName()), new CSVFile.CSVField((Object)(otherPrinted ? "" : String.valueOf(1 + otherPeriod.getIndex()))), new CSVFile.CSVField((Object)(otherPrinted ? "" : otherPeriod.getTimeStr())), new CSVFile.CSVField(otherPrinted ? "" : var26_33), new CSVFile.CSVField((Object)(otherPrinted ? "" : distStr))});
                                csPrinted = true;
                                stdPrinted = true;
                                typePrinted = true;
                                otherPrinted = true;
                            }
                        }
                    }
                }
                if ((nrExamsADay = student.getExamsADay(assignment, period.getDay()).size()) <= 2) continue;
                boolean typePrinted2 = false;
                for (Exam otherExam : student.getExamsADay(assignment, period.getDay())) {
                    if (otherExam.equals((Object)exam)) continue;
                    ExamPlacement otherPlacement = (ExamPlacement)assignment.getValue((Variable)otherExam);
                    ExamPeriod otherPeriod = otherPlacement.getPeriod();
                    String roomsOtherExam = "";
                    for (ExamRoomPlacement room : otherPlacement.getRoomPlacements()) {
                        if (roomsOtherExam.length() > 0) {
                            roomsOtherExam = roomsOtherExam + ", ";
                        }
                        roomsOtherExam = roomsOtherExam + room.getName();
                    }
                    boolean bl = false;
                    for (ExamOwner ocs : this.getOwners(otherExam, student)) {
                        boolean bl2;
                        csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)(csPrinted ? "" : cs.getName())), new CSVFile.CSVField((Object)(csPrinted ? "" : String.valueOf(1 + period.getIndex()))), new CSVFile.CSVField((Object)(csPrinted ? "" : period.getDayStr())), new CSVFile.CSVField((Object)(csPrinted ? "" : period.getTimeStr())), new CSVFile.CSVField((Object)(csPrinted ? "" : roomsThisExam)), new CSVFile.CSVField((Object)(stdPrinted ? "" : student.getName())), new CSVFile.CSVField((Object)(typePrinted2 ? "" : "more-2-day")), new CSVFile.CSVField((Object)ocs.getName()), new CSVFile.CSVField((Object)(bl2 ? "" : String.valueOf(1 + otherPeriod.getIndex()))), new CSVFile.CSVField((Object)(bl2 ? "" : otherPeriod.getTimeStr())), new CSVFile.CSVField((Object)(bl2 ? "" : roomsOtherExam))});
                        csPrinted = true;
                        stdPrinted = true;
                        typePrinted2 = true;
                        bl2 = true;
                    }
                }
            }
        }
        return csv;
    }
}

