/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.sectioning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.coursett.sectioning.SctEnrollment;
import org.cpsolver.coursett.sectioning.SctStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.JProf;

public class SctModel {
    public static double sEps = 1.0E-4;
    private long iTimeOut = 1000L;
    private boolean iUseCriteria = true;
    private TimetableModel iModel;
    private Assignment<Lecture, Placement> iAssignment;
    private List<StudentConflict> iStudentConflictCriteria = null;
    private List<Configuration> iConfigurations = null;
    private List<SctStudent> iStudents = null;
    private Long iOfferingId = null;
    private Map<Long, Double> iLimits = new HashMap<Long, Double>();
    private Map<Long, Map<Long, Set<Lecture>>> iSubparts = new HashMap<Long, Map<Long, Set<Lecture>>>();
    private boolean iTimeOutReached = false;
    private boolean iGroupFirst = false;

    public SctModel(TimetableModel model, Assignment<Lecture, Placement> assignment) {
        this.iModel = model;
        this.iAssignment = assignment;
        this.iTimeOut = model.getProperties().getPropertyLong("SctSectioning.TimeOut", 1000L);
        this.iUseCriteria = model.getProperties().getPropertyBoolean("SctSectioning.UseCriteria", true);
        this.iGroupFirst = model.getProperties().getPropertyBoolean("SctSectioning.GroupFirst", false);
    }

    public List<StudentConflict> getStudentConflictCriteria() {
        if (!this.iUseCriteria) {
            return null;
        }
        if (this.iStudentConflictCriteria == null && this.iModel != null) {
            this.iStudentConflictCriteria = new ArrayList<StudentConflict>();
            for (Criterion criterion : this.iModel.getCriteria()) {
                if (!(criterion instanceof StudentConflict)) continue;
                this.iStudentConflictCriteria.add((StudentConflict)criterion);
            }
        }
        return this.iStudentConflictCriteria;
    }

    public List<Configuration> getConfigurations() {
        return this.iConfigurations;
    }

    public void setConfiguration(Configuration config) {
        this.iConfigurations = new ArrayList<Configuration>();
        this.iConfigurations.add(config);
        this.iOfferingId = config.getOfferingId();
        if (config.getAltConfigurations() != null) {
            for (Configuration alt : config.getAltConfigurations()) {
                if (alt.equals(config)) continue;
                this.iConfigurations.add(alt);
            }
        }
        this.iStudents = new ArrayList<SctStudent>();
        HashSet<Long> studentIds = new HashSet<Long>();
        for (Configuration c : this.iConfigurations) {
            for (Lecture l : c.getTopLectures(c.getTopSubpartIds().iterator().next())) {
                for (Student s : l.students()) {
                    if (!studentIds.add(s.getId())) continue;
                    this.iStudents.add(new SctStudent(this, s));
                }
            }
        }
        for (Student student : this.getTimetableModel().getAllStudents()) {
            if (!student.hasOffering(this.getOfferingId()) || !studentIds.add(student.getId())) continue;
            this.iStudents.add(new SctStudent(this, student));
        }
        Collections.sort(this.iStudents);
    }

    public Map<Long, Set<Lecture>> getSubparts(Configuration configuration) {
        Map<Long, Set<Lecture>> subparts = this.iSubparts.get(configuration.getConfigId());
        if (subparts == null) {
            subparts = new HashMap<Long, Set<Lecture>>();
            LinkedList queue = new LinkedList();
            for (Map.Entry<Long, Set<Lecture>> e : configuration.getTopLectures().entrySet()) {
                subparts.put(e.getKey(), e.getValue());
                queue.addAll(e.getValue());
            }
            Lecture lecture = null;
            while ((lecture = (Lecture)((Object)queue.poll())) != null) {
                if (lecture.getChildren() == null) continue;
                for (Map.Entry<Long, List<Lecture>> e : lecture.getChildren().entrySet()) {
                    Set<Lecture> lectures = subparts.get(e.getKey());
                    if (lectures == null) {
                        lectures = new HashSet<Lecture>((Collection)e.getValue());
                        subparts.put(e.getKey(), lectures);
                    } else {
                        lectures.addAll((Collection<Lecture>)e.getValue());
                    }
                    queue.addAll(e.getValue());
                }
            }
            this.iSubparts.put(configuration.getConfigId(), subparts);
        }
        return subparts;
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public TimetableModel getTimetableModel() {
        return this.iModel;
    }

    public Assignment<Lecture, Placement> getAssignment() {
        return this.iAssignment;
    }

    private double getEnrollment(Lecture lecture, Map<Long, Double> limits) {
        Double enrollment = limits.get(lecture.getClassId());
        return enrollment == null ? 0.0 : enrollment;
    }

    private void incEnrollment(Lecture lecture, Map<Long, Double> limits, double weight) {
        Double enrollment = limits.get(lecture.getClassId());
        limits.put(lecture.getClassId(), (enrollment == null ? 0.0 : enrollment) + weight);
    }

    private void incEnrollment(SctStudent student, SctEnrollment enrollment, Map<Long, Double> limits, Map<Long, Map<Long, Match>> matches) {
        for (Lecture lecture : enrollment.getLectures()) {
            this.incEnrollment(lecture, limits, student.getOfferingWeight());
        }
        for (StudentGroup group : student.getStudent().getGroups()) {
            Map<Long, Match> match = matches.get(group.getId());
            if (match == null) {
                match = new HashMap<Long, Match>();
                matches.put(group.getId(), match);
            }
            for (Lecture lecture : enrollment.getLectures()) {
                Match m = match.get(lecture.getSchedulingSubpartId());
                if (m == null) {
                    m = new Match(group, lecture);
                    match.put(lecture.getSchedulingSubpartId(), m);
                }
                m.inc(lecture);
            }
        }
    }

    private void decEnrollment(SctStudent student, SctEnrollment enrollment, Map<Long, Double> limits, Map<Long, Map<Long, Match>> matches) {
        for (Lecture lecture : enrollment.getLectures()) {
            this.incEnrollment(lecture, limits, -student.getOfferingWeight());
        }
        for (StudentGroup group : student.getStudent().getGroups()) {
            Map<Long, Match> match = matches.get(group.getId());
            if (match == null) {
                match = new HashMap<Long, Match>();
                matches.put(group.getId(), match);
            }
            for (Lecture lecture : enrollment.getLectures()) {
                Match m = match.get(lecture.getSchedulingSubpartId());
                if (m == null) {
                    m = new Match(group, lecture);
                    match.put(lecture.getSchedulingSubpartId(), m);
                }
                m.dec(lecture);
            }
        }
    }

    private double getLimit(Lecture lecture) {
        Double limit = this.iLimits.get(lecture.getClassId());
        if (limit == null) {
            limit = Math.max((double)lecture.classLimit(this.getAssignment()), lecture.nrWeightedStudents()) - sEps;
            this.iLimits.put(lecture.getClassId(), limit);
        }
        return limit;
    }

    private boolean isAvailable(SctStudent student, SctEnrollment enrollment, Map<Long, Double> limits) {
        for (Lecture lecture : enrollment.getLectures()) {
            if (!(this.getEnrollment(lecture, limits) > this.getLimit(lecture))) continue;
            return false;
        }
        return true;
    }

    private double group(SctEnrollment[] enrollments) {
        HashMap matches = new HashMap();
        for (SctEnrollment enrollment : enrollments) {
            if (enrollment == null) continue;
            for (StudentGroup group : enrollment.getStudent().getStudent().getGroups()) {
                HashMap<Long, Match> match = (HashMap<Long, Match>)matches.get(group.getId());
                if (match == null) {
                    match = new HashMap<Long, Match>();
                    matches.put(group.getId(), match);
                }
                for (Lecture lecture : enrollment.getLectures()) {
                    Match m = (Match)match.get(lecture.getSchedulingSubpartId());
                    if (m == null) {
                        m = new Match(group, lecture.getConfiguration());
                        match.put(lecture.getSchedulingSubpartId(), m);
                    }
                    m.inc(lecture);
                }
            }
        }
        double ret = 0.0;
        for (Map match : matches.values()) {
            for (Match m : match.values()) {
                ret += m.value();
            }
        }
        return ret;
    }

    protected double group(SctEnrollment[] enrollments, int index, Map<Long, Double> limits, Map<Long, Map<Long, Match>> matches) {
        HashMap<Long, UnMatched> unmatched = new HashMap<Long, UnMatched>();
        for (int i = index; i < this.iStudents.size(); ++i) {
            SctStudent student = this.iStudents.get(i);
            for (StudentGroup group : student.getStudent().getGroups()) {
                UnMatched m = (UnMatched)unmatched.get(group.getId());
                if (m == null) {
                    m = new UnMatched(group);
                    unmatched.put(group.getId(), m);
                }
                m.incBound(student);
            }
        }
        double ret = 0.0;
        for (Map.Entry<Long, Map<Long, Match>> match : matches.entrySet()) {
            for (Match m : match.getValue().values()) {
                ret += m.value((UnMatched)unmatched.remove(match.getKey()), limits);
            }
        }
        for (UnMatched m : unmatched.values()) {
            ret += m.value();
        }
        return ret;
    }

    public void computeSolution(SctSolution solution, int index, SctEnrollment[] enrollments, Map<Long, Double> limits, Map<Long, Map<Long, Match>> match, double totalConflicts, long t0) {
        if (this.iTimeOutReached) {
            return;
        }
        if (JProf.currentTimeMillis() - t0 > this.iTimeOut) {
            this.iTimeOutReached = true;
            return;
        }
        if (index < this.iStudents.size()) {
            if (!solution.checkBound(index, enrollments, totalConflicts, limits, match)) {
                return;
            }
            SctStudent student = this.iStudents.get(index);
            for (SctEnrollment enrollment : student.getEnrollments(new SctEnrollmentComparator(limits, match, index))) {
                if (!this.isAvailable(student, enrollment, limits)) continue;
                enrollments[index] = enrollment;
                this.incEnrollment(student, enrollment, limits, match);
                this.computeSolution(solution, index + 1, enrollments, limits, match, totalConflicts + enrollment.getConflictWeight(), t0);
                this.decEnrollment(student, enrollment, limits, match);
            }
        } else if (solution.isBetter(enrollments, totalConflicts)) {
            solution.record(enrollments, totalConflicts);
        }
    }

    public SctSolution computeSolution() {
        SctSolution solution = this.currentSolution();
        this.iTimeOutReached = false;
        this.computeSolution(solution, 0, new SctEnrollment[this.iStudents.size()], new HashMap<Long, Double>(), new HashMap<Long, Map<Long, Match>>(), 0.0, JProf.currentTimeMillis());
        return solution;
    }

    public boolean isTimeOutReached() {
        return this.iTimeOutReached;
    }

    public SctSolution currentSolution() {
        SctEnrollment[] enrollments = new SctEnrollment[this.iStudents.size()];
        for (int index = 0; index < this.iStudents.size(); ++index) {
            enrollments[index] = this.iStudents.get(index).getCurrentEnrollment(true);
        }
        return new SctSolution(enrollments);
    }

    protected void decJenrl(Assignment<Lecture, Placement> assignment, Student student, Lecture l1, Lecture l2) {
        if (l1.equals((Object)l2)) {
            return;
        }
        JenrlConstraint jenrl = l1.jenrlConstraint(l2);
        if (jenrl != null) {
            jenrl.decJenrl(assignment, student);
        }
    }

    protected void incJenrl(Assignment<Lecture, Placement> assignment, Student student, Lecture l1, Lecture l2) {
        if (l1.equals((Object)l2)) {
            return;
        }
        JenrlConstraint jenrl = l1.jenrlConstraint(l2);
        if (jenrl == null) {
            jenrl = new JenrlConstraint();
            jenrl.addVariable((Variable)l1);
            jenrl.addVariable((Variable)l2);
            this.iModel.addConstraint((Constraint<Lecture, Placement>)jenrl);
        }
        jenrl.incJenrl(assignment, student);
    }

    public void unassign() {
        for (SctStudent student : this.iStudents) {
            Configuration configuration = null;
            for (Lecture lecture : student.getCurrentEnrollment(false).getLectures()) {
                if (configuration == null) {
                    configuration = lecture.getConfiguration();
                }
                for (Lecture other : student.getStudent().getLectures()) {
                    this.decJenrl(this.getAssignment(), student.getStudent(), lecture, other);
                }
                lecture.removeStudent(this.getAssignment(), student.getStudent());
                student.getStudent().removeLecture(lecture);
            }
            if (configuration == null) continue;
            student.getStudent().removeConfiguration(configuration);
        }
    }

    public void assign(SctSolution solution) {
        for (int index = 0; index < this.iStudents.size(); ++index) {
            SctStudent student = this.iStudents.get(index);
            Configuration configuration = null;
            SctEnrollment enrollment = solution.iEnrollments[index];
            if (enrollment == null) continue;
            for (Lecture lecture : enrollment.getLectures()) {
                if (configuration == null) {
                    configuration = lecture.getConfiguration();
                }
                for (Lecture other : student.getStudent().getLectures()) {
                    this.incJenrl(this.getAssignment(), student.getStudent(), lecture, other);
                }
                lecture.addStudent(this.getAssignment(), student.getStudent());
                student.getStudent().addLecture(lecture);
            }
            if (configuration == null) continue;
            student.getStudent().addConfiguration(configuration);
        }
    }

    private class SctEnrollmentComparator
    implements Comparator<SctEnrollment> {
        private Map<Long, Double> limits;
        private Map<Long, Map<Long, Match>> matches;
        private int index;

        SctEnrollmentComparator(Map<Long, Double> limits, Map<Long, Map<Long, Match>> match, int index) {
            this.limits = limits;
            this.matches = match;
            this.index = index;
        }

        public int compareByGroup(SctEnrollment e1, SctEnrollment e2) {
            double m1 = 0.0;
            double m2 = 0.0;
            for (StudentGroup g : e1.getStudent().getStudent().getGroups()) {
                double enroll;
                int a;
                double fraction;
                Match m;
                int remaining = 0;
                int total = g.countStudents(SctModel.this.getOfferingId());
                double remainingWeight = 0.0;
                for (int i = this.index; i < SctModel.this.iStudents.size(); ++i) {
                    SctStudent student = (SctStudent)SctModel.this.iStudents.get(i);
                    if (!student.getStudent().hasGroup(g)) continue;
                    ++remaining;
                    remainingWeight += student.getStudent().getOfferingWeight(SctModel.this.getOfferingId());
                }
                double avgWeight = remainingWeight / (double)remaining;
                Map<Long, Match> match = this.matches.get(g.getId());
                for (Lecture lecture : e1.getLectures()) {
                    m = match == null ? null : match.get(lecture.getSchedulingSubpartId());
                    fraction = 1.0 / (double)SctModel.this.getSubparts(lecture.getConfiguration()).size();
                    a = m == null ? 0 : m.get(lecture);
                    enroll = Math.min(remainingWeight, SctModel.this.getLimit(lecture) - SctModel.this.getEnrollment(lecture, this.limits));
                    m1 += fraction * (double)((a += (int)Math.round(enroll / avgWeight)) * (a - 1)) / (double)(total * (total - 1));
                }
                for (Lecture lecture : e2.getLectures()) {
                    m = match == null ? null : match.get(lecture.getSchedulingSubpartId());
                    fraction = 1.0 / (double)SctModel.this.getSubparts(lecture.getConfiguration()).size();
                    a = m == null ? 0 : m.get(lecture);
                    enroll = Math.min(remainingWeight, SctModel.this.getLimit(lecture) - SctModel.this.getEnrollment(lecture, this.limits));
                    m2 += fraction * (double)((a += (int)Math.round(enroll / avgWeight)) * (a - 1)) / (double)(total * (total - 1));
                }
            }
            if (m1 != m2) {
                return m1 > m2 ? -1 : 1;
            }
            return 0;
        }

        @Override
        public int compare(SctEnrollment e1, SctEnrollment e2) {
            if (SctModel.this.iGroupFirst) {
                int cmp = this.compareByGroup(e1, e2);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = Double.compare(e1.getConflictWeight(), e2.getConflictWeight());
                if (cmp != 0) {
                    return cmp;
                }
            } else {
                int cmp = Double.compare(e1.getConflictWeight(), e2.getConflictWeight());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = this.compareByGroup(e1, e2);
                if (cmp != 0) {
                    return cmp;
                }
            }
            return e1.getId().compareTo(e2.getId());
        }
    }

    private class UnMatched {
        private int iTotal = 0;
        private int iNotMatched = 0;
        private double iEnrollmentWeight = 0.0;

        UnMatched(StudentGroup group) {
            this.iTotal = group.countStudents(SctModel.this.getOfferingId());
        }

        void incBound(SctStudent student) {
            ++this.iNotMatched;
            this.iEnrollmentWeight += student.getStudent().getOfferingWeight(SctModel.this.getOfferingId());
        }

        double value() {
            if (this.iTotal <= 1) {
                return 1.0;
            }
            if (this.iNotMatched > 1) {
                return (double)this.iNotMatched * ((double)this.iNotMatched - 1.0) / ((double)this.iTotal * ((double)this.iTotal - 1.0));
            }
            return 0.0;
        }

        int getNotMatched() {
            return this.iNotMatched;
        }

        public double getEnrollmentWeight() {
            return this.iEnrollmentWeight;
        }

        public String toString() {
            return this.iTotal + "/" + this.iNotMatched;
        }
    }

    private class Match {
        private int iTotal = 0;
        private Map<Lecture, Integer> iMatch = new HashMap<Lecture, Integer>();
        private double iFraction = 1.0;

        Match(StudentGroup group, Lecture lecture) {
            this(group, lecture.getConfiguration());
            for (Lecture l : lecture.sameSubpartLectures()) {
                this.iMatch.put(l, 0);
            }
        }

        Match(StudentGroup group, Configuration config) {
            this.iTotal = group.countStudents(SctModel.this.getOfferingId());
            this.iFraction = 1.0 / (double)SctModel.this.getSubparts(config).size();
        }

        void inc(Lecture lecture) {
            Integer val = this.iMatch.get((Object)lecture);
            this.iMatch.put(lecture, 1 + (val == null ? 0 : val));
        }

        void dec(Lecture lecture) {
            Integer val = this.iMatch.get((Object)lecture);
            this.iMatch.put(lecture, (val == null ? 0 : val) - 1);
        }

        int get(Lecture lecture) {
            Integer val = this.iMatch.get((Object)lecture);
            return val == null ? 0 : val;
        }

        double value(UnMatched u, final Map<Long, Double> limits) {
            if (this.iTotal <= 1) {
                return this.iFraction;
            }
            if (u == null || u.getNotMatched() == 0) {
                return this.value();
            }
            double value = 0.0;
            int unmatched = u.getNotMatched();
            double remains = u.getEnrollmentWeight();
            double avgWeight = remains / (double)unmatched;
            TreeSet<Map.Entry<Lecture, Integer>> entries = new TreeSet<Map.Entry<Lecture, Integer>>(new Comparator<Map.Entry<Lecture, Integer>>(){

                @Override
                public int compare(Map.Entry<Lecture, Integer> e1, Map.Entry<Lecture, Integer> e2) {
                    if (e1.getValue() > e2.getValue()) {
                        return -1;
                    }
                    if (e1.getValue() < e2.getValue()) {
                        return 1;
                    }
                    double r1 = SctModel.this.getLimit(e1.getKey()) - SctModel.this.getEnrollment(e1.getKey(), limits);
                    double r2 = SctModel.this.getLimit(e2.getKey()) - SctModel.this.getEnrollment(e2.getKey(), limits);
                    int cmp = Double.compare(r2, r1);
                    if (cmp != 0) {
                        return cmp;
                    }
                    return e1.getKey().compareTo(e2.getKey());
                }
            });
            entries.addAll(this.iMatch.entrySet());
            for (Map.Entry<Lecture, Integer> entry : entries) {
                double enroll;
                int inc;
                Integer m = entry.getValue();
                if (unmatched > 0 && (inc = (int)Math.round((enroll = Math.min(remains, SctModel.this.getLimit(entry.getKey()) - SctModel.this.getEnrollment(entry.getKey(), limits))) / avgWeight)) > 0) {
                    m = m + inc;
                    unmatched -= inc;
                    remains -= enroll;
                }
                if (m <= 1) continue;
                value += (double)m.intValue() * ((double)m.intValue() - 1.0) / ((double)this.iTotal * ((double)this.iTotal - 1.0));
            }
            if (unmatched > 1) {
                value += (double)unmatched * ((double)unmatched - 1.0) / ((double)this.iTotal * ((double)this.iTotal - 1.0));
            }
            return value * this.iFraction;
        }

        double value() {
            if (this.iTotal <= 1) {
                return this.iFraction;
            }
            double value = 0.0;
            for (Integer m : this.iMatch.values()) {
                if (m <= 1) continue;
                value += (double)m.intValue() * ((double)m.intValue() - 1.0) / ((double)this.iTotal * ((double)this.iTotal - 1.0));
            }
            return value * this.iFraction;
        }

        public String toString() {
            return this.iTotal + "/" + this.iMatch + "[" + this.value() + "]";
        }
    }

    class SctSolution {
        private double iWeight = 0.0;
        private double iGroup = 0.0;
        private SctEnrollment[] iEnrollments = null;

        public SctSolution() {
        }

        public SctSolution(SctEnrollment[] enrollments) {
            this.iEnrollments = enrollments;
            this.iWeight = 0.0;
            for (SctEnrollment enrollment : enrollments) {
                if (enrollment == null) continue;
                this.iWeight += enrollment.getConflictWeight();
            }
            this.iGroup = SctModel.this.group(enrollments);
        }

        public boolean isBetter(SctEnrollment[] solution, double weight) {
            if (SctModel.this.iGroupFirst) {
                if (this.iEnrollments == null) {
                    return true;
                }
                double gr = SctModel.this.group(solution);
                return gr > this.iGroup || gr == this.iGroup && weight < this.iWeight;
            }
            return this.iEnrollments == null || weight < this.iWeight || weight == this.iWeight && SctModel.this.group(solution) > this.iGroup;
        }

        public boolean isBetter(SctSolution other) {
            if (SctModel.this.iGroupFirst) {
                if (this.iEnrollments == null) {
                    return true;
                }
                return other.getGroup() < this.iGroup || other.getGroup() == this.iGroup && this.iWeight < other.getWeight();
            }
            return this.iEnrollments != null && (this.iWeight < other.getWeight() || other.getWeight() == this.iWeight && other.getGroup() < this.iGroup);
        }

        public void record(SctEnrollment[] solution, double weight) {
            this.iEnrollments = Arrays.copyOf(solution, solution.length);
            this.iWeight = weight;
            this.iGroup = SctModel.this.group(solution);
        }

        public boolean checkBound(int index, SctEnrollment[] solution, double weight, Map<Long, Double> limits, Map<Long, Map<Long, Match>> match) {
            if (this.iEnrollments == null) {
                return true;
            }
            if (SctModel.this.iGroupFirst) {
                double gr = SctModel.this.group(solution, index, limits, match);
                if (gr == this.iGroup) {
                    double guess = weight;
                    for (int i = index; i < SctModel.this.iStudents.size(); ++i) {
                        SctStudent student = (SctStudent)SctModel.this.iStudents.get(i);
                        SctEnrollment enrollment = null;
                        for (SctEnrollment e : student.getEnrollments()) {
                            if (!SctModel.this.isAvailable(student, e, limits)) continue;
                            enrollment = e;
                            break;
                        }
                        if (enrollment == null) {
                            return false;
                        }
                        if ((guess += enrollment.getConflictWeight()) >= this.iWeight) break;
                    }
                    return guess < this.iWeight;
                }
                return gr > this.iGroup;
            }
            double guess = weight;
            for (int i = index; i < SctModel.this.iStudents.size(); ++i) {
                SctStudent student = (SctStudent)SctModel.this.iStudents.get(i);
                SctEnrollment enrollment = null;
                for (SctEnrollment e : student.getEnrollments()) {
                    if (!SctModel.this.isAvailable(student, e, limits)) continue;
                    enrollment = e;
                    break;
                }
                if (enrollment == null) {
                    return false;
                }
                if ((guess += enrollment.getConflictWeight()) > this.iWeight) break;
            }
            return guess < this.iWeight || guess == this.iWeight && SctModel.this.group(solution, index, limits, match) > this.iGroup;
        }

        public SctEnrollment[] getEnrollments() {
            return this.iEnrollments;
        }

        public double getWeight() {
            return this.iWeight;
        }

        public double getGroup() {
            return this.iGroup;
        }

        public boolean isValid() {
            return this.iEnrollments != null;
        }
    }
}

