/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class StudentOverLunchConflict
extends StudentConflict {
    private int iNoonSlot = 144;
    private boolean iSameDay = true;

    @Override
    public void configure(DataProperties properties) {
        super.configure(properties);
        this.iNoonSlot = properties.getPropertyInt("StudentConflict.NoonSlot", 144);
        this.iSameDay = properties.getPropertyBoolean("StudentConflict.OverLunchSameDayOnly", true);
    }

    public boolean shareDays(Placement p1, Placement p2) {
        return p1 != null && p2 != null && p1.getTimeLocation().shareDays(p2.getTimeLocation()) && p1.getTimeLocation().shareWeeks(p2.getTimeLocation());
    }

    public boolean isMorning(Placement placement) {
        return placement != null && placement.getTimeLocation().getStartSlot() <= this.iNoonSlot;
    }

    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return p1 != null && p2 != null && this.isMorning(p1) != this.isMorning(p2) && (!this.iSameDay || this.shareDays(p1, p2));
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !StudentOverLunchConflict.ignore(l1, l2) && StudentOverLunchConflict.applicable(l1, l2);
    }

    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.StudentOverLunchConflictWeight", 0.1 * config.getPropertyDouble("Comparator.StudentConflictWeight", 1.0));
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.StudentOverLunchConflictWeight";
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        super.getInfo(assignment, info);
        double conf = this.getValue(assignment);
        if (conf > 0.0) {
            double total = 0.0;
            for (JenrlConstraint jenrl : ((TimetableModel)this.getModel()).getJenrlConstraints()) {
                if (jenrl.isToBeIgnored()) continue;
                total += jenrl.jenrl();
            }
            info.put("Student over-lunch conflicts", this.getPerc(conf, 0.0, total) + "% (" + sDoubleFormat.format(conf) + " / " + sDoubleFormat.format(total) + ", weighted: " + sDoubleFormat.format(this.getWeightedValue(assignment)) + ")");
        }
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(assignment, info, variables);
        double conf = this.getValue(assignment, variables);
        if (conf > 0.0) {
            HashSet<JenrlConstraint> jenrls = new HashSet<JenrlConstraint>();
            double total = 0.0;
            for (Lecture lecture : variables) {
                for (JenrlConstraint jenrl : lecture.jenrlConstraints()) {
                    if (!jenrls.add(jenrl) || jenrl.isToBeIgnored()) continue;
                    total += jenrl.jenrl();
                }
            }
            info.put("Student over-lunch conflicts", this.getPerc(conf, 0.0, total) + "% (" + sDoubleFormat.format(conf) + ")");
        }
    }
}

