/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class TooBigRooms
extends TimetablingCriterion {
    private double iDiscouragedRoomSize;
    private double iStronglyDiscouragedRoomSize;

    @Override
    public void configure(DataProperties properties) {
        super.configure(properties);
        this.iDiscouragedRoomSize = properties.getPropertyDouble("TooBigRooms.DiscouragedRoomSize", 1.25);
        this.iStronglyDiscouragedRoomSize = properties.getPropertyDouble("TooBigRooms.StronglyDiscouragedRoomSize", 1.5);
    }

    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.TooBigRoomWeight", 0.1);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.TooBigRoomWeight";
    }

    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = this.getPreference(value);
        if (conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= (double)this.getPreference(conflict);
            }
        }
        return ret;
    }

    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Lecture lect : variables) {
            if (lect.getNrRooms() <= 0) continue;
            bounds[0] = bounds[0] + (double)Constants.sPreferenceLevelStronglyDiscouraged;
        }
        return bounds;
    }

    private long getDiscouragedRoomSize(Placement value) {
        return Math.round(this.iDiscouragedRoomSize * (double)((Lecture)value.variable()).minRoomSize());
    }

    private long getStronglyDiscouragedRoomSize(Placement value) {
        return Math.round(this.iStronglyDiscouragedRoomSize * (double)((Lecture)value.variable()).minRoomSize());
    }

    public int getPreference(Placement value) {
        if (value.isMultiRoom()) {
            PreferenceCombination pref = PreferenceCombination.getDefault();
            for (RoomLocation r : value.getRoomLocations()) {
                if ((long)r.getRoomSize() > this.getStronglyDiscouragedRoomSize(value)) {
                    pref.addPreferenceInt(Constants.sPreferenceLevelStronglyDiscouraged);
                    continue;
                }
                if ((long)r.getRoomSize() <= this.getDiscouragedRoomSize(value)) continue;
                pref.addPreferenceInt(Constants.sPreferenceLevelDiscouraged);
            }
            return pref.getPreferenceInt();
        }
        if ((long)value.getRoomLocation().getRoomSize() > this.getStronglyDiscouragedRoomSize(value)) {
            return Constants.sPreferenceLevelStronglyDiscouraged;
        }
        if ((long)value.getRoomLocation().getRoomSize() > this.getDiscouragedRoomSize(value)) {
            return Constants.sPreferenceLevelDiscouraged;
        }
        return Constants.sPreferenceLevelNeutral;
    }

    @Deprecated
    public static int getTooBigRoomPreference(Placement value) {
        if (value.isMultiRoom()) {
            PreferenceCombination pref = PreferenceCombination.getDefault();
            for (RoomLocation r : value.getRoomLocations()) {
                if ((long)r.getRoomSize() > Math.round(1.5 * (double)((Lecture)value.variable()).minRoomSize())) {
                    pref.addPreferenceInt(Constants.sPreferenceLevelStronglyDiscouraged);
                    continue;
                }
                if ((long)r.getRoomSize() <= Math.round(1.25 * (double)((Lecture)value.variable()).minRoomSize())) continue;
                pref.addPreferenceInt(Constants.sPreferenceLevelDiscouraged);
            }
            return pref.getPreferenceInt();
        }
        if ((long)value.getRoomLocation().getRoomSize() > Math.round(1.5 * (double)((Lecture)value.variable()).minRoomSize())) {
            return Constants.sPreferenceLevelStronglyDiscouraged;
        }
        if ((long)value.getRoomLocation().getRoomSize() > Math.round(1.25 * (double)((Lecture)value.variable()).minRoomSize())) {
            return Constants.sPreferenceLevelDiscouraged;
        }
        return Constants.sPreferenceLevelNeutral;
    }
}

