/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.ToolBox;

public class MaxBlockFlexibleConstraint
extends FlexibleConstraint {
    private int iMaxBreakBetweenBTB;
    protected int iMaxBlockSlotsBTB;

    public MaxBlockFlexibleConstraint(Long id, String owner, String preference, String reference) {
        super(id, owner, preference, reference);
        Pattern pattern = null;
        Matcher matcher = null;
        String patternString = "_(MaxBlock):([0-9]+):([0-9]+)_";
        pattern = Pattern.compile(patternString);
        matcher = pattern.matcher(reference);
        if (matcher.find()) {
            this.iMaxBlockSlotsBTB = Integer.parseInt(matcher.group(2)) / Constants.SLOT_LENGTH_MIN;
            this.iMaxBreakBetweenBTB = Integer.parseInt(matcher.group(3)) / Constants.SLOT_LENGTH_MIN;
            this.iConstraintType = FlexibleConstraint.FlexibleConstraintType.MAXBLOCK_BACKTOBACK;
        }
    }

    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!this.isHard()) {
            return;
        }
        List<BitSet> weeks = this.getWeeks();
        for (int dayCode : Constants.DAY_CODES) {
            for (BitSet week : weeks) {
                boolean isProblem = false;
                do {
                    isProblem = false;
                    List<FlexibleConstraint.Block> blocks = this.getBlocks(assignment, dayCode, conflicts, value, null, week);
                    for (FlexibleConstraint.Block block : blocks) {
                        if (!block.getPlacements().contains((Object)value)) continue;
                        HashSet<Placement> adepts = new HashSet<Placement>();
                        if (block.getNbrPlacements() == 1 || block.haveSameStartTime() || block.getLengthInSlots() <= this.iMaxBlockSlotsBTB) continue;
                        adepts.addAll(block.getPlacements());
                        adepts.remove((Object)value);
                        isProblem = true;
                        Placement conflict = (Placement)((Object)ToolBox.random(adepts));
                        if (conflict == null) continue;
                        conflicts.add(conflict);
                    }
                } while (isProblem);
            }
        }
    }

    public List<FlexibleConstraint.Block> getBlocks(Assignment<Lecture, Placement> assignment, int dayCode, Set<Placement> conflicts, Placement value, HashMap<Lecture, Placement> assignments, BitSet week) {
        ArrayList<Placement> toBeSorted = new ArrayList<Placement>(this.getRelevantPlacements(assignment, dayCode, conflicts, value, assignments, week));
        Collections.sort(toBeSorted, new FlexibleConstraint.PlacementTimeComparator());
        return this.mergeToBlocks(toBeSorted, this.iMaxBreakBetweenBTB);
    }

    @Override
    public double getNrViolations(Assignment<Lecture, Placement> assignment, Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        List<BitSet> weeks = this.getWeeks();
        int violatedBlocks = 0;
        for (int dayCode : Constants.DAY_CODES) {
            for (BitSet week : weeks) {
                List<FlexibleConstraint.Block> blocks = this.getBlocks(assignment, dayCode, null, null, assignments, week);
                for (FlexibleConstraint.Block block : blocks) {
                    if (block.getNbrPlacements() == 1 || block.haveSameStartTime() || block.getLengthInSlots() <= this.iMaxBlockSlotsBTB) continue;
                    int blockLengthPenalty = block.getLengthInSlots() / this.iMaxBlockSlotsBTB;
                    violatedBlocks += blockLengthPenalty;
                }
            }
        }
        return violatedBlocks;
    }
}

