/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.util;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.util.ProgressListener;
import org.dom4j.Element;

public class Progress {
    public static boolean sTraceEnabled = false;
    private static Logger sLogger = LogManager.getLogger(Progress.class);
    public static SimpleDateFormat sDF = new SimpleDateFormat("MM/dd/yy HH:mm:ss.SSS");
    public static final int MSGLEVEL_TRACE = 0;
    public static final int MSGLEVEL_DEBUG = 1;
    public static final int MSGLEVEL_PROGRESS = 2;
    public static final int MSGLEVEL_INFO = 3;
    public static final int MSGLEVEL_STAGE = 4;
    public static final int MSGLEVEL_WARN = 5;
    public static final int MSGLEVEL_ERROR = 6;
    public static final int MSGLEVEL_FATAL = 7;
    private String iStatus = "";
    private String iPhase = "";
    private long iProgressMax = 0L;
    private long iProgressCurrent = 0L;
    private List<ProgressListener> iListeners = new ArrayList<ProgressListener>(5);
    private List<Object[]> iSave = new ArrayList<Object[]>(5);
    private List<Message> iLog = new ArrayList<Message>(1000);
    private boolean iDisposed = false;
    private static HashMap<Object, Progress> sInstances = new HashMap();

    private Progress() {
    }

    public static Progress getInstance() {
        return Progress.getInstance("--DEFAULT--");
    }

    public static Progress getInstance(Object key) {
        Progress progress = sInstances.get(key);
        if (progress == null) {
            progress = new Progress();
            sInstances.put(key, progress);
        }
        return progress;
    }

    public static void changeInstance(Object oldKey, Object newKey) {
        Progress.removeInstance(newKey);
        Progress progress = sInstances.get(oldKey);
        if (progress != null) {
            sInstances.remove(oldKey);
            sInstances.put(newKey, progress);
        }
    }

    public static void removeInstance(Object key) {
        Progress progress = sInstances.get(key);
        if (progress != null) {
            progress.iListeners.clear();
            progress.iDisposed = true;
            sInstances.remove(key);
        }
    }

    public String getStatus() {
        return this.iStatus;
    }

    public void setStatus(String status) {
        this.message(4, status);
        if (!status.equals(this.iStatus)) {
            this.iPhase = "";
            this.iProgressMax = 0L;
            this.iProgressCurrent = 0L;
            this.iStatus = status;
            this.fireStatusChanged();
        }
    }

    public String getPhase() {
        return this.iPhase;
    }

    public void setPhase(String phase, long progressMax) {
        if (this.iSave.isEmpty() && !phase.equals(this.iPhase)) {
            this.message(2, phase);
        }
        this.iPhase = phase;
        this.iProgressMax = progressMax;
        this.iProgressCurrent = 0L;
        this.firePhaseChanged();
    }

    public void setPhase(String phase) {
        this.setPhase(phase, 100L);
    }

    public void setProgress(long progress) {
        if (this.iProgressCurrent != progress) {
            this.iProgressCurrent = progress;
            this.fireProgressChanged();
        }
    }

    public long getProgress() {
        return this.iProgressCurrent;
    }

    public long getProgressMax() {
        return this.iProgressMax;
    }

    public void incProgress() {
        ++this.iProgressCurrent;
        this.fireProgressChanged();
    }

    public void addProgressListener(ProgressListener listener) {
        this.iListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.iListeners.remove(listener);
    }

    public void clearProgressListeners() {
        this.iListeners.clear();
    }

    public synchronized void save() {
        this.iSave.add(new Object[]{this.iStatus, this.iPhase, new Long(this.iProgressMax), new Long(this.iProgressCurrent)});
        this.fireProgressSaved();
    }

    public synchronized void restore() {
        if (this.iSave.isEmpty()) {
            return;
        }
        Object[] o = this.iSave.get(this.iSave.size() - 1);
        this.iSave.remove(this.iSave.size() - 1);
        this.iStatus = (String)o[0];
        this.iPhase = (String)o[1];
        this.iProgressMax = (Long)o[2];
        this.iProgressCurrent = (Long)o[3];
        this.fireProgressRestored();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void message(int level, String message, Throwable t) {
        if (this.iDisposed) {
            throw new RuntimeException("This solver is killed.");
        }
        Message m = new Message(level, message, t);
        switch (level) {
            case 0: {
                sLogger.debug("    -- " + message, t);
                break;
            }
            case 1: {
                sLogger.debug("  -- " + message, t);
                break;
            }
            case 2: {
                sLogger.debug("[" + message + "]", t);
                break;
            }
            case 3: {
                sLogger.info(message, t);
                break;
            }
            case 4: {
                sLogger.info("[" + message + "]", t);
                break;
            }
            case 5: {
                sLogger.warn(message, t);
                break;
            }
            case 6: {
                sLogger.error(message, t);
                break;
            }
            case 7: {
                sLogger.fatal(message, t);
            }
        }
        List<Message> list = this.iLog;
        synchronized (list) {
            this.iLog.add(m);
        }
        this.fireMessagePrinted(m);
    }

    public void message(int level, String message) {
        this.message(level, message, null);
    }

    public void trace(String message) {
        if (!sTraceEnabled) {
            return;
        }
        this.message(0, message);
    }

    public void debug(String message) {
        this.message(1, message);
    }

    public void info(String message) {
        this.message(3, message);
    }

    public void warn(String message) {
        this.message(5, message);
    }

    public void error(String message) {
        this.message(6, message);
    }

    public void fatal(String message) {
        this.message(7, message);
    }

    public void trace(String message, Throwable e) {
        if (!sTraceEnabled) {
            return;
        }
        this.message(0, message, e);
    }

    public void debug(String message, Throwable e) {
        this.message(1, message, e);
    }

    public void info(String message, Throwable e) {
        this.message(3, message, e);
    }

    public void warn(String message, Throwable e) {
        this.message(5, message, e);
    }

    public void error(String message, Throwable e) {
        this.message(6, message, e);
    }

    public void fatal(String message, Throwable e) {
        this.message(7, message, e);
    }

    public List<Message> getLog() {
        return this.iLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLog(int level) {
        StringBuffer sb = new StringBuffer();
        List<Message> list = this.iLog;
        synchronized (list) {
            for (Message m : this.iLog) {
                String s = m.toString(level);
                if (s == null) continue;
                sb.append(s + "\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtmlLog(int level, boolean includeDate) {
        StringBuffer sb = new StringBuffer();
        List<Message> list = this.iLog;
        synchronized (list) {
            for (Message m : this.iLog) {
                String s = m.toHtmlString(level, includeDate);
                if (s == null) continue;
                sb.append(s + "<br>");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtmlLog(int level, boolean includeDate, String fromStage) {
        StringBuffer sb = new StringBuffer();
        List<Message> list = this.iLog;
        synchronized (list) {
            for (Message m : this.iLog) {
                String s;
                if (m.getLevel() == 4 && m.getMessage().equals(fromStage)) {
                    sb = new StringBuffer();
                }
                if ((s = m.toHtmlString(level, includeDate)) == null) continue;
                sb.append(s + "<br>");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Message> list = this.iLog;
        synchronized (list) {
            this.iLog.clear();
        }
    }

    private void fireStatusChanged() {
        for (ProgressListener listener : this.iListeners) {
            listener.statusChanged(this.iStatus);
        }
    }

    private void firePhaseChanged() {
        for (ProgressListener listener : this.iListeners) {
            listener.phaseChanged(this.iPhase);
        }
    }

    private void fireProgressChanged() {
        for (ProgressListener listener : this.iListeners) {
            listener.progressChanged(this.iProgressCurrent, this.iProgressMax);
        }
    }

    private void fireProgressSaved() {
        for (ProgressListener listener : this.iListeners) {
            listener.progressSaved();
        }
    }

    private void fireProgressRestored() {
        for (ProgressListener listener : this.iListeners) {
            listener.progressRestored();
        }
    }

    private void fireMessagePrinted(Message message) {
        for (ProgressListener listener : this.iListeners) {
            listener.progressMessagePrinted(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Element root) {
        Element log = root.addElement("log");
        List<Message> list = this.iLog;
        synchronized (list) {
            for (Message m : this.iLog) {
                m.save(log.addElement("msg"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Element root, boolean clear) {
        List<Message> list = this.iLog;
        synchronized (list) {
            Element log;
            if (clear) {
                this.iLog.clear();
            }
            if ((log = root.element("log")) != null) {
                Iterator i = log.elementIterator("msg");
                while (i.hasNext()) {
                    this.iLog.add(new Message((Element)i.next()));
                }
            }
        }
    }

    public static class Message
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int iLevel = 0;
        private String iMessage;
        private Date iDate = null;
        private String[] iStakTrace = null;

        private Message(int level, String message, Throwable e) {
            StackTraceElement[] trace;
            this.iLevel = level;
            this.iMessage = message;
            this.iDate = new Date();
            if (e != null && (trace = e.getStackTrace()) != null) {
                this.iStakTrace = new String[trace.length + 1];
                this.iStakTrace[0] = e.getClass().getName() + ": " + e.getMessage();
                for (int i = 0; i < trace.length; ++i) {
                    this.iStakTrace[i + 1] = trace[i].getClassName() + "." + trace[i].getMethodName() + (trace[i].getFileName() == null ? "" : "(" + trace[i].getFileName() + (trace[i].getLineNumber() >= 0 ? ":" + trace[i].getLineNumber() : "") + ")");
                }
            }
        }

        public Message(Element element) {
            this.iLevel = Integer.parseInt(element.attributeValue("level", "0"));
            this.iMessage = element.attributeValue("msg");
            this.iDate = new Date(Long.parseLong(element.attributeValue("date", "0")));
            List tr = element.elements("trace");
            if (tr != null && !tr.isEmpty()) {
                this.iStakTrace = new String[tr.size()];
                for (int i = 0; i < tr.size(); ++i) {
                    this.iStakTrace[i] = ((Element)tr.get(i)).getText();
                }
            }
        }

        public String getMessage() {
            return this.iMessage;
        }

        public int getLevel() {
            return this.iLevel;
        }

        public Date getDate() {
            return this.iDate;
        }

        private String getTraceLog() {
            if (this.iStakTrace == null) {
                return "";
            }
            StringBuffer ret = new StringBuffer("\n" + this.iStakTrace[0]);
            for (int i = 1; i < this.iStakTrace.length; ++i) {
                ret.append("\n    at " + this.iStakTrace[i]);
            }
            return ret.toString();
        }

        private String getHtmlTraceLog() {
            if (this.iStakTrace == null) {
                return "";
            }
            StringBuffer ret = new StringBuffer("<BR>" + this.iStakTrace[0]);
            for (int i = 1; i < this.iStakTrace.length; ++i) {
                ret.append("<BR>&nbsp;&nbsp;&nbsp;&nbsp;at " + this.iStakTrace[i]);
            }
            return ret.toString();
        }

        public String[] getTrace() {
            return this.iStakTrace;
        }

        public String toString(int level) {
            if (this.iLevel < level) {
                return null;
            }
            switch (this.iLevel) {
                case 0: {
                    return sDF.format(this.iDate) + "    -- " + this.iMessage + this.getTraceLog();
                }
                case 1: {
                    return sDF.format(this.iDate) + "  -- " + this.iMessage + this.getTraceLog();
                }
                case 2: {
                    return sDF.format(this.iDate) + " [" + this.iMessage + "]" + this.getTraceLog();
                }
                case 3: {
                    return sDF.format(this.iDate) + " " + this.iMessage + this.getTraceLog();
                }
                case 4: {
                    return sDF.format(this.iDate) + " >>> " + this.iMessage + " <<<" + this.getTraceLog();
                }
                case 5: {
                    return sDF.format(this.iDate) + " WARNING: " + this.iMessage + this.getTraceLog();
                }
                case 6: {
                    return sDF.format(this.iDate) + " ERROR: " + this.iMessage + this.getTraceLog();
                }
                case 7: {
                    return sDF.format(this.iDate) + " >>>FATAL: " + this.iMessage + " <<<" + this.getTraceLog();
                }
            }
            return null;
        }

        public String toString() {
            return this.toString(0);
        }

        public String toHtmlString(int level, boolean includeDate) {
            if (this.iLevel < level) {
                return null;
            }
            switch (this.iLevel) {
                case 0: {
                    return (includeDate ? sDF.format(this.iDate) : "") + " &nbsp;&nbsp;&nbsp;&nbsp;-- " + this.iMessage + this.getHtmlTraceLog();
                }
                case 1: {
                    return (includeDate ? sDF.format(this.iDate) : "") + " &nbsp;&nbsp;-- " + this.iMessage + this.getHtmlTraceLog();
                }
                case 2: {
                    return (includeDate ? sDF.format(this.iDate) : "") + " " + this.iMessage + this.getHtmlTraceLog();
                }
                case 3: {
                    return (includeDate ? sDF.format(this.iDate) : "") + " " + this.iMessage + this.getHtmlTraceLog();
                }
                case 4: {
                    return "<br>" + (includeDate ? sDF.format(this.iDate) : "") + " <span style='font-weight:bold;'>" + this.iMessage + "</span>" + this.getHtmlTraceLog();
                }
                case 5: {
                    return (includeDate ? sDF.format(this.iDate) : "") + " <span style='color:orange;font-weight:bold;'>WARNING:</span> " + this.iMessage + this.getHtmlTraceLog();
                }
                case 6: {
                    return (includeDate ? sDF.format(this.iDate) : "") + " <span style='color:red;font-weight:bold;'>ERROR:</span> " + this.iMessage + this.getHtmlTraceLog();
                }
                case 7: {
                    return (includeDate ? sDF.format(this.iDate) : "") + " <span style='color:red;font-weight:bold;'>&gt;&gt;&gt;FATAL: " + this.iMessage + " &lt;&lt;&lt;</span>" + this.getHtmlTraceLog();
                }
            }
            return null;
        }

        public String toHtmlString(int level) {
            return this.toHtmlString(level, true);
        }

        public String toHtmlString(boolean includeDate) {
            return this.toHtmlString(0, includeDate);
        }

        public String toHtmlString() {
            return this.toHtmlString(0, true);
        }

        public void save(Element element) {
            element.addAttribute("level", String.valueOf(this.iLevel));
            element.addAttribute("msg", this.iMessage);
            element.addAttribute("date", String.valueOf(this.iDate.getTime()));
            if (this.iStakTrace != null) {
                for (int i = 0; i < this.iStakTrace.length; ++i) {
                    element.addElement("trace").setText(this.iStakTrace[i]);
                }
            }
        }
    }
}

