/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.report.CourseSection;
import org.cpsolver.studentsct.report.StudentSectioningReport;

public class TimeOverlapConflictTable
implements StudentSectioningReport {
    private static DecimalFormat sDF1 = new DecimalFormat("0.####");
    private static DecimalFormat sDF2 = new DecimalFormat("0.0000");
    private StudentSectioningModel iModel = null;
    private TimeOverlapsCounter iTOC = null;

    public TimeOverlapConflictTable(StudentSectioningModel model) {
        this.iModel = model;
        this.iTOC = model.getTimeOverlaps();
        if (this.iTOC == null) {
            this.iTOC = new TimeOverlapsCounter(null, model.getProperties());
        }
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, boolean includeLastLikeStudents, boolean includeRealStudents, boolean useAmPm) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"Total\nConflicts"), new CSVFile.CSVField((Object)"Class"), new CSVFile.CSVField((Object)"Meeting Time"), new CSVFile.CSVField((Object)"Time\nConflicts"), new CSVFile.CSVField((Object)"% of Total\nConflicts"), new CSVFile.CSVField((Object)"Conflicting\nClass"), new CSVFile.CSVField((Object)"Conflicting\nMeeting Time"), new CSVFile.CSVField((Object)"Overlap [min]"), new CSVFile.CSVField((Object)"Joined\nConflicts"), new CSVFile.CSVField((Object)"% of Total\nConflicts")});
        HashSet<TimeOverlapsCounter.Conflict> confs = new HashSet<TimeOverlapsCounter.Conflict>();
        for (Request r1 : this.getModel().variables()) {
            Enrollment e1 = (Enrollment)assignment.getValue((Variable)r1);
            if (e1 == null || r1 instanceof FreeTimeRequest) continue;
            for (Request r2 : r1.getStudent().getRequests()) {
                Enrollment e2 = (Enrollment)assignment.getValue((Variable)r2);
                if (r2 instanceof FreeTimeRequest) {
                    FreeTimeRequest ft = (FreeTimeRequest)r2;
                    confs.addAll(this.iTOC.conflicts(e1, ft.createEnrollment()));
                    continue;
                }
                if (e2 == null || r1.getId() >= r2.getId()) continue;
                confs.addAll(this.iTOC.conflicts(e1, e2));
            }
        }
        HashMap totals = new HashMap();
        HashMap<CourseSection, Map<Object, Object>> conflictingPairs = new HashMap<CourseSection, Map<Object, Object>>();
        HashMap sectionOverlaps = new HashMap();
        for (TimeOverlapsCounter.Conflict conflict : confs) {
            if (conflict.getStudent().isDummy() && !includeLastLikeStudents || !conflict.getStudent().isDummy() && !includeRealStudents || conflict.getR1() == null || conflict.getR1() instanceof FreeTimeRequest || conflict.getR2() == null || conflict.getR2() instanceof FreeTimeRequest) continue;
            Section s1 = (Section)conflict.getS1();
            Section s2 = (Section)conflict.getS2();
            Request r1 = conflict.getR1();
            Course c1 = ((Enrollment)assignment.getValue((Variable)conflict.getR1())).getCourse();
            Request r2 = conflict.getR2();
            Course c2 = ((Enrollment)assignment.getValue((Variable)conflict.getR2())).getCourse();
            CourseSection a = new CourseSection(c1, s1);
            CourseSection b = new CourseSection(c2, s2);
            Set<Long> students = (HashSet<Long>)totals.get((Object)c1);
            if (students == null) {
                students = new HashSet<Long>();
                totals.put(c1, students);
            }
            students.add(r1.getStudent().getId());
            students = (Set)totals.get((Object)c2);
            if (students == null) {
                students = new HashSet();
                totals.put(c2, students);
            }
            students.add(r2.getStudent().getId());
            Set<Long> total = (HashSet<Long>)sectionOverlaps.get(a);
            if (total == null) {
                total = new HashSet<Long>();
                sectionOverlaps.put(a, total);
            }
            total.add(r1.getStudent().getId());
            Map<CourseSection, Double> pair = (HashMap<CourseSection, Double>)conflictingPairs.get(a);
            if (pair == null) {
                pair = new HashMap<CourseSection, Double>();
                conflictingPairs.put(a, pair);
            }
            Double prev = (Double)pair.get(b);
            pair.put(b, r2.getWeight() + (prev == null ? 0.0 : prev));
            total = (Set)sectionOverlaps.get(b);
            if (total == null) {
                total = new HashSet();
                sectionOverlaps.put(b, total);
            }
            total.add(r2.getStudent().getId());
            pair = (Map)conflictingPairs.get(b);
            if (pair == null) {
                pair = new HashMap();
                conflictingPairs.put(b, pair);
            }
            prev = (Double)pair.get(a);
            pair.put(a, r1.getWeight() + (prev == null ? 0.0 : prev));
        }
        Comparator<Course> courseComparator = new Comparator<Course>(){

            @Override
            public int compare(Course a, Course b) {
                int cmp = a.getName().compareTo(b.getName());
                if (cmp != 0) {
                    return cmp;
                }
                return a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1);
            }
        };
        Comparator<Section> sectionComparator = new Comparator<Section>(){

            @Override
            public int compare(Section a, Section b) {
                int cmp = a.getSubpart().getConfig().getOffering().getName().compareTo(b.getSubpart().getConfig().getOffering().getName());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = a.getSubpart().getInstructionalType().compareTo(b.getSubpart().getInstructionalType());
                if (cmp != 0) {
                    return cmp;
                }
                return a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1);
            }
        };
        TreeSet<Course> courses = new TreeSet<Course>(courseComparator);
        courses.addAll(totals.keySet());
        for (Course course : courses) {
            Set total = (Set)totals.get((Object)course);
            TreeSet<Section> sections = new TreeSet<Section>(sectionComparator);
            for (Map.Entry entry : sectionOverlaps.entrySet()) {
                if (!course.equals((Object)((CourseSection)entry.getKey()).getCourse())) continue;
                sections.add(((CourseSection)entry.getKey()).getSection());
            }
            boolean firstCourse = true;
            for (Section section : sections) {
                Set sectionOverlap = (Set)sectionOverlaps.get(new CourseSection(course, section));
                Map pair = (Map)conflictingPairs.get(new CourseSection(course, section));
                boolean firstClass = true;
                for (CourseSection other : new TreeSet(pair.keySet())) {
                    ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                    line.add(new CSVFile.CSVField((Object)(firstCourse && firstClass ? course.getName() : "")));
                    line.add(new CSVFile.CSVField(firstCourse && firstClass ? Integer.valueOf(total.size()) : ""));
                    line.add(new CSVFile.CSVField((Object)(firstClass ? section.getSubpart().getName() + " " + section.getName(course.getId()) : "")));
                    line.add(new CSVFile.CSVField((Object)(firstClass ? (section.getTime() == null ? "" : section.getTime().getDayHeader() + " " + section.getTime().getStartTimeHeader(useAmPm) + " - " + section.getTime().getEndTimeHeader(useAmPm)) : "")));
                    line.add(new CSVFile.CSVField((Object)(firstClass && sectionOverlap != null ? String.valueOf(sectionOverlap.size()) : "")));
                    line.add(new CSVFile.CSVField((Object)(firstClass && sectionOverlap != null ? sDF2.format((double)sectionOverlap.size() / (double)total.size()) : "")));
                    line.add(new CSVFile.CSVField((Object)(other.getCourse().getName() + " " + other.getSection().getSubpart().getName() + " " + other.getSection().getName(other.getCourse().getId()))));
                    line.add(new CSVFile.CSVField((Object)(other.getSection().getTime().getDayHeader() + " " + other.getSection().getTime().getStartTimeHeader(useAmPm) + " - " + other.getSection().getTime().getEndTimeHeader(useAmPm))));
                    line.add(new CSVFile.CSVField((Object)sDF1.format(5 * this.iTOC.share(section, other.getSection()))));
                    line.add(new CSVFile.CSVField((Object)sDF1.format(pair.get(other))));
                    line.add(new CSVFile.CSVField((Object)sDF2.format((Double)pair.get(other) / (double)total.size())));
                    csv.addLine(line);
                    firstClass = false;
                }
                firstCourse = false;
            }
            csv.addLine();
        }
        return csv;
    }

    @Override
    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        return this.createTable(assignment, properties.getPropertyBoolean("lastlike", false), properties.getPropertyBoolean("real", true), properties.getPropertyBoolean("useAmPm", true));
    }
}

