/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.report.StudentSectioningReport;

public class RequestGroupTable
implements StudentSectioningReport {
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private StudentSectioningModel iModel;

    public RequestGroupTable(StudentSectioningModel model) {
        this.iModel = model;
    }

    @Override
    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        boolean useAmPm = properties.getPropertyBoolean("useAmPm", true);
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Group"), new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"Total\nSpread"), new CSVFile.CSVField((Object)"Group\nEnrollment"), new CSVFile.CSVField((Object)"Class"), new CSVFile.CSVField((Object)"Meeting Time"), new CSVFile.CSVField((Object)"Class\nSpread"), new CSVFile.CSVField((Object)"Class\nEnrollment"), new CSVFile.CSVField((Object)"Class\nLimit")});
        TreeSet<RequestGroup> groups = new TreeSet<RequestGroup>(new Comparator<RequestGroup>(){

            @Override
            public int compare(RequestGroup g1, RequestGroup g2) {
                int cmp = g1.getName().compareTo(g2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = g1.getCourse().getName().compareTo(g2.getCourse().getName());
                if (cmp != 0) {
                    return cmp;
                }
                if (g1.getId() < g2.getId()) {
                    return -1;
                }
                if (g1.getId() > g2.getId()) {
                    return 1;
                }
                return g1.getCourse().getId() < g2.getCourse().getId() ? -1 : (g1.getCourse().getId() > g2.getCourse().getId() ? 1 : 0);
            }
        });
        for (Offering offering : this.iModel.getOfferings()) {
            for (Course course : offering.getCourses()) {
                groups.addAll(course.getRequestGroups());
            }
        }
        for (RequestGroup group : groups) {
            double groupEnrollment = group.getEnrollmentWeight(assignment, null);
            double groupSpread = group.getAverageSpread(assignment);
            for (Config config : group.getCourse().getOffering().getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        double s = group.getSectionWeight(assignment, section, null);
                        if (!(s > 1.0E-5)) continue;
                        csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)group.getName()), new CSVFile.CSVField((Object)group.getCourse().getName()), new CSVFile.CSVField((Object)sDF.format(100.0 * groupSpread)), new CSVFile.CSVField(Math.round(groupEnrollment)), new CSVFile.CSVField((Object)(section.getSubpart().getName() + " " + section.getName(group.getCourse().getId()))), new CSVFile.CSVField((Object)(section.getTime() == null ? "" : section.getTime().getDayHeader() + " " + section.getTime().getStartTimeHeader(useAmPm) + " - " + section.getTime().getEndTimeHeader(useAmPm))), new CSVFile.CSVField((Object)sDF.format(100.0 * group.getSectionSpread(assignment, section))), new CSVFile.CSVField(Math.round(group.getSectionWeight(assignment, section, null))), new CSVFile.CSVField(section.getLimit())});
                    }
                }
            }
        }
        return csv;
    }
}

