/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.heuristics.selection.BacktrackSelection;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class StudentEnrollmentSwapSelection
implements NeighbourSelection<Request, Enrollment>,
InfoProvider<Request, Enrollment>,
SolverListener<Request, Enrollment> {
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    private Selection iSelection = null;
    protected LinkedList<Request> iRequests = null;
    protected long iNbrIterations = 0L;
    protected long iTotalTime = 0L;
    protected long iNbrTimeoutReached = 0L;
    protected long iNbrNoSolution = 0L;
    protected BacktrackSelection.RequestComparator iRequestComparator;

    public StudentEnrollmentSwapSelection(DataProperties properties) {
        this.iRequestComparator = new BacktrackSelection.RequestComparator(properties);
    }

    public void init(Solver<Request, Enrollment> solver, String name) {
        ArrayList variables = new ArrayList(solver.currentSolution().getModel().assignedVariables(solver.currentSolution().getAssignment()));
        Collections.shuffle(variables);
        Collections.sort(variables, this.iRequestComparator);
        this.iRequests = new LinkedList(variables);
        if (this.iSelection == null) {
            try {
                this.iSelection = new Selection(solver.getProperties());
                this.iSelection.init(solver);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Progress.getInstance((Object)solver.currentSolution().getModel()).setPhase(name, (long)variables.size());
        this.iNbrIterations = 0L;
        this.iNbrTimeoutReached = 0L;
        this.iNbrNoSolution = 0L;
        this.iTotalTime = 0L;
    }

    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Enrollment swaps...");
    }

    protected synchronized Request nextRequest() {
        return this.iRequests.poll();
    }

    public synchronized void addRequest(Request request) {
        if (this.iRequests != null && request != null && !request.getStudent().isDummy()) {
            if (request.getStudent().getPriority().ordinal() < Student.StudentPriority.Normal.ordinal() || request.getRequestPriority().ordinal() < Request.RequestPriority.Normal.ordinal()) {
                ListIterator<Request> i = this.iRequests.listIterator();
                while (i.hasNext()) {
                    Request r = (Request)((Object)i.next());
                    if (this.iRequestComparator.compare(r, request) <= 0) continue;
                    i.previous();
                    i.add(request);
                    return;
                }
            }
            this.iRequests.add(request);
        }
    }

    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Request request = null;
        while ((request = this.nextRequest()) != null) {
            Progress p = Progress.getInstance((Object)solution.getModel());
            p.incProgress();
            if ((double)p.getProgress() > 2.0 * (double)p.getProgressMax()) {
                return null;
            }
            if (!(request instanceof CourseRequest)) continue;
            try {
                Enrollment e = (Enrollment)request.getAssignment(solution.getAssignment());
                if (e != null && e.getPriority() <= 0 && ((CourseRequest)request).getSelectedChoices().isEmpty()) continue;
                Neighbour n = this.iSelection.selectNeighbour(solution, (Variable)request);
                if (this.iSelection.getContext() != null) {
                    ++this.iNbrIterations;
                    this.iTotalTime += this.iSelection.getContext().getTime();
                    if (this.iSelection.getContext().isTimeoutReached()) {
                        ++this.iNbrTimeoutReached;
                    }
                    if (n == null) {
                        ++this.iNbrNoSolution;
                    }
                }
                if (n == null || !(n.value(solution.getAssignment()) <= 0.0)) continue;
                return n;
            }
            catch (ConcurrentModificationException e) {
                this.addRequest(request);
            }
        }
        return null;
    }

    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info) {
        if (this.iNbrIterations > 0L) {
            info.put("Timing of " + this.getClass().getSimpleName(), sDF.format((double)this.iTotalTime / (double)this.iNbrIterations) + " ms/it (" + this.iNbrIterations + " iterations, " + (this.iNbrNoSolution == 0L ? "" : sDF.format(100.0 * (double)this.iNbrNoSolution / (double)this.iNbrIterations) + "% no solution, ") + sDF.format(100.0 * (double)this.iNbrTimeoutReached / (double)this.iNbrIterations) + "% time limit of " + sDF.format((double)this.iSelection.getTimeout() / 1000.0) + " seconds reached)");
        }
    }

    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info, Collection<Request> variables) {
    }

    public boolean variableSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable) {
        return false;
    }

    public boolean valueSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable, Enrollment value) {
        return false;
    }

    public boolean neighbourSelected(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        return false;
    }

    public void neighbourFailed(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        if (neighbour instanceof BacktrackNeighbourSelection.BackTrackNeighbour) {
            this.addRequest(((Enrollment)((Object)((BacktrackNeighbourSelection.BackTrackNeighbour)neighbour).getAssignments().get(0))).getRequest());
        }
    }

    class Selection
    extends BacktrackNeighbourSelection<Request, Enrollment> {
        private int iMaxValues;

        Selection(DataProperties properties) throws Exception {
            super(properties);
            this.iMaxValues = 1000;
            this.setTimeout(properties.getPropertyInt("Neighbour.EnrollmentSwapTimeout", 500));
            this.iMaxValues = properties.getPropertyInt("Neighbour.EnrollmentSwapMaxValues", this.iMaxValues);
        }

        protected Iterator<Enrollment> values(BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context, Request variable) {
            if (variable instanceof CourseRequest) {
                final CourseRequest request = (CourseRequest)variable;
                final StudentSectioningModel model = (StudentSectioningModel)context.getModel();
                final Assignment assignment = context.getAssignment();
                List<Enrollment> values = null;
                Enrollment current = (Enrollment)request.getAssignment(context.getAssignment());
                values = !request.getSelectedChoices().isEmpty() && current != null && current.getPriority() == 0 ? request.getSelectedEnrollments((Assignment<Request, Enrollment>)assignment, false) : (this.iMaxValues > 0 ? request.computeRandomEnrollments((Assignment<Request, Enrollment>)assignment, this.iMaxValues) : request.computeEnrollments((Assignment<Request, Enrollment>)assignment));
                Collections.sort(values, new Comparator<Enrollment>(){
                    private HashMap<Enrollment, Double> iValues = new HashMap();

                    private Double value(Enrollment e) {
                        Double value = this.iValues.get((Object)e);
                        if (value == null) {
                            value = model.getStudentQuality() != null ? Double.valueOf(model.getStudentWeights().getWeight((Assignment<Request, Enrollment>)assignment, e, model.getStudentQuality().conflicts(e))) : Double.valueOf(model.getStudentWeights().getWeight((Assignment<Request, Enrollment>)assignment, e, model.getDistanceConflict() == null ? null : model.getDistanceConflict().conflicts(e), model.getTimeOverlaps() == null ? null : model.getTimeOverlaps().conflicts(e)));
                            this.iValues.put(e, value);
                        }
                        return value;
                    }

                    @Override
                    public int compare(Enrollment e1, Enrollment e2) {
                        Double v2;
                        if (e1.equals(assignment.getValue((Variable)request))) {
                            return -1;
                        }
                        if (e2.equals(assignment.getValue((Variable)request))) {
                            return 1;
                        }
                        Double v1 = this.value(e1);
                        return v1.equals(v2 = this.value(e2)) ? e1.compareTo(assignment, e2) : v2.compareTo(v1);
                    }
                });
                return values.iterator();
            }
            return variable.computeEnrollments((Assignment<Request, Enrollment>)context.getAssignment()).iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void selectNeighbour(Solution<Request, Enrollment> solution, Request variable, BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context) {
            this.iContext = context;
            Lock lock = solution.getLock().writeLock();
            lock.lock();
            try {
                this.exploreEnrollmentSwaps(context, variable);
            }
            finally {
                lock.unlock();
            }
        }

        protected void exploreEnrollmentSwaps(BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context, Request variable) {
            Enrollment current = (Enrollment)context.getAssignment().getValue((Variable)variable);
            double currentValue = current == null ? 0.0 : current.toDouble((Assignment<Request, Enrollment>)context.getAssignment());
            Iterator<Enrollment> e = this.values(context, variable);
            while (this.canContinueEvaluation(context) && e.hasNext()) {
                Enrollment value = e.next();
                if (value.equals((Object)current) || current != null && currentValue <= value.toDouble((Assignment<Request, Enrollment>)context.getAssignment())) continue;
                if (context.isTimeoutReached() || context.isMaxItersReached()) break;
                context.incIteration();
                if (context.getModel().inConflict(context.getAssignment(), (Value)value)) {
                    for (Enrollment other : new ArrayList<Enrollment>(((Course.CourseContext)value.getCourse().getContext(context.getAssignment())).getEnrollments())) {
                        if (other.getStudent().equals(value.getStudent()) || !other.getSections().equals(value.getSections())) continue;
                        context.getAssignment().unassign(0L, other.variable());
                        if (!context.getModel().inConflict(context.getAssignment(), (Value)value)) {
                            if (current != null) {
                                context.getAssignment().unassign(0L, current.variable());
                            }
                            context.getAssignment().assign(0L, (Value)value);
                            Iterator<Enrollment> f = this.values(context, (Request)other.variable());
                            while (this.canContinueEvaluation(context) && f.hasNext()) {
                                Enrollment fix = f.next();
                                if (context.getModel().inConflict(context.getAssignment(), (Value)fix)) continue;
                                context.getAssignment().assign(0L, (Value)fix);
                                context.saveBest((Variable[])new Request[]{variable, (Request)other.variable()});
                                context.getAssignment().unassign(0L, fix.variable());
                            }
                            if (current == null) {
                                context.getAssignment().unassign(0L, (Variable)variable);
                            } else {
                                context.getAssignment().assign(0L, (Value)current);
                            }
                        }
                        context.getAssignment().assign(0L, (Value)other);
                    }
                    continue;
                }
                if (current != null) {
                    context.getAssignment().unassign(0L, current.variable());
                }
                context.getAssignment().assign(0L, (Value)value);
                context.saveBest((Variable[])new Request[]{variable});
                if (current == null) {
                    context.getAssignment().unassign(0L, (Variable)variable);
                    continue;
                }
                context.getAssignment().assign(0L, (Value)current);
            }
        }
    }
}

