/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.filter;

import java.util.HashSet;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.filter.StudentFilter;
import org.cpsolver.studentsct.model.Student;

public class RandomStudentFilter
implements StudentFilter {
    private double iProb = 1.0;
    private HashSet<Long> iAcceptedStudentIds = new HashSet();
    private HashSet<Long> iRejectedStudentIds = new HashSet();

    public RandomStudentFilter(double prob) {
        this.iProb = prob;
    }

    @Override
    public boolean accept(Student student) {
        boolean accept;
        Long studentId = new Long(student.getId());
        if (this.iAcceptedStudentIds.contains(studentId)) {
            return true;
        }
        if (this.iRejectedStudentIds.contains(studentId)) {
            return false;
        }
        boolean bl = accept = Math.random() < this.iProb;
        if (accept) {
            this.iAcceptedStudentIds.add(studentId);
        } else {
            this.iRejectedStudentIds.add(studentId);
        }
        return accept;
    }

    public void setProbability(double prob) {
        Long studentId;
        this.iProb = prob;
        int accept = (int)Math.round(prob * (double)(this.iAcceptedStudentIds.size() + this.iRejectedStudentIds.size()));
        while (this.iAcceptedStudentIds.size() < accept && !this.iRejectedStudentIds.isEmpty()) {
            studentId = (Long)ToolBox.random(this.iRejectedStudentIds);
            this.iRejectedStudentIds.remove(studentId);
            this.iAcceptedStudentIds.add(studentId);
        }
        while (this.iAcceptedStudentIds.size() > accept && !this.iAcceptedStudentIds.isEmpty()) {
            studentId = (Long)ToolBox.random(this.iAcceptedStudentIds);
            this.iRejectedStudentIds.add(studentId);
            this.iAcceptedStudentIds.remove(studentId);
        }
    }

    @Override
    public String getName() {
        return "Random";
    }
}

