/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;

public class RequiredSections
extends GlobalConstraint<Request, Enrollment> {
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        if (this.inConflict(assignment, enrollment)) {
            conflicts.add(enrollment);
        }
    }

    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        if (enrollment.getConfig() == null) {
            return false;
        }
        CourseRequest cr = (CourseRequest)enrollment.variable();
        for (Section section : enrollment.getSections()) {
            if (cr.isRequired(section)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "RequiredSections";
    }
}

