/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.heuristics;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.neighbours.ExamRandomMove;
import org.cpsolver.exam.neighbours.ExamRoomMove;
import org.cpsolver.exam.neighbours.ExamTimeMove;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.LazyNeighbour;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;

@Deprecated
public class ExamGreatDeluge
extends NeighbourSelectionWithContext<Exam, ExamPlacement, Context>
implements SolutionListener<Exam, ExamPlacement>,
LazyNeighbour.LazyNeighbourAcceptanceCriterion<Exam, ExamPlacement> {
    private static Logger sLog = LogManager.getLogger(ExamGreatDeluge.class);
    private static DecimalFormat sDF2 = new DecimalFormat("0.00");
    private static DecimalFormat sDF5 = new DecimalFormat("0.00000");
    private double iCoolRate = 0.99999995;
    private double iUpperBoundRate = 1.05;
    private double iLowerBoundRate = 0.95;
    private Progress iProgress = null;
    private List<NeighbourSelection<Exam, ExamPlacement>> iNeighbours = null;

    public ExamGreatDeluge(DataProperties properties) {
        this.iCoolRate = properties.getPropertyDouble("GreatDeluge.CoolRate", this.iCoolRate);
        this.iUpperBoundRate = properties.getPropertyDouble("GreatDeluge.UpperBoundRate", this.iUpperBoundRate);
        this.iLowerBoundRate = properties.getPropertyDouble("GreatDeluge.LowerBoundRate", this.iLowerBoundRate);
        String neighbours = properties.getProperty("GreatDeluge.Neighbours", ExamRandomMove.class.getName() + ";" + ExamRoomMove.class.getName() + ";" + ExamTimeMove.class.getName());
        neighbours = neighbours + ";" + properties.getProperty("GreatDeluge.AdditionalNeighbours", "");
        this.iNeighbours = new ArrayList<NeighbourSelection<Exam, ExamPlacement>>();
        for (String neighbour : neighbours.split("\\;")) {
            if (neighbour == null || neighbour.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName(neighbour);
                this.iNeighbours.add((NeighbourSelection<Exam, ExamPlacement>)clazz.getConstructor(DataProperties.class).newInstance(properties));
            }
            catch (Exception e) {
                sLog.error("Unable to use " + neighbour + ": " + e.getMessage());
            }
        }
    }

    public void init(Solver<Exam, ExamPlacement> solver) {
        super.init(solver);
        solver.currentSolution().addSolutionListener((SolutionListener)this);
        for (NeighbourSelection<Exam, ExamPlacement> neighbour : this.iNeighbours) {
            neighbour.init(solver);
        }
        solver.setUpdateProgress(false);
        this.iProgress = Progress.getInstance((Object)solver.currentSolution().getModel());
        ((Context)this.getContext(solver.currentSolution().getAssignment())).reset();
    }

    protected void info(Solution<Exam, ExamPlacement> solution) {
        Assignment assignment = solution.getAssignment();
        ((Context)this.getContext(assignment)).info(solution);
    }

    public Neighbour<Exam, ExamPlacement> genMove(Solution<Exam, ExamPlacement> solution) {
        NeighbourSelection<Exam, ExamPlacement> ns;
        Neighbour n;
        do {
            this.incIter(solution);
        } while ((n = (ns = this.iNeighbours.get(ToolBox.random((int)this.iNeighbours.size()))).selectNeighbour(solution)) == null);
        return n;
    }

    protected boolean accept(Solution<Exam, ExamPlacement> solution, Neighbour<Exam, ExamPlacement> neighbour) {
        if (neighbour instanceof LazyNeighbour) {
            ((LazyNeighbour)neighbour).setAcceptanceCriterion((LazyNeighbour.LazyNeighbourAcceptanceCriterion)this);
            return true;
        }
        Assignment assignment = solution.getAssignment();
        return neighbour.value(assignment) <= 0.0 || solution.getModel().getTotalValue(assignment) + neighbour.value(assignment) <= ((Context)this.getContext(assignment)).getBound();
    }

    public boolean accept(Assignment<Exam, ExamPlacement> assignment, LazyNeighbour<Exam, ExamPlacement> neighbour, double value) {
        return value <= 0.0 || neighbour.getModel().getTotalValue(assignment) <= ((Context)this.getContext(assignment)).getBound();
    }

    protected void incIter(Solution<Exam, ExamPlacement> solution) {
        ((Context)this.getContext(solution.getAssignment())).incIter(solution);
    }

    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        Neighbour<Exam, ExamPlacement> neighbour = null;
        while ((neighbour = this.genMove(solution)) != null) {
            ((Context)this.getContext(solution.getAssignment())).incMoves();
            if (!this.accept(solution, neighbour)) continue;
            ((Context)this.getContext(solution.getAssignment())).incAcceptedMoves();
            break;
        }
        return neighbour == null ? null : neighbour;
    }

    public void bestSaved(Solution<Exam, ExamPlacement> solution) {
        ((Context)this.getContext(solution.getAssignment())).bestSaved((Model<Exam, ExamPlacement>)solution.getModel());
    }

    public void solutionUpdated(Solution<Exam, ExamPlacement> solution) {
    }

    public void getInfo(Solution<Exam, ExamPlacement> solution, Map<String, String> info) {
    }

    public void getInfo(Solution<Exam, ExamPlacement> solution, Map<String, String> info, Collection<Exam> variables) {
    }

    public void bestCleared(Solution<Exam, ExamPlacement> solution) {
    }

    public void bestRestored(Solution<Exam, ExamPlacement> solution) {
    }

    public Context createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new Context();
    }

    public class Context
    implements AssignmentContext {
        private double iUpperBound;
        private int iMoves = 0;
        private int iAcceptedMoves = 0;
        private int iNrIdle = 0;
        private long iT0 = -1L;
        private long iIter = -1L;
        private double iBound = 0.0;
        private long iLastImprovingIter = 0L;
        private double iBestValue = 0.0;

        protected void reset() {
            this.iIter = -1L;
        }

        protected void incIter(Solution<Exam, ExamPlacement> solution) {
            double lowerBound;
            double best = solution.getModel().getBestValue();
            if (this.iIter < 0L) {
                this.iIter = 0L;
                this.iLastImprovingIter = 0L;
                this.iT0 = JProf.currentTimeMillis();
                this.iUpperBound = this.iBound = best > 0.0 ? ExamGreatDeluge.this.iUpperBoundRate * best : best / ExamGreatDeluge.this.iUpperBoundRate;
                this.iNrIdle = 0;
                solution.restoreBest();
                ExamGreatDeluge.this.iProgress.setPhase("Great deluge [" + (1 + this.iNrIdle) + "]...");
            } else {
                ++this.iIter;
                this.iBound = best >= 0.0 ? (this.iBound *= ExamGreatDeluge.this.iCoolRate) : (this.iBound /= ExamGreatDeluge.this.iCoolRate);
            }
            if (this.iIter % 1000L == 0L) {
                double d = best > 0.0 ? ExamGreatDeluge.this.iUpperBoundRate * best : best / ExamGreatDeluge.this.iUpperBoundRate;
                if (this.iBound > d) {
                    double d2 = this.iBound = best > 0.0 ? ExamGreatDeluge.this.iUpperBoundRate * best : best / ExamGreatDeluge.this.iUpperBoundRate;
                }
            }
            if (this.iIter % 100000L == 0L) {
                this.info(solution);
            }
            double d = lowerBound = best >= 0.0 ? Math.pow(ExamGreatDeluge.this.iLowerBoundRate, 1 + this.iNrIdle) * best : best / Math.pow(ExamGreatDeluge.this.iLowerBoundRate, 1 + this.iNrIdle);
            if (this.iBound < lowerBound) {
                ++this.iNrIdle;
                sLog.info(" -<[" + this.iNrIdle + "]>- ");
                this.iUpperBound = this.iBound = Math.max(best + 2.0, best >= 0.0 ? Math.pow(ExamGreatDeluge.this.iUpperBoundRate, this.iNrIdle) * best : best / Math.pow(ExamGreatDeluge.this.iUpperBoundRate, this.iNrIdle));
                ExamGreatDeluge.this.iProgress.setPhase("Great deluge [" + (1 + this.iNrIdle) + "]...");
                solution.restoreBest();
            }
            ExamGreatDeluge.this.iProgress.setProgress(100L - Math.round(100.0 * (this.iBound - lowerBound) / (this.iUpperBound - lowerBound)));
        }

        protected void info(Solution<Exam, ExamPlacement> solution) {
            sLog.info("Iter=" + this.iIter / 1000L + "k, NonImpIter=" + sDF2.format((double)(this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + sDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s");
            sLog.info("Bound is " + sDF2.format(this.iBound) + ", best value is " + sDF2.format(solution.getModel().getBestValue()) + " (" + sDF2.format(100.0 * this.iBound / solution.getModel().getBestValue()) + "%), current value is " + sDF2.format(solution.getModel().getTotalValue(solution.getAssignment())) + " (" + sDF2.format(100.0 * this.iBound / solution.getModel().getTotalValue(solution.getAssignment())) + "%), #idle=" + this.iNrIdle + ", Pacc=" + sDF5.format(100.0 * (double)this.iAcceptedMoves / (double)this.iMoves) + "%");
            this.iMoves = 0;
            this.iAcceptedMoves = 0;
        }

        protected void bestSaved(Model<Exam, ExamPlacement> model) {
            if (Math.abs(this.iBestValue - model.getBestValue()) >= 1.0) {
                this.iLastImprovingIter = this.iIter;
                this.iNrIdle = 0;
                this.iBestValue = model.getBestValue();
            }
        }

        public double getBound() {
            return this.iBound;
        }

        public void incMoves() {
            ++this.iMoves;
        }

        public void incAcceptedMoves() {
            ++this.iAcceptedMoves;
        }
    }
}

