/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.instructor.Test;
import org.cpsolver.instructor.constraints.SameInstructorConstraint;
import org.cpsolver.instructor.constraints.SameLinkConstraint;
import org.cpsolver.instructor.criteria.DifferentLecture;
import org.cpsolver.instructor.model.Attribute;
import org.cpsolver.instructor.model.Course;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.Preference;
import org.cpsolver.instructor.model.Section;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class MathTest
extends Test {
    private static Logger sLog = LogManager.getLogger(MathTest.class);

    public MathTest(DataProperties properties) {
        super(properties);
        this.removeCriterion(DifferentLecture.class);
    }

    public String getLevel(Instructor instructor) {
        for (Attribute attribute : instructor.getAttributes()) {
            if (!attribute.getType().getTypeName().equals("Level")) continue;
            return attribute.getAttributeName();
        }
        return null;
    }

    public String toString(Instructor instructor) {
        StringBuffer sb = new StringBuffer();
        sb.append(instructor.getExternalId());
        sb.append(",\"" + instructor.getAvailable() + "\"");
        Collections.sort(instructor.getCoursePreferences(), new Comparator<Preference<Course>>(){

            @Override
            public int compare(Preference<Course> p1, Preference<Course> p2) {
                if (p1.getPreference() == p2.getPreference()) {
                    return p1.getTarget().getCourseName().compareTo(p2.getTarget().getCourseName());
                }
                return p1.getPreference() < p2.getPreference() ? -1 : 1;
            }
        });
        for (int i = 0; i < 3; ++i) {
            Preference<Course> p = i < instructor.getCoursePreferences().size() ? instructor.getCoursePreferences().get(i) : null;
            sb.append("," + (p == null ? "" : p.getTarget().getCourseName()));
        }
        sb.append("," + (instructor.getPreference() == 0 ? "Yes" : "No"));
        sb.append("," + (instructor.isBackToBackPreferred() ? "1" : (instructor.isBackToBackDiscouraged() ? "-1" : "0")));
        sb.append("," + new DecimalFormat("0.0").format(instructor.getMaxLoad()));
        String level = this.getLevel(instructor);
        sb.append("," + (level == null ? "" : level));
        return sb.toString();
    }

    public String getLink(TeachingRequest.Variable request) {
        for (Constraint c : request.constraints()) {
            if (!(c instanceof SameLinkConstraint)) continue;
            return c.getName().substring(c.getName().indexOf(45) + 1);
        }
        return null;
    }

    public Long getAssignmentId(TeachingRequest.Variable request) {
        for (Constraint c : request.constraints()) {
            if (!(c instanceof SameInstructorConstraint) || ((SameInstructorConstraint)c).getConstraintId() == null) continue;
            return ((SameInstructorConstraint)c).getConstraintId();
        }
        return null;
    }

    public int countDiffLinks(Set<TeachingAssignment> assignments) {
        HashSet<String> links = new HashSet<String>();
        for (TeachingAssignment assignment : assignments) {
            String link = this.getLink((TeachingRequest.Variable)assignment.variable());
            if (link == null) continue;
            links.add(link);
        }
        return Math.max(0, links.size() - 1);
    }

    public String toString(TeachingRequest.Variable request) {
        StringBuffer sb = new StringBuffer();
        Long assId = this.getAssignmentId(request);
        sb.append(assId == null ? "" : assId);
        sb.append("," + request.getCourse().getCourseName());
        Section section = request.getSections().get(0);
        sb.append("," + section.getSectionName());
        sb.append("," + section.getTimeName(true));
        sb.append(",\"" + (section.hasRoom() ? section.getRoom() : "") + "\"");
        String link = this.getLink(request);
        sb.append("," + (link == null ? "" : link));
        HashMap<String, Integer> levels = new HashMap<String, Integer>();
        for (Preference<Attribute> p : request.getRequest().getAttributePreferences()) {
            levels.put(p.getTarget().getAttributeName(), -p.getPreference());
        }
        sb.append(",\"" + levels + "\"");
        sb.append("," + new DecimalFormat("0.0").format(request.getRequest().getLoad()));
        return sb.toString();
    }

    @Override
    protected boolean load(File dir, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        if (!dir.isDirectory()) {
            return super.load(dir, assignment);
        }
        try {
            String[] fields;
            List classes;
            String line = null;
            BufferedReader r = new BufferedReader(new FileReader(new File(dir, "courses.csv")));
            HashMap<Object, Course> courses = new HashMap<Object, Course>();
            HashMap<Long, ArrayList<TeachingRequest>> id2classes = new HashMap<Long, ArrayList<TeachingRequest>>();
            HashMap<String, ArrayList<TeachingRequest>> link2classes = new HashMap<String, ArrayList<TeachingRequest>>();
            long assId = 0L;
            long reqId = 0L;
            while ((line = r.readLine()) != null) {
                int idx;
                if (line.trim().isEmpty()) continue;
                String[] fields2 = line.split(",");
                Long l = Long.valueOf(fields2[0]);
                Object course = fields2[1];
                Object section = fields2[2];
                int dayCode = 0;
                block10: for (idx = 3; idx < fields2.length && (idx == 3 || ((String)fields2[idx]).length() == 1); ++idx) {
                    block11: for (int i = 0; i < ((String)fields2[idx]).length(); ++i) {
                        switch (((String)fields2[idx]).charAt(i)) {
                            case 'M': {
                                dayCode += Constants.DAY_CODES[0];
                                continue block11;
                            }
                            case 'T': {
                                dayCode += Constants.DAY_CODES[1];
                                continue block11;
                            }
                            case 'W': {
                                dayCode += Constants.DAY_CODES[2];
                                continue block11;
                            }
                            case 'R': {
                                dayCode += Constants.DAY_CODES[3];
                                continue block11;
                            }
                            case 'F': {
                                dayCode += Constants.DAY_CODES[4];
                                continue block11;
                            }
                            default: {
                                break block10;
                            }
                        }
                    }
                }
                int startSlot = 0;
                if (dayCode > 0) {
                    int time = Integer.parseInt((String)fields2[idx++]);
                    startSlot = 12 * (time / 100) + time % 100 / 5;
                }
                Object room = null;
                if (idx < fields2.length) {
                    room = fields2[idx++];
                }
                Iterator<TeachingRequest> link = null;
                if (idx < fields2.length) {
                    link = fields2[idx++];
                }
                int length = 12;
                if (idx < fields2.length) {
                    int time;
                    int endSlot;
                    if ((length = (endSlot = 12 * ((time = Integer.parseInt((String)fields2[idx++])) / 100) + time % 100 / 5) - startSlot) == 10) {
                        length = 12;
                    } else if (length == 15) {
                        length = 18;
                    }
                }
                ArrayList<Section> sections = new ArrayList<Section>();
                TimeLocation time = new TimeLocation(dayCode, startSlot, length, 0, 0.0, 0, null, "", null, length == 18 ? 15 : 10);
                sections.add(new Section(assId++, l.toString(), (String)section, (String)course + " " + (String)section + " " + time.getName(true) + (room == null ? "" : " " + (String)room), time, (String)room, false, false));
                Course c = (Course)courses.get(course);
                if (c == null) {
                    c = new Course(courses.size(), (String)course);
                    courses.put(course, c);
                }
                TeachingRequest clazz = new TeachingRequest(reqId++, 1, c, 0.0f, sections, Constants.sPreferenceLevelRequired, Constants.sPreferenceLevelNeutral);
                this.addRequest(clazz);
                ArrayList<TeachingRequest> classes2 = (ArrayList<TeachingRequest>)id2classes.get(l);
                if (classes2 == null) {
                    classes2 = new ArrayList<TeachingRequest>();
                    id2classes.put(l, classes2);
                }
                classes2.add(clazz);
                if (link == null || ((String)((Object)link)).isEmpty()) continue;
                ArrayList<TeachingRequest> linked = (ArrayList<TeachingRequest>)link2classes.get((String)course + "-" + link);
                if (linked == null) {
                    linked = new ArrayList<TeachingRequest>();
                    link2classes.put((String)course + "-" + link, linked);
                }
                linked.add(clazz);
            }
            for (Map.Entry entry : id2classes.entrySet()) {
                Long id = (Long)entry.getKey();
                classes = (List)entry.getValue();
                if (classes.size() <= 1) continue;
                SameInstructorConstraint sa = new SameInstructorConstraint(id, "A" + id.toString(), "R");
                for (TeachingRequest c : classes) {
                    sa.addVariable(c.getVariables()[0]);
                }
                this.addConstraint(sa);
            }
            for (Map.Entry entry : link2classes.entrySet()) {
                String link = (String)entry.getKey();
                classes = (List)entry.getValue();
                if (classes.size() <= 1) continue;
                SameLinkConstraint sa = new SameLinkConstraint(null, link, "-1");
                for (TeachingRequest c : classes) {
                    sa.addVariable(c.getVariables()[0]);
                }
                this.addConstraint(sa);
            }
            Attribute.Type level = new Attribute.Type(0L, "Level", false, true);
            this.addAttributeType(level);
            HashMap<Object, Attribute> hashMap = new HashMap<Object, Attribute>();
            r.close();
            r = new BufferedReader(new FileReader(new File(dir, "level_codes.csv")));
            String[] codes = r.readLine().split(",");
            while ((line = r.readLine()) != null) {
                Attribute attribute;
                if (line.trim().isEmpty()) continue;
                fields = line.split(",");
                String code = fields[0];
                if (code.startsWith("\"") && code.endsWith("\"")) {
                    code = code.substring(1, code.length() - 1);
                }
                if ((attribute = (Attribute)hashMap.get(code)) == null) {
                    attribute = new Attribute(hashMap.size(), code, level);
                    hashMap.put(code, attribute);
                }
                for (int i = 1; i < codes.length; ++i) {
                    int pref = Integer.parseInt(fields[i]);
                    if (pref <= 0) continue;
                    for (TeachingRequest clazz : this.getRequests()) {
                        if (!clazz.getCourse().getCourseName().contains(codes[i])) continue;
                        clazz.addAttributePreference(new Preference<Attribute>(attribute, -pref));
                    }
                }
            }
            r = new BufferedReader(new FileReader(new File(dir, "hours_per_course.csv")));
            while ((line = r.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                fields = line.split(",");
                for (TeachingRequest clazz : this.getRequests()) {
                    if (!clazz.getCourse().getCourseName().contains(fields[0])) continue;
                    clazz.setLoad(Float.parseFloat(fields[1]));
                }
            }
            String defaultCode = this.getProperties().getProperty("TA.DefaultLevelCode", "XXX");
            Attribute defaultAttribute = (Attribute)hashMap.get(defaultCode);
            if (defaultAttribute == null) {
                defaultAttribute = new Attribute(hashMap.size(), defaultCode, level);
                hashMap.put(defaultCode, defaultAttribute);
            }
            for (TeachingRequest.Variable clazz : this.variables()) {
                sLog.info("Added class " + this.toString(clazz));
                if (clazz.getRequest().getAttributePreferences().isEmpty()) {
                    sLog.error("No level: " + this.toString(clazz));
                    clazz.getRequest().addAttributePreference(new Preference<Attribute>(defaultAttribute, -1));
                }
                if ((double)clazz.getRequest().getLoad() != 0.0) continue;
                sLog.error("No load: " + this.toString(clazz));
                clazz.getRequest().setLoad(this.getProperties().getPropertyFloat("TA.DefaultLoad", 10.0f));
            }
            r = new BufferedReader(new FileReader(new File(dir, "students.csv")));
            HashSet<Object> studentIds = new HashSet<Object>();
            double studentMaxLoad = 0.0;
            while ((line = r.readLine()) != null) {
                float maxLoad;
                Object id;
                String[] fields3;
                if (line.trim().isEmpty() || "puid".equals((fields3 = line.split(","))[0])) continue;
                int idx = 0;
                if (!studentIds.add(id = fields3[idx++])) {
                    sLog.error("Student " + (String)id + " is two or more times in the file.");
                }
                boolean[] av = new boolean[50];
                for (int i = 0; i < 50; ++i) {
                    av[i] = "1".equals(fields3[idx++]);
                }
                ArrayList<String> prefs = new ArrayList<String>();
                for (int i = 0; i < 3; ++i) {
                    String p;
                    if ((p = fields3[idx++].replace("Large lecture", "LEC").replace("Lecture", "LEC").replace("Recitation", "REC")).startsWith("MA ")) {
                        p = p.substring(3);
                    }
                    if ("I have no preference".equals(p)) continue;
                    prefs.add(p);
                }
                boolean grad = "Yes".equals(fields3[idx++]);
                int b2b = Integer.parseInt(fields3[idx++]);
                if ((maxLoad = Float.parseFloat(fields3[idx++])) == 0.0f) {
                    maxLoad = this.getProperties().getPropertyFloat("TA.DefaultMaxLoad", 20.0f);
                }
                Iterator<Preference<Attribute>> code = idx < fields3.length ? fields3[idx++] : null;
                Instructor instructor = new Instructor(Long.valueOf(((String)id).replace("-", "")), (String)id, null, grad ? Constants.sPreferenceLevelNeutral : Constants.sPreferenceLevelDiscouraged, maxLoad);
                for (int i = 0; i < prefs.size(); ++i) {
                    Course c;
                    String pref = (String)prefs.get(i);
                    if (pref.indexOf(32) > 0) {
                        pref = pref.substring(0, pref.indexOf(32));
                    }
                    if ((c = (Course)courses.get(pref)) == null) {
                        c = new Course(courses.size(), pref);
                        courses.put(pref, c);
                    }
                    instructor.addCoursePreference(new Preference<Course>(c, i == 0 ? -10 : (i == 1 ? -8 : -5)));
                }
                if (code != null) {
                    Attribute attribute = (Attribute)hashMap.get(code);
                    if (attribute == null) {
                        attribute = new Attribute(hashMap.size(), (String)((Object)code), level);
                        hashMap.put(code, attribute);
                    }
                    instructor.addAttribute(attribute);
                }
                if (b2b == 1) {
                    instructor.setBackToBackPreference(Constants.sPreferenceLevelPreferred);
                } else if (b2b == -1) {
                    instructor.setBackToBackPreference(Constants.sPreferenceLevelDiscouraged);
                }
                for (int d = 0; d < 5; ++d) {
                    int f = -1;
                    for (int t = 0; t < 10; ++t) {
                        if (!av[10 * d + t]) {
                            if (f >= 0) continue;
                            f = t;
                            continue;
                        }
                        if (f < 0) continue;
                        instructor.addTimePreference(new Preference<TimeLocation>(new TimeLocation(Constants.DAY_CODES[d], 90 + 12 * f, (t - f) * 12, 0, 0.0, null, "", null, 0), Constants.sPreferenceLevelProhibited));
                        f = -1;
                    }
                    if (f < 0) continue;
                    instructor.addTimePreference(new Preference<TimeLocation>(new TimeLocation(Constants.DAY_CODES[d], 90 + 12 * f, (10 - f) * 12, 0, 0.0, null, "", null, 0), Constants.sPreferenceLevelProhibited));
                    f = -1;
                }
                if (instructor.getMaxLoad() > 0.0f) {
                    this.addInstructor(instructor);
                    sLog.info("Added student " + this.toString(instructor));
                    int nrClasses = 0;
                    for (TeachingRequest.Variable req : this.variables()) {
                        if (!instructor.canTeach(req.getRequest()) || req.getRequest().getAttributePreference(instructor).isProhibited()) continue;
                        sLog.info("  -- " + this.toString(req) + "," + -req.getRequest().getAttributePreference(instructor).getPreferenceInt() + "," + -instructor.getCoursePreference(req.getCourse()).getPreference());
                        ++nrClasses;
                    }
                    if (nrClasses == 0) {
                        sLog.info("  -- no courses available");
                    }
                    studentMaxLoad += (double)instructor.getMaxLoad();
                    continue;
                }
                sLog.info("Ignoring student " + instructor);
                if (instructor.getMaxLoad() == 0.0f) {
                    sLog.info("  -- zero max load");
                    continue;
                }
                sLog.info("  -- no courses available");
            }
            r.close();
            double totalLoad = 0.0;
            for (Object clazz : this.variables()) {
                if (((TeachingRequest.Variable)clazz).values(this.getEmptyAssignment()).isEmpty()) {
                    sLog.error("No values: " + this.toString((TeachingRequest.Variable)clazz));
                }
                totalLoad += (double)((TeachingRequest.Variable)clazz).getRequest().getLoad();
            }
            HashMap<String, Double> studentLevel2load = new HashMap<String, Double>();
            for (Instructor instructor : this.getInstructors()) {
                Set<Attribute> levels = instructor.getAttributes(level);
                String studentLevel = levels.isEmpty() ? "null" : levels.iterator().next().getAttributeName();
                Double load = (Double)studentLevel2load.get(studentLevel);
                studentLevel2load.put(studentLevel, (double)instructor.getMaxLoad() + (load == null ? 0.0 : load));
            }
            sLog.info("Student max loads: (total: " + sDoubleFormat.format(studentMaxLoad) + ")");
            for (String studentLevel : new TreeSet(studentLevel2load.keySet())) {
                Double load = (Double)studentLevel2load.get(studentLevel);
                sLog.info("  " + studentLevel + ": " + sDoubleFormat.format(load));
            }
            HashMap<String, Double> clazzLevel2load = new HashMap<String, Double>();
            for (TeachingRequest.Variable clazz : this.variables()) {
                String classLevel = null;
                TreeSet<String> levels = new TreeSet<String>();
                for (Preference<Attribute> ap : clazz.getRequest().getAttributePreferences()) {
                    levels.add(ap.getTarget().getAttributeName());
                }
                for (String l : levels) {
                    classLevel = (classLevel == null ? "" : classLevel + ",") + l;
                }
                if (classLevel == null) {
                    classLevel = "null";
                }
                if (clazz.getId() < 0L) {
                    classLevel = clazz.getName();
                }
                Double load = (Double)clazzLevel2load.get(classLevel);
                clazzLevel2load.put(classLevel, (double)clazz.getRequest().getLoad() + (load == null ? 0.0 : load));
            }
            sLog.info("Class loads: (total: " + sDoubleFormat.format(totalLoad) + ")");
            for (String classLevel : new TreeSet(clazzLevel2load.keySet())) {
                Double load = (Double)clazzLevel2load.get(classLevel);
                sLog.info("  " + level + ": " + sDoubleFormat.format(load));
            }
            return true;
        }
        catch (IOException e) {
            sLog.error("Failed to load the problem: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    protected void generateReports(File dir, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) throws IOException {
        PrintWriter out = new PrintWriter(new File(dir, "solution-assignments.csv"));
        out.println("Assignment Id,Course,Section,Time,Room,Link,Level,Load,Student,Availability,1st Preference,2nd Preference,3rd Preference,Graduate,Back-To-Back,Max Load,Level,Level,Preference");
        for (TeachingRequest.Variable variable : this.variables()) {
            Long assId = this.getAssignmentId(variable);
            out.print(assId == null ? "" : assId);
            out.print("," + variable.getCourse().getCourseName());
            Section section = variable.getSections().get(0);
            out.print("," + section.getSectionType());
            out.print("," + section.getTimeName(true));
            out.print(",\"" + (section.hasRoom() ? section.getRoom() : "") + "\"");
            String link = this.getLink(variable);
            out.print("," + (link == null ? "" : link));
            HashMap<String, Integer> levels = new HashMap<String, Integer>();
            for (Preference<Attribute> p : variable.getRequest().getAttributePreferences()) {
                if (!p.getTarget().getType().getTypeName().equals("Level")) continue;
                levels.put(p.getTarget().getAttributeName(), -p.getPreference());
            }
            out.print(",\"" + levels + "\"");
            out.print("," + new DecimalFormat("0.0").format(variable.getRequest().getLoad()));
            TeachingAssignment value = assignment.getValue(variable);
            if (value != null) {
                out.print("," + this.toString(value.getInstructor()));
                out.print("," + -value.getAttributePreference());
                out.print("," + (value.getCoursePreference() == -10 ? "1" : (value.getCoursePreference() == -8 ? "2" : (value.getCoursePreference() == -5 ? "3" : Integer.valueOf(value.getCoursePreference())))));
            }
            out.println();
        }
        out.flush();
        out.close();
        out = new PrintWriter(new File(dir, "solution-students.csv"));
        out.println("Student,Availability,1st Preference,2nd Preference,3rd Preference,Graduate,Back-To-Back,Max Load,Level,Assigned Load,Avg Level,Avg Preference,Back-To-Back,Diff Links,1st Assignment,2nd Assignment, 3rd Assignment");
        for (Instructor instructor : this.getInstructors()) {
            out.print(instructor.getExternalId());
            out.print(",\"" + instructor.getAvailable() + "\"");
            for (int i = 0; i < 3; ++i) {
                Preference<Course> p = i < instructor.getCoursePreferences().size() ? instructor.getCoursePreferences().get(i) : null;
                out.print("," + (p == null ? "" : p.getTarget().getCourseName()));
            }
            out.print("," + (instructor.getPreference() == 0 ? "Yes" : "No"));
            out.print("," + (instructor.isBackToBackPreferred() ? "1" : (instructor.isBackToBackDiscouraged() ? "-1" : "0")));
            out.print("," + new DecimalFormat("0.0").format(instructor.getMaxLoad()));
            String level = this.getLevel(instructor);
            out.print("," + (level == null ? "" : level));
            Instructor.Context context = (Instructor.Context)instructor.getContext(assignment);
            out.print("," + new DecimalFormat("0.0").format(context.getLoad()));
            double att = 0.0;
            double pref = 0.0;
            for (TeachingAssignment ta : context.getAssignments()) {
                att += (double)Math.abs(ta.getAttributePreference());
                pref += (double)(ta.getCoursePreference() == -10 ? 1 : (ta.getCoursePreference() == -8 ? 2 : (ta.getCoursePreference() == -5 ? 3 : ta.getCoursePreference())));
            }
            int diffLinks = this.countDiffLinks(context.getAssignments());
            out.print("," + (context.getAssignments().isEmpty() ? "" : new DecimalFormat("0.0").format(att / (double)context.getAssignments().size())));
            out.print("," + (context.getAssignments().isEmpty() || pref == 0.0 ? "" : new DecimalFormat("0.0").format(pref / (double)context.getAssignments().size())));
            out.print("," + new DecimalFormat("0.0").format(100.0 * context.countBackToBackPercentage()));
            out.print("," + (diffLinks <= 0 ? "" : Integer.valueOf(diffLinks)));
            for (TeachingAssignment ta : context.getAssignments()) {
                String link = this.getLink((TeachingRequest.Variable)ta.variable());
                out.print("," + ((TeachingRequest.Variable)ta.variable()).getCourse() + " " + ((TeachingRequest.Variable)ta.variable()).getSections().get(0).getSectionType() + " " + ((TeachingRequest.Variable)ta.variable()).getSections().get(0).getTime().getName(true) + (link == null ? "" : " " + link));
            }
            out.println();
        }
        out.flush();
        out.close();
        out = new PrintWriter(new File(dir, "input-courses.csv"));
        TreeSet<String> levels = new TreeSet<String>();
        for (TeachingRequest.Variable request : this.variables()) {
            for (Preference<Attribute> p : request.getRequest().getAttributePreferences()) {
                levels.add(p.getTarget().getAttributeName());
            }
        }
        out.print("Course,Type,Load");
        for (String level : levels) {
            out.print("," + level);
        }
        out.println();
        HashSet<String> hashSet = new HashSet<String>();
        for (TeachingRequest.Variable request : this.variables()) {
            if (!hashSet.add(request.getCourse() + "," + request.getSections().get(0).getSectionType())) continue;
            out.print(request.getCourse().getCourseName() + "," + request.getSections().get(0).getSectionType() + "," + request.getRequest().getLoad());
            for (String level : levels) {
                int pref = 0;
                for (Preference<Attribute> p : request.getRequest().getAttributePreferences()) {
                    if (!p.getTarget().getAttributeName().equals(level)) continue;
                    pref = p.getPreference();
                }
                out.print("," + (pref == 0 ? "" : Integer.valueOf(-pref)));
            }
            out.println();
        }
        out.flush();
        out.close();
    }

    public static void main(String[] args) throws Exception {
        DataProperties config = new DataProperties();
        config.load(MathTest.class.getClass().getResourceAsStream("/org/cpsolver/instructor/test/math.properties"));
        config.putAll((Map<?, ?>)System.getProperties());
        ToolBox.configureLogging();
        new MathTest(config).execute();
    }
}

