/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.ClassLimitConstraint;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.criteria.BackToBackInstructorPreferences;
import org.cpsolver.coursett.criteria.BrokenTimePatterns;
import org.cpsolver.coursett.criteria.DepartmentBalancingPenalty;
import org.cpsolver.coursett.criteria.DistributionPreferences;
import org.cpsolver.coursett.criteria.FlexibleConstraintCriterion;
import org.cpsolver.coursett.criteria.Perturbations;
import org.cpsolver.coursett.criteria.RoomPreferences;
import org.cpsolver.coursett.criteria.RoomViolations;
import org.cpsolver.coursett.criteria.SameSubpartBalancingPenalty;
import org.cpsolver.coursett.criteria.StudentCommittedConflict;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.StudentDistanceConflict;
import org.cpsolver.coursett.criteria.StudentHardConflict;
import org.cpsolver.coursett.criteria.StudentOverlapConflict;
import org.cpsolver.coursett.criteria.StudentWorkdayConflict;
import org.cpsolver.coursett.criteria.TimePreferences;
import org.cpsolver.coursett.criteria.TimeViolations;
import org.cpsolver.coursett.criteria.TooBigRooms;
import org.cpsolver.coursett.criteria.UselessHalfHours;
import org.cpsolver.coursett.criteria.additional.InstructorConflict;
import org.cpsolver.coursett.criteria.placement.DeltaTimePreference;
import org.cpsolver.coursett.criteria.placement.HardConflicts;
import org.cpsolver.coursett.criteria.placement.PotentialHardConflicts;
import org.cpsolver.coursett.criteria.placement.WeightedHardConflicts;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.DefaultStudentSectioning;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.OnFlySectioning;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.StudentSectioning;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.constant.ConstantModel;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;

public class TimetableModel
extends ConstantModel<Lecture, Placement> {
    private static Logger sLogger = LogManager.getLogger(TimetableModel.class);
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private List<InstructorConstraint> iInstructorConstraints = new ArrayList<InstructorConstraint>();
    private List<JenrlConstraint> iJenrlConstraints = new ArrayList<JenrlConstraint>();
    private List<RoomConstraint> iRoomConstraints = new ArrayList<RoomConstraint>();
    private List<DepartmentSpreadConstraint> iDepartmentSpreadConstraints = new ArrayList<DepartmentSpreadConstraint>();
    private List<SpreadConstraint> iSpreadConstraints = new ArrayList<SpreadConstraint>();
    private List<GroupConstraint> iGroupConstraints = new ArrayList<GroupConstraint>();
    private List<ClassLimitConstraint> iClassLimitConstraints = new ArrayList<ClassLimitConstraint>();
    private List<FlexibleConstraint> iFlexibleConstraints = new ArrayList<FlexibleConstraint>();
    private DataProperties iProperties = null;
    private int iYear = -1;
    private List<BitSet> iWeeks = null;
    private boolean iOnFlySectioning = false;
    private int iStudentWorkDayLimit = -1;
    private boolean iAllowBreakHard = false;
    private HashSet<Student> iAllStudents = new HashSet();
    private DistanceMetric iDistanceMetric = null;
    private StudentSectioning iStudentSectioning = null;
    private List<StudentGroup> iStudentGroups = new ArrayList<StudentGroup>();
    Map<Student, Set<Lecture>> iBestEnrollment = null;

    public TimetableModel(DataProperties properties) {
        this.iProperties = properties;
        this.iDistanceMetric = new DistanceMetric(properties);
        if (properties.getPropertyBoolean("OnFlySectioning.Enabled", false)) {
            this.addModelListener(new OnFlySectioning(this));
            this.iOnFlySectioning = true;
        }
        this.iStudentWorkDayLimit = properties.getPropertyInt("StudentConflict.WorkDayLimit", -1);
        this.iAllowBreakHard = properties.getPropertyBoolean("General.AllowBreakHard", false);
        String criteria = properties.getProperty("General.Criteria", StudentConflict.class.getName() + ";" + StudentDistanceConflict.class.getName() + ";" + StudentHardConflict.class.getName() + ";" + StudentCommittedConflict.class.getName() + ";" + StudentOverlapConflict.class.getName() + ";" + UselessHalfHours.class.getName() + ";" + BrokenTimePatterns.class.getName() + ";" + TooBigRooms.class.getName() + ";" + TimePreferences.class.getName() + ";" + RoomPreferences.class.getName() + ";" + DistributionPreferences.class.getName() + ";" + SameSubpartBalancingPenalty.class.getName() + ";" + DepartmentBalancingPenalty.class.getName() + ";" + BackToBackInstructorPreferences.class.getName() + ";" + Perturbations.class.getName() + ";" + DeltaTimePreference.class.getName() + ";" + HardConflicts.class.getName() + ";" + PotentialHardConflicts.class.getName() + ";" + FlexibleConstraintCriterion.class.getName() + ";" + WeightedHardConflicts.class.getName());
        if (this.iStudentWorkDayLimit > 0) {
            criteria = criteria + ";" + StudentWorkdayConflict.class.getName();
        }
        if (properties.getPropertyBoolean("General.InteractiveMode", false)) {
            criteria = criteria + ";" + TimeViolations.class.getName() + ";" + RoomViolations.class.getName();
        } else if (properties.getPropertyBoolean("General.AllowProhibitedRooms", false)) {
            criteria = criteria + ";" + RoomViolations.class.getName();
            this.iAllowBreakHard = true;
        }
        criteria = criteria + ";" + properties.getProperty("General.AdditionalCriteria", "");
        for (String criterion : criteria.split("\\;")) {
            if (criterion == null || criterion.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName(criterion);
                Criterion c = (Criterion)clazz.newInstance();
                c.configure(properties);
                this.addCriterion(c);
            }
            catch (Exception e) {
                sLogger.error("Unable to use " + criterion + ": " + e.getMessage());
            }
        }
        if (properties.getPropertyBoolean("General.SoftInstructorConstraints", false)) {
            InstructorConflict ic = new InstructorConflict();
            ic.configure(properties);
            this.addCriterion((Criterion)ic);
        }
        try {
            String studentSectioningClassName = properties.getProperty("StudentSectioning.Class", DefaultStudentSectioning.class.getName());
            Class<?> studentSectioningClass = Class.forName(studentSectioningClassName);
            this.iStudentSectioning = (StudentSectioning)studentSectioningClass.getConstructor(TimetableModel.class).newInstance(new Object[]{this});
        }
        catch (Exception e) {
            sLogger.error("Failed to load custom student sectioning class: " + e.getMessage());
            this.iStudentSectioning = new DefaultStudentSectioning(this);
        }
        if (this.iStudentSectioning instanceof InfoProvider) {
            this.getInfoProviders().add((InfoProvider)this.iStudentSectioning);
        }
    }

    public DistanceMetric getDistanceMetric() {
        return this.iDistanceMetric;
    }

    public int getStudentWorkDayLimit() {
        return this.iStudentWorkDayLimit;
    }

    public StudentSectioning getStudentSectioning() {
        return this.iStudentSectioning;
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    public void switchStudents(Assignment<Lecture, Placement> assignment, TerminationCondition<Lecture, Placement> termination) {
        this.getStudentSectioning().switchStudents((Solution<Lecture, Placement>)new Solution((Model)this, assignment), termination);
    }

    public void switchStudents(Assignment<Lecture, Placement> assignment) {
        this.getStudentSectioning().switchStudents((Solution<Lecture, Placement>)new Solution((Model)this, assignment), null);
    }

    public Map<String, String> getBounds(Assignment<Lecture, Placement> assignment) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Room preferences min", "" + this.getCriterion(RoomPreferences.class).getBounds(assignment)[0]);
        ret.put("Room preferences max", "" + this.getCriterion(RoomPreferences.class).getBounds(assignment)[1]);
        ret.put("Time preferences min", "" + this.getCriterion(TimePreferences.class).getBounds(assignment)[0]);
        ret.put("Time preferences max", "" + this.getCriterion(TimePreferences.class).getBounds(assignment)[1]);
        ret.put("Distribution preferences min", "" + this.getCriterion(DistributionPreferences.class).getBounds(assignment)[0]);
        ret.put("Distribution preferences max", "" + this.getCriterion(DistributionPreferences.class).getBounds(assignment)[1]);
        if (this.getProperties().getPropertyBoolean("General.UseDistanceConstraints", false)) {
            ret.put("Back-to-back instructor preferences max", "" + this.getCriterion(BackToBackInstructorPreferences.class).getBounds(assignment)[1]);
        }
        ret.put("Too big rooms max", "" + this.getCriterion(TooBigRooms.class).getBounds(assignment)[0]);
        ret.put("Useless half-hours", "" + this.getCriterion(UselessHalfHours.class).getBounds(assignment)[0]);
        return ret;
    }

    public Map<String, String> getInfo(Assignment<Lecture, Placement> assignment) {
        Map ret = super.getInfo(assignment);
        ret.put("Memory usage", TimetableModel.getMem());
        Criterion rp = this.getCriterion(RoomPreferences.class);
        Criterion rv = this.getCriterion(RoomViolations.class);
        ret.put("Room preferences", this.getPerc(rp.getValue(assignment), rp.getBounds(assignment)[0], rp.getBounds(assignment)[1]) + "% (" + Math.round(rp.getValue(assignment)) + ")" + (rv != null && rv.getValue(assignment) >= 0.5 ? " [hard:" + Math.round(rv.getValue(assignment)) + "]" : ""));
        Criterion tp = this.getCriterion(TimePreferences.class);
        Criterion tv = this.getCriterion(TimeViolations.class);
        ret.put("Time preferences", this.getPerc(tp.getValue(assignment), tp.getBounds(assignment)[0], tp.getBounds(assignment)[1]) + "% (" + sDoubleFormat.format(tp.getValue(assignment)) + ")" + (tv != null && tv.getValue(assignment) >= 0.5 ? " [hard:" + Math.round(tv.getValue(assignment)) + "]" : ""));
        Criterion dp = this.getCriterion(DistributionPreferences.class);
        ret.put("Distribution preferences", this.getPerc(dp.getValue(assignment), dp.getBounds(assignment)[0], dp.getBounds(assignment)[1]) + "% (" + sDoubleFormat.format(dp.getValue(assignment)) + ")");
        Criterion sc = this.getCriterion(StudentConflict.class);
        Criterion shc = this.getCriterion(StudentHardConflict.class);
        Criterion sdc = this.getCriterion(StudentDistanceConflict.class);
        Criterion scc = this.getCriterion(StudentCommittedConflict.class);
        ret.put("Student conflicts", Math.round(scc.getValue(assignment) + sc.getValue(assignment)) + " [committed:" + Math.round(scc.getValue(assignment)) + ", distance:" + Math.round(sdc.getValue(assignment)) + ", hard:" + Math.round(shc.getValue(assignment)) + "]");
        if (!this.getSpreadConstraints().isEmpty()) {
            Criterion ip = this.getCriterion(BackToBackInstructorPreferences.class);
            ret.put("Back-to-back instructor preferences", this.getPerc(ip.getValue(assignment), ip.getBounds(assignment)[0], ip.getBounds(assignment)[1]) + "% (" + Math.round(ip.getValue(assignment)) + ")");
        }
        if (!this.getDepartmentSpreadConstraints().isEmpty()) {
            Criterion dbp = this.getCriterion(DepartmentBalancingPenalty.class);
            ret.put("Department balancing penalty", sDoubleFormat.format(dbp.getValue(assignment)));
        }
        Criterion sbp = this.getCriterion(SameSubpartBalancingPenalty.class);
        ret.put("Same subpart balancing penalty", sDoubleFormat.format(sbp.getValue(assignment)));
        Criterion tbr = this.getCriterion(TooBigRooms.class);
        ret.put("Too big rooms", this.getPercRev(tbr.getValue(assignment), tbr.getBounds(assignment)[1], tbr.getBounds(assignment)[0]) + "% (" + Math.round(tbr.getValue(assignment)) + ")");
        Criterion uh = this.getCriterion(UselessHalfHours.class);
        Criterion bt = this.getCriterion(BrokenTimePatterns.class);
        ret.put("Useless half-hours", this.getPercRev(uh.getValue(assignment) + bt.getValue(assignment), 0.0, (double)Constants.sPreferenceLevelStronglyDiscouraged * bt.getBounds(assignment)[0]) + "% (" + Math.round(uh.getValue(assignment)) + " + " + Math.round(bt.getValue(assignment)) + ")");
        return ret;
    }

    public Map<String, String> getInfo(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        Map ret = super.getInfo(assignment, variables);
        ret.put("Memory usage", TimetableModel.getMem());
        Criterion rp = this.getCriterion(RoomPreferences.class);
        ret.put("Room preferences", this.getPerc(rp.getValue(assignment, variables), rp.getBounds(assignment, variables)[0], rp.getBounds(assignment, variables)[1]) + "% (" + Math.round(rp.getValue(assignment, variables)) + ")");
        Criterion tp = this.getCriterion(TimePreferences.class);
        ret.put("Time preferences", this.getPerc(tp.getValue(assignment, variables), tp.getBounds(assignment, variables)[0], tp.getBounds(assignment, variables)[1]) + "% (" + sDoubleFormat.format(tp.getValue(assignment, variables)) + ")");
        Criterion dp = this.getCriterion(DistributionPreferences.class);
        ret.put("Distribution preferences", this.getPerc(dp.getValue(assignment, variables), dp.getBounds(assignment, variables)[0], dp.getBounds(assignment, variables)[1]) + "% (" + sDoubleFormat.format(dp.getValue(assignment, variables)) + ")");
        Criterion sc = this.getCriterion(StudentConflict.class);
        Criterion shc = this.getCriterion(StudentHardConflict.class);
        Criterion sdc = this.getCriterion(StudentDistanceConflict.class);
        Criterion scc = this.getCriterion(StudentCommittedConflict.class);
        ret.put("Student conflicts", Math.round(scc.getValue(assignment, variables) + sc.getValue(assignment, variables)) + " [committed:" + Math.round(scc.getValue(assignment, variables)) + ", distance:" + Math.round(sdc.getValue(assignment, variables)) + ", hard:" + Math.round(shc.getValue(assignment, variables)) + "]");
        if (!this.getSpreadConstraints().isEmpty()) {
            Criterion ip = this.getCriterion(BackToBackInstructorPreferences.class);
            ret.put("Back-to-back instructor preferences", this.getPerc(ip.getValue(assignment, variables), ip.getBounds(assignment, variables)[0], ip.getBounds(assignment, variables)[1]) + "% (" + Math.round(ip.getValue(assignment, variables)) + ")");
        }
        if (!this.getDepartmentSpreadConstraints().isEmpty()) {
            Criterion dbp = this.getCriterion(DepartmentBalancingPenalty.class);
            ret.put("Department balancing penalty", sDoubleFormat.format(dbp.getValue(assignment, variables)));
        }
        Criterion sbp = this.getCriterion(SameSubpartBalancingPenalty.class);
        ret.put("Same subpart balancing penalty", sDoubleFormat.format(sbp.getValue(assignment, variables)));
        Criterion tbr = this.getCriterion(TooBigRooms.class);
        ret.put("Too big rooms", this.getPercRev(tbr.getValue(assignment, variables), tbr.getBounds(assignment, variables)[1], tbr.getBounds(assignment, variables)[0]) + "% (" + Math.round(tbr.getValue(assignment, variables)) + ")");
        Criterion uh = this.getCriterion(UselessHalfHours.class);
        Criterion bt = this.getCriterion(BrokenTimePatterns.class);
        ret.put("Useless half-hours", this.getPercRev(uh.getValue(assignment, variables) + bt.getValue(assignment, variables), 0.0, (double)Constants.sPreferenceLevelStronglyDiscouraged * bt.getBounds(assignment, variables)[0]) + "% (" + Math.round(uh.getValue(assignment, variables)) + " + " + Math.round(bt.getValue(assignment, variables)) + ")");
        return ret;
    }

    public void addConstraint(Constraint<Lecture, Placement> constraint) {
        super.addConstraint(constraint);
        if (constraint instanceof InstructorConstraint) {
            this.iInstructorConstraints.add((InstructorConstraint)constraint);
        } else if (constraint instanceof JenrlConstraint) {
            this.iJenrlConstraints.add((JenrlConstraint)constraint);
        } else if (constraint instanceof RoomConstraint) {
            this.iRoomConstraints.add((RoomConstraint)constraint);
        } else if (constraint instanceof DepartmentSpreadConstraint) {
            this.iDepartmentSpreadConstraints.add((DepartmentSpreadConstraint)constraint);
        } else if (constraint instanceof SpreadConstraint) {
            this.iSpreadConstraints.add((SpreadConstraint)constraint);
        } else if (constraint instanceof ClassLimitConstraint) {
            this.iClassLimitConstraints.add((ClassLimitConstraint)constraint);
        } else if (constraint instanceof GroupConstraint) {
            this.iGroupConstraints.add((GroupConstraint)constraint);
        } else if (constraint instanceof FlexibleConstraint) {
            this.iFlexibleConstraints.add((FlexibleConstraint)constraint);
        }
    }

    public void removeConstraint(Constraint<Lecture, Placement> constraint) {
        super.removeConstraint(constraint);
        if (constraint instanceof InstructorConstraint) {
            this.iInstructorConstraints.remove(constraint);
        } else if (constraint instanceof JenrlConstraint) {
            this.iJenrlConstraints.remove(constraint);
        } else if (constraint instanceof RoomConstraint) {
            this.iRoomConstraints.remove(constraint);
        } else if (constraint instanceof DepartmentSpreadConstraint) {
            this.iDepartmentSpreadConstraints.remove(constraint);
        } else if (constraint instanceof SpreadConstraint) {
            this.iSpreadConstraints.remove(constraint);
        } else if (constraint instanceof ClassLimitConstraint) {
            this.iClassLimitConstraints.remove(constraint);
        } else if (constraint instanceof GroupConstraint) {
            this.iGroupConstraints.remove(constraint);
        } else if (constraint instanceof FlexibleConstraint) {
            this.iFlexibleConstraints.remove(constraint);
        }
    }

    public List<InstructorConstraint> getInstructorConstraints() {
        return this.iInstructorConstraints;
    }

    public List<GroupConstraint> getGroupConstraints() {
        return this.iGroupConstraints;
    }

    public List<JenrlConstraint> getJenrlConstraints() {
        return this.iJenrlConstraints;
    }

    public List<RoomConstraint> getRoomConstraints() {
        return this.iRoomConstraints;
    }

    public List<DepartmentSpreadConstraint> getDepartmentSpreadConstraints() {
        return this.iDepartmentSpreadConstraints;
    }

    public List<SpreadConstraint> getSpreadConstraints() {
        return this.iSpreadConstraints;
    }

    public List<ClassLimitConstraint> getClassLimitConstraints() {
        return this.iClassLimitConstraints;
    }

    public List<FlexibleConstraint> getFlexibleConstraints() {
        return this.iFlexibleConstraints;
    }

    public double getTotalValue(Assignment<Lecture, Placement> assignment) {
        double ret = 0.0;
        for (Criterion criterion : this.getCriteria()) {
            ret += criterion.getWeightedValue(assignment);
        }
        return ret;
    }

    public double getTotalValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double ret = 0.0;
        for (Criterion criterion : this.getCriteria()) {
            ret += criterion.getWeightedValue(assignment, variables);
        }
        return ret;
    }

    public int getYear() {
        return this.iYear;
    }

    public void setYear(int year) {
        this.iYear = year;
    }

    public Set<Student> getAllStudents() {
        return this.iAllStudents;
    }

    public void addStudent(Student student) {
        this.iAllStudents.add(student);
    }

    public void removeStudent(Student student) {
        this.iAllStudents.remove(student);
    }

    public static synchronized String getMem() {
        Runtime rt = Runtime.getRuntime();
        return sDoubleFormat.format((double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0) + "M";
    }

    public Set<Placement> conflictValuesSkipWeakeningConstraints(Assignment<Lecture, Placement> assignment, Placement value) {
        HashSet<Placement> conflictValues = new HashSet<Placement>();
        for (Constraint constraint : ((Lecture)value.variable()).hardConstraints()) {
            if (constraint instanceof WeakeningConstraint) continue;
            if (constraint instanceof GroupConstraint) {
                ((GroupConstraint)constraint).computeConflictsNoForwardCheck(assignment, value, conflictValues);
                continue;
            }
            constraint.computeConflicts(assignment, (Value)value, conflictValues);
        }
        for (Constraint constraint : this.globalConstraints()) {
            if (constraint instanceof WeakeningConstraint) continue;
            constraint.computeConflicts(assignment, (Value)value, conflictValues);
        }
        return conflictValues;
    }

    public List<BitSet> getWeeks() {
        block15: {
            if (this.iWeeks != null) break block15;
            String defaultDatePattern = this.getProperties().getProperty("DatePattern.CustomDatePattern", null);
            if (defaultDatePattern == null) {
                defaultDatePattern = this.getProperties().getProperty("DatePattern.Default");
            }
            BitSet fullTerm = null;
            if (defaultDatePattern == null) {
                HashMap<Long, Integer> counter = new HashMap<Long, Integer>();
                int max = 0;
                String name = null;
                Long id = null;
                for (Lecture lecture : this.variables()) {
                    if (lecture.isCommitted()) continue;
                    for (TimeLocation time : lecture.timeLocations()) {
                        if (time.getWeekCode() == null || time.getDatePatternId() == null) continue;
                        int count = 1;
                        if (counter.containsKey(time.getDatePatternId())) {
                            count += ((Integer)counter.get(time.getDatePatternId())).intValue();
                        }
                        counter.put(time.getDatePatternId(), count);
                        if (count <= max) continue;
                        max = count;
                        fullTerm = time.getWeekCode();
                        name = time.getDatePatternName();
                        id = time.getDatePatternId();
                    }
                }
                sLogger.info("Using date pattern " + name + " (id " + id + ") as the default.");
            } else {
                fullTerm = new BitSet(defaultDatePattern.length());
                for (int i = 0; i < defaultDatePattern.length(); ++i) {
                    if (defaultDatePattern.charAt(i) != '1') continue;
                    fullTerm.set(i);
                }
            }
            if (fullTerm == null) {
                return null;
            }
            this.iWeeks = new ArrayList<BitSet>();
            if (this.getProperties().getPropertyBoolean("DatePattern.ShiftWeeks", false)) {
                int i = fullTerm.nextSetBit(0);
                while (i < fullTerm.length()) {
                    if (!fullTerm.get(i)) {
                        ++i;
                        continue;
                    }
                    BitSet w = new BitSet(i + 7);
                    for (int j = 0; j < 7; ++j) {
                        if (!fullTerm.get(i + j)) continue;
                        w.set(i + j);
                    }
                    this.iWeeks.add(w);
                    i += 7;
                }
            } else {
                for (int i = fullTerm.nextSetBit(0); i < fullTerm.length(); i += 7) {
                    BitSet w = new BitSet(i + 7);
                    for (int j = 0; j < 7; ++j) {
                        if (!fullTerm.get(i + j)) continue;
                        w.set(i + j);
                    }
                    this.iWeeks.add(w);
                }
            }
        }
        return this.iWeeks;
    }

    public List<StudentGroup> getStudentGroups() {
        return this.iStudentGroups;
    }

    public void addStudentGroup(StudentGroup group) {
        this.iStudentGroups.add(group);
    }

    public void saveBest(Assignment<Lecture, Placement> assignment) {
        super.saveBest(assignment);
        if (this.iOnFlySectioning) {
            if (this.iBestEnrollment == null) {
                this.iBestEnrollment = new HashMap<Student, Set<Lecture>>();
            } else {
                this.iBestEnrollment.clear();
            }
            for (Student student : this.getAllStudents()) {
                this.iBestEnrollment.put(student, new HashSet<Lecture>(student.getLectures()));
            }
        }
    }

    protected void incJenrl(Assignment<Lecture, Placement> assignment, Student student, Lecture l1, Lecture l2) {
        if (l1.equals((Object)l2)) {
            return;
        }
        JenrlConstraint jenrl = l1.jenrlConstraint(l2);
        if (jenrl == null) {
            jenrl = new JenrlConstraint();
            jenrl.addVariable((Variable)l1);
            jenrl.addVariable((Variable)l2);
            this.addConstraint((Constraint<Lecture, Placement>)jenrl);
        }
        jenrl.incJenrl(assignment, student);
    }

    protected void decJenrl(Assignment<Lecture, Placement> assignment, Student student, Lecture l1, Lecture l2) {
        if (l1.equals((Object)l2)) {
            return;
        }
        JenrlConstraint jenrl = l1.jenrlConstraint(l2);
        if (jenrl != null) {
            jenrl.decJenrl(assignment, student);
        }
    }

    public void restoreBest(Assignment<Lecture, Placement> assignment) {
        if (this.iOnFlySectioning && this.iBestEnrollment != null) {
            for (Lecture lecture : this.variables()) {
                Placement placement = (Placement)assignment.getValue((Variable)lecture);
                if (placement == null || placement.equals(lecture.getBestAssignment())) continue;
                assignment.unassign(0L, (Variable)lecture);
            }
            for (Map.Entry entry : this.iBestEnrollment.entrySet()) {
                Student student = (Student)entry.getKey();
                Set lectures = (Set)entry.getValue();
                HashSet<Configuration> configs = new HashSet<Configuration>();
                for (Lecture lecture : lectures) {
                    if (lecture.getConfiguration() == null) continue;
                    configs.add(lecture.getConfiguration());
                }
                for (Lecture lecture : new ArrayList<Lecture>(student.getLectures())) {
                    if (lectures.contains((Object)lecture)) continue;
                    for (Lecture other : student.getLectures()) {
                        this.decJenrl(assignment, student, lecture, other);
                    }
                    lecture.removeStudent(assignment, student);
                    student.removeLecture(lecture);
                    if (lecture.getConfiguration() == null || configs.contains(lecture.getConfiguration())) continue;
                    student.removeConfiguration(lecture.getConfiguration());
                }
                for (Lecture lecture : lectures) {
                    if (student.getLectures().contains((Object)lecture)) continue;
                    for (Lecture other : student.getLectures()) {
                        this.incJenrl(assignment, student, lecture, other);
                    }
                    lecture.addStudent(assignment, student);
                    student.addLecture(lecture);
                    student.addConfiguration(lecture.getConfiguration());
                }
            }
            for (JenrlConstraint jenrlConstraint : new ArrayList<JenrlConstraint>(this.getJenrlConstraints())) {
                if (jenrlConstraint.getNrStudents() != 0) continue;
                ((JenrlConstraint.JenrlConstraintContext)jenrlConstraint.getContext(assignment)).unassigned(assignment, (Placement)null);
                Object[] vars = jenrlConstraint.variables().toArray();
                for (int k = 0; k < vars.length; ++k) {
                    jenrlConstraint.removeVariable((Variable)((Lecture)((Object)vars[k])));
                }
                this.removeConstraint((Constraint<Lecture, Placement>)jenrlConstraint);
            }
        }
        super.restoreBest(assignment);
    }

    public boolean isAllowBreakHard() {
        return this.iAllowBreakHard;
    }
}

