/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.heuristics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.perturbations.DefaultPerturbationsCounter;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;

public class UniversalPerturbationsCounter
extends DefaultPerturbationsCounter<Lecture, Placement> {
    private double iDifferentPlacement = 1.0;
    private double iAffectedStudentWeight = 0.0;
    private double iAffectedInstructorWeight = 0.0;
    private double iAffectedStudentByTimeWeight = 0.0;
    private double iAffectedInstructorByTimeWeight = 0.0;
    private double iAffectedStudentByRoomWeight = 0.0;
    private double iAffectedInstructorByRoomWeight = 0.0;
    private double iAffectedStudentByBldgWeight = 0.0;
    private double iAffectedInstructorByBldgWeight = 0.0;
    private double iDifferentRoomWeight = 0.0;
    private double iDifferentBuildingWeight = 0.0;
    private double iDifferentTimeWeight = 0.0;
    private double iDifferentDayWeight = 0.0;
    private double iDifferentHourWeight = 0.0;
    private double iNewStudentConflictsWeight = 0.0;
    private double iDeltaStudentConflictsWeight = 0.0;
    private double iTooFarForInstructorsWeight = 0.0;
    private double iTooFarForStudentsWeight = 0.0;
    private double iDeltaInstructorDistancePreferenceWeight = 0.0;
    private double iDeltaRoomPreferenceWeight = 0.0;
    private double iDeltaTimePreferenceWeight = 0.0;
    private boolean iMPP = false;
    private DistanceMetric iDistanceMetric = null;

    public UniversalPerturbationsCounter(DataProperties properties) {
        super(properties);
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        this.iDifferentPlacement = properties.getPropertyDouble("Perturbations.DifferentPlacement", this.iDifferentPlacement);
        this.iAffectedStudentWeight = properties.getPropertyDouble("Perturbations.AffectedStudentWeight", this.iAffectedStudentWeight);
        this.iAffectedInstructorWeight = properties.getPropertyDouble("Perturbations.AffectedInstructorWeight", this.iAffectedInstructorWeight);
        this.iAffectedStudentByTimeWeight = properties.getPropertyDouble("Perturbations.AffectedStudentByTimeWeight", this.iAffectedStudentByTimeWeight);
        this.iAffectedInstructorByTimeWeight = properties.getPropertyDouble("Perturbations.AffectedInstructorByTimeWeight", this.iAffectedInstructorByTimeWeight);
        this.iAffectedStudentByRoomWeight = properties.getPropertyDouble("Perturbations.AffectedStudentByRoomWeight", this.iAffectedStudentByRoomWeight);
        this.iAffectedInstructorByRoomWeight = properties.getPropertyDouble("Perturbations.AffectedInstructorByRoomWeight", this.iAffectedInstructorByRoomWeight);
        this.iAffectedStudentByBldgWeight = properties.getPropertyDouble("Perturbations.AffectedStudentByBldgWeight", this.iAffectedStudentByBldgWeight);
        this.iAffectedInstructorByBldgWeight = properties.getPropertyDouble("Perturbations.AffectedInstructorByBldgWeight", this.iAffectedInstructorByBldgWeight);
        this.iDifferentRoomWeight = properties.getPropertyDouble("Perturbations.DifferentRoomWeight", this.iDifferentRoomWeight);
        this.iDifferentBuildingWeight = properties.getPropertyDouble("Perturbations.DifferentBuildingWeight", this.iDifferentBuildingWeight);
        this.iDifferentTimeWeight = properties.getPropertyDouble("Perturbations.DifferentTimeWeight", this.iDifferentTimeWeight);
        this.iDifferentDayWeight = properties.getPropertyDouble("Perturbations.DifferentDayWeight", this.iDifferentDayWeight);
        this.iDifferentHourWeight = properties.getPropertyDouble("Perturbations.DifferentHourWeight", this.iDifferentHourWeight);
        this.iDeltaStudentConflictsWeight = properties.getPropertyDouble("Perturbations.DeltaStudentConflictsWeight", this.iDeltaStudentConflictsWeight);
        this.iNewStudentConflictsWeight = properties.getPropertyDouble("Perturbations.NewStudentConflictsWeight", this.iNewStudentConflictsWeight);
        this.iTooFarForInstructorsWeight = properties.getPropertyDouble("Perturbations.TooFarForInstructorsWeight", this.iTooFarForInstructorsWeight);
        this.iTooFarForStudentsWeight = properties.getPropertyDouble("Perturbations.TooFarForStudentsWeight", this.iTooFarForStudentsWeight);
        this.iDeltaInstructorDistancePreferenceWeight = properties.getPropertyDouble("Perturbations.DeltaInstructorDistancePreferenceWeight", this.iDeltaInstructorDistancePreferenceWeight);
        this.iDeltaRoomPreferenceWeight = properties.getPropertyDouble("Perturbations.DeltaRoomPreferenceWeight", this.iDeltaRoomPreferenceWeight);
        this.iDeltaTimePreferenceWeight = properties.getPropertyDouble("Perturbations.DeltaTimePreferenceWeight", this.iDeltaTimePreferenceWeight);
        this.iDistanceMetric = new DistanceMetric(properties);
    }

    protected double getPenalty(Assignment<Lecture, Placement> assignment, Placement assignedPlacement, Placement initialPlacement) {
        Lecture lecture = (Lecture)initialPlacement.variable();
        double penalty = 0.0;
        if (this.iDifferentPlacement != 0.0) {
            penalty += this.iDifferentPlacement;
        }
        if (this.iAffectedStudentWeight != 0.0) {
            penalty += this.iAffectedStudentWeight * (double)lecture.classLimit(assignment);
        }
        if (this.iAffectedInstructorWeight != 0.0) {
            penalty += this.iAffectedInstructorWeight * (double)lecture.getInstructorConstraints().size();
        }
        if (assignedPlacement != null) {
            int nrDiff;
            if (this.iDifferentRoomWeight != 0.0 || this.iAffectedInstructorByRoomWeight != 0.0 || this.iAffectedStudentByRoomWeight != 0.0) {
                nrDiff = initialPlacement.nrDifferentRooms(assignedPlacement);
                penalty += (double)nrDiff * this.iDifferentRoomWeight;
                penalty += (double)nrDiff * this.iAffectedInstructorByRoomWeight * (double)lecture.getInstructorConstraints().size();
                penalty += (double)nrDiff * this.iAffectedStudentByRoomWeight * (double)lecture.classLimit(assignment);
            }
            if (this.iDifferentBuildingWeight != 0.0 || this.iAffectedInstructorByBldgWeight != 0.0 || this.iAffectedStudentByBldgWeight != 0.0) {
                nrDiff = initialPlacement.nrDifferentBuildings(assignedPlacement);
                penalty += (double)nrDiff * this.iDifferentBuildingWeight;
                penalty += (double)nrDiff * this.iAffectedInstructorByBldgWeight * (double)lecture.getInstructorConstraints().size();
                penalty += (double)nrDiff * this.iAffectedStudentByBldgWeight * (double)lecture.classLimit(assignment);
            }
            if (!(this.iDifferentTimeWeight == 0.0 && this.iAffectedInstructorByTimeWeight == 0.0 && this.iAffectedStudentByTimeWeight == 0.0 || initialPlacement.getTimeLocation().equals(assignedPlacement.getTimeLocation()))) {
                penalty += this.iDifferentTimeWeight;
                penalty += this.iAffectedInstructorByTimeWeight * (double)lecture.getInstructorConstraints().size();
                penalty += this.iAffectedStudentByTimeWeight * (double)lecture.classLimit(assignment);
            }
            if (this.iDifferentDayWeight != 0.0 && initialPlacement.getTimeLocation().getDayCode() != assignedPlacement.getTimeLocation().getDayCode()) {
                penalty += this.iDifferentDayWeight;
            }
            if (this.iDifferentHourWeight != 0.0 && initialPlacement.getTimeLocation().getStartSlot() != assignedPlacement.getTimeLocation().getStartSlot()) {
                penalty += this.iDifferentHourWeight;
            }
            if (!(this.iTooFarForInstructorsWeight == 0.0 && this.iTooFarForStudentsWeight == 0.0 || initialPlacement.getTimeLocation().equals(assignedPlacement.getTimeLocation()))) {
                double distance = Placement.getDistanceInMeters(this.iDistanceMetric, initialPlacement, assignedPlacement);
                if (!lecture.getInstructorConstraints().isEmpty() && this.iTooFarForInstructorsWeight != 0.0) {
                    if (distance > this.iDistanceMetric.getInstructorNoPreferenceLimit() && distance <= this.iDistanceMetric.getInstructorDiscouragedLimit()) {
                        penalty += (double)Constants.sPreferenceLevelDiscouraged * this.iTooFarForInstructorsWeight * (double)lecture.getInstructorConstraints().size();
                    } else if (distance > this.iDistanceMetric.getInstructorDiscouragedLimit() && distance <= this.iDistanceMetric.getInstructorProhibitedLimit()) {
                        penalty += (double)Constants.sPreferenceLevelStronglyDiscouraged * this.iTooFarForInstructorsWeight * (double)lecture.getInstructorConstraints().size();
                    } else if (distance > this.iDistanceMetric.getInstructorProhibitedLimit()) {
                        penalty += (double)Constants.sPreferenceLevelProhibited * this.iTooFarForInstructorsWeight * (double)lecture.getInstructorConstraints().size();
                    }
                }
                if (this.iTooFarForStudentsWeight != 0.0 && distance > this.iDistanceMetric.minutes2meters(10)) {
                    penalty += this.iTooFarForStudentsWeight * (double)lecture.classLimit(assignment);
                }
            }
            if (this.iDeltaStudentConflictsWeight != 0.0) {
                int newStudentConflicts = lecture.countStudentConflicts(assignment, assignedPlacement);
                int oldStudentConflicts = lecture.countInitialStudentConflicts();
                penalty += this.iDeltaStudentConflictsWeight * (double)(newStudentConflicts - oldStudentConflicts);
            }
            if (this.iNewStudentConflictsWeight != 0.0) {
                Set<Student> newStudentConflicts = lecture.conflictStudents(assignment, assignedPlacement);
                Set<Student> initialStudentConflicts = lecture.initialStudentConflicts();
                Iterator<Student> i = newStudentConflicts.iterator();
                while (i.hasNext()) {
                    if (initialStudentConflicts.contains(i.next())) continue;
                    penalty += this.iNewStudentConflictsWeight;
                }
            }
            if (this.iDeltaTimePreferenceWeight != 0.0) {
                penalty += this.iDeltaTimePreferenceWeight * (assignedPlacement.getTimeLocation().getNormalizedPreference() - initialPlacement.getTimeLocation().getNormalizedPreference());
            }
            if (this.iDeltaRoomPreferenceWeight != 0.0) {
                penalty += this.iDeltaRoomPreferenceWeight * (double)(assignedPlacement.sumRoomPreference() - initialPlacement.sumRoomPreference());
            }
            if (this.iDeltaInstructorDistancePreferenceWeight != 0.0) {
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    for (Lecture lect : ic.variables()) {
                        if (lect.equals((Object)lecture)) continue;
                        int initialPreference = lect.getInitialAssignment() == null ? Constants.sPreferenceLevelNeutral : ic.getDistancePreference(initialPlacement, (Placement)lect.getInitialAssignment());
                        int assignedPreference = assignment.getValue((Variable)lect) == null ? Constants.sPreferenceLevelNeutral : ic.getDistancePreference(assignedPlacement, (Placement)assignment.getValue((Variable)lect));
                        penalty += this.iDeltaInstructorDistancePreferenceWeight * (double)(assignedPreference - initialPreference);
                    }
                }
            }
        }
        return penalty;
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, TimetableModel model, Map<String, String> info) {
        this.getInfo(assignment, model, info, null);
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, TimetableModel model, Map<String, String> info, List<Lecture> variables) {
        if (variables == null) {
            super.getInfo(assignment, (Model)model, info);
        } else {
            super.getInfo(assignment, (Model)model, info, variables);
        }
        if (!this.iMPP) {
            return;
        }
        int perts = 0;
        long affectedStudents = 0L;
        int affectedInstructors = 0;
        long affectedStudentsByTime = 0L;
        int affectedInstructorsByTime = 0;
        long affectedStudentsByRoom = 0L;
        int affectedInstructorsByRoom = 0;
        long affectedStudentsByBldg = 0L;
        int affectedInstructorsByBldg = 0;
        int differentRoom = 0;
        int differentBuilding = 0;
        int differentTime = 0;
        int differentDay = 0;
        int differentHour = 0;
        int tooFarForInstructors = 0;
        int tooFarForStudents = 0;
        int deltaStudentConflicts = 0;
        int newStudentConflicts = 0;
        double deltaTimePreferences = 0.0;
        int deltaRoomPreferences = 0;
        int deltaInstructorDistancePreferences = 0;
        for (Lecture lecture : variables == null ? model.perturbVariables(assignment) : model.perturbVariables(assignment, variables)) {
            if (assignment.getValue((Variable)lecture) == null || lecture.getInitialAssignment() == null || ((Placement)assignment.getValue((Variable)lecture)).equals(lecture.getInitialAssignment())) continue;
            ++perts;
            Placement assignedPlacement = (Placement)assignment.getValue((Variable)lecture);
            Placement initialPlacement = (Placement)lecture.getInitialAssignment();
            affectedStudents += (long)lecture.classLimit(assignment);
            affectedInstructors += lecture.getInstructorConstraints().size();
            int nrDiff = initialPlacement.nrDifferentRooms(assignedPlacement);
            differentRoom += nrDiff;
            affectedInstructorsByRoom += nrDiff * lecture.getInstructorConstraints().size();
            affectedStudentsByRoom += (long)(nrDiff * lecture.classLimit(assignment));
            nrDiff = initialPlacement.nrDifferentBuildings(assignedPlacement);
            differentBuilding += nrDiff;
            affectedInstructorsByBldg += nrDiff * lecture.getInstructorConstraints().size();
            affectedStudentsByBldg += (long)(nrDiff * lecture.classLimit(assignment));
            deltaRoomPreferences += assignedPlacement.sumRoomPreference() - initialPlacement.sumRoomPreference();
            if (!initialPlacement.getTimeLocation().equals(assignedPlacement.getTimeLocation())) {
                ++differentTime;
                affectedInstructorsByTime += lecture.getInstructorConstraints().size();
                affectedStudentsByTime += (long)lecture.classLimit(assignment);
            }
            if (initialPlacement.getTimeLocation().getDayCode() != assignedPlacement.getTimeLocation().getDayCode()) {
                ++differentDay;
            }
            if (initialPlacement.getTimeLocation().getStartSlot() != assignedPlacement.getTimeLocation().getStartSlot()) {
                ++differentHour;
            }
            if (!initialPlacement.getTimeLocation().equals(assignedPlacement.getTimeLocation())) {
                double distance = Placement.getDistanceInMeters(this.iDistanceMetric, initialPlacement, assignedPlacement);
                if (!lecture.getInstructorConstraints().isEmpty()) {
                    if (distance > this.iDistanceMetric.getInstructorNoPreferenceLimit() && distance <= this.iDistanceMetric.getInstructorDiscouragedLimit()) {
                        tooFarForInstructors += Constants.sPreferenceLevelDiscouraged * lecture.getInstructorConstraints().size();
                    } else if (distance > this.iDistanceMetric.getInstructorDiscouragedLimit() && distance <= this.iDistanceMetric.getInstructorProhibitedLimit()) {
                        tooFarForInstructors += Constants.sPreferenceLevelStronglyDiscouraged * lecture.getInstructorConstraints().size();
                    } else if (distance > this.iDistanceMetric.getInstructorProhibitedLimit()) {
                        tooFarForInstructors += Constants.sPreferenceLevelProhibited * lecture.getInstructorConstraints().size();
                    }
                }
                if (distance > this.iDistanceMetric.minutes2meters(10)) {
                    tooFarForStudents += lecture.classLimit(assignment);
                }
            }
            deltaStudentConflicts += lecture.countStudentConflicts(assignment, assignedPlacement) - lecture.countInitialStudentConflicts();
            Set<Student> newStudentConflictsSet = lecture.conflictStudents(assignment, assignedPlacement);
            Set<Student> initialStudentConflicts = lecture.initialStudentConflicts();
            Iterator<Student> e1 = newStudentConflictsSet.iterator();
            while (e1.hasNext()) {
                if (initialStudentConflicts.contains(e1.next())) continue;
                ++newStudentConflicts;
            }
            deltaTimePreferences += assignedPlacement.getTimeLocation().getNormalizedPreference() - initialPlacement.getTimeLocation().getNormalizedPreference();
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                for (Lecture lect : ic.variables()) {
                    if (lect.equals((Object)lecture)) continue;
                    int initialPreference = lect.getInitialAssignment() == null ? Constants.sPreferenceLevelNeutral : ic.getDistancePreference(initialPlacement, (Placement)lect.getInitialAssignment());
                    int assignedPreference = assignedPlacement == null ? Constants.sPreferenceLevelNeutral : ic.getDistancePreference(assignedPlacement, assignedPlacement);
                    deltaInstructorDistancePreferences += assignedPreference - initialPreference;
                }
            }
        }
        if (perts != 0) {
            info.put("Perturbations: Different placement", String.valueOf(perts) + " (weighted " + sDoubleFormat.format(this.iDifferentPlacement * (double)perts) + ")");
        }
        if (affectedStudents != 0L) {
            info.put("Perturbations: Number of affected students", String.valueOf(affectedStudents) + " (weighted " + sDoubleFormat.format(this.iAffectedStudentWeight * (double)affectedStudents) + ")");
        }
        if (affectedInstructors != 0) {
            info.put("Perturbations: Number of affected instructors", String.valueOf(affectedInstructors) + " (weighted " + sDoubleFormat.format(this.iAffectedInstructorWeight * (double)affectedInstructors) + ")");
        }
        if (affectedStudentsByTime != 0L) {
            info.put("Perturbations: Number of affected students [time]", String.valueOf(affectedStudentsByTime) + " (weighted " + sDoubleFormat.format(this.iAffectedStudentByTimeWeight * (double)affectedStudentsByTime) + ")");
        }
        if (affectedInstructorsByTime != 0) {
            info.put("Perturbations: Number of affected instructors [time]", String.valueOf(affectedInstructorsByTime) + " (weighted " + sDoubleFormat.format(this.iAffectedInstructorByTimeWeight * (double)affectedInstructorsByTime) + ")");
        }
        if (affectedStudentsByRoom != 0L) {
            info.put("Perturbations: Number of affected students [room]", String.valueOf(affectedStudentsByRoom) + " (weighted " + sDoubleFormat.format(this.iAffectedStudentByRoomWeight * (double)affectedStudentsByRoom) + ")");
        }
        if (affectedInstructorsByRoom != 0) {
            info.put("Perturbations: Number of affected instructors [room]", String.valueOf(affectedInstructorsByRoom) + " (weighted " + sDoubleFormat.format(this.iAffectedInstructorByRoomWeight * (double)affectedInstructorsByRoom) + ")");
        }
        if (affectedStudentsByBldg != 0L) {
            info.put("Perturbations: Number of affected students [bldg]", String.valueOf(affectedStudentsByBldg) + " (weighted " + sDoubleFormat.format(this.iAffectedStudentByBldgWeight * (double)affectedStudentsByBldg) + ")");
        }
        if (affectedInstructorsByBldg != 0) {
            info.put("Perturbations: Number of affected instructors [bldg]", String.valueOf(affectedInstructorsByBldg) + " (weighted " + sDoubleFormat.format(this.iAffectedInstructorByBldgWeight * (double)affectedInstructorsByBldg) + ")");
        }
        if (differentRoom != 0) {
            info.put("Perturbations: Different room", String.valueOf(differentRoom) + " (weighted " + sDoubleFormat.format(this.iDifferentRoomWeight * (double)differentRoom) + ")");
        }
        if (differentBuilding != 0) {
            info.put("Perturbations: Different building", String.valueOf(differentBuilding) + " (weighted " + sDoubleFormat.format(this.iDifferentBuildingWeight * (double)differentBuilding) + ")");
        }
        if (differentTime != 0) {
            info.put("Perturbations: Different time", String.valueOf(differentTime) + " (weighted " + sDoubleFormat.format(this.iDifferentTimeWeight * (double)differentTime) + ")");
        }
        if (differentDay != 0) {
            info.put("Perturbations: Different day", String.valueOf(differentDay) + " (weighted " + sDoubleFormat.format(this.iDifferentDayWeight * (double)differentDay) + ")");
        }
        if (differentHour != 0) {
            info.put("Perturbations: Different hour", String.valueOf(differentHour) + " (weighted " + sDoubleFormat.format(this.iDifferentHourWeight * (double)differentHour) + ")");
        }
        if (tooFarForInstructors != 0) {
            info.put("Perturbations: New placement too far from initial [instructors]", String.valueOf(tooFarForInstructors) + " (weighted " + sDoubleFormat.format(this.iTooFarForInstructorsWeight * (double)tooFarForInstructors) + ")");
        }
        if (tooFarForStudents != 0) {
            info.put("Perturbations: New placement too far from initial [students]", String.valueOf(tooFarForStudents) + " (weighted " + sDoubleFormat.format(this.iTooFarForStudentsWeight * (double)tooFarForStudents) + ")");
        }
        if (deltaStudentConflicts != 0) {
            info.put("Perturbations: Delta student conflicts", String.valueOf(deltaStudentConflicts) + " (weighted " + sDoubleFormat.format(this.iDeltaStudentConflictsWeight * (double)deltaStudentConflicts) + ")");
        }
        if (newStudentConflicts != 0) {
            info.put("Perturbations: New student conflicts", String.valueOf(newStudentConflicts) + " (weighted " + sDoubleFormat.format(this.iNewStudentConflictsWeight * (double)newStudentConflicts) + ")");
        }
        if (deltaTimePreferences != 0.0) {
            info.put("Perturbations: Delta time preferences", String.valueOf(deltaTimePreferences) + " (weighted " + sDoubleFormat.format(this.iDeltaTimePreferenceWeight * deltaTimePreferences) + ")");
        }
        if (deltaRoomPreferences != 0) {
            info.put("Perturbations: Delta room preferences", String.valueOf(deltaRoomPreferences) + " (weighted " + sDoubleFormat.format(this.iDeltaRoomPreferenceWeight * (double)deltaRoomPreferences) + ")");
        }
        if (deltaInstructorDistancePreferences != 0) {
            info.put("Perturbations: Delta instructor distance preferences", String.valueOf(deltaInstructorDistancePreferences) + " (weighted " + sDoubleFormat.format(this.iDeltaInstructorDistancePreferenceWeight * (double)deltaInstructorDistancePreferences) + ")");
        }
    }

    public Map<String, Double> getCompactInfo(Assignment<Lecture, Placement> assignment, TimetableModel model, boolean includeZero, boolean weighted) {
        HashMap<String, Double> info = new HashMap<String, Double>();
        if (!this.iMPP) {
            return info;
        }
        int perts = 0;
        long affectedStudents = 0L;
        int affectedInstructors = 0;
        long affectedStudentsByTime = 0L;
        int affectedInstructorsByTime = 0;
        long affectedStudentsByRoom = 0L;
        int affectedInstructorsByRoom = 0;
        long affectedStudentsByBldg = 0L;
        int affectedInstructorsByBldg = 0;
        int differentRoom = 0;
        int differentBuilding = 0;
        int differentTime = 0;
        int differentDay = 0;
        int differentHour = 0;
        int tooFarForInstructors = 0;
        int tooFarForStudents = 0;
        int deltaStudentConflicts = 0;
        int newStudentConflicts = 0;
        double deltaTimePreferences = 0.0;
        int deltaRoomPreferences = 0;
        int deltaInstructorDistancePreferences = 0;
        for (Lecture lecture : model.perturbVariables(assignment)) {
            if (assignment.getValue((Variable)lecture) == null || lecture.getInitialAssignment() == null || ((Placement)assignment.getValue((Variable)lecture)).equals(lecture.getInitialAssignment())) continue;
            ++perts;
            Placement assignedPlacement = (Placement)assignment.getValue((Variable)lecture);
            Placement initialPlacement = (Placement)lecture.getInitialAssignment();
            affectedStudents += (long)lecture.classLimit(assignment);
            affectedInstructors += lecture.getInstructorConstraints().size();
            int nrDiff = initialPlacement.nrDifferentRooms(assignedPlacement);
            differentRoom += nrDiff;
            affectedInstructorsByRoom += nrDiff * lecture.getInstructorConstraints().size();
            affectedStudentsByRoom += (long)(nrDiff * lecture.classLimit(assignment));
            nrDiff = initialPlacement.nrDifferentBuildings(initialPlacement);
            differentBuilding += nrDiff;
            affectedInstructorsByBldg += nrDiff * lecture.getInstructorConstraints().size();
            affectedStudentsByBldg += (long)(nrDiff * lecture.classLimit(assignment));
            deltaRoomPreferences += assignedPlacement.sumRoomPreference() - initialPlacement.sumRoomPreference();
            if (!initialPlacement.getTimeLocation().equals(assignedPlacement.getTimeLocation())) {
                ++differentTime;
                affectedInstructorsByTime += lecture.getInstructorConstraints().size();
                affectedStudentsByTime += (long)lecture.classLimit(assignment);
            }
            if (initialPlacement.getTimeLocation().getDayCode() != assignedPlacement.getTimeLocation().getDayCode()) {
                ++differentDay;
            }
            if (initialPlacement.getTimeLocation().getStartSlot() != assignedPlacement.getTimeLocation().getStartSlot()) {
                ++differentHour;
            }
            if (!initialPlacement.getTimeLocation().equals(assignedPlacement.getTimeLocation())) {
                double distance = Placement.getDistanceInMeters(this.iDistanceMetric, initialPlacement, assignedPlacement);
                if (!lecture.getInstructorConstraints().isEmpty()) {
                    if (distance > this.iDistanceMetric.getInstructorNoPreferenceLimit() && distance <= this.iDistanceMetric.getInstructorDiscouragedLimit()) {
                        tooFarForInstructors += Constants.sPreferenceLevelDiscouraged;
                    } else if (distance > this.iDistanceMetric.getInstructorDiscouragedLimit() && distance <= this.iDistanceMetric.getInstructorProhibitedLimit()) {
                        tooFarForInstructors += Constants.sPreferenceLevelStronglyDiscouraged;
                    } else if (distance > this.iDistanceMetric.getInstructorProhibitedLimit()) {
                        tooFarForInstructors += Constants.sPreferenceLevelProhibited;
                    }
                }
                if (distance > this.iDistanceMetric.minutes2meters(10)) {
                    tooFarForStudents += lecture.classLimit(assignment);
                }
            }
            deltaStudentConflicts += lecture.countStudentConflicts(assignment, assignedPlacement) - lecture.countInitialStudentConflicts();
            Set<Student> newStudentConflictsSet = lecture.conflictStudents(assignment, assignedPlacement);
            Set<Student> initialStudentConflicts = lecture.initialStudentConflicts();
            Iterator<Student> e1 = newStudentConflictsSet.iterator();
            while (e1.hasNext()) {
                if (initialStudentConflicts.contains(e1.next())) continue;
                ++newStudentConflicts;
            }
            deltaTimePreferences += assignedPlacement.getTimeLocation().getNormalizedPreference() - initialPlacement.getTimeLocation().getNormalizedPreference();
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                if (ic == null) continue;
                for (Lecture lect : ic.variables()) {
                    if (lect.equals((Object)lecture)) continue;
                    int initialPreference = lect.getInitialAssignment() == null ? Constants.sPreferenceLevelNeutral : ic.getDistancePreference(initialPlacement, (Placement)lect.getInitialAssignment());
                    int assignedPreference = assignedPlacement == null ? Constants.sPreferenceLevelNeutral : ic.getDistancePreference(assignedPlacement, assignedPlacement);
                    deltaInstructorDistancePreferences += assignedPreference - initialPreference;
                }
            }
        }
        if (includeZero || this.iDifferentPlacement != 0.0) {
            info.put("Different placement", new Double(weighted ? this.iDifferentPlacement * (double)perts : (double)perts));
        }
        if (includeZero || this.iAffectedStudentWeight != 0.0) {
            info.put("Affected students", new Double(weighted ? this.iAffectedStudentWeight * (double)affectedStudents : (double)affectedStudents));
        }
        if (includeZero || this.iAffectedInstructorWeight != 0.0) {
            info.put("Affected instructors", new Double(weighted ? this.iAffectedInstructorWeight * (double)affectedInstructors : (double)affectedInstructors));
        }
        if (includeZero || this.iAffectedStudentByTimeWeight != 0.0) {
            info.put("Affected students [time]", new Double(weighted ? this.iAffectedStudentByTimeWeight * (double)affectedStudentsByTime : (double)affectedStudentsByTime));
        }
        if (includeZero || this.iAffectedInstructorByTimeWeight != 0.0) {
            info.put("Affected instructors [time]", new Double(weighted ? this.iAffectedInstructorByTimeWeight * (double)affectedInstructorsByTime : (double)affectedInstructorsByTime));
        }
        if (includeZero || this.iAffectedStudentByRoomWeight != 0.0) {
            info.put("Affected students [room]", new Double(weighted ? this.iAffectedStudentByRoomWeight * (double)affectedStudentsByRoom : (double)affectedStudentsByRoom));
        }
        if (includeZero || this.iAffectedInstructorByRoomWeight != 0.0) {
            info.put("Affected instructors [room]", new Double(weighted ? this.iAffectedInstructorByRoomWeight * (double)affectedInstructorsByRoom : (double)affectedInstructorsByRoom));
        }
        if (includeZero || this.iAffectedStudentByBldgWeight != 0.0) {
            info.put("Affected students [bldg]", new Double(weighted ? this.iAffectedStudentByBldgWeight * (double)affectedStudentsByBldg : (double)affectedStudentsByBldg));
        }
        if (includeZero || this.iAffectedInstructorByBldgWeight != 0.0) {
            info.put("Affected instructors [bldg]", new Double(weighted ? this.iAffectedInstructorByBldgWeight * (double)affectedInstructorsByBldg : (double)affectedInstructorsByBldg));
        }
        if (includeZero || this.iDifferentRoomWeight != 0.0) {
            info.put("Different room", new Double(weighted ? this.iDifferentRoomWeight * (double)differentRoom : (double)differentRoom));
        }
        if (includeZero || this.iDifferentBuildingWeight != 0.0) {
            info.put("Different building", new Double(weighted ? this.iDifferentBuildingWeight * (double)differentBuilding : (double)differentBuilding));
        }
        if (includeZero || this.iDifferentTimeWeight != 0.0) {
            info.put("Different time", new Double(weighted ? this.iDifferentTimeWeight * (double)differentTime : (double)differentTime));
        }
        if (includeZero || this.iDifferentDayWeight != 0.0) {
            info.put("Different day", new Double(weighted ? this.iDifferentDayWeight * (double)differentDay : (double)differentDay));
        }
        if (includeZero || this.iDifferentHourWeight != 0.0) {
            info.put("Different hour", new Double(weighted ? this.iDifferentHourWeight * (double)differentHour : (double)differentHour));
        }
        if (includeZero || this.iTooFarForInstructorsWeight != 0.0) {
            info.put("New placement too far for initial [instructors]", new Double(weighted ? this.iTooFarForInstructorsWeight * (double)tooFarForInstructors : (double)tooFarForInstructors));
        }
        if (includeZero || this.iTooFarForStudentsWeight != 0.0) {
            info.put("New placement too far for initial [students]", new Double(weighted ? this.iTooFarForStudentsWeight * (double)tooFarForStudents : (double)tooFarForStudents));
        }
        if (includeZero || this.iDeltaStudentConflictsWeight != 0.0) {
            info.put("Delta student conflicts", new Double(weighted ? this.iDeltaStudentConflictsWeight * (double)deltaStudentConflicts : (double)deltaStudentConflicts));
        }
        if (includeZero || this.iNewStudentConflictsWeight != 0.0) {
            info.put("New student conflicts", new Double(weighted ? this.iNewStudentConflictsWeight * (double)newStudentConflicts : (double)newStudentConflicts));
        }
        if (includeZero || this.iDeltaTimePreferenceWeight != 0.0) {
            info.put("Delta time preferences", new Double(weighted ? this.iDeltaTimePreferenceWeight * deltaTimePreferences : deltaTimePreferences));
        }
        if (includeZero || this.iDeltaRoomPreferenceWeight != 0.0) {
            info.put("Delta room preferences", new Double(weighted ? this.iDeltaRoomPreferenceWeight * (double)deltaRoomPreferences : (double)deltaRoomPreferences));
        }
        if (includeZero || this.iDeltaInstructorDistancePreferenceWeight != 0.0) {
            info.put("Delta instructor distance preferences", new Double(weighted ? this.iDeltaInstructorDistancePreferenceWeight * (double)deltaInstructorDistancePreferences : (double)deltaInstructorDistancePreferences));
        }
        return info;
    }

    public Map<String, Double> getCompactInfo(Assignment<Lecture, Placement> assignment, TimetableModel model, Placement assignedPlacement, boolean includeZero, boolean weighted) {
        HashMap<String, Double> info = new HashMap<String, Double>();
        if (!this.iMPP) {
            return info;
        }
        Lecture lecture = (Lecture)assignedPlacement.variable();
        Placement initialPlacement = (Placement)lecture.getInitialAssignment();
        if (initialPlacement == null || initialPlacement.equals((Object)assignedPlacement)) {
            return info;
        }
        boolean perts = true;
        long affectedStudents = lecture.classLimit(assignment);
        int affectedInstructors = lecture.getInstructorConstraints().size();
        long affectedStudentsByTime = initialPlacement.getTimeLocation().equals(assignedPlacement.getTimeLocation()) ? 0 : lecture.classLimit(assignment);
        int affectedInstructorsByTime = initialPlacement.getTimeLocation().equals(assignedPlacement.getTimeLocation()) ? 0 : lecture.getInstructorConstraints().size();
        int differentRoom = initialPlacement.nrDifferentRooms(assignedPlacement);
        int affectedInstructorsByRoom = differentRoom * lecture.getInstructorConstraints().size();
        long affectedStudentsByRoom = differentRoom * lecture.classLimit(assignment);
        int differentBuilding = initialPlacement.nrDifferentBuildings(initialPlacement);
        int affectedInstructorsByBldg = differentBuilding * lecture.getInstructorConstraints().size();
        long affectedStudentsByBldg = differentBuilding * lecture.classLimit(assignment);
        int deltaRoomPreferences = assignedPlacement.sumRoomPreference() - initialPlacement.sumRoomPreference();
        boolean differentTime = !initialPlacement.getTimeLocation().equals(assignedPlacement.getTimeLocation());
        boolean differentDay = initialPlacement.getTimeLocation().getDayCode() != assignedPlacement.getTimeLocation().getDayCode();
        boolean differentHour = initialPlacement.getTimeLocation().getStartSlot() != assignedPlacement.getTimeLocation().getStartSlot();
        int tooFarForInstructors = 0;
        int tooFarForStudents = 0;
        int deltaStudentConflicts = lecture.countStudentConflicts(assignment, assignedPlacement) - lecture.countInitialStudentConflicts();
        int newStudentConflicts = 0;
        double deltaTimePreferences = assignedPlacement.getTimeLocation().getNormalizedPreference() - initialPlacement.getTimeLocation().getNormalizedPreference();
        int deltaInstructorDistancePreferences = 0;
        double distance = Placement.getDistanceInMeters(this.iDistanceMetric, initialPlacement, assignedPlacement);
        if (!lecture.getInstructorConstraints().isEmpty()) {
            if (distance > this.iDistanceMetric.getInstructorNoPreferenceLimit() && distance <= this.iDistanceMetric.getInstructorDiscouragedLimit()) {
                tooFarForInstructors += lecture.getInstructorConstraints().size();
            } else if (distance > this.iDistanceMetric.getInstructorDiscouragedLimit() && distance <= this.iDistanceMetric.getInstructorProhibitedLimit()) {
                tooFarForInstructors += 2 * lecture.getInstructorConstraints().size();
            } else if (distance > this.iDistanceMetric.getInstructorProhibitedLimit()) {
                tooFarForInstructors += 10 * lecture.getInstructorConstraints().size();
            }
        }
        if (distance > this.iDistanceMetric.minutes2meters(10)) {
            tooFarForStudents = lecture.classLimit(assignment);
        }
        Set<Student> newStudentConflictsVect = lecture.conflictStudents(assignment, assignedPlacement);
        Set<Student> initialStudentConflicts = lecture.initialStudentConflicts();
        Iterator<Student> e = newStudentConflictsVect.iterator();
        while (e.hasNext()) {
            if (initialStudentConflicts.contains(e.next())) continue;
            ++newStudentConflicts;
        }
        for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
            for (Lecture lect : ic.variables()) {
                if (lect.equals((Object)lecture)) continue;
                int initialPreference = lect.getInitialAssignment() == null ? Constants.sPreferenceLevelNeutral : ic.getDistancePreference(initialPlacement, (Placement)lect.getInitialAssignment());
                int assignedPreference = assignment.getValue((Variable)lect) == null ? Constants.sPreferenceLevelNeutral : ic.getDistancePreference(assignedPlacement, (Placement)assignment.getValue((Variable)lect));
                deltaInstructorDistancePreferences += assignedPreference - initialPreference;
            }
        }
        if (includeZero || this.iDifferentPlacement != 0.0) {
            info.put("Different placement", new Double(weighted ? this.iDifferentPlacement * (double)perts : (double)perts));
        }
        if (includeZero || this.iAffectedStudentWeight != 0.0) {
            info.put("Affected students", new Double(weighted ? this.iAffectedStudentWeight * (double)affectedStudents : (double)affectedStudents));
        }
        if (includeZero || this.iAffectedInstructorWeight != 0.0) {
            info.put("Affected instructors", new Double(weighted ? this.iAffectedInstructorWeight * (double)affectedInstructors : (double)affectedInstructors));
        }
        if (includeZero || this.iAffectedStudentByTimeWeight != 0.0) {
            info.put("Affected students [time]", new Double(weighted ? this.iAffectedStudentByTimeWeight * (double)affectedStudentsByTime : (double)affectedStudentsByTime));
        }
        if (includeZero || this.iAffectedInstructorByTimeWeight != 0.0) {
            info.put("Affected instructors [time]", new Double(weighted ? this.iAffectedInstructorByTimeWeight * (double)affectedInstructorsByTime : (double)affectedInstructorsByTime));
        }
        if (includeZero || this.iAffectedStudentByRoomWeight != 0.0) {
            info.put("Affected students [room]", new Double(weighted ? this.iAffectedStudentByRoomWeight * (double)affectedStudentsByRoom : (double)affectedStudentsByRoom));
        }
        if (includeZero || this.iAffectedInstructorByRoomWeight != 0.0) {
            info.put("Affected instructors [room]", new Double(weighted ? this.iAffectedInstructorByRoomWeight * (double)affectedInstructorsByRoom : (double)affectedInstructorsByRoom));
        }
        if (includeZero || this.iAffectedStudentByBldgWeight != 0.0) {
            info.put("Affected students [bldg]", new Double(weighted ? this.iAffectedStudentByBldgWeight * (double)affectedStudentsByBldg : (double)affectedStudentsByBldg));
        }
        if (includeZero || this.iAffectedInstructorByBldgWeight != 0.0) {
            info.put("Affected instructors [bldg]", new Double(weighted ? this.iAffectedInstructorByBldgWeight * (double)affectedInstructorsByBldg : (double)affectedInstructorsByBldg));
        }
        if (includeZero || this.iDifferentRoomWeight != 0.0) {
            info.put("Different room", new Double(weighted ? this.iDifferentRoomWeight * (double)differentRoom : (double)differentRoom));
        }
        if (includeZero || this.iDifferentBuildingWeight != 0.0) {
            info.put("Different building", new Double(weighted ? this.iDifferentBuildingWeight * (double)differentBuilding : (double)differentBuilding));
        }
        if (includeZero || this.iDifferentTimeWeight != 0.0) {
            info.put("Different time", new Double(weighted ? this.iDifferentTimeWeight * (double)differentTime : (double)differentTime));
        }
        if (includeZero || this.iDifferentDayWeight != 0.0) {
            info.put("Different day", new Double(weighted ? this.iDifferentDayWeight * (double)differentDay : (double)differentDay));
        }
        if (includeZero || this.iDifferentHourWeight != 0.0) {
            info.put("Different hour", new Double(weighted ? this.iDifferentHourWeight * (double)differentHour : (double)differentHour));
        }
        if (includeZero || this.iTooFarForInstructorsWeight != 0.0) {
            info.put("New placement too far for initial [instructors]", new Double(weighted ? this.iTooFarForInstructorsWeight * (double)tooFarForInstructors : (double)tooFarForInstructors));
        }
        if (includeZero || this.iTooFarForStudentsWeight != 0.0) {
            info.put("New placement too far for initial [students]", new Double(weighted ? this.iTooFarForStudentsWeight * (double)tooFarForStudents : (double)tooFarForStudents));
        }
        if (includeZero || this.iDeltaStudentConflictsWeight != 0.0) {
            info.put("Delta student conflicts", new Double(weighted ? this.iDeltaStudentConflictsWeight * (double)deltaStudentConflicts : (double)deltaStudentConflicts));
        }
        if (includeZero || this.iNewStudentConflictsWeight != 0.0) {
            info.put("New student conflicts", new Double(weighted ? this.iNewStudentConflictsWeight * (double)newStudentConflicts : (double)newStudentConflicts));
        }
        if (includeZero || this.iDeltaTimePreferenceWeight != 0.0) {
            info.put("Delta time preferences", new Double(weighted ? this.iDeltaTimePreferenceWeight * deltaTimePreferences : deltaTimePreferences));
        }
        if (includeZero || this.iDeltaRoomPreferenceWeight != 0.0) {
            info.put("Delta room preferences", new Double(weighted ? this.iDeltaRoomPreferenceWeight * (double)deltaRoomPreferences : (double)deltaRoomPreferences));
        }
        if (includeZero || this.iDeltaInstructorDistancePreferenceWeight != 0.0) {
            info.put("Delta instructor distance preferences", new Double(weighted ? this.iDeltaInstructorDistancePreferenceWeight * (double)deltaInstructorDistancePreferences : (double)deltaInstructorDistancePreferences));
        }
        return info;
    }
}

