/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.Map;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class StudentWorkdayConflict
extends StudentConflict {
    public int getStudentWorkDayLimit() {
        return this.getModel() == null ? -1 : ((TimetableModel)this.getModel()).getStudentWorkDayLimit();
    }

    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return StudentWorkdayConflict.workday(this.getStudentWorkDayLimit(), p1, p2);
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !StudentWorkdayConflict.ignore(l1, l2) && StudentWorkdayConflict.applicable(l1, l2);
    }

    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.WorkDayStudentConflictWeight", 0.2);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrWorkDayStudConfsWeight";
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        super.getInfo(assignment, info);
        double conf = this.getValue(assignment);
        if (conf > 0.0) {
            info.put("Workday student conflicts", sDoubleFormat.format(conf));
        }
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(assignment, info, variables);
        double conf = this.getValue(assignment, variables);
        if (conf > 0.0) {
            info.put("Workday student conflicts", sDoubleFormat.format(conf));
        }
    }
}

