/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.IdConvertor;
import org.cpsolver.coursett.TimetableSaver;
import org.cpsolver.coursett.constraint.ClassLimitConstraint;
import org.cpsolver.coursett.constraint.DiscouragedRoomConstraint;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.IgnoreStudentConflictsConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.MinimizeNumberOfUsedGroupsOfTime;
import org.cpsolver.coursett.constraint.MinimizeNumberOfUsedRoomsConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.constraint.SoftInstructorConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class TimetableXMLSaver
extends TimetableSaver {
    private static Logger sLogger = LogManager.getLogger(TimetableXMLSaver.class);
    private static DecimalFormat[] sDF = new DecimalFormat[]{new DecimalFormat(""), new DecimalFormat("0"), new DecimalFormat("00"), new DecimalFormat("000"), new DecimalFormat("0000"), new DecimalFormat("00000"), new DecimalFormat("000000"), new DecimalFormat("0000000")};
    private static DecimalFormat sStudentWeightFormat = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
    public static boolean ANONYMISE = false;
    private boolean iConvertIds = false;
    private boolean iShowNames = false;
    private File iOutputFolder = new File(((TimetableModel)this.getModel()).getProperties().getProperty("General.Output", "." + File.separator + "output"));
    private boolean iSaveBest = false;
    private boolean iSaveInitial = false;
    private boolean iSaveCurrent = false;
    private boolean iExportStudentSectioning = false;
    private IdConvertor iIdConvertor = null;

    public TimetableXMLSaver(Solver<Lecture, Placement> solver) {
        super(solver);
        this.iShowNames = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Xml.ShowNames", false);
        this.iExportStudentSectioning = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Xml.ExportStudentSectioning", false);
        if (ANONYMISE) {
            this.iConvertIds = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Xml.ConvertIds", true);
            this.iSaveBest = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveBest", false);
            this.iSaveInitial = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveInitial", false);
            this.iSaveCurrent = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveCurrent", true);
        } else {
            this.iConvertIds = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Xml.ConvertIds", false);
            this.iSaveBest = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveBest", true);
            this.iSaveInitial = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveInitial", true);
            this.iSaveCurrent = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveCurrent", true);
        }
    }

    private String getId(String type, String id) {
        if (!this.iConvertIds) {
            return id.toString();
        }
        if (this.iIdConvertor == null) {
            this.iIdConvertor = new IdConvertor(((TimetableModel)this.getModel()).getProperties().getProperty("Xml.IdConv"));
        }
        return this.iIdConvertor.convert(type, id);
    }

    private String getId(String type, Number id) {
        return this.getId(type, id.toString());
    }

    private static String bitset2string(BitSet b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length(); ++i) {
            sb.append(b.get(i) ? "1" : "0");
        }
        return sb.toString();
    }

    public void save() throws Exception {
        this.save(null);
    }

    public Document saveDocument() {
        Document document = DocumentHelper.createDocument();
        document.addComment("University Course Timetabling");
        if (this.iSaveCurrent && this.getAssignment().nrAssignedVariables() != 0) {
            StringBuffer comments = new StringBuffer("Solution Info:\n");
            Map solutionInfo = this.getSolution() == null ? ((TimetableModel)this.getModel()).getExtendedInfo(this.getAssignment()) : this.getSolution().getExtendedInfo();
            for (String key : new TreeSet(solutionInfo.keySet())) {
                String value = (String)solutionInfo.get(key);
                comments.append("    " + key + ": " + value + "\n");
            }
            document.addComment(comments.toString());
        }
        Element root = document.addElement("timetable");
        this.doSave(root);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File outFile) throws Exception {
        if (outFile == null) {
            outFile = new File(this.iOutputFolder, "solution.xml");
        }
        outFile.getParentFile().mkdirs();
        sLogger.debug("Writting XML data to:" + outFile);
        Document document = DocumentHelper.createDocument();
        document.addComment("University Course Timetabling");
        if (this.iSaveCurrent && this.getAssignment().nrAssignedVariables() != 0) {
            StringBuffer comments = new StringBuffer("Solution Info:\n");
            Map solutionInfo = this.getSolution() == null ? ((TimetableModel)this.getModel()).getExtendedInfo(this.getAssignment()) : this.getSolution().getExtendedInfo();
            for (String key : new TreeSet(solutionInfo.keySet())) {
                String value = (String)solutionInfo.get(key);
                comments.append("    " + key + ": " + value + "\n");
            }
            document.addComment(comments.toString());
        }
        Element root = document.addElement("timetable");
        this.doSave(root);
        if (this.iShowNames) {
            Progress.getInstance((Object)this.getModel()).save(root);
            try {
                this.getSolver().getClass().getMethod("save", Element.class).invoke((Object)this.getSolver(), root);
            }
            catch (Exception solutionInfo) {
                // empty catch block
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
            fos.flush();
            fos.close();
            fos = null;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.iConvertIds) {
            this.iIdConvertor.save();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doSave(Element root) {
        Element grEl;
        root.addAttribute("version", "2.5");
        root.addAttribute("initiative", ((TimetableModel)this.getModel()).getProperties().getProperty("Data.Initiative"));
        root.addAttribute("term", ((TimetableModel)this.getModel()).getProperties().getProperty("Data.Term"));
        root.addAttribute("year", String.valueOf(((TimetableModel)this.getModel()).getYear()));
        root.addAttribute("created", String.valueOf(new Date()));
        root.addAttribute("nrDays", String.valueOf(Constants.DAY_CODES.length));
        root.addAttribute("slotsPerDay", String.valueOf(288));
        if (!this.iConvertIds && ((TimetableModel)this.getModel()).getProperties().getProperty("General.SessionId") != null) {
            root.addAttribute("session", ((TimetableModel)this.getModel()).getProperties().getProperty("General.SessionId"));
        }
        if (this.iShowNames && !this.iConvertIds && ((TimetableModel)this.getModel()).getProperties().getProperty("General.SolverGroupId") != null) {
            root.addAttribute("solverGroup", this.getId("solverGroup", ((TimetableModel)this.getModel()).getProperties().getProperty("General.SolverGroupId")));
        }
        HashMap<String, Element> roomElements = new HashMap<String, Element>();
        Element roomsEl = root.addElement("rooms");
        for (RoomConstraint roomConstraint : ((TimetableModel)this.getModel()).getRoomConstraints()) {
            Map travelTimes;
            Element roomEl = roomsEl.addElement("room").addAttribute("id", this.getId("room", roomConstraint.getResourceId()));
            roomEl.addAttribute("constraint", "true");
            if (roomConstraint instanceof DiscouragedRoomConstraint) {
                roomEl.addAttribute("discouraged", "true");
            }
            if (this.iShowNames) {
                roomEl.addAttribute("name", roomConstraint.getRoomName());
            }
            if (!this.iConvertIds && roomConstraint.getBuildingId() != null) {
                roomEl.addAttribute("building", this.getId("bldg", roomConstraint.getBuildingId()));
            }
            roomElements.put(this.getId("room", roomConstraint.getResourceId()), roomEl);
            roomEl.addAttribute("capacity", String.valueOf(roomConstraint.getCapacity()));
            if (roomConstraint.getPosX() != null && roomConstraint.getPosY() != null) {
                roomEl.addAttribute("location", roomConstraint.getPosX() + "," + roomConstraint.getPosY());
            }
            if (roomConstraint.getIgnoreTooFar()) {
                roomEl.addAttribute("ignoreTooFar", "true");
            }
            if (!roomConstraint.getConstraint()) {
                roomEl.addAttribute("fake", "true");
            }
            if (roomConstraint.getSharingModel() != null) {
                RoomSharingModel sharingModel = roomConstraint.getSharingModel();
                Element sharingEl = roomEl.addElement("sharing");
                sharingEl.addElement("pattern").addAttribute("unit", String.valueOf(sharingModel.getStep())).setText(sharingModel.getPreferences());
                sharingEl.addElement("freeForAll").addAttribute("value", String.valueOf(sharingModel.getFreeForAllPrefChar()));
                sharingEl.addElement("notAvailable").addAttribute("value", String.valueOf(sharingModel.getNotAvailablePrefChar()));
                for (Long id : sharingModel.getDepartmentIds()) {
                    sharingEl.addElement("department").addAttribute("value", String.valueOf(sharingModel.getCharacter(id))).addAttribute("id", this.getId("dept", id));
                }
            }
            if (roomConstraint.getType() != null && this.iShowNames) {
                roomEl.addAttribute("type", roomConstraint.getType().toString());
            }
            if ((travelTimes = (Map)((TimetableModel)this.getModel()).getDistanceMetric().getTravelTimes().get(roomConstraint.getResourceId())) == null) continue;
            for (Map.Entry entry : travelTimes.entrySet()) {
                roomEl.addElement("travel-time").addAttribute("id", this.getId("room", (Number)entry.getKey())).addAttribute("minutes", ((Integer)entry.getValue()).toString());
            }
        }
        Element instructorsEl = root.addElement("instructors");
        Element departmentsEl = root.addElement("departments");
        HashMap<Long, String> depts = new HashMap<Long, String>();
        Element configsEl = this.iShowNames ? root.addElement("configurations") : null;
        HashSet<Configuration> configs = new HashSet<Configuration>();
        Element element = root.addElement("classes");
        HashMap<Long, Element> classElements = new HashMap<Long, Element>();
        ArrayList vars = new ArrayList(((TimetableModel)this.getModel()).variables());
        if (((TimetableModel)this.getModel()).hasConstantVariables()) {
            vars.addAll(((TimetableModel)this.getModel()).constantVariables());
        }
        for (Lecture lecture : vars) {
            void var14_27;
            Placement placement = (Placement)this.getAssignment().getValue((Variable)lecture);
            if (lecture.isCommitted() && placement == null) {
                Placement placement2 = (Placement)lecture.getInitialAssignment();
            }
            Placement initialPlacement = (Placement)lecture.getInitialAssignment();
            Placement bestPlacement = (Placement)lecture.getBestAssignment();
            Element element2 = element.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId()));
            classElements.put(lecture.getClassId(), element2);
            if (this.iShowNames && lecture.getNote() != null) {
                element2.addAttribute("note", lecture.getNote());
            }
            if (this.iShowNames && !lecture.isCommitted()) {
                element2.addAttribute("ord", String.valueOf(lecture.getOrd()));
            }
            if (lecture.getWeight() != 1.0) {
                element2.addAttribute("weight", String.valueOf(lecture.getWeight()));
            }
            if (this.iShowNames && lecture.getSolverGroupId() != null) {
                element2.addAttribute("solverGroup", this.getId("solverGroup", lecture.getSolverGroupId()));
            }
            if (lecture.getParent() == null && lecture.getConfiguration() != null) {
                if (!this.iShowNames) {
                    element2.addAttribute("offering", this.getId("offering", lecture.getConfiguration().getOfferingId().toString()));
                }
                element2.addAttribute("config", this.getId("config", lecture.getConfiguration().getConfigId().toString()));
                if (this.iShowNames && configs.add(lecture.getConfiguration())) {
                    configsEl.addElement("config").addAttribute("id", this.getId("config", lecture.getConfiguration().getConfigId().toString())).addAttribute("limit", String.valueOf(lecture.getConfiguration().getLimit())).addAttribute("offering", this.getId("offering", lecture.getConfiguration().getOfferingId().toString()));
                }
            }
            element2.addAttribute("committed", lecture.isCommitted() ? "true" : "false");
            if (lecture.getParent() != null) {
                element2.addAttribute("parent", this.getId("class", lecture.getParent().getClassId()));
            }
            if (lecture.getSchedulingSubpartId() != null) {
                element2.addAttribute("subpart", this.getId("subpart", lecture.getSchedulingSubpartId()));
            }
            if (this.iShowNames && lecture.isCommitted() && var14_27 != null && var14_27.getAssignmentId() != null) {
                element2.addAttribute("assignment", this.getId("assignment", var14_27.getAssignmentId()));
            }
            if (!lecture.isCommitted()) {
                if (lecture.minClassLimit() == lecture.maxClassLimit()) {
                    element2.addAttribute("classLimit", String.valueOf(lecture.maxClassLimit()));
                } else {
                    element2.addAttribute("minClassLimit", String.valueOf(lecture.minClassLimit()));
                    element2.addAttribute("maxClassLimit", String.valueOf(lecture.maxClassLimit()));
                }
                if (lecture.roomToLimitRatio() != 1.0) {
                    element2.addAttribute("roomToLimitRatio", sStudentWeightFormat.format(lecture.roomToLimitRatio()));
                }
            }
            if (lecture.getNrRooms() != 1) {
                element2.addAttribute("nrRooms", String.valueOf(lecture.getNrRooms()));
            }
            if (lecture.getNrRooms() > 1 && lecture.getMaxRoomCombinations() > 0) {
                element2.addAttribute("maxRoomCombinations", String.valueOf(lecture.getMaxRoomCombinations()));
            }
            if (this.iShowNames) {
                element2.addAttribute("name", lecture.getName());
            }
            if (lecture.getDeptSpreadConstraint() != null) {
                element2.addAttribute("department", this.getId("dept", lecture.getDeptSpreadConstraint().getDepartmentId()));
                depts.put(lecture.getDeptSpreadConstraint().getDepartmentId(), lecture.getDeptSpreadConstraint().getName());
            }
            if (lecture.getScheduler() != null) {
                element2.addAttribute("scheduler", this.getId("dept", lecture.getScheduler()));
            }
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                Element instrEl = element2.addElement("instructor").addAttribute("id", this.getId("inst", ic.getResourceId()));
                if ((lecture.isCommitted() || this.iSaveCurrent) && var14_27 != null) {
                    instrEl.addAttribute("solution", "true");
                }
                if (this.iSaveInitial && initialPlacement != null) {
                    instrEl.addAttribute("initial", "true");
                }
                if (!this.iSaveBest || bestPlacement == null || bestPlacement.equals(var14_27)) continue;
                instrEl.addAttribute("best", "true");
            }
            for (RoomLocation rl : lecture.roomLocations()) {
                Element roomLocationEl = element2.addElement("room");
                roomLocationEl.addAttribute("id", this.getId("room", rl.getId()));
                roomLocationEl.addAttribute("pref", String.valueOf(rl.getPreference()));
                if ((lecture.isCommitted() || this.iSaveCurrent) && var14_27 != null && var14_27.hasRoomLocation(rl.getId())) {
                    roomLocationEl.addAttribute("solution", "true");
                }
                if (this.iSaveInitial && initialPlacement != null && initialPlacement.hasRoomLocation(rl.getId())) {
                    roomLocationEl.addAttribute("initial", "true");
                }
                if (this.iSaveBest && bestPlacement != null && !bestPlacement.equals(var14_27) && bestPlacement.hasRoomLocation(rl.getId())) {
                    roomLocationEl.addAttribute("best", "true");
                }
                if (roomElements.containsKey(this.getId("room", rl.getId()))) continue;
                Element element3 = roomsEl.addElement("room").addAttribute("id", this.getId("room", rl.getId()));
                element3.addAttribute("constraint", "false");
                if (!this.iConvertIds && rl.getBuildingId() != null) {
                    element3.addAttribute("building", this.getId("bldg", rl.getBuildingId()));
                }
                if (this.iShowNames) {
                    element3.addAttribute("name", rl.getName());
                }
                roomElements.put(this.getId("room", rl.getId()), element3);
                element3.addAttribute("capacity", String.valueOf(rl.getRoomSize()));
                if (rl.getPosX() != null && rl.getPosY() != null) {
                    element3.addAttribute("location", rl.getPosX() + "," + rl.getPosY());
                }
                if (!rl.getIgnoreTooFar()) continue;
                element3.addAttribute("ignoreTooFar", "true");
            }
            boolean first = true;
            HashSet<Long> dp = new HashSet<Long>();
            for (TimeLocation timeLocation : lecture.timeLocations()) {
                Element element4 = element2.addElement("time");
                element4.addAttribute("days", sDF[7].format(Long.parseLong(Integer.toBinaryString(timeLocation.getDayCode()))));
                element4.addAttribute("start", String.valueOf(timeLocation.getStartSlot()));
                element4.addAttribute("length", String.valueOf(timeLocation.getLength()));
                element4.addAttribute("breakTime", String.valueOf(timeLocation.getBreakTime()));
                if (this.iShowNames) {
                    element4.addAttribute("pref", String.valueOf(timeLocation.getPreference()));
                    element4.addAttribute("npref", String.valueOf(timeLocation.getNormalizedPreference()));
                } else {
                    element4.addAttribute("pref", String.valueOf(timeLocation.getNormalizedPreference()));
                }
                if (!this.iConvertIds && timeLocation.getTimePatternId() != null) {
                    element4.addAttribute("pattern", this.getId("pat", timeLocation.getTimePatternId()));
                }
                if (timeLocation.getDatePatternId() != null && dp.add(timeLocation.getDatePatternId())) {
                    Element dateEl = element2.addElement("date");
                    dateEl.addAttribute("id", this.getId("dpat", String.valueOf(timeLocation.getDatePatternId())));
                    if (this.iShowNames) {
                        dateEl.addAttribute("name", timeLocation.getDatePatternName());
                    }
                    dateEl.addAttribute("pattern", TimetableXMLSaver.bitset2string(timeLocation.getWeekCode()));
                }
                if (timeLocation.getDatePatternPreference() != 0) {
                    element4.addAttribute("datePref", String.valueOf(timeLocation.getDatePatternPreference()));
                }
                if (timeLocation.getTimePatternId() == null && first) {
                    if (this.iShowNames) {
                        element2.addAttribute("datePatternName", timeLocation.getDatePatternName());
                    }
                    element2.addAttribute("dates", TimetableXMLSaver.bitset2string(timeLocation.getWeekCode()));
                    first = false;
                }
                if (timeLocation.getDatePatternId() != null) {
                    element4.addAttribute("date", this.getId("dpat", String.valueOf(timeLocation.getDatePatternId())));
                }
                if ((lecture.isCommitted() || this.iSaveCurrent) && var14_27 != null && var14_27.getTimeLocation().equals(timeLocation)) {
                    element4.addAttribute("solution", "true");
                }
                if (this.iSaveInitial && initialPlacement != null && initialPlacement.getTimeLocation().equals(timeLocation)) {
                    element4.addAttribute("initial", "true");
                }
                if (!this.iSaveBest || bestPlacement == null || bestPlacement.equals(var14_27) || !bestPlacement.getTimeLocation().equals(timeLocation)) continue;
                element4.addAttribute("best", "true");
            }
        }
        for (InstructorConstraint instructorConstraint : ((TimetableModel)this.getModel()).getInstructorConstraints()) {
            if (this.iShowNames || instructorConstraint.isIgnoreDistances() || instructorConstraint instanceof SoftInstructorConstraint) {
                Element element5 = instructorsEl.addElement("instructor").addAttribute("id", this.getId("inst", instructorConstraint.getResourceId()));
                if (this.iShowNames) {
                    if (instructorConstraint.getPuid() != null && instructorConstraint.getPuid().length() > 0) {
                        element5.addAttribute("puid", instructorConstraint.getPuid());
                    }
                    element5.addAttribute("name", instructorConstraint.getName());
                    if (instructorConstraint.getType() != null && this.iShowNames) {
                        element5.addAttribute("type", instructorConstraint.getType().toString());
                    }
                }
                if (instructorConstraint.isIgnoreDistances()) {
                    element5.addAttribute("ignDist", "true");
                }
                if (instructorConstraint instanceof SoftInstructorConstraint) {
                    element5.addAttribute("soft", "true");
                }
            }
            if (instructorConstraint.getUnavailabilities() == null) continue;
            for (Placement placement : instructorConstraint.getUnavailabilities()) {
                Lecture lecture = (Lecture)placement.variable();
                Element element6 = (Element)classElements.get(lecture.getClassId());
                element6.addElement("instructor").addAttribute("id", this.getId("inst", instructorConstraint.getResourceId())).addAttribute("solution", "true");
            }
        }
        if (instructorsEl.elements().isEmpty()) {
            root.remove(instructorsEl);
        }
        Element grConstraintsEl = root.addElement("groupConstraints");
        for (GroupConstraint groupConstraint : ((TimetableModel)this.getModel()).getGroupConstraints()) {
            grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(groupConstraint.getId())));
            grEl.addAttribute("type", groupConstraint.getType().reference());
            grEl.addAttribute("pref", groupConstraint.getPrologPreference());
            for (Lecture lecture : groupConstraint.variables()) {
                grEl.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId()));
            }
        }
        for (SpreadConstraint spreadConstraint : ((TimetableModel)this.getModel()).getSpreadConstraints()) {
            grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(spreadConstraint.getId())));
            grEl.addAttribute("type", "SPREAD");
            grEl.addAttribute("pref", "R");
            if (this.iShowNames) {
                grEl.addAttribute("name", spreadConstraint.getName());
            }
            for (Lecture lecture : spreadConstraint.variables()) {
                grEl.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId()));
            }
        }
        for (Constraint constraint : ((TimetableModel)this.getModel()).constraints()) {
            if (constraint instanceof MinimizeNumberOfUsedRoomsConstraint) {
                grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(constraint.getId())));
                grEl.addAttribute("type", "MIN_ROOM_USE");
                grEl.addAttribute("pref", "R");
                for (Lecture lecture : constraint.variables()) {
                    grEl.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId()));
                }
            }
            if (constraint instanceof MinimizeNumberOfUsedGroupsOfTime) {
                grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(constraint.getId())));
                grEl.addAttribute("type", ((MinimizeNumberOfUsedGroupsOfTime)constraint).getConstraintName());
                grEl.addAttribute("pref", "R");
                for (Lecture lecture : constraint.variables()) {
                    grEl.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId()));
                }
            }
            if (!(constraint instanceof IgnoreStudentConflictsConstraint)) continue;
            grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(constraint.getId())));
            grEl.addAttribute("type", "NO_CONFLICT");
            grEl.addAttribute("pref", "R");
            for (Lecture lecture : constraint.variables()) {
                grEl.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId()));
            }
        }
        for (ClassLimitConstraint classLimitConstraint : ((TimetableModel)this.getModel()).getClassLimitConstraints()) {
            grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(classLimitConstraint.getId())));
            grEl.addAttribute("type", "CLASS_LIMIT");
            grEl.addAttribute("pref", "R");
            if (classLimitConstraint.getParentLecture() != null) {
                grEl.addElement("parentClass").addAttribute("id", this.getId("class", classLimitConstraint.getParentLecture().getClassId()));
            } else {
                grEl.addAttribute("courseLimit", String.valueOf(classLimitConstraint.classLimit() - classLimitConstraint.getClassLimitDelta()));
            }
            if (classLimitConstraint.getClassLimitDelta() != 0) {
                grEl.addAttribute("delta", String.valueOf(classLimitConstraint.getClassLimitDelta()));
            }
            if (this.iShowNames) {
                grEl.addAttribute("name", classLimitConstraint.getName());
            }
            for (Lecture lecture : classLimitConstraint.variables()) {
                grEl.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId()));
            }
        }
        for (FlexibleConstraint flexibleConstraint : ((TimetableModel)this.getModel()).getFlexibleConstraints()) {
            Element flEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(flexibleConstraint.getId())));
            flEl.addAttribute("reference", flexibleConstraint.getReference());
            flEl.addAttribute("owner", flexibleConstraint.getOwner());
            flEl.addAttribute("pref", flexibleConstraint.getPrologPreference());
            flEl.addAttribute("type", flexibleConstraint.getType().toString());
            for (Lecture lecture : flexibleConstraint.variables()) {
                flEl.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId()));
            }
        }
        HashMap<Student, ArrayList<String>> hashMap = new HashMap<Student, ArrayList<String>>();
        for (Lecture lecture : vars) {
            for (Student student : lecture.students()) {
                ArrayList<String> enrls = (ArrayList<String>)hashMap.get(student);
                if (enrls == null) {
                    enrls = new ArrayList<String>();
                    hashMap.put(student, enrls);
                }
                enrls.add(this.getId("class", lecture.getClassId()));
            }
        }
        Element element7 = root.addElement("students");
        Element groupsEl = root.addElement("groups");
        HashMap<StudentGroup, Element> groups = new HashMap<StudentGroup, Element>();
        for (Student student : new TreeSet(hashMap.keySet())) {
            Map<Long, Set<Lecture>> canNotEnroll;
            Element stEl = element7.addElement("student").addAttribute("id", this.getId("student", student.getId()));
            if (this.iShowNames) {
                if (student.getAcademicArea() != null) {
                    stEl.addAttribute("area", student.getAcademicArea());
                }
                if (student.getAcademicClassification() != null) {
                    stEl.addAttribute("classification", student.getAcademicClassification());
                }
                if (student.getMajor() != null) {
                    stEl.addAttribute("major", student.getMajor());
                }
                if (student.getCurriculum() != null) {
                    stEl.addAttribute("curriculum", student.getCurriculum());
                }
            }
            for (Map.Entry entry : student.getOfferingsMap().entrySet()) {
                Long altId;
                Double priority;
                Long l = (Long)entry.getKey();
                Double weight = (Double)entry.getValue();
                Element offEl = stEl.addElement("offering").addAttribute("id", this.getId("offering", l.toString()));
                if (weight != 1.0) {
                    offEl.addAttribute("weight", sStudentWeightFormat.format(weight));
                }
                if ((priority = student.getPriority(l)) != null) {
                    offEl.addAttribute("priority", priority.toString());
                }
                if ((altId = student.getAlternative(l)) == null) continue;
                offEl.addAttribute("alternative", altId.toString());
            }
            if (this.iExportStudentSectioning || ((TimetableModel)this.getModel()).nrUnassignedVariables(this.getAssignment()) == 0 || student.getOfferingsMap().isEmpty()) {
                List lectures = (List)hashMap.get(student);
                Collections.sort(lectures);
                for (String string : lectures) {
                    stEl.addElement("class").addAttribute("id", string);
                }
            }
            if ((canNotEnroll = student.canNotEnrollSections()) != null) {
                for (Set<Lecture> set : canNotEnroll.values()) {
                    Iterator<Lecture> i3 = set.iterator();
                    while (i3.hasNext()) {
                        stEl.addElement("prohibited-class").addAttribute("id", this.getId("class", i3.next().getClassId()));
                    }
                }
            }
            if (student.getCommitedPlacements() != null) {
                for (Placement placement : student.getCommitedPlacements()) {
                    stEl.addElement("class").addAttribute("id", this.getId("class", ((Lecture)placement.variable()).getClassId()));
                }
            }
            if (student.getInstructor() != null) {
                stEl.addAttribute("instructor", this.getId("inst", student.getInstructor().getResourceId()));
            }
            for (StudentGroup studentGroup : student.getGroups()) {
                Element groupEl = (Element)groups.get(studentGroup);
                if (groupEl == null) {
                    groupEl = groupsEl.addElement("group");
                    groupEl.addAttribute("id", this.getId("group", studentGroup.getId()));
                    if (studentGroup.getWeight() != 1.0) {
                        groupEl.addAttribute("weight", String.valueOf(studentGroup.getWeight()));
                    }
                    if (this.iShowNames && studentGroup.getName() != null) {
                        groupEl.addAttribute("name", studentGroup.getName());
                    }
                    groups.put(studentGroup, groupEl);
                }
                groupEl.addElement("student").addAttribute("id", this.getId("student", student.getId()));
            }
        }
        if (((TimetableModel)this.getModel()).getProperties().getPropertyInt("MPP.GenTimePert", 0) > 0) {
            Element element8 = root.addElement("perturbations");
            int nrChanges = ((TimetableModel)this.getModel()).getProperties().getPropertyInt("MPP.GenTimePert", 0);
            ArrayList<Lecture> lectures = new ArrayList<Lecture>();
            while (lectures.size() < nrChanges) {
                Lecture lecture = (Lecture)((Object)ToolBox.random((Collection)this.getAssignment().assignedVariables()));
                if (lecture.isCommitted() || lecture.timeLocations().size() <= 1 || lectures.contains((Object)lecture)) continue;
                Placement placement = (Placement)this.getAssignment().getValue((Variable)lecture);
                TimeLocation timeLocation = placement.getTimeLocation();
                element8.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId())).addAttribute("days", sDF[7].format(Long.parseLong(Integer.toBinaryString(timeLocation.getDayCode())))).addAttribute("start", String.valueOf(timeLocation.getStartSlot())).addAttribute("length", String.valueOf(timeLocation.getLength()));
                lectures.add(lecture);
            }
        }
        for (Map.Entry entry : depts.entrySet()) {
            Long id = (Long)entry.getKey();
            String name = (String)entry.getValue();
            if (!this.iShowNames) continue;
            departmentsEl.addElement("department").addAttribute("id", this.getId("dept", id.toString())).addAttribute("name", name);
        }
        if (departmentsEl.elements().isEmpty()) {
            root.remove(departmentsEl);
        }
    }
}

