/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics;

import org.cpsolver.ifs.heuristics.RouletteWheelSelection;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class RouletteWheelRequestSelection
implements VariableSelection<Request, Enrollment> {
    RouletteWheelSelection<Request> iRoulette = null;

    public RouletteWheelRequestSelection(DataProperties properties) {
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
    }

    protected RouletteWheelSelection<Request> getRoulette(Solution<Request, Enrollment> solution) {
        if (this.iRoulette != null && this.iRoulette.hasMoreElements() && this.iRoulette.getUsedPoints() < 0.1 * this.iRoulette.getTotalPoints()) {
            return this.iRoulette;
        }
        this.iRoulette = new RouletteWheelSelection();
        for (Request request : ((StudentSectioningModel)solution.getModel()).variables()) {
            double points = 0.0;
            if (solution.getAssignment().getValue(request) == null) {
                points += 10.0;
            } else {
                Enrollment enrollment = solution.getAssignment().getValue(request);
                if (enrollment.toDouble(solution.getAssignment()) > request.getBound()) {
                    points += 1.0;
                }
            }
            if (!(points > 0.0)) continue;
            this.iRoulette.add(request, points);
        }
        return this.iRoulette;
    }

    @Override
    public synchronized Request selectVariable(Solution<Request, Enrollment> solution) {
        return this.getRoulette(solution).nextElement();
    }
}

