/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.report.StudentSectioningReport;

public class RequestPriorityTable
implements StudentSectioningReport {
    private StudentSectioningModel iModel = null;

    public RequestPriorityTable(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    @Override
    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("__Student"), new CSVFile.CSVField("Student"), new CSVFile.CSVField("Course"), new CSVFile.CSVField("Alternative"), new CSVFile.CSVField("Enrolled"), new CSVFile.CSVField("Primary"), new CSVFile.CSVField("Priority"), new CSVFile.CSVField("Alternativity")});
        for (Student student : this.getModel().getStudents()) {
            if (student.isDummy()) continue;
            int regPriority = 1;
            int altPriority = 1;
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                Enrollment e = cr.getAssignment(assignment);
                int primary = cr.isAlternative() ? 0 : 1;
                int priority = 0;
                priority = cr.isAlternative() ? altPriority++ : regPriority++;
                int alternativity = 0;
                for (Course course : cr.getCourses()) {
                    int alternative = primary == 0 || alternativity > 0 ? 1 : 0;
                    int enrolled = e != null && e.getCourse().equals(course) ? 1 : 0;
                    csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(student.getId()), new CSVFile.CSVField(student.getExternalId()), new CSVFile.CSVField(cr.getCourses().get(alternativity).getName()), new CSVFile.CSVField(alternative), new CSVFile.CSVField(enrolled), new CSVFile.CSVField(primary), new CSVFile.CSVField(priority), new CSVFile.CSVField(alternativity)});
                    ++alternativity;
                }
            }
        }
        return csv;
    }
}

