/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.heuristics.studentord.StudentChoiceRealFirstOrder;
import org.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class PriorityConstructionSelection
implements NeighbourSelection<Request, Enrollment> {
    private static Logger sLog = Logger.getLogger(PriorityConstructionSelection.class);
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    private int iCycle = 0;
    private int iMaxCycles = 7;
    private boolean iImproved = false;
    private boolean iSkip = false;
    private BranchBoundSelection iBranchBoundSelection = null;
    protected Iterator<Student> iStudentsEnumeration = null;
    protected StudentOrder iOrder = new StudentChoiceRealFirstOrder();
    protected List<Student> iStudents = null;

    public PriorityConstructionSelection(DataProperties properties) {
        this.iBranchBoundSelection = new BranchBoundSelection(properties);
        if (properties.getProperty("Neighbour.PriorityConstructionOrder") != null) {
            try {
                this.iOrder = (StudentOrder)Class.forName(properties.getProperty("Neighbour.PriorityConstructionOrder")).getConstructor(DataProperties.class).newInstance(properties);
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to set student order, reason:" + e.getMessage()), (Throwable)e);
            }
        }
        this.iMaxCycles = properties.getPropertyInteger("Neighbour.PriorityConstructionCycles", this.iMaxCycles);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.iCycle = 1;
        this.iImproved = false;
        boolean bl = this.iSkip = !solver.currentSolution().getModel().assignedVariables(solver.currentSolution().getAssignment()).isEmpty();
        if (this.iSkip) {
            this.iBranchBoundSelection.init(solver);
        } else {
            this.iStudents = this.iOrder.order(((StudentSectioningModel)solver.currentSolution().getModel()).getStudents());
            this.iStudentsEnumeration = this.iStudents.iterator();
            this.iBranchBoundSelection.init(solver, "Construction[" + this.iCycle + "]...");
        }
    }

    public Neighbour<Request, Enrollment> branchAndBound(Solution<Request, Enrollment> solution) {
        while (this.iStudentsEnumeration.hasNext()) {
            Student student = this.iStudentsEnumeration.next();
            Progress.getInstance(solution.getModel()).incProgress();
            BranchBoundSelection.BranchBoundNeighbour neighbour = this.iBranchBoundSelection.getSelection(solution.getAssignment(), student).select();
            if (neighbour == null) continue;
            return neighbour;
        }
        return null;
    }

    protected void nextCycle(Solution<Request, Enrollment> solution) {
        ++this.iCycle;
        this.iImproved = false;
        sLog.debug((Object)("Assigning up to " + this.iCycle + " requests..."));
        StudentSectioningModel m = (StudentSectioningModel)solution.getModel();
        double tv = m.getTotalValue(solution.getAssignment(), true);
        sLog.debug((Object)("**CURR** " + solution.getModel().toString() + ", TM:" + sDF.format(solution.getTime() / 3600.0) + "h, TV:" + sDF.format(-tv) + " (" + sDF.format(-100.0 * tv / (double)m.getStudents().size()) + "%)"));
        this.iStudentsEnumeration = this.iStudents.iterator();
        Progress.getInstance(solution.getModel()).setPhase("Construction[" + this.iCycle + "]...", this.iStudents.size());
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        if (this.iSkip) {
            return this.iBranchBoundSelection.selectNeighbour(solution);
        }
        Neighbour<Request, Enrollment> n = this.branchAndBound(solution);
        if (n == null) {
            if (this.iCycle == this.iMaxCycles || !this.iImproved) {
                return null;
            }
            this.nextCycle(solution);
            n = this.branchAndBound(solution);
        }
        return n == null ? null : new ConstructionNeighbour((BranchBoundSelection.BranchBoundNeighbour)n);
    }

    public class ConstructionNeighbour
    implements Neighbour<Request, Enrollment> {
        private BranchBoundSelection.BranchBoundNeighbour iNeighbour;

        public ConstructionNeighbour(BranchBoundSelection.BranchBoundNeighbour neighbour) {
            this.iNeighbour = neighbour;
        }

        @Override
        public void assign(Assignment<Request, Enrollment> assignment, long iteration) {
            if (PriorityConstructionSelection.this.iCycle >= PriorityConstructionSelection.this.iMaxCycles) {
                this.iNeighbour.assign(assignment, iteration);
                return;
            }
            for (Request r : this.iNeighbour.getStudent().getRequests()) {
                assignment.unassign(iteration, r);
            }
            int n = PriorityConstructionSelection.this.iCycle;
            for (int i = 0; i < this.iNeighbour.getAssignment().length; ++i) {
                if (this.iNeighbour.getAssignment()[i] != null) {
                    assignment.assign(iteration, this.iNeighbour.getAssignment()[i]);
                    --n;
                }
                if (n != 0) continue;
                PriorityConstructionSelection.this.iImproved = true;
                break;
            }
        }

        @Override
        public double value(Assignment<Request, Enrollment> assignment) {
            return this.iNeighbour.value(assignment);
        }

        public String toString() {
            int n = PriorityConstructionSelection.this.iCycle;
            StringBuffer sb = new StringBuffer("B&B[" + n + "]{ " + this.iNeighbour.getStudent() + " " + sDF.format(-this.value((Assignment<Request, Enrollment>)null) * 100.0) + "%");
            int idx = 0;
            for (Request request : this.iNeighbour.getStudent().getRequests()) {
                sb.append("\n  " + request);
                Enrollment enrollment = this.iNeighbour.getAssignment()[idx];
                if (enrollment == null) {
                    sb.append("  -- not assigned");
                } else {
                    sb.append("  -- " + enrollment);
                    --n;
                }
                if (n == 0) break;
                ++idx;
            }
            sb.append("\n}");
            return sb.toString();
        }

        @Override
        public Map<Request, Enrollment> assignments() {
            HashMap<Request, Enrollment> ret = new HashMap<Request, Enrollment>();
            if (PriorityConstructionSelection.this.iCycle >= PriorityConstructionSelection.this.iMaxCycles) {
                return this.iNeighbour.assignments();
            }
            for (Request r : this.iNeighbour.getStudent().getRequests()) {
                ret.put(r, null);
            }
            int n = PriorityConstructionSelection.this.iCycle;
            for (int i = 0; i < this.iNeighbour.getAssignment().length; ++i) {
                if (this.iNeighbour.getAssignment()[i] != null) {
                    ret.put((Request)this.iNeighbour.getAssignment()[i].variable(), this.iNeighbour.getAssignment()[i]);
                    --n;
                }
                if (n != 0) continue;
                PriorityConstructionSelection.this.iImproved = true;
                break;
            }
            return ret;
        }
    }
}

