/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.check;

import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;

public class SectionLimitCheck {
    private static Logger sLog = Logger.getLogger(SectionLimitCheck.class);
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private StudentSectioningModel iModel;

    public SectionLimitCheck(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public boolean check(Assignment<Request, Enrollment> assignment) {
        sLog.info((Object)"Checking section limits...");
        boolean ret = true;
        for (Offering offering : this.getModel().getOfferings()) {
            for (Config config : offering.getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        if (section.getLimit() < 0) continue;
                        double used = section.getEnrollmentWeight(assignment, null);
                        if (used - section.getMaxEnrollmentWeight(assignment) > (double)section.getLimit()) {
                            sLog.error((Object)("Section " + section.getName() + " exceeds its limit " + sDF.format(used) + ">" + section.getLimit() + " for more than one student (W:" + section.getMaxEnrollmentWeight(assignment) + ")"));
                            ret = false;
                            continue;
                        }
                        if (Math.round(used) <= (long)section.getLimit()) continue;
                        sLog.debug((Object)("Section " + section.getName() + " exceeds its limit " + sDF.format(used) + ">" + section.getLimit() + " for less than one student (W:" + section.getMaxEnrollmentWeight(assignment) + ")"));
                    }
                }
            }
        }
        return ret;
    }
}

