/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;

public class OnlineSectioningCriterion
implements MultiCriteriaBranchAndBoundSelection.SelectionCriterion {
    private Hashtable<CourseRequest, Set<Section>> iPreferredSections = null;
    private List<TimeToAvoid> iTimesToAvoid = null;
    private OnlineSectioningModel iModel;
    private Student iStudent;
    protected double[] iQalityWeights;

    public OnlineSectioningCriterion(Student student, OnlineSectioningModel model, Assignment<Request, Enrollment> assignment, Hashtable<CourseRequest, Set<Section>> preferredSections) {
        this.iStudent = student;
        this.iModel = model;
        this.iPreferredSections = preferredSections;
        if (model.getProperties().getPropertyBoolean("OnlineStudentSectioning.TimesToAvoidHeuristics", true)) {
            this.iTimesToAvoid = new ArrayList<TimeToAvoid>();
            for (Request r : this.iStudent.getRequests()) {
                if (r instanceof CourseRequest) {
                    List<Enrollment> enrollments = ((CourseRequest)r).getAvaiableEnrollmentsSkipSameTime(assignment);
                    if (enrollments.size() > 5) continue;
                    int penalty = (7 - enrollments.size()) * (r.isAlternative() ? 1 : 7 - enrollments.size());
                    for (Enrollment enrollment : enrollments) {
                        for (Section section : enrollment.getSections()) {
                            if (section.getTime() == null) continue;
                            this.iTimesToAvoid.add(new TimeToAvoid(section.getTime(), penalty, r.getPriority()));
                        }
                    }
                    continue;
                }
                if (!(r instanceof FreeTimeRequest)) continue;
                this.iTimesToAvoid.add(new TimeToAvoid(((FreeTimeRequest)r).getTime(), 1, Integer.MAX_VALUE));
            }
            for (Unavailability unavailability : this.iStudent.getUnavailabilities()) {
                if (unavailability.getTime() == null) continue;
                this.iTimesToAvoid.add(new TimeToAvoid(unavailability.getTime(), 1, Integer.MAX_VALUE));
            }
        }
        this.iQalityWeights = new double[StudentQuality.Type.values().length];
        for (StudentQuality.Type type : StudentQuality.Type.values()) {
            this.iQalityWeights[type.ordinal()] = model.getProperties().getPropertyDouble(type.getWeightName(), type.getWeightDefault());
        }
    }

    protected OnlineSectioningModel getModel() {
        return this.iModel;
    }

    protected Student getStudent() {
        return this.iStudent;
    }

    protected Set<Section> getPreferredSections(Request request) {
        return this.iPreferredSections.get(request);
    }

    protected List<TimeToAvoid> getTimesToAvoid() {
        return this.iTimesToAvoid;
    }

    public Set<DistanceConflict.Conflict> getDistanceConflicts(Enrollment[] assignment, int idx) {
        if (this.getModel().getDistanceConflict() == null || assignment[idx] == null) {
            return null;
        }
        Set<DistanceConflict.Conflict> dist = this.getModel().getDistanceConflict().conflicts(assignment[idx]);
        for (int x = 0; x < idx; ++x) {
            if (assignment[x] == null) continue;
            dist.addAll(this.getModel().getDistanceConflict().conflicts(assignment[x], assignment[idx]));
        }
        return dist;
    }

    public Set<TimeOverlapsCounter.Conflict> getTimeOverlappingConflicts(Enrollment[] assignment, int idx) {
        if (this.getModel().getTimeOverlaps() == null || assignment[idx] == null) {
            return null;
        }
        HashSet<TimeOverlapsCounter.Conflict> overlaps = new HashSet<TimeOverlapsCounter.Conflict>();
        for (int x = 0; x < idx; ++x) {
            if (assignment[x] != null) {
                overlaps.addAll(this.getModel().getTimeOverlaps().conflicts(assignment[x], assignment[idx]));
                continue;
            }
            if (!(this.getStudent().getRequests().get(x) instanceof FreeTimeRequest)) continue;
            overlaps.addAll(this.getModel().getTimeOverlaps().conflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x)).createEnrollment(), assignment[idx]));
        }
        overlaps.addAll(this.getModel().getTimeOverlaps().notAvailableTimeConflicts(assignment[idx]));
        return overlaps;
    }

    public Set<StudentQuality.Conflict> getStudentQualityConflicts(Enrollment[] assignment, int idx) {
        if (this.getModel().getStudentQuality() == null || assignment[idx] == null) {
            return null;
        }
        HashSet<StudentQuality.Conflict> conflicts = new HashSet<StudentQuality.Conflict>();
        for (StudentQuality.Type t : StudentQuality.Type.values()) {
            for (int x = 0; x < idx; ++x) {
                if (assignment[x] == null) continue;
                conflicts.addAll(this.getModel().getStudentQuality().conflicts(t, assignment[x], assignment[idx]));
            }
            conflicts.addAll(this.getModel().getStudentQuality().conflicts(t, assignment[idx]));
        }
        return conflicts;
    }

    @Deprecated
    protected double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<DistanceConflict.Conflict> distanceConflicts, Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts) {
        double weight = -this.getModel().getStudentWeights().getWeight(assignment, enrollment);
        if (distanceConflicts != null) {
            for (DistanceConflict.Conflict conflict : distanceConflicts) {
                Enrollment other = conflict.getE1().equals(enrollment) ? conflict.getE2() : conflict.getE1();
                if (other.getRequest().getPriority() > enrollment.getRequest().getPriority()) continue;
                weight += this.getModel().getStudentWeights().getDistanceConflictWeight(assignment, conflict);
            }
        }
        if (timeOverlappingConflicts != null) {
            for (TimeOverlapsCounter.Conflict conflict : timeOverlappingConflicts) {
                weight += this.getModel().getStudentWeights().getTimeOverlapConflictWeight(assignment, enrollment, conflict);
            }
        }
        return enrollment.getRequest().getWeight() * weight;
    }

    protected double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<StudentQuality.Conflict> conflicts) {
        double weight = -this.getModel().getStudentWeights().getWeight(assignment, enrollment);
        if (conflicts != null) {
            for (StudentQuality.Conflict c : conflicts) {
                weight += this.getModel().getStudentWeights().getStudentQualityConflictWeight(assignment, enrollment, c);
            }
        }
        return enrollment.getRequest().getWeight() * weight;
    }

    public Request getRequest(int index) {
        return index < 0 || index >= this.getStudent().getRequests().size() ? null : this.getStudent().getRequests().get(index);
    }

    public boolean isFreeTime(int index) {
        Request r = this.getRequest(index);
        return r != null && r instanceof FreeTimeRequest;
    }

    @Override
    public int compare(Assignment<Request, Enrollment> assignment, Enrollment[] current, Enrollment[] best) {
        double currentUnavailableSizeFraction;
        int idx;
        int idx2;
        int x;
        int bestTimeOverlaps;
        if (best == null) {
            return -1;
        }
        boolean ft = false;
        boolean res = false;
        for (int idx3 = 0; idx3 < current.length; ++idx3) {
            if (this.isFreeTime(idx3)) {
                ft = true;
                continue;
            }
            Request request = this.getRequest(idx3);
            if (request instanceof CourseRequest && ((CourseRequest)request).hasReservations()) {
                res = true;
            }
            if (best[idx3] != null && best[idx3].getAssignments() != null) {
                if (current[idx3] == null || current[idx3].getSections() == null) {
                    return 1;
                }
                if (best[idx3].getTruePriority() < current[idx3].getTruePriority()) {
                    return 1;
                }
                if (best[idx3].getTruePriority() <= current[idx3].getTruePriority()) continue;
                return -1;
            }
            if (current[idx3] == null || current[idx3].getAssignments() == null) continue;
            return -1;
        }
        int bestNotAvailable = 0;
        int currentNotAvailable = 0;
        for (int idx4 = 0; idx4 < current.length; ++idx4) {
            if (best[idx4] != null && best[idx4].getAssignments() != null && best[idx4].getRequest() instanceof CourseRequest && best[idx4].getReservation() != null && best[idx4].getReservation().canAssignOverLimit()) {
                for (Section section : best[idx4].getSections()) {
                    if (section.getLimit() != 0) continue;
                    ++bestNotAvailable;
                }
            }
            if (current[idx4] == null || current[idx4].getAssignments() == null || !(current[idx4].getRequest() instanceof CourseRequest) || current[idx4].getReservation() == null || !current[idx4].getReservation().canAssignOverLimit()) continue;
            for (Section section : current[idx4].getSections()) {
                if (section.getLimit() != 0) continue;
                ++currentNotAvailable;
            }
        }
        if (bestNotAvailable > currentNotAvailable) {
            return -1;
        }
        if (bestNotAvailable < currentNotAvailable) {
            return 1;
        }
        if (this.getModel().getStudentQuality() != null) {
            int idx5;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                if (best[idx5] != null && best[idx5].getAssignments() != null && best[idx5].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx5; ++x) {
                        if (best[x] == null || best[x].getAssignments() == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, best[x], best[idx5]);
                    }
                }
                if (current[idx5] == null || current[idx5].getAssignments() == null || !(current[idx5].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx5; ++x) {
                    if (current[x] == null || current[x].getAssignments() == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, current[x], current[idx5]);
                }
            }
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                if (best[idx5] != null && best[idx5].getAssignments() != null && best[idx5].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, best[idx5]);
                }
                if (current[idx5] == null || current[idx5].getAssignments() == null || !current[idx5].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, current[idx5]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return -1;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return 1;
            }
        } else if (this.getModel().getTimeOverlaps() != null) {
            int idx6;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx6 = 0; idx6 < current.length; ++idx6) {
                if (best[idx6] == null || best[idx6].getAssignments() == null || !(best[idx6].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx6; ++x) {
                    if (best[x] == null || best[x].getAssignments() == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx6]);
                }
                for (x = 0; x < idx6; ++x) {
                    if (current[x] == null || current[x].getAssignments() == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx6]);
                }
            }
            for (idx6 = 0; idx6 < current.length; ++idx6) {
                if (best[idx6] != null && best[idx6].getAssignments() != null && best[idx6].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx6]);
                }
                if (current[idx6] == null || current[idx6].getAssignments() == null || !current[idx6].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx6]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return -1;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return 1;
            }
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (idx2 = 0; idx2 < current.length; ++idx2) {
            if (best[idx2] == null || best[idx2].getAssignments() == null || !best[idx2].isCourseRequest()) continue;
            for (Section section : best[idx2].getSections()) {
                bestPenalties += this.getModel().getOverExpected(assignment, best, idx2, section, best[idx2].getRequest());
            }
            for (Section section : current[idx2].getSections()) {
                currentPenalties += this.getModel().getOverExpected(assignment, current, idx2, section, current[idx2].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return -1;
        }
        if (bestPenalties < currentPenalties) {
            return 1;
        }
        if (ft) {
            for (idx2 = 0; idx2 < current.length; ++idx2) {
                if (best[idx2] != null && best[idx2].getAssignments() != null) {
                    if (current[idx2] == null || current[idx2].getSections() == null) {
                        return 1;
                    }
                    if (best[idx2].getTruePriority() < current[idx2].getTruePriority()) {
                        return 1;
                    }
                    if (best[idx2].getTruePriority() <= current[idx2].getTruePriority()) continue;
                    return -1;
                }
                if (current[idx2] == null || current[idx2].getAssignments() == null) continue;
                return -1;
            }
        }
        int bestSelected = 0;
        int currentSelected = 0;
        for (int idx7 = 0; idx7 < current.length; ++idx7) {
            Set<Section> preferred;
            if (best[idx7] == null || best[idx7].getAssignments() == null || !best[idx7].isCourseRequest() || (preferred = this.getPreferredSections(best[idx7].getRequest())) == null || preferred.isEmpty()) continue;
            for (Section section : best[idx7].getSections()) {
                if (!preferred.contains(section)) continue;
                ++bestSelected;
            }
            for (Section section : current[idx7].getSections()) {
                if (!preferred.contains(section)) continue;
                ++currentSelected;
            }
        }
        if (currentSelected > bestSelected) {
            return -1;
        }
        if (bestSelected > currentSelected) {
            return 1;
        }
        double bestSelectedConfigs = 0.0;
        double currentSelectedConfigs = 0.0;
        double bestSelectedSections = 0.0;
        double currentSelectedSections = 0.0;
        for (idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                bestSelectedSections += best[idx].percentSelectedSameSection();
                bestSelectedConfigs += best[idx].percentSelectedSameConfig();
            }
            if (current[idx] == null || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
            currentSelectedSections += current[idx].percentSelectedSameSection();
            currentSelectedConfigs += current[idx].percentSelectedSameConfig();
        }
        if (0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections > 0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections) {
            return -1;
        }
        if (0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections > 0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections) {
            return 1;
        }
        if (res) {
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getAssignments() != null) {
                    if (current[idx] == null || current[idx].getSections() == null) {
                        return 1;
                    }
                    if (best[idx].getAdjustedPriority() < current[idx].getAdjustedPriority()) {
                        return 1;
                    }
                    if (best[idx].getAdjustedPriority() <= current[idx].getAdjustedPriority()) continue;
                    return -1;
                }
                if (current[idx] == null || current[idx].getAssignments() == null) continue;
                return -1;
            }
        }
        int bestPast = 0;
        int currentPast = 0;
        for (int idx8 = 0; idx8 < current.length; ++idx8) {
            if (best[idx8] != null && best[idx8].getAssignments() != null) {
                for (Section section : best[idx8].getSections()) {
                    if (!section.isPast()) continue;
                    ++bestPast;
                }
            }
            if (current[idx8] == null || current[idx8].getAssignments() == null) continue;
            for (Section section : current[idx8].getSections()) {
                if (!section.isPast()) continue;
                ++currentPast;
            }
        }
        if (currentPast < bestPast) {
            return -1;
        }
        if (bestPast < currentPast) {
            return 1;
        }
        if (this.getModel().getStudentQuality() != null) {
            double bestQuality = 0.0;
            double currentQuality = 0.0;
            for (StudentQuality.Type type : StudentQuality.Type.values()) {
                for (int idx9 = 0; idx9 < current.length; ++idx9) {
                    int x2;
                    if (best[idx9] != null && best[idx9].getAssignments() != null) {
                        bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[idx9]);
                        for (x2 = 0; x2 < idx9; ++x2) {
                            if (best[x2] == null || best[x2].getAssignments() == null) continue;
                            bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[x2], best[idx9]);
                        }
                    }
                    if (current[idx9] == null || current[idx9].getAssignments() == null) continue;
                    currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[idx9]);
                    for (x2 = 0; x2 < idx9; ++x2) {
                        if (current[x2] == null || current[x2].getAssignments() == null) continue;
                        currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[x2], current[idx9]);
                    }
                }
            }
            if (currentQuality < bestQuality) {
                return -1;
            }
            if (bestQuality < currentQuality) {
                return 1;
            }
        } else {
            int x3;
            if (this.getModel().getTimeOverlaps() != null) {
                int idx10;
                int bestTimeOverlaps2 = 0;
                int currentTimeOverlaps = 0;
                for (idx10 = 0; idx10 < current.length; ++idx10) {
                    if (best[idx10] == null || best[idx10].getAssignments() == null) continue;
                    for (x3 = 0; x3 < idx10; ++x3) {
                        if (best[x3] != null && best[x3].getAssignments() != null) {
                            bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(best[x3], best[idx10]);
                            continue;
                        }
                        if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                        bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), best[idx10]);
                    }
                    for (x3 = 0; x3 < idx10; ++x3) {
                        if (current[x3] != null && current[x3].getAssignments() != null) {
                            currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x3], current[idx10]);
                            continue;
                        }
                        if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                        currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), current[idx10]);
                    }
                }
                for (idx10 = 0; idx10 < current.length; ++idx10) {
                    if (best[idx10] != null && best[idx10].getAssignments() != null && best[idx10].isCourseRequest()) {
                        bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx10]);
                    }
                    if (current[idx10] == null || current[idx10].getAssignments() == null || !current[idx10].isCourseRequest()) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx10]);
                }
                if (currentTimeOverlaps < bestTimeOverlaps2) {
                    return -1;
                }
                if (bestTimeOverlaps2 < currentTimeOverlaps) {
                    return 1;
                }
            }
            if (this.getModel().getDistanceConflict() != null) {
                int bestDistanceConf = 0;
                int currentDistanceConf = 0;
                for (int idx11 = 0; idx11 < current.length; ++idx11) {
                    if (best[idx11] != null && best[idx11].getAssignments() != null) {
                        bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[idx11]);
                        for (x3 = 0; x3 < idx11; ++x3) {
                            if (best[x3] == null || best[x3].getAssignments() == null) continue;
                            bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[x3], best[idx11]);
                        }
                    }
                    if (current[idx11] == null || current[idx11].getAssignments() == null) continue;
                    currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[idx11]);
                    for (x3 = 0; x3 < idx11; ++x3) {
                        if (current[x3] == null || current[x3].getAssignments() == null) continue;
                        currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[x3], current[idx11]);
                    }
                }
                if (currentDistanceConf < bestDistanceConf) {
                    return -1;
                }
                if (bestDistanceConf < currentDistanceConf) {
                    return 1;
                }
            }
        }
        int bestNoTime = 0;
        int currentNoTime = 0;
        int bestOnline = 0;
        int currentOnline = 0;
        for (int idx12 = 0; idx12 < current.length; ++idx12) {
            if (best[idx12] == null || best[idx12].getAssignments() == null) continue;
            for (Section section : best[idx12].getSections()) {
                if (!section.hasTime()) {
                    ++bestNoTime;
                }
                if (!section.isOnline()) continue;
                ++bestOnline;
            }
            for (Section section : current[idx12].getSections()) {
                if (!section.hasTime()) {
                    ++currentNoTime;
                }
                if (!section.isOnline()) continue;
                ++currentOnline;
            }
        }
        if (currentNoTime < bestNoTime) {
            return -1;
        }
        if (bestNoTime < currentNoTime) {
            return 1;
        }
        if (currentOnline < bestOnline) {
            return -1;
        }
        if (bestOnline < currentOnline) {
            return 1;
        }
        double bestUnavailableSize = 0.0;
        double currentUnavailableSize = 0.0;
        int bestAltSectionsWithLimit = 0;
        int currentAltSectionsWithLimit = 0;
        for (int idx13 = 0; idx13 < current.length; ++idx13) {
            double averageSize;
            Subpart subpart;
            if (best[idx13] == null || best[idx13].getAssignments() == null) continue;
            for (Section section : best[idx13].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    bestUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++bestAltSectionsWithLimit;
            }
            for (Section section : current[idx13].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    currentUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++currentAltSectionsWithLimit;
            }
        }
        double bestUnavailableSizeFraction = bestUnavailableSize > 0.0 ? bestUnavailableSize / (double)bestAltSectionsWithLimit : 0.0;
        double d = currentUnavailableSizeFraction = currentUnavailableSize > 0.0 ? currentUnavailableSize / (double)currentAltSectionsWithLimit : 0.0;
        if (currentUnavailableSizeFraction < bestUnavailableSizeFraction) {
            return -1;
        }
        if (bestUnavailableSizeFraction < currentUnavailableSizeFraction) {
            return 1;
        }
        double bestPenalty = 0.0;
        double currentPenalty = 0.0;
        for (int idx14 = 0; idx14 < current.length; ++idx14) {
            if (best[idx14] == null || best[idx14].getAssignments() == null) continue;
            for (Section section : best[idx14].getSections()) {
                bestPenalty += section.getPenalty() / (double)best[idx14].getSections().size();
            }
            for (Section section : current[idx14].getSections()) {
                currentPenalty += section.getPenalty() / (double)current[idx14].getSections().size();
            }
        }
        if (currentPenalty < bestPenalty) {
            return -1;
        }
        if (bestPenalty < currentPenalty) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canImprove(Assignment<Request, Enrollment> assignment, int maxIdx, Enrollment[] current, Enrollment[] best) {
        double currentUnavailableSizeFraction;
        int idx;
        int idx2;
        int x;
        int bestTimeOverlaps;
        int alt = 0;
        boolean ft = false;
        boolean res = false;
        for (int idx3 = 0; idx3 < current.length; ++idx3) {
            if (this.isFreeTime(idx3)) {
                ft = true;
                continue;
            }
            Request request = this.getRequest(idx3);
            if (request instanceof CourseRequest && ((CourseRequest)request).hasReservations()) {
                res = true;
            }
            if (idx3 < maxIdx) {
                if (best[idx3] != null) {
                    if (current[idx3] == null) {
                        return false;
                    }
                    if (best[idx3].getTruePriority() < current[idx3].getTruePriority()) {
                        return false;
                    }
                    if (best[idx3].getTruePriority() > current[idx3].getTruePriority()) {
                        return true;
                    }
                    if (!request.isAlternative()) continue;
                    --alt;
                    continue;
                }
                if (current[idx3] != null) {
                    return true;
                }
                if (request.isAlternative()) continue;
                ++alt;
                continue;
            }
            if (!(best[idx3] != null ? best[idx3].getTruePriority() > 0 : !request.isAlternative() || alt > 0)) continue;
            return true;
        }
        int notAvailable = 0;
        for (int idx4 = 0; idx4 < current.length; ++idx4) {
            if (best[idx4] != null && best[idx4].getAssignments() != null && best[idx4].getRequest() instanceof CourseRequest && best[idx4].getReservation() != null && best[idx4].getReservation().canAssignOverLimit()) {
                for (Section section : best[idx4].getSections()) {
                    if (section.getLimit() != 0) continue;
                    ++notAvailable;
                }
            }
            if (idx4 >= maxIdx || current[idx4] == null || current[idx4].getAssignments() == null || !(current[idx4].getRequest() instanceof CourseRequest) || current[idx4].getReservation() == null || !current[idx4].getReservation().canAssignOverLimit()) continue;
            for (Section section : current[idx4].getSections()) {
                if (section.getLimit() != 0) continue;
                --notAvailable;
            }
        }
        if (notAvailable > 0) {
            return true;
        }
        if (this.getModel().getStudentQuality() != null) {
            int idx5;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                if (best[idx5] != null && best[idx5].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx5; ++x) {
                        if (best[x] == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, best[x], best[idx5]);
                    }
                }
                if (current[idx5] == null || idx5 >= maxIdx || !(current[idx5].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx5; ++x) {
                    if (current[x] == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, current[x], current[idx5]);
                }
            }
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                if (best[idx5] != null && best[idx5].getAssignments() != null && best[idx5].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, best[idx5]);
                }
                if (current[idx5] == null || idx5 >= maxIdx || current[idx5].getAssignments() == null || !current[idx5].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, current[idx5]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return true;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return false;
            }
        } else if (this.getModel().getTimeOverlaps() != null) {
            int idx6;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx6 = 0; idx6 < current.length; ++idx6) {
                if (best[idx6] != null && best[idx6].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx6; ++x) {
                        if (best[x] == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx6]);
                    }
                }
                if (current[idx6] == null || idx6 >= maxIdx || !(current[idx6].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx6; ++x) {
                    if (current[x] == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx6]);
                }
            }
            for (idx6 = 0; idx6 < current.length; ++idx6) {
                if (best[idx6] != null && best[idx6].getAssignments() != null && best[idx6].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx6]);
                }
                if (current[idx6] == null || idx6 >= maxIdx || current[idx6].getAssignments() == null || !current[idx6].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx6]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return true;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return false;
            }
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (idx2 = 0; idx2 < current.length; ++idx2) {
            if (best[idx2] != null) {
                for (Section section : best[idx2].getSections()) {
                    bestPenalties += this.getModel().getOverExpected(assignment, best, idx2, section, best[idx2].getRequest());
                }
            }
            if (current[idx2] == null || idx2 >= maxIdx) continue;
            for (Section section : current[idx2].getSections()) {
                currentPenalties += this.getModel().getOverExpected(assignment, current, idx2, section, current[idx2].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return true;
        }
        if (bestPenalties < currentPenalties) {
            return false;
        }
        if (ft) {
            alt = 0;
            for (idx2 = 0; idx2 < current.length; ++idx2) {
                Request request = this.getStudent().getRequests().get(idx2);
                if (idx2 < maxIdx) {
                    if (best[idx2] != null) {
                        if (current[idx2] == null) {
                            return false;
                        }
                        if (best[idx2].getTruePriority() < current[idx2].getTruePriority()) {
                            return false;
                        }
                        if (best[idx2].getTruePriority() > current[idx2].getTruePriority()) {
                            return true;
                        }
                        if (!request.isAlternative()) continue;
                        --alt;
                        continue;
                    }
                    if (current[idx2] != null) {
                        return true;
                    }
                    if (!(request instanceof CourseRequest) || request.isAlternative()) continue;
                    ++alt;
                    continue;
                }
                if (!(best[idx2] != null ? best[idx2].getTruePriority() > 0 : !request.isAlternative() || alt > 0)) continue;
                return true;
            }
        }
        int bestSelected = 0;
        int currentSelected = 0;
        for (int idx7 = 0; idx7 < current.length; ++idx7) {
            Set<Section> preferred;
            if (best[idx7] != null && best[idx7].isCourseRequest() && (preferred = this.getPreferredSections(best[idx7].getRequest())) != null && !preferred.isEmpty()) {
                for (Section section : best[idx7].getSections()) {
                    if (preferred.contains(section)) {
                        if (idx7 >= maxIdx) continue;
                        ++bestSelected;
                        continue;
                    }
                    if (idx7 < maxIdx) continue;
                    --bestSelected;
                }
            }
            if (current[idx7] == null || idx7 >= maxIdx || !current[idx7].isCourseRequest() || (preferred = this.getPreferredSections(current[idx7].getRequest())) == null || preferred.isEmpty()) continue;
            for (Section section : current[idx7].getSections()) {
                if (!preferred.contains(section)) continue;
                ++currentSelected;
            }
        }
        if (currentSelected > bestSelected) {
            return true;
        }
        if (bestSelected > currentSelected) {
            return false;
        }
        double bestSelectedConfigs = 0.0;
        double currentSelectedConfigs = 0.0;
        double bestSelectedSections = 0.0;
        double currentSelectedSections = 0.0;
        for (idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                bestSelectedSections += best[idx].percentSelectedSameSection();
                bestSelectedConfigs += best[idx].percentSelectedSameConfig();
                if (idx >= maxIdx) {
                    bestSelectedSections -= 1.0;
                    bestSelectedConfigs -= 1.0;
                }
            }
            if (current[idx] == null || idx >= maxIdx || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
            currentSelectedSections += current[idx].percentSelectedSameSection();
            currentSelectedConfigs += current[idx].percentSelectedSameConfig();
        }
        if (0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections > 0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections) {
            return true;
        }
        if (0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections > 0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections) {
            return false;
        }
        if (res) {
            alt = 0;
            for (idx = 0; idx < current.length; ++idx) {
                Request request = this.getStudent().getRequests().get(idx);
                if (idx < maxIdx) {
                    if (best[idx] != null) {
                        if (current[idx] == null) {
                            return false;
                        }
                        if (best[idx].getAdjustedPriority() < current[idx].getAdjustedPriority()) {
                            return false;
                        }
                        if (best[idx].getAdjustedPriority() > current[idx].getAdjustedPriority()) {
                            return true;
                        }
                        if (!request.isAlternative()) continue;
                        --alt;
                        continue;
                    }
                    if (current[idx] != null) {
                        return true;
                    }
                    if (!(request instanceof CourseRequest) || request.isAlternative()) continue;
                    ++alt;
                    continue;
                }
                if (!(best[idx] != null ? best[idx].getTruePriority() > 0 : !request.isAlternative() || alt > 0)) continue;
                return true;
            }
        }
        int bestPast = 0;
        int currentPast = 0;
        for (int idx8 = 0; idx8 < current.length; ++idx8) {
            if (best[idx8] != null && best[idx8].getAssignments() != null) {
                for (Section section : best[idx8].getSections()) {
                    if (!section.isPast()) continue;
                    ++bestPast;
                }
            }
            if (current[idx8] == null || idx8 >= maxIdx || current[idx8].getAssignments() == null) continue;
            for (Section section : current[idx8].getSections()) {
                if (!section.isPast()) continue;
                ++currentPast;
            }
        }
        if (currentPast < bestPast) {
            return true;
        }
        if (bestPast < currentPast) {
            return false;
        }
        if (this.getModel().getStudentQuality() != null) {
            double bestQuality = 0.0;
            double currentQuality = 0.0;
            for (StudentQuality.Type type : StudentQuality.Type.values()) {
                for (int idx9 = 0; idx9 < current.length; ++idx9) {
                    int x2;
                    if (best[idx9] != null) {
                        bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[idx9]);
                        for (x2 = 0; x2 < idx9; ++x2) {
                            if (best[x2] == null) continue;
                            bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[x2], best[idx9]);
                        }
                    }
                    if (current[idx9] == null || idx9 >= maxIdx) continue;
                    currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[idx9]);
                    for (x2 = 0; x2 < idx9; ++x2) {
                        if (current[x2] == null) continue;
                        currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[x2], current[idx9]);
                    }
                }
            }
            if (currentQuality < bestQuality) {
                return true;
            }
            if (bestQuality < currentQuality) {
                return false;
            }
        } else {
            int x3;
            if (this.getModel().getTimeOverlaps() != null) {
                int idx10;
                int bestTimeOverlaps2 = 0;
                int currentTimeOverlaps = 0;
                for (idx10 = 0; idx10 < current.length; ++idx10) {
                    if (best[idx10] != null) {
                        for (x3 = 0; x3 < idx10; ++x3) {
                            if (best[x3] != null) {
                                bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(best[x3], best[idx10]);
                                continue;
                            }
                            if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                            bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), best[idx10]);
                        }
                    }
                    if (current[idx10] == null || idx10 >= maxIdx) continue;
                    for (x3 = 0; x3 < idx10; ++x3) {
                        if (current[x3] != null) {
                            currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x3], current[idx10]);
                            continue;
                        }
                        if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                        currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), current[idx10]);
                    }
                }
                for (idx10 = 0; idx10 < current.length; ++idx10) {
                    if (best[idx10] != null && best[idx10].getAssignments() != null && best[idx10].isCourseRequest()) {
                        bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx10]);
                    }
                    if (current[idx10] == null || idx10 >= maxIdx || current[idx10].getAssignments() == null || !current[idx10].isCourseRequest()) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx10]);
                }
                if (currentTimeOverlaps < bestTimeOverlaps2) {
                    return true;
                }
                if (bestTimeOverlaps2 < currentTimeOverlaps) {
                    return false;
                }
            }
            if (this.getModel().getDistanceConflict() != null) {
                int bestDistanceConf = 0;
                int currentDistanceConf = 0;
                for (int idx11 = 0; idx11 < current.length; ++idx11) {
                    if (best[idx11] != null) {
                        bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[idx11]);
                        for (x3 = 0; x3 < idx11; ++x3) {
                            if (best[x3] == null) continue;
                            bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[x3], best[idx11]);
                        }
                    }
                    if (current[idx11] == null || idx11 >= maxIdx) continue;
                    currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[idx11]);
                    for (x3 = 0; x3 < idx11; ++x3) {
                        if (current[x3] == null) continue;
                        currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[x3], current[idx11]);
                    }
                }
                if (currentDistanceConf < bestDistanceConf) {
                    return true;
                }
                if (bestDistanceConf < currentDistanceConf) {
                    return false;
                }
            }
        }
        int bestNoTime = 0;
        int currentNoTime = 0;
        int bestOnline = 0;
        int currentOnline = 0;
        for (int idx12 = 0; idx12 < current.length; ++idx12) {
            if (best[idx12] != null) {
                for (Section section : best[idx12].getSections()) {
                    if (!section.hasTime()) {
                        ++bestNoTime;
                    }
                    if (!section.isOnline()) continue;
                    ++bestOnline;
                }
            }
            if (current[idx12] == null || idx12 >= maxIdx) continue;
            for (Section section : current[idx12].getSections()) {
                if (!section.hasTime()) {
                    ++currentNoTime;
                }
                if (!section.isOnline()) continue;
                ++currentOnline;
            }
        }
        if (currentNoTime < bestNoTime) {
            return true;
        }
        if (bestNoTime < currentNoTime) {
            return false;
        }
        if (currentOnline < bestOnline) {
            return true;
        }
        if (bestOnline < currentOnline) {
            return false;
        }
        double bestUnavailableSize = 0.0;
        double currentUnavailableSize = 0.0;
        int bestAltSectionsWithLimit = 0;
        int currentAltSectionsWithLimit = 0;
        for (int idx13 = 0; idx13 < current.length; ++idx13) {
            double averageSize;
            Subpart subpart;
            if (best[idx13] != null) {
                for (Section section : best[idx13].getSections()) {
                    subpart = section.getSubpart();
                    if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                    averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                    if ((double)section.getLimit() < averageSize) {
                        bestUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                    }
                    ++bestAltSectionsWithLimit;
                }
            }
            if (current[idx13] == null || idx13 >= maxIdx) continue;
            for (Section section : current[idx13].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    currentUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++currentAltSectionsWithLimit;
            }
        }
        double bestUnavailableSizeFraction = bestUnavailableSize > 0.0 ? bestUnavailableSize / (double)bestAltSectionsWithLimit : 0.0;
        double d = currentUnavailableSizeFraction = currentUnavailableSize > 0.0 ? currentUnavailableSize / (double)currentAltSectionsWithLimit : 0.0;
        if (currentUnavailableSizeFraction < bestUnavailableSizeFraction) {
            return true;
        }
        if (bestUnavailableSizeFraction < currentUnavailableSizeFraction) {
            return false;
        }
        double bestPenalty = 0.0;
        double currentPenalty = 0.0;
        for (int idx14 = 0; idx14 < current.length; ++idx14) {
            if (best[idx14] != null) {
                for (Section section : best[idx14].getSections()) {
                    bestPenalty += section.getPenalty() / (double)best[idx14].getSections().size();
                }
                if (idx14 >= maxIdx && best[idx14].isCourseRequest()) {
                    bestPenalty -= ((CourseRequest)best[idx14].getRequest()).getMinPenalty();
                }
            }
            if (current[idx14] == null || idx14 >= maxIdx) continue;
            for (Section section : current[idx14].getSections()) {
                currentPenalty += section.getPenalty() / (double)current[idx14].getSections().size();
            }
        }
        if (currentPenalty < bestPenalty) {
            return true;
        }
        return !(bestPenalty < currentPenalty);
    }

    @Override
    public double getTotalWeight(Assignment<Request, Enrollment> assignment, Enrollment[] enrollemnts) {
        if (enrollemnts == null) {
            return 0.0;
        }
        double value = 0.0;
        for (int idx = 0; idx < enrollemnts.length; ++idx) {
            if (enrollemnts[idx] == null) continue;
            if (this.getModel().getStudentQuality() != null) {
                value += this.getWeight(assignment, enrollemnts[idx], this.getStudentQualityConflicts(enrollemnts, idx));
                continue;
            }
            value += this.getWeight(assignment, enrollemnts[idx], this.getDistanceConflicts(enrollemnts, idx), this.getTimeOverlappingConflicts(enrollemnts, idx));
        }
        return value;
    }

    @Override
    public int compare(Assignment<Request, Enrollment> assignment, Enrollment e1, Enrollment e2) {
        double f2;
        double averageSize;
        Subpart subpart;
        Set<Section> preferred;
        if (e1.getTruePriority() < e2.getTruePriority()) {
            return -1;
        }
        if (e1.getTruePriority() > e2.getTruePriority()) {
            return 1;
        }
        int na1 = 0;
        int na2 = 0;
        for (Section section : e1.getSections()) {
            if (section.getLimit() != 0) continue;
            ++na1;
        }
        for (Section section : e2.getSections()) {
            if (section.getLimit() != 0) continue;
            ++na2;
        }
        if (na1 < na2) {
            return -1;
        }
        if (na1 > na2) {
            return 1;
        }
        double p1 = 0.0;
        double p2 = 0.0;
        for (Section section : e1.getSections()) {
            p1 += this.getModel().getOverExpected(assignment, section, e1.getRequest());
        }
        for (Section section : e2.getSections()) {
            p2 += this.getModel().getOverExpected(assignment, section, e2.getRequest());
        }
        if (p1 < p2) {
            return -1;
        }
        if (p2 < p1) {
            return 1;
        }
        if (e1.isCourseRequest() && (preferred = this.getPreferredSections(e1.getRequest())) != null && !preferred.isEmpty()) {
            int s1 = 0;
            int s2 = 0;
            for (Section section : e1.getSections()) {
                if (!preferred.contains(section)) continue;
                ++s1;
            }
            for (Section section : e2.getSections()) {
                if (!preferred.contains(section)) continue;
                ++s2;
            }
            if (s2 > s1) {
                return -1;
            }
            if (s1 > s2) {
                return 1;
            }
        }
        if (e1.isCourseRequest()) {
            double s2;
            double s1 = 0.3 * e1.percentSelectedSameConfig() + 0.7 * e1.percentSelectedSameSection();
            if (s1 > (s2 = 0.3 * e2.percentSelectedSameConfig() + 0.7 * e2.percentSelectedSameSection())) {
                return -1;
            }
            if (s2 > s1) {
                return 1;
            }
        }
        if (e1.getAdjustedPriority() < e2.getAdjustedPriority()) {
            return -1;
        }
        if (e1.getAdjustedPriority() > e2.getAdjustedPriority()) {
            return 1;
        }
        int w1 = 0;
        int w2 = 0;
        for (Section section : e1.getSections()) {
            if (!section.isPast()) continue;
            ++w1;
        }
        for (Section section : e2.getSections()) {
            if (!section.isPast()) continue;
            ++w2;
        }
        if (w1 < w2) {
            return -1;
        }
        if (w2 < w1) {
            return 1;
        }
        if (this.getTimesToAvoid() == null) {
            if (this.getModel().getStudentQuality() != null) {
                int o2;
                int o1 = this.getModel().getStudentQuality().penalty(StudentQuality.Type.FreeTimeOverlap, e1) + this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, e1);
                if (o1 < (o2 = this.getModel().getStudentQuality().penalty(StudentQuality.Type.FreeTimeOverlap, e2) + this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, e2))) {
                    return -1;
                }
                if (o2 < o1) {
                    return 1;
                }
            } else if (this.getModel().getTimeOverlaps() != null) {
                int o2;
                int o1 = this.getModel().getTimeOverlaps().nrFreeTimeConflicts(e1) + this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(e1);
                if (o1 < (o2 = this.getModel().getTimeOverlaps().nrFreeTimeConflicts(e2) + this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(e2))) {
                    return -1;
                }
                if (o2 < o1) {
                    return 1;
                }
            }
        } else if (e1.getRequest().equals(e2.getRequest()) && e1.isCourseRequest()) {
            double o1 = 0.0;
            double o2 = 0.0;
            for (Section s : e1.getSections()) {
                if (s.getTime() == null) continue;
                for (TimeToAvoid avoid : this.getTimesToAvoid()) {
                    if (avoid.priority() <= e1.getRequest().getPriority()) continue;
                    o1 += avoid.overlap(s.getTime());
                }
            }
            for (Section s : e2.getSections()) {
                if (s.getTime() == null) continue;
                for (TimeToAvoid avoid : this.getTimesToAvoid()) {
                    if (avoid.priority() <= e2.getRequest().getPriority()) continue;
                    o2 += avoid.overlap(s.getTime());
                }
            }
            if (o1 < o2) {
                return -1;
            }
            if (o2 < o1) {
                return 1;
            }
        }
        if (this.getModel().getDistanceConflict() != null) {
            int c2;
            int c1 = this.getModel().getDistanceConflict().nrConflicts(e1);
            if (c1 < (c2 = this.getModel().getDistanceConflict().nrConflicts(e2))) {
                return -1;
            }
            if (c2 < c1) {
                return 1;
            }
        }
        int n1 = 0;
        int n2 = 0;
        int o1 = 0;
        int o2 = 0;
        for (Section section : e1.getSections()) {
            if (!section.hasTime()) {
                ++n1;
            }
            if (!section.isOnline()) continue;
            ++o1;
        }
        for (Section section : e2.getSections()) {
            if (!section.hasTime()) {
                ++n2;
            }
            if (!section.isOnline()) continue;
            ++o2;
        }
        if (n1 < n2) {
            return -1;
        }
        if (n2 < n1) {
            return 1;
        }
        if (o1 < o2) {
            return -1;
        }
        if (o2 < o1) {
            return 1;
        }
        double u1 = 0.0;
        double u2 = 0.0;
        int a1 = 0;
        int a2 = 0;
        for (Section section : e1.getSections()) {
            subpart = section.getSubpart();
            if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
            averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
            if ((double)section.getLimit() < averageSize) {
                u1 += (averageSize - (double)section.getLimit()) / averageSize;
            }
            ++a1;
        }
        for (Section section : e2.getSections()) {
            subpart = section.getSubpart();
            if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
            averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
            if ((double)section.getLimit() < averageSize) {
                u2 += (averageSize - (double)section.getLimit()) / averageSize;
            }
            ++a2;
        }
        double f1 = u1 > 0.0 ? u1 / (double)a1 : 0.0;
        double d = f2 = u2 > 0.0 ? u2 / (double)a2 : 0.0;
        if (f1 < f2) {
            return -1;
        }
        if (f2 < f1) {
            return 1;
        }
        double x1 = 0.0;
        double x2 = 0.0;
        for (Section section : e1.getSections()) {
            x1 += section.getPenalty() / (double)e1.getSections().size();
        }
        for (Section section : e2.getSections()) {
            x2 += section.getPenalty() / (double)e2.getSections().size();
        }
        if (x1 < x2) {
            return -1;
        }
        if (x2 < x1) {
            return 1;
        }
        return 0;
    }

    public static class TimeToAvoid {
        private TimeLocation iTime;
        private double iPenalty;
        private int iPriority;

        public TimeToAvoid(TimeLocation time, int penalty, int priority) {
            this.iTime = time;
            this.iPenalty = penalty;
            this.iPriority = priority;
        }

        public int priority() {
            return this.iPriority;
        }

        public double overlap(TimeLocation time) {
            if (time.hasIntersection(this.iTime)) {
                return this.iPenalty * (double)(time.nrSharedDays(this.iTime) * time.nrSharedHours(this.iTime)) / (double)(this.iTime.getNrMeetings() * this.iTime.getLength());
            }
            return 0.0;
        }

        public String toString() {
            return this.iTime.getLongName(true) + " (" + this.iPriority + "/" + this.iPenalty + ")";
        }
    }
}

