/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.heuristics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;

public class RoundRobinNeighbourSelection<V extends Variable<V, T>, T extends Value<V, T>>
extends StandardNeighbourSelection<V, T> {
    protected static Logger sLogger = Logger.getLogger(RoundRobinNeighbourSelection.class);
    private int iSelectionIdx = -1;
    private List<NeighbourSelection<V, T>> iSelections = new ArrayList<NeighbourSelection<V, T>>();
    protected Solver<V, T> iSolver = null;

    public RoundRobinNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
    }

    public void registerSelection(NeighbourSelection<V, T> selection) {
        this.iSelections.add(selection);
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        this.iSolver = solver;
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        for (int nrChanges = 0; nrChanges <= this.iSelections.size(); ++nrChanges) {
            int selectionIndex = this.getSelectionIndex();
            NeighbourSelection<V, T> selection = this.iSelections.get(selectionIndex % this.iSelections.size());
            Neighbour<V, T> neighbour = selection.selectNeighbour(solution);
            if (neighbour != null) {
                return neighbour;
            }
            this.changeSelection(selectionIndex);
        }
        return null;
    }

    public int getSelectionIndex() {
        if (this.iSelectionIdx == -1) {
            this.changeSelection(-1);
        }
        this.iSolver.currentSolution().getLock().readLock().lock();
        try {
            int n = this.iSelectionIdx;
            return n;
        }
        finally {
            this.iSolver.currentSolution().getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSelection(int selectionIndex) {
        this.iSolver.currentSolution().getLock().writeLock().lock();
        try {
            Progress progress = Progress.getInstance(this.iSolver.currentSolution().getModel());
            int newSelectionIndex = 1 + selectionIndex;
            if (newSelectionIndex <= this.iSelectionIdx) {
                return;
            }
            if (selectionIndex == -1 && this.iSelectionIdx >= 0) {
                return;
            }
            this.iSelectionIdx = newSelectionIndex;
            if (selectionIndex >= 0) {
                try {
                    NeighbourSelection<V, T> selection = this.iSelections.get(selectionIndex % this.iSelections.size());
                    if (selection instanceof InfoProvider) {
                        HashMap<String, String> info = new HashMap<String, String>();
                        ((InfoProvider)((Object)selection)).getInfo(this.iSolver.currentSolution().getAssignment(), info);
                        if (!info.isEmpty()) {
                            for (Map.Entry e : info.entrySet()) {
                                progress.debug((String)e.getKey() + ": " + (String)e.getValue());
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sLogger.info((Object)("Phase changed to " + (newSelectionIndex % this.iSelections.size() + 1)));
            progress.debug(this.iSolver.currentSolution().toString());
            if (this.iSolver.currentSolution().getBestInfo() == null || this.iSolver.getSolutionComparator().isBetterThanBestSolution(this.iSolver.currentSolution())) {
                this.iSolver.currentSolution().saveBest();
            }
            this.iSelections.get(this.iSelectionIdx % this.iSelections.size()).init(this.iSolver);
        }
        finally {
            this.iSolver.currentSolution().getLock().writeLock().unlock();
        }
    }

    public NeighbourSelection<V, T> getSelection() {
        return this.iSelections.get(this.getSelectionIndex() % this.iSelections.size());
    }
}

