/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.rpp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.example.rpp.Location;
import org.cpsolver.ifs.example.rpp.RPPModel;
import org.cpsolver.ifs.example.rpp.Rectangle;
import org.cpsolver.ifs.example.rpp.ResourceConstraint;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressWriter;
import org.cpsolver.ifs.util.PrologFile;
import org.cpsolver.ifs.util.ToolBox;

public class Test {
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("dd-MMM-yy_HHmmss", Locale.US);
    private static Logger sLogger = Logger.getLogger(Test.class);

    private static RPPModel loadModel(int mWidth, int mHeight, List<PrologFile.Term> objects, List<PrologFile.Term> assigned, List<PrologFile.Term> perturbations, int perb, int test) {
        try {
            String name;
            sLogger.debug((Object)("Loading model " + perb + "." + test + " ..."));
            double startTime = JProf.currentTimeSec();
            RPPModel m = new RPPModel();
            ResourceConstraint c = new ResourceConstraint(mWidth, mHeight);
            m.addConstraint(c);
            for (PrologFile.Term object : objects.get(0).getContent().get(0).getContent()) {
                name = object.elementAt(0).elementAt(0).getText();
                int width = object.elementAt(1).elementAt(0).elementAt(0).toInt();
                int height = object.elementAt(1).elementAt(0).elementAt(1).toInt();
                String xpos = object.elementAt(2).elementAt(0).elementAt(0).getText();
                String ypos = object.elementAt(2).elementAt(0).elementAt(1).getText();
                int xmin = Integer.parseInt(xpos.substring(0, xpos.indexOf(45)));
                int xmax = Integer.parseInt(xpos.substring(xpos.indexOf(45) + 1));
                int ymin = Integer.parseInt(ypos.substring(0, ypos.indexOf(45)));
                int ymax = Integer.parseInt(ypos.substring(ypos.indexOf(45) + 1));
                Rectangle r = new Rectangle(name, width, height, xmin, xmax, ymin, ymax, null);
                m.addVariable(r);
                c.addVariable(r);
            }
            Iterator<PrologFile.Term> i = assigned.get(0).elementAt(0).getContent().iterator();
            while (i.hasNext()) {
                PrologFile.Term assignment = i.next();
                name = assignment.elementAt(0).getText();
                name = name.substring(0, name.length() - 1);
                int x = assignment.elementAt(1).elementAt(0).toInt();
                assignment = i.next();
                int y = assignment.elementAt(1).elementAt(0).toInt();
                m.getRectangle(name).setInitialAssignment(new Location(m.getRectangle(name), x, y));
            }
            for (PrologFile.Term pert : perturbations) {
                if (test != pert.elementAt(0).toInt() || perb != pert.elementAt(1).toInt() || perb <= 0) continue;
                for (PrologFile.Term t : pert.elementAt(2).getContent()) {
                    int rec = t.toInt();
                    m.getRectangle("rect" + rec).setProhibited();
                }
            }
            sLogger.debug((Object)("Loaded in " + sDoubleFormat.format(JProf.currentTimeSec() - startTime) + " sec."));
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static RPPModel loadModel(int mWidth, int mHeight, List<PrologFile.Term> objects) {
        try {
            sLogger.debug((Object)"Loading model ...");
            double startTime = JProf.currentTimeSec();
            RPPModel m = new RPPModel();
            ResourceConstraint c = new ResourceConstraint(mWidth, mHeight);
            m.addConstraint(c);
            for (PrologFile.Term object : objects.get(0).getContent().get(0).getContent()) {
                String name = object.elementAt(0).elementAt(0).getText();
                int width = object.elementAt(1).elementAt(0).elementAt(0).toInt();
                int height = object.elementAt(1).elementAt(0).elementAt(1).toInt();
                String xpos = object.elementAt(2).elementAt(0).elementAt(0).getText();
                String ypos = object.elementAt(2).elementAt(0).elementAt(1).getText();
                int xmin = Integer.parseInt(xpos.substring(0, xpos.indexOf(45)));
                int xmax = Integer.parseInt(xpos.substring(xpos.indexOf(45) + 1));
                int ymin = Integer.parseInt(ypos.substring(0, ypos.indexOf(45)));
                int ymax = Integer.parseInt(ypos.substring(ypos.indexOf(45) + 1));
                Rectangle r = new Rectangle(name, width, height, xmin, xmax, ymin, ymax, null);
                m.addVariable(r);
                c.addVariable(r);
            }
            sLogger.debug((Object)("Loaded in " + sDoubleFormat.format(JProf.currentTimeSec() - startTime) + " sec."));
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void testMPP(DataProperties properties) {
        try {
            FileInputStream fis = new FileInputStream(properties.getProperty("General.Input") + ".pl");
            List<PrologFile.Term> v1 = PrologFile.readTermsFromStream(fis, "objects");
            fis.close();
            fis = new FileInputStream(properties.getProperty("General.Input") + ".solution");
            List<PrologFile.Term> v2 = PrologFile.readTermsFromStream(fis, "assigned");
            fis.close();
            fis = new FileInputStream(properties.getProperty("General.Input") + ".mpp");
            List<PrologFile.Term> v3 = PrologFile.readTermsFromStream(fis, "perturbation");
            fis.close();
            PrintWriter res = new PrintWriter(new FileWriter(properties.getProperty("General.Output") + File.separator + "result.pl"));
            PrintWriter stat = new PrintWriter(new FileWriter(properties.getProperty("General.Output") + File.separator + "stat.pl"));
            PrintWriter txt = new PrintWriter(new FileWriter(properties.getProperty("General.Output") + File.separator + "stat.csv"));
            txt.println("pert;time[s];timeRMS;assigned;assignedRMS;perturbations;perturbationsRMS;iters;itersRMS");
            DecimalFormat nf = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
            int size = -1;
            int tests = properties.getPropertyInt("Rpp.NrTests", 10);
            int step = properties.getPropertyInt("Rpp.Step", 4);
            int min = properties.getPropertyInt("Rpp.Min", 0);
            int max = properties.getPropertyInt("Rpp.Max", -1);
            for (int i = min; size == -1 || i <= (max > 0 ? Math.min(max, size) : size); i += step) {
                double time = 0.0;
                long assigned = 0L;
                long perturbation = 0L;
                long iters = 0L;
                double time2 = 0.0;
                long assigned2 = 0L;
                long perturbation2 = 0L;
                long iters2 = 0L;
                for (int t = 1; t <= tests; ++t) {
                    RPPModel m = Test.loadModel(properties.getPropertyInt("Rpp.ProblemWidth", 40), properties.getPropertyInt("Rpp.ProblemHeight", 14), v1, v2, v3, i, t);
                    if (size < 0) {
                        size = m.variables().size();
                    }
                    Solver<Rectangle, Location> s = new Solver<Rectangle, Location>(properties);
                    s.setInitalSolution(m);
                    s.start();
                    s.getSolverThread().join();
                    Solution best = s.currentSolution();
                    best.restoreBest();
                    res.println("result(" + t + "," + i + "," + nf.format(best.getBestTime()) + "," + (best.getModel().variables().size() - best.getModel().getBestUnassignedVariables()) + "," + best.getBestIteration() + ",");
                    Collection notPlaced = best.getModel().bestUnassignedVariables(best.getAssignment());
                    if (notPlaced == null) {
                        notPlaced = new ArrayList();
                    }
                    res.print("  unassigned(" + 2 * notPlaced.size() + "/[");
                    Iterator it = notPlaced.iterator();
                    while (it.hasNext()) {
                        Rectangle rect = (Rectangle)it.next();
                        res.print(rect.getName() + "X," + rect.getName() + "Y" + (it.hasNext() ? "," : ""));
                    }
                    res.println("]),");
                    StringBuffer sb = new StringBuffer();
                    int perts = 0;
                    for (Rectangle rect : ((RPPModel)best.getModel()).variables()) {
                        if (!(rect.getBestAssignment() == null || rect.getInitialAssignment() != null && ((Location)rect.getBestAssignment()).equals(rect.getInitialAssignment()))) {
                            sb.append(sb.length() == 0 ? "" : ",");
                            sb.append(rect.getName() + "X-" + ((Location)rect.getBestAssignment()).getX());
                            sb.append(sb.length() == 0 ? "" : ",");
                            sb.append(rect.getName() + "Y-" + ((Location)rect.getBestAssignment()).getY());
                            ++perts;
                        }
                        if (rect.getBestAssignment() != null) continue;
                        ++perts;
                    }
                    res.println("  perturbations(" + 2 * perts + "/[" + sb + "])");
                    res.println(").");
                    res.flush();
                    iters += best.getBestIteration();
                    iters2 += best.getBestIteration() * best.getBestIteration();
                    time += best.getBestTime();
                    time2 += best.getBestTime() * best.getBestTime();
                    assigned += (long)(best.getModel().variables().size() - best.getModel().getBestUnassignedVariables());
                    assigned2 += (long)((best.getModel().variables().size() - best.getModel().getBestUnassignedVariables()) * (best.getModel().variables().size() - best.getModel().getBestUnassignedVariables()));
                    perturbation += (long)perts;
                    perturbation2 += (long)(perts * perts);
                }
                txt.println(i + ";" + nf.format(time / (double)tests) + ";" + nf.format(ToolBox.rms(tests, time, time2)) + ";" + nf.format((double)assigned / (double)tests) + ";" + nf.format(ToolBox.rms(tests, assigned, assigned2)) + ";" + nf.format((double)perturbation / (double)tests) + ";" + nf.format(ToolBox.rms(tests, perturbation, perturbation2)) + ";" + nf.format((double)iters / (double)tests) + ";" + nf.format(ToolBox.rms(tests, iters, iters2)));
                txt.flush();
                stat.println("averages( initperturbations( " + i + " ), time( " + nf.format(time / (double)tests) + " ), assigned( " + nf.format((double)assigned / (double)tests) + " ), perturbations( " + nf.format((double)perturbation / (double)tests) + " ) ).");
                stat.println("deviations( initperturbations( " + i + " ), time( " + nf.format(ToolBox.rms(tests, time, time2)) + " ), assigned( " + nf.format(ToolBox.rms(tests, assigned, assigned2)) + " ), perturbations( " + nf.format(ToolBox.rms(tests, perturbation, perturbation2)) + " ) ).");
                stat.flush();
            }
            res.close();
            txt.close();
            stat.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test(DataProperties properties) {
        try {
            int tests = properties.getPropertyInt("Rpp.NrTests", 10);
            int min = properties.getPropertyInt("Rpp.Min", 0);
            int max = properties.getPropertyInt("Rpp.Max", -1);
            PrintWriter res = new PrintWriter(new FileWriter(properties.getProperty("General.Output") + File.separator + "result.pl"));
            PrintWriter stat = new PrintWriter(new FileWriter(properties.getProperty("General.Output") + File.separator + "stat.pl"));
            PrintWriter txt = new PrintWriter(new FileWriter(properties.getProperty("General.Output") + File.separator + "stat.csv"));
            txt.println("gen;time[s];timeRMS;assigned;assignedRMS;iters;itersRMS");
            DecimalFormat nf = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
            for (int genNr = min; genNr <= max; ++genNr) {
                FileInputStream fis = new FileInputStream(properties.getProperty("General.Input") + File.separator + "gen" + genNr + ".pl");
                List<PrologFile.Term> v1 = PrologFile.readTermsFromStream(fis, "objects");
                fis.close();
                double time = 0.0;
                long assigned = 0L;
                long iters = 0L;
                double time2 = 0.0;
                long assigned2 = 0L;
                long iters2 = 0L;
                for (int t = 1; t <= tests; ++t) {
                    RPPModel m = Test.loadModel(properties.getPropertyInt("Rpp.ProblemWidth", 40), properties.getPropertyInt("Rpp.ProblemHeight", 14), v1);
                    Solver<Rectangle, Location> s = new Solver<Rectangle, Location>(properties);
                    s.setInitalSolution(m);
                    s.start();
                    s.getSolverThread().join();
                    Solution best = s.currentSolution();
                    best.restoreBest();
                    iters += best.getBestIteration();
                    iters2 += best.getBestIteration() * best.getBestIteration();
                    time += best.getBestTime();
                    time2 += best.getBestTime() * best.getBestTime();
                    assigned += (long)(best.getModel().variables().size() - best.getModel().getBestUnassignedVariables());
                    assigned2 += (long)((best.getModel().variables().size() - best.getModel().getBestUnassignedVariables()) * (best.getModel().variables().size() - best.getModel().getBestUnassignedVariables()));
                    res.println("result(" + genNr + "," + t + "," + nf.format(best.getBestTime()) + "," + (best.getModel().variables().size() - best.getModel().getBestUnassignedVariables()) + "," + best.getBestIteration() + ",");
                    Collection notPlaced = best.getModel().bestUnassignedVariables(best.getAssignment());
                    if (notPlaced == null) {
                        notPlaced = new ArrayList();
                    }
                    res.print("  unassigned(" + 2 * notPlaced.size() + "/[");
                    Iterator it = notPlaced.iterator();
                    while (it.hasNext()) {
                        Rectangle rect = (Rectangle)it.next();
                        res.print(rect.getName() + "X," + rect.getName() + "Y" + (it.hasNext() ? "," : ""));
                    }
                    res.println("]),");
                    int perts = 0;
                    StringBuffer sb = new StringBuffer();
                    for (Rectangle rect : ((RPPModel)best.getModel()).variables()) {
                        if (rect.getBestAssignment() == null) continue;
                        sb.append(sb.length() == 0 ? "" : ",");
                        sb.append(rect.getName() + "X-" + ((Location)rect.getBestAssignment()).getX());
                        sb.append(sb.length() == 0 ? "" : ",");
                        sb.append(rect.getName() + "Y-" + ((Location)rect.getBestAssignment()).getY());
                        ++perts;
                    }
                    res.println("  assigned(" + 2 * perts + "/[" + sb + "])");
                    res.println(").");
                    res.flush();
                }
                txt.println(genNr + ";" + nf.format(time / (double)tests) + ";" + nf.format(ToolBox.rms(tests, time, time2)) + ";" + nf.format((double)assigned / (double)tests) + ";" + nf.format(ToolBox.rms(tests, assigned, assigned2)) + ";" + nf.format((double)iters / (double)tests) + ";" + nf.format(ToolBox.rms(tests, iters, iters2)));
                txt.flush();
                stat.println("averages( problem( " + genNr + " ), time( " + nf.format(time / (double)tests) + " ), assigned( " + nf.format((double)assigned / (double)tests) + " ) ).");
                stat.println("deviations( problem( " + genNr + " ), time( " + nf.format(ToolBox.rms(tests, time, time2)) + " ), assigned( " + nf.format(ToolBox.rms(tests, assigned, assigned2)) + " ) ).");
                stat.flush();
            }
            res.close();
            txt.close();
            stat.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test(File inputCfg, String name, String include, String regexp, String outDir) throws Exception {
        if (regexp != null) {
            String incFile;
            if (regexp.indexOf(59) > 0) {
                incFile = regexp.substring(0, regexp.indexOf(59));
                regexp = regexp.substring(regexp.indexOf(59) + 1);
            } else {
                incFile = regexp;
                regexp = null;
            }
            if (incFile.startsWith("[") && incFile.endsWith("]")) {
                Test.test(inputCfg, name, include, regexp, outDir);
                incFile = incFile.substring(1, incFile.length() - 1);
            }
            if (incFile.indexOf(123) >= 0 && incFile.indexOf(125) >= 0) {
                String prefix = incFile.substring(0, incFile.indexOf(123));
                StringTokenizer middle = new StringTokenizer(incFile.substring(incFile.indexOf(123) + 1, incFile.indexOf(125)), "|");
                String sufix = incFile.substring(incFile.indexOf(125) + 1);
                while (middle.hasMoreTokens()) {
                    String m = middle.nextToken();
                    Test.test(inputCfg, (name == null ? "" : name + "_") + m, (include == null ? "" : include + ";") + prefix + m + sufix, regexp, outDir);
                }
            } else {
                Test.test(inputCfg, name, (include == null ? "" : include + ";") + incFile, regexp, outDir);
            }
        } else {
            DataProperties properties = ToolBox.loadProperties(inputCfg);
            StringTokenizer inc = new StringTokenizer(include, ";");
            while (inc.hasMoreTokens()) {
                String aFile = inc.nextToken();
                System.out.println("  Loading included file '" + aFile + "' ... ");
                FileInputStream is = null;
                if (new File(aFile).exists()) {
                    is = new FileInputStream(aFile);
                }
                if (new File(inputCfg.getParent() + File.separator + aFile).exists()) {
                    is = new FileInputStream(inputCfg.getParent() + File.separator + aFile);
                }
                if (is == null) {
                    System.err.println("Unable to find include file '" + aFile + "'.");
                }
                properties.load(is);
                is.close();
            }
            String outDirTisTest = (outDir == null ? properties.getProperty("General.Output", ".") : outDir) + File.separator + name + File.separator + sDateFormat.format(new Date());
            properties.setProperty("General.Output", outDirTisTest.toString());
            System.out.println("Output folder: " + properties.getProperty("General.Output"));
            new File(outDirTisTest).mkdirs();
            ToolBox.configureLogging(outDirTisTest, null);
            FileOutputStream fos = new FileOutputStream(outDirTisTest + File.separator + "rcsp.conf");
            properties.store(fos, "Random CSP problem configuration file");
            fos.flush();
            fos.close();
            boolean mpp = properties.getPropertyBoolean("General.MPP", true);
            if (mpp) {
                Test.testMPP(properties);
            } else {
                Test.test(properties);
            }
        }
    }

    public static void main(String[] args) {
        try {
            Progress.getInstance().addProgressListener(new ProgressWriter(System.out));
            File inputCfg = new File(args[0]);
            DataProperties properties = ToolBox.loadProperties(inputCfg);
            if (properties.getProperty("INCLUDE_REGEXP") != null) {
                if (args.length > 1) {
                    properties.setProperty("General.Output", args[1]);
                }
                Test.test(inputCfg, null, null, properties.getProperty("INCLUDE_REGEXP"), args.length > 1 ? args[1] : null);
            } else {
                String outDir = properties.getProperty("General.Output", ".") + File.separator + inputCfg.getName().substring(0, inputCfg.getName().lastIndexOf(46)) + File.separator + sDateFormat.format(new Date());
                if (args.length > 1) {
                    outDir = args[1] + File.separator + sDateFormat.format(new Date());
                }
                new File(outDir).mkdirs();
                properties.setProperty("General.Output", outDir.toString());
                System.out.println("Output folder: " + properties.getProperty("General.Output"));
                ToolBox.configureLogging(outDir, null);
                boolean mpp = properties.getPropertyBoolean("General.MPP", false);
                if (mpp) {
                    Test.testMPP(properties);
                } else {
                    Test.test(properties);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

