/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.rpp;

import java.util.Set;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.example.rpp.Location;
import org.cpsolver.ifs.example.rpp.Rectangle;

public class ResourceConstraint
extends ConstraintWithContext<Rectangle, Location, Context> {
    private static Logger sLogger = Logger.getLogger(ResourceConstraint.class);
    private int iWidth;
    private int iHeight;

    public ResourceConstraint(int width, int height) {
        this.iWidth = width;
        this.iHeight = height;
    }

    @Override
    public void computeConflicts(Assignment<Rectangle, Location> assignment, Location placement, Set<Location> conflicts) {
        Rectangle rectangle = (Rectangle)placement.variable();
        Context context = (Context)this.getContext((Assignment)assignment);
        for (int x = placement.getX(); x < Math.min(this.iWidth, placement.getX() + rectangle.getWidth()); ++x) {
            for (int y = placement.getY(); y < Math.min(this.iHeight, placement.getY() + rectangle.getHeight()); ++y) {
                if (context.getRectangle(x, y) == null) continue;
                conflicts.add(context.getRectangle(x, y).getAssignment(assignment));
            }
        }
    }

    @Override
    public boolean inConflict(Assignment<Rectangle, Location> assignment, Location placement) {
        Rectangle rectangle = (Rectangle)placement.variable();
        Context context = (Context)this.getContext((Assignment)assignment);
        for (int x = placement.getX(); x < Math.min(this.iWidth, placement.getX() + rectangle.getWidth()); ++x) {
            for (int y = placement.getY(); y < Math.min(this.iHeight, placement.getY() + rectangle.getHeight()); ++y) {
                if (context.getRectangle(x, y) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent(Location p1, Location p2) {
        Rectangle r1 = (Rectangle)p1.variable();
        Rectangle r2 = (Rectangle)p2.variable();
        if (p2.getX() + r2.getWidth() <= p1.getX()) {
            return true;
        }
        if (p2.getX() >= p1.getX() + r1.getWidth()) {
            return true;
        }
        if (p2.getY() + r2.getHeight() <= p1.getY()) {
            return true;
        }
        return p2.getY() >= p1.getY() + r1.getHeight();
    }

    public void check(Assignment<Rectangle, Location> assignment) {
        sLogger.debug((Object)"check");
        Context context = (Context)this.getContext((Assignment)assignment);
        for (Rectangle rectangle : this.variables()) {
            Location placement = assignment.getValue(rectangle);
            if (placement == null) {
                sLogger.warn((Object)("Rectangle " + rectangle.getName() + " is not assigned."));
                continue;
            }
            sLogger.debug((Object)("Checking " + rectangle.getName() + "    (assigned:" + placement.getName() + ", prohibited:" + rectangle.isProhibited(placement.getX(), placement.getY()) + ", initial:" + rectangle.getInitialAssignment() + ", prohibited:[" + rectangle.getProhibitedX() + "," + rectangle.getProhibitedY() + "])"));
            if (placement.getX() == rectangle.getProhibitedX() || placement.getY() == rectangle.getProhibitedY()) {
                sLogger.error((Object)"Placement is prohibited.");
            }
            if (placement.getX() < rectangle.getMinX() || placement.getX() > rectangle.getMaxX() || placement.getY() < rectangle.getMinY() || placement.getY() > rectangle.getMaxY()) {
                sLogger.error((Object)"Placement is outside bounds.");
            }
            for (int x = placement.getX(); x < Math.min(this.iWidth, placement.getX() + rectangle.getWidth()); ++x) {
                for (int y = placement.getY(); y < Math.min(this.iHeight, placement.getY() + rectangle.getHeight()); ++y) {
                    if (context.getRectangle(x, y) != null && context.getRectangle(x, y).equals(rectangle)) continue;
                    sLogger.error((Object)("Problem at [" + x + "," + y + "], " + context.getRectangle(x, y) + " is assigned there."));
                }
            }
        }
        sLogger.debug((Object)this.toString());
    }

    public String toString() {
        return "ResourceConstraint{" + this.iWidth + "x" + this.iHeight + "}";
    }

    @Override
    public Context createAssignmentContext(Assignment<Rectangle, Location> assignment) {
        return new Context(assignment);
    }

    public class Context
    implements AssignmentConstraintContext<Rectangle, Location> {
        private Rectangle[][] iResource;

        public Context(Assignment<Rectangle, Location> assignment) {
            this.iResource = new Rectangle[ResourceConstraint.this.iWidth][ResourceConstraint.this.iHeight];
            for (int x = 0; x < ResourceConstraint.this.iWidth; ++x) {
                for (int y = 0; y < ResourceConstraint.this.iHeight; ++y) {
                    this.iResource[x][y] = null;
                }
            }
            for (Location location : assignment.assignedValues()) {
                this.assigned(assignment, location);
            }
        }

        @Override
        public void assigned(Assignment<Rectangle, Location> assignment, Location placement) {
            Rectangle rectangle = (Rectangle)placement.variable();
            for (int x = placement.getX(); x < Math.min(ResourceConstraint.this.iWidth, placement.getX() + rectangle.getWidth()); ++x) {
                for (int y = placement.getY(); y < Math.min(ResourceConstraint.this.iHeight, placement.getY() + rectangle.getHeight()); ++y) {
                    this.iResource[x][y] = rectangle;
                }
            }
        }

        public Rectangle getRectangle(int x, int y) {
            return this.iResource[x][y];
        }

        @Override
        public void unassigned(Assignment<Rectangle, Location> assignment, Location placement) {
            Rectangle rectangle = (Rectangle)placement.variable();
            for (int x = placement.getX(); x < Math.min(ResourceConstraint.this.iWidth, placement.getX() + rectangle.getWidth()); ++x) {
                for (int y = placement.getY(); y < Math.min(ResourceConstraint.this.iHeight, placement.getY() + rectangle.getHeight()); ++y) {
                    this.iResource[x][y] = null;
                }
            }
        }
    }
}

