/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;

public class ExamContext
implements AssignmentConstraintContext<Exam, ExamPlacement> {
    private Map<ExamStudent, Set<Exam>>[] iStudentTable;
    private Map<ExamStudent, Set<Exam>>[] iStudentDayTable;
    private Map<ExamInstructor, Set<Exam>>[] iInstructorTable;
    private Map<ExamInstructor, Set<Exam>>[] iInstructorDayTable;

    public ExamContext(ExamModel model, Assignment<Exam, ExamPlacement> assignment) {
        int i;
        this.iStudentTable = new Map[model.getNrPeriods()];
        for (i = 0; i < this.iStudentTable.length; ++i) {
            this.iStudentTable[i] = new HashMap<ExamStudent, Set<Exam>>();
        }
        this.iStudentDayTable = new Map[model.getNrDays()];
        for (i = 0; i < this.iStudentDayTable.length; ++i) {
            this.iStudentDayTable[i] = new HashMap<ExamStudent, Set<Exam>>();
        }
        this.iInstructorTable = new Map[model.getNrPeriods()];
        for (i = 0; i < this.iInstructorTable.length; ++i) {
            this.iInstructorTable[i] = new HashMap<ExamInstructor, Set<Exam>>();
        }
        this.iInstructorDayTable = new Map[model.getNrDays()];
        for (i = 0; i < this.iInstructorDayTable.length; ++i) {
            this.iInstructorDayTable[i] = new HashMap<ExamInstructor, Set<Exam>>();
        }
        for (Exam exam : model.variables()) {
            ExamPlacement placement = assignment.getValue(exam);
            if (placement == null) continue;
            this.assigned(assignment, placement);
        }
    }

    @Override
    public void assigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement) {
        Set<Exam> examsThisDay;
        Set<Exam> examsThisPeriod;
        int period = placement.getPeriod().getIndex();
        int day = placement.getPeriod().getDay();
        for (ExamStudent student : ((Exam)placement.variable()).getStudents()) {
            examsThisPeriod = this.iStudentTable[period].get(student);
            if (examsThisPeriod == null) {
                examsThisPeriod = new HashSet<Exam>();
                this.iStudentTable[period].put(student, examsThisPeriod);
            }
            examsThisPeriod.add((Exam)placement.variable());
            examsThisDay = this.iStudentDayTable[day].get(student);
            if (examsThisDay == null) {
                examsThisDay = new HashSet<Exam>();
                this.iStudentDayTable[day].put(student, examsThisDay);
            }
            examsThisDay.add((Exam)placement.variable());
        }
        for (ExamInstructor instructor : ((Exam)placement.variable()).getInstructors()) {
            examsThisPeriod = this.iInstructorTable[period].get(instructor);
            if (examsThisPeriod == null) {
                examsThisPeriod = new HashSet<Exam>();
                this.iInstructorTable[period].put(instructor, examsThisPeriod);
            }
            examsThisPeriod.add((Exam)placement.variable());
            examsThisDay = this.iInstructorDayTable[day].get(instructor);
            if (examsThisDay == null) {
                examsThisDay = new HashSet<Exam>();
                this.iInstructorDayTable[day].put(instructor, examsThisDay);
            }
            examsThisDay.add((Exam)placement.variable());
        }
    }

    @Override
    public void unassigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement) {
        Set<Exam> examsThisDay;
        Set<Exam> examsThisPeriod;
        int period = placement.getPeriod().getIndex();
        int day = placement.getPeriod().getDay();
        for (ExamStudent student : ((Exam)placement.variable()).getStudents()) {
            examsThisPeriod = this.iStudentTable[period].get(student);
            examsThisPeriod.remove(placement.variable());
            if (examsThisPeriod.isEmpty()) {
                this.iStudentTable[period].remove(student);
            }
            examsThisDay = this.iStudentDayTable[day].get(student);
            examsThisDay.remove(placement.variable());
            if (!examsThisDay.isEmpty()) continue;
            this.iStudentDayTable[day].remove(student);
        }
        for (ExamInstructor instructor : ((Exam)placement.variable()).getInstructors()) {
            examsThisPeriod = this.iInstructorTable[period].get(instructor);
            examsThisPeriod.remove(placement.variable());
            if (examsThisPeriod.isEmpty()) {
                this.iInstructorTable[period].remove(instructor);
            }
            examsThisDay = this.iInstructorDayTable[day].get(instructor);
            examsThisDay.remove(placement.variable());
            if (!examsThisDay.isEmpty()) continue;
            this.iInstructorDayTable[day].remove(instructor);
        }
    }

    public Map<ExamStudent, Set<Exam>> getStudentsOfPeriod(int period) {
        return this.iStudentTable[period];
    }

    public Map<ExamStudent, Set<Exam>> getStudentsOfDay(int day) {
        return this.iStudentDayTable[day];
    }

    public Map<ExamInstructor, Set<Exam>> getInstructorsOfPeriod(int period) {
        return this.iInstructorTable[period];
    }

    public Map<ExamInstructor, Set<Exam>> getInstructorsOfDay(int day) {
        return this.iInstructorDayTable[day];
    }
}

