/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class AssignInitialSelection
extends BranchBoundSelection {
    public AssignInitialSelection(DataProperties properties) {
        super(properties);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Assign initial enrollments...");
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Student student = null;
        while ((student = this.nextStudent()) != null) {
            BranchBoundSelection.BranchBoundNeighbour neighbour;
            Progress.getInstance(solution.getModel()).incProgress();
            if (student.nrAssignedRequests(solution.getAssignment()) > 0 || (neighbour = new InitialSelection(student, solution.getAssignment()).select()) == null) continue;
            return neighbour;
        }
        return null;
    }

    public class InitialSelection
    extends BranchBoundSelection.Selection {
        public InitialSelection(Student student, Assignment<Request, Enrollment> assignment) {
            super(AssignInitialSelection.this, student, assignment);
        }

        @Override
        public void backTrack(int idx) {
            if (AssignInitialSelection.this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)AssignInitialSelection.this.iTimeout) {
                this.iTimeoutReached = true;
                return;
            }
            if (this.getBestAssignment() != null && this.getBound(idx) >= this.getBestValue()) {
                return;
            }
            if (idx == this.iAssignment.length) {
                if (this.getBestAssignment() == null || this.getValue() < this.getBestValue()) {
                    this.saveBest();
                }
                return;
            }
            Request request = this.iStudent.getRequests().get(idx);
            if (!this.canAssign(request, idx)) {
                this.backTrack(idx + 1);
                return;
            }
            if (request.isMPP()) {
                Enrollment initial = (Enrollment)request.getInitialAssignment();
                if (initial != null) {
                    if (!this.inConflict(idx, initial)) {
                        this.iAssignment[idx] = initial;
                        this.backTrack(idx + 1);
                        this.iAssignment[idx] = null;
                    }
                } else {
                    this.backTrack(idx + 1);
                }
            } else {
                this.backTrack(idx + 1);
            }
        }
    }
}

