/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;

public class RoomSplitPenalty
extends ExamCriterion {
    @Override
    public AbstractCriterion.ValueContext createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new RoomSplitContext(assignment);
    }

    @Override
    public String getWeightName() {
        return "Exams.RoomSplitWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "roomSplitWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 10.0;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        return value.getRoomPlacements() == null || value.getRoomPlacements().size() <= 1 ? 0 : (value.getRoomPlacements().size() - 1) * (value.getRoomPlacements().size() - 1);
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) != 0.0) {
            int[] roomSplits = ((RoomSplitContext)this.getContext((Assignment)assignment)).getRoomSplits();
            String split = "";
            for (int i = 0; i < roomSplits.length; ++i) {
                if (roomSplits[i] <= 0) continue;
                if (split.length() > 0) {
                    split = split + ", ";
                }
                split = split + roomSplits[i] + "&times;" + (i + 2);
            }
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment)) + " (" + split + ")");
        }
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "RSp:" + sDoubleFormat.format(this.getValue(assignment));
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }

    protected class RoomSplitContext
    extends AbstractCriterion.ValueContext {
        private int[] iRoomSplits;

        public RoomSplitContext(Assignment<Exam, ExamPlacement> assignment) {
            super(RoomSplitPenalty.this, assignment);
            this.iRoomSplits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            for (Exam exam : RoomSplitPenalty.this.getModel().variables()) {
                ExamPlacement placement = assignment.getValue(exam);
                if (placement == null || placement.getRoomPlacements() == null || placement.getRoomPlacements().size() <= 1) continue;
                int n = placement.getRoomPlacements().size() - 2;
                this.iRoomSplits[n] = this.iRoomSplits[n] + 1;
            }
        }

        public void assigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
            super.assigned(assignment, value);
            if (value.getRoomPlacements() != null && value.getRoomPlacements().size() > 1) {
                int n = value.getRoomPlacements().size() - 2;
                this.iRoomSplits[n] = this.iRoomSplits[n] + 1;
            }
        }

        public void unassigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
            super.unassigned(assignment, value);
            if (value.getRoomPlacements() != null && value.getRoomPlacements().size() > 1) {
                int n = value.getRoomPlacements().size() - 2;
                this.iRoomSplits[n] = this.iRoomSplits[n] - 1;
            }
        }

        public int[] getRoomSplits() {
            return this.iRoomSplits;
        }
    }
}

