/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.reservation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparable;
import org.cpsolver.ifs.assignment.context.AbstractClassWithContext;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;

public abstract class Reservation
extends AbstractClassWithContext<Request, Enrollment, ReservationContext>
implements AssignmentComparable<Reservation, Request, Enrollment>,
CanInheritContext<Request, Enrollment, ReservationContext> {
    private long iId = 0L;
    private boolean iExpired;
    private Offering iOffering;
    private Set<Config> iConfigs = new HashSet<Config>();
    private Map<Subpart, Set<Section>> iSections = new HashMap<Subpart, Set<Section>>();
    private int iPriority = 100;
    private boolean iMustBeUsed = false;
    private boolean iCanAssignOverLimit = false;
    private boolean iAllowOverlap = false;
    private boolean iAllowDisabled = false;
    private boolean iNeverIncluded = false;
    private boolean iBreakLinkedSections = false;
    private Double iCachedRestrictivity = null;
    private Double iLimitCap = null;

    public Reservation(long id, Offering offering, int priority, boolean mustBeUsed, boolean canAssignOverLimit, boolean allowOverlap) {
        this.iId = id;
        this.iOffering = offering;
        this.iOffering.getReservations().add(this);
        this.iOffering.clearReservationCache();
        this.iPriority = priority;
        this.iMustBeUsed = mustBeUsed;
        this.iCanAssignOverLimit = canAssignOverLimit;
        this.iAllowOverlap = allowOverlap;
    }

    public long getId() {
        return this.iId;
    }

    public abstract double getReservationLimit();

    public int getPriority() {
        return this.iPriority;
    }

    public void setPriority(int priority) {
        this.iPriority = priority;
    }

    public abstract boolean isApplicable(Student var1);

    public Offering getOffering() {
        return this.iOffering;
    }

    public Set<Config> getConfigs() {
        return this.iConfigs;
    }

    public void addConfig(Config config) {
        this.iConfigs.add(config);
        this.clearLimitCapCache();
    }

    public Map<Subpart, Set<Section>> getSections() {
        return this.iSections;
    }

    public Set<Section> getSections(Subpart subpart) {
        return this.iSections.get(subpart);
    }

    public void addSection(Section section, boolean inclusive) {
        if (inclusive) {
            this.addConfig(section.getSubpart().getConfig());
            while (section != null) {
                Set<Section> sections = this.iSections.get(section.getSubpart());
                if (sections == null) {
                    sections = new HashSet<Section>();
                    this.iSections.put(section.getSubpart(), sections);
                }
                sections.add(section);
                section = section.getParent();
            }
        } else {
            Set<Section> sections = this.iSections.get(section.getSubpart());
            if (sections == null) {
                sections = new HashSet<Section>();
                this.iSections.put(section.getSubpart(), sections);
            }
            sections.add(section);
        }
        this.clearLimitCapCache();
    }

    public void addSection(Section section) {
        this.addSection(section, true);
    }

    public boolean isIncluded(Enrollment enrollment) {
        if (this.neverIncluded()) {
            return false;
        }
        if (enrollment.getConfig() == null) {
            return false;
        }
        if (!this.iOffering.equals(enrollment.getConfig().getOffering())) {
            return false;
        }
        if (this.areRestrictionsInclusive()) {
            if (!this.iConfigs.isEmpty() && !this.iConfigs.contains(enrollment.getConfig())) {
                return false;
            }
            for (Section section : enrollment.getSections()) {
                Set<Section> sections = this.iSections.get(section.getSubpart());
                if (sections == null || sections.contains(section)) continue;
                return false;
            }
            return true;
        }
        if (this.iConfigs.isEmpty() && this.iSections.isEmpty()) {
            return true;
        }
        if (this.iConfigs.contains(enrollment.getConfig())) {
            return true;
        }
        for (Section section : enrollment.getSections()) {
            Set<Section> sections = this.iSections.get(section.getSubpart());
            if (sections == null || !sections.contains(section)) continue;
            return true;
        }
        return false;
    }

    public boolean canEnroll(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        if (!this.isApplicable(enrollment.getStudent())) {
            return false;
        }
        if (!this.isIncluded(enrollment)) {
            return false;
        }
        return this.getLimit() < 0.0 || ((ReservationContext)this.getContext(assignment)).getUsedSpace() + enrollment.getRequest().getWeight() <= this.getLimit();
    }

    public boolean canAssignOverLimit() {
        return this.iCanAssignOverLimit;
    }

    public boolean canBatchAssignOverLimit() {
        return this.canAssignOverLimit() && (this.iOffering.getModel() == null || ((StudentSectioningModel)this.iOffering.getModel()).getReservationCanAssignOverTheLimit());
    }

    public void setCanAssignOverLimit(boolean canAssignOverLimit) {
        this.iCanAssignOverLimit = canAssignOverLimit;
    }

    public boolean mustBeUsed() {
        return this.iMustBeUsed && !this.isExpired();
    }

    public boolean mustBeUsedIgnoreExpiration() {
        return this.iMustBeUsed;
    }

    public void setMustBeUsed(boolean mustBeUsed) {
        this.iMustBeUsed = mustBeUsed;
    }

    public double getRestrictivity() {
        if (this.iCachedRestrictivity == null) {
            boolean inclusive = this.areRestrictionsInclusive();
            if (this.getConfigs().isEmpty()) {
                return 1.0;
            }
            int nrChoices = 0;
            int nrMatchingChoices = 0;
            for (Config config : this.getOffering().getConfigs()) {
                int[] x = this.nrChoices(config, 0, new HashSet<Section>(), this.getConfigs().contains(config), inclusive);
                nrChoices += x[0];
                nrMatchingChoices += x[1];
            }
            this.iCachedRestrictivity = (double)nrMatchingChoices / (double)nrChoices;
        }
        return this.iCachedRestrictivity;
    }

    private int[] nrChoices(Config config, int idx, HashSet<Section> sections, boolean matching, boolean inclusive) {
        if (config.getSubparts().size() == idx) {
            return new int[]{1, matching ? 1 : 0};
        }
        Subpart subpart = config.getSubparts().get(idx);
        Set<Section> matchingSections = this.getSections(subpart);
        int choicesThisSubpart = 0;
        int matchingChoicesThisSubpart = 0;
        for (Section section : subpart.getSections()) {
            if (section.getParent() != null && !sections.contains(section.getParent()) || section.isOverlapping(sections)) continue;
            sections.add(section);
            boolean m = inclusive ? matching && (matchingSections == null || matchingSections.contains(section)) : matching || matchingSections != null && matchingSections.contains(section);
            int[] x = this.nrChoices(config, 1 + idx, sections, m, inclusive);
            choicesThisSubpart += x[0];
            matchingChoicesThisSubpart += x[1];
            sections.remove(section);
        }
        return new int[]{choicesThisSubpart, matchingChoicesThisSubpart};
    }

    @Override
    public int compareTo(Assignment<Request, Enrollment> assignment, Reservation r) {
        if (this.getPriority() != r.getPriority()) {
            return this.getPriority() < r.getPriority() ? -1 : 1;
        }
        int cmp = Double.compare(this.getRestrictivity(), r.getRestrictivity());
        if (cmp != 0) {
            return cmp;
        }
        cmp = -Double.compare(((ReservationContext)this.getContext(assignment)).getReservedAvailableSpace(assignment, null), ((ReservationContext)r.getContext(assignment)).getReservedAvailableSpace(assignment, null));
        if (cmp != 0) {
            return cmp;
        }
        return new Long(this.getId()).compareTo(r.getId());
    }

    @Override
    public int compareTo(Reservation r) {
        if (this.getPriority() != r.getPriority()) {
            return this.getPriority() < r.getPriority() ? -1 : 1;
        }
        int cmp = Double.compare(this.getRestrictivity(), r.getRestrictivity());
        if (cmp != 0) {
            return cmp;
        }
        return new Long(this.getId()).compareTo(r.getId());
    }

    private static double min(double l1, double l2) {
        return l1 < 0.0 ? l2 : (l2 < 0.0 ? l1 : Math.min(l1, l2));
    }

    private static double add(double l1, double l2) {
        return l1 < 0.0 ? -1.0 : (l2 < 0.0 ? -1.0 : l1 + l2);
    }

    public double getLimitCap() {
        if (this.iLimitCap == null) {
            this.iLimitCap = this.getLimitCapNoCache();
        }
        return this.iLimitCap;
    }

    public boolean areRestrictionsInclusive() {
        for (Map.Entry<Subpart, Set<Section>> entry : this.getSections().entrySet()) {
            if (!this.getConfigs().contains(entry.getKey().getConfig())) continue;
            return true;
        }
        return false;
    }

    private double getLimitCapNoCache() {
        if (this.getConfigs().isEmpty()) {
            return -1.0;
        }
        if (this.canAssignOverLimit()) {
            return -1.0;
        }
        double cap = 0.0;
        if (this.areRestrictionsInclusive()) {
            for (Config config : this.getConfigs()) {
                double configCap = config.getLimit();
                for (Map.Entry<Subpart, Set<Section>> entry : this.getSections().entrySet()) {
                    if (!config.equals(entry.getKey().getConfig())) continue;
                    Set<Section> sections = entry.getValue();
                    double subpartCap = 0.0;
                    for (Section section : sections) {
                        subpartCap = Reservation.add(subpartCap, section.getLimit());
                    }
                    configCap = Reservation.min(configCap, subpartCap);
                }
                cap = Reservation.add(cap, configCap);
            }
        } else {
            for (Config config : this.getConfigs()) {
                cap = Reservation.add(cap, config.getLimit());
            }
            for (Map.Entry entry : this.getSections().entrySet()) {
                Set sections = (Set)entry.getValue();
                double subpartCap = 0.0;
                for (Section section : sections) {
                    subpartCap = Reservation.add(subpartCap, section.getLimit());
                }
                cap = Reservation.add(cap, subpartCap);
            }
        }
        return cap;
    }

    private void clearLimitCapCache() {
        this.iLimitCap = null;
    }

    public double getLimit() {
        return Reservation.min(this.getLimitCap(), this.getReservationLimit());
    }

    public boolean isAllowOverlap() {
        return this.iAllowOverlap;
    }

    public void setAllowOverlap(boolean allowOverlap) {
        this.iAllowOverlap = allowOverlap;
    }

    public boolean isAllowDisabled() {
        return this.iAllowDisabled;
    }

    public void setAllowDisabled(boolean allowDisabled) {
        this.iAllowDisabled = allowDisabled;
    }

    public void setExpired(boolean expired) {
        this.iExpired = expired;
    }

    public boolean isExpired() {
        return this.iExpired;
    }

    public boolean neverIncluded() {
        return this.iNeverIncluded;
    }

    public void setNeverIncluded(boolean neverIncluded) {
        this.iNeverIncluded = neverIncluded;
    }

    public boolean canBreakLinkedSections() {
        return this.iBreakLinkedSections;
    }

    public void setBreakLinkedSections(boolean breakLinkedSections) {
        this.iBreakLinkedSections = breakLinkedSections;
    }

    @Override
    public Model<Request, Enrollment> getModel() {
        return this.getOffering().getModel();
    }

    public double getReservedAvailableSpace(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
        return ((ReservationContext)this.getContext(assignment)).getReservedAvailableSpace(assignment, excludeRequest);
    }

    public Set<Enrollment> getEnrollments(Assignment<Request, Enrollment> assignment) {
        return ((ReservationContext)this.getContext(assignment)).getEnrollments();
    }

    @Override
    public ReservationContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new ReservationContext(assignment);
    }

    @Override
    public ReservationContext inheritAssignmentContext(Assignment<Request, Enrollment> assignment, ReservationContext parentContext) {
        return new ReservationContext(parentContext);
    }

    public class ReservationContext
    implements AssignmentConstraintContext<Request, Enrollment> {
        private Set<Enrollment> iEnrollments = new HashSet<Enrollment>();
        private double iUsed = 0.0;
        private boolean iReadOnly = false;

        public ReservationContext(Assignment<Request, Enrollment> assignment) {
            for (Course course : Reservation.this.getOffering().getCourses()) {
                for (CourseRequest request : course.getRequests()) {
                    Enrollment enrollment = assignment.getValue(request);
                    if (enrollment == null || !Reservation.this.equals(enrollment.getReservation())) continue;
                    this.assigned(assignment, enrollment);
                }
            }
        }

        public ReservationContext(ReservationContext parent) {
            this.iUsed = parent.iUsed;
            this.iEnrollments = parent.iEnrollments;
            this.iReadOnly = true;
        }

        @Override
        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (this.iReadOnly) {
                this.iEnrollments = new HashSet<Enrollment>(this.iEnrollments);
                this.iReadOnly = false;
            }
            if (this.iEnrollments.add(enrollment)) {
                this.iUsed += enrollment.getRequest().getWeight();
            }
        }

        @Override
        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (this.iReadOnly) {
                this.iEnrollments = new HashSet<Enrollment>(this.iEnrollments);
                this.iReadOnly = false;
            }
            if (this.iEnrollments.remove(enrollment)) {
                this.iUsed -= enrollment.getRequest().getWeight();
            }
        }

        public Set<Enrollment> getEnrollments() {
            return this.iEnrollments;
        }

        public double getUsedSpace() {
            return this.iUsed;
        }

        public double getReservedAvailableSpace(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
            if (Reservation.this.getLimit() < 0.0) {
                return Double.MAX_VALUE;
            }
            double reserved = Reservation.this.getLimit() - ((ReservationContext)Reservation.this.getContext(assignment)).getUsedSpace();
            if (excludeRequest != null && assignment.getValue(excludeRequest) != null && this.iEnrollments.contains(assignment.getValue(excludeRequest))) {
                reserved += excludeRequest.getWeight();
            }
            return reserved;
        }
    }
}

