/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.extension;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.assignment.context.ExtensionWithContext;
import org.cpsolver.ifs.model.ModelListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;

public class DistanceConflict
extends ExtensionWithContext<Request, Enrollment, DistanceConflictContext>
implements ModelListener<Request, Enrollment>,
CanInheritContext<Request, Enrollment, DistanceConflictContext> {
    private static Logger sLog = Logger.getLogger(DistanceConflict.class);
    public static boolean sDebug = false;
    private DistanceMetric iDistanceMetric = null;
    private Map<Long, Map<Long, Integer>> iDistanceCache = new HashMap<Long, Map<Long, Integer>>();

    public DistanceConflict(Solver<Request, Enrollment> solver, DataProperties properties) {
        super(solver, properties);
        if (solver != null) {
            StudentSectioningModel model = (StudentSectioningModel)solver.currentSolution().getModel();
            this.iDistanceMetric = model.getDistanceMetric();
            model.setDistanceConflict(this);
        }
        if (this.iDistanceMetric == null) {
            this.iDistanceMetric = new DistanceMetric(properties);
        }
    }

    public DistanceConflict(DistanceMetric metrics, DataProperties properties) {
        super(null, properties);
        this.iDistanceMetric = metrics;
    }

    public String toString() {
        return "DistanceConstraint";
    }

    public DistanceMetric getDistanceMetric() {
        return this.iDistanceMetric;
    }

    protected synchronized int getDistanceInMinutes(RoomLocation r1, RoomLocation r2) {
        Integer distance;
        if (r1.getId().compareTo(r2.getId()) > 0) {
            return this.getDistanceInMinutes(r2, r1);
        }
        if (r1.getId().equals(r2.getId()) || r1.getIgnoreTooFar() || r2.getIgnoreTooFar()) {
            return 0;
        }
        if (r1.getPosX() == null || r1.getPosY() == null || r2.getPosX() == null || r2.getPosY() == null) {
            return this.iDistanceMetric.getMaxTravelDistanceInMinutes();
        }
        Map<Long, Integer> other2distance = this.iDistanceCache.get(r1.getId());
        if (other2distance == null) {
            other2distance = new HashMap<Long, Integer>();
            this.iDistanceCache.put(r1.getId(), other2distance);
        }
        if ((distance = other2distance.get(r2.getId())) == null) {
            distance = this.iDistanceMetric.getDistanceInMinutes(r1.getId(), r1.getPosX(), r1.getPosY(), r2.getId(), r2.getPosX(), r2.getPosY());
            other2distance.put(r2.getId(), distance);
        }
        return distance;
    }

    protected int getDistanceInMinutes(Placement p1, Placement p2) {
        if (p1.isMultiRoom()) {
            if (p2.isMultiRoom()) {
                int dist = 0;
                for (RoomLocation r1 : p1.getRoomLocations()) {
                    for (RoomLocation r2 : p2.getRoomLocations()) {
                        dist = Math.max(dist, this.getDistanceInMinutes(r1, r2));
                    }
                }
                return dist;
            }
            if (p2.getRoomLocation() == null) {
                return 0;
            }
            int dist = 0;
            for (RoomLocation r1 : p1.getRoomLocations()) {
                dist = Math.max(dist, this.getDistanceInMinutes(r1, p2.getRoomLocation()));
            }
            return dist;
        }
        if (p2.isMultiRoom()) {
            if (p1.getRoomLocation() == null) {
                return 0;
            }
            int dist = 0;
            for (RoomLocation r2 : p2.getRoomLocations()) {
                dist = Math.max(dist, this.getDistanceInMinutes(p1.getRoomLocation(), r2));
            }
            return dist;
        }
        if (p1.getRoomLocation() == null || p2.getRoomLocation() == null) {
            return 0;
        }
        return this.getDistanceInMinutes(p1.getRoomLocation(), p2.getRoomLocation());
    }

    public boolean inConflict(Student student, Section s1, Section s2) {
        int dist;
        TimeLocation t2;
        if (s1.getPlacement() == null || s2.getPlacement() == null) {
            return false;
        }
        TimeLocation t1 = s1.getTime();
        if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getStartSlot();
        int a2 = t2.getStartSlot();
        if (student.isNeedShortDistances()) {
            int dist2;
            return this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses() ? (a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist2 = this.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = this.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength())) : (a1 + t1.getNrSlotsPerMeeting() == a2 ? (dist = this.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > 0 : a2 + t2.getNrSlotsPerMeeting() == a1 && (dist = this.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > 0);
        }
        return this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses() ? (a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist = this.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = this.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength())) : (a1 + t1.getNrSlotsPerMeeting() == a2 ? (dist = this.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > t1.getBreakTime() : a2 + t2.getNrSlotsPerMeeting() == a1 && (dist = this.getDistanceInMinutes(s1.getPlacement(), s2.getPlacement())) > t2.getBreakTime());
    }

    public int nrConflicts(Enrollment e1) {
        if (!e1.isCourseRequest()) {
            return 0;
        }
        int cnt = 0;
        for (Section s1 : e1.getSections()) {
            for (Section s2 : e1.getSections()) {
                if (s1.getId() >= s2.getId() || !this.inConflict(e1.getStudent(), s1, s2)) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    public int nrConflicts(Enrollment e1, Enrollment e2) {
        if (!(e1.isCourseRequest() && e2.isCourseRequest() && e1.getStudent().equals(e2.getStudent()))) {
            return 0;
        }
        int cnt = 0;
        for (Section s1 : e1.getSections()) {
            for (Section s2 : e2.getSections()) {
                if (!this.inConflict(e1.getStudent(), s1, s2)) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    public Set<Conflict> conflicts(Enrollment e1) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        if (!e1.isCourseRequest()) {
            return ret;
        }
        for (Section s1 : e1.getSections()) {
            for (Section s2 : e1.getSections()) {
                if (s1.getId() >= s2.getId() || !this.inConflict(e1.getStudent(), s1, s2)) continue;
                ret.add(new Conflict(e1.getStudent(), e1, s1, e1, s2));
            }
        }
        return ret;
    }

    public Set<Conflict> conflicts(Enrollment e1, Enrollment e2) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        if (!(e1.isCourseRequest() && e2.isCourseRequest() && e1.getStudent().equals(e2.getStudent()))) {
            return ret;
        }
        for (Section s1 : e1.getSections()) {
            for (Section s2 : e2.getSections()) {
                if (!this.inConflict(e1.getStudent(), s1, s2)) continue;
                ret.add(new Conflict(e1.getStudent(), e1, s1, e2, s2));
            }
        }
        return ret;
    }

    public Set<Conflict> allConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        Set<Conflict> ret = this.conflicts(enrollment);
        if (!enrollment.isCourseRequest()) {
            return ret;
        }
        for (Request request : enrollment.getStudent().getRequests()) {
            if (request.equals(enrollment.getRequest()) || assignment.getValue(request) == null) continue;
            ret.addAll(this.conflicts(enrollment, assignment.getValue(request)));
        }
        return ret;
    }

    public void checkAllConflicts(Assignment<Request, Enrollment> assignment) {
        ((DistanceConflictContext)this.getContext(assignment)).checkAllConflicts(assignment);
    }

    public int getTotalNrConflicts(Assignment<Request, Enrollment> assignment) {
        return ((DistanceConflictContext)this.getContext(assignment)).getTotalNrConflicts();
    }

    public int getTotalNrShortConflicts(Assignment<Request, Enrollment> assignment) {
        return ((DistanceConflictContext)this.getContext(assignment)).getTotalNrShortConflicts();
    }

    public int countTotalNrConflicts(Assignment<Request, Enrollment> assignment) {
        int total = 0;
        for (Request r1 : this.getModel().variables()) {
            if (assignment.getValue(r1) == null || !(r1 instanceof CourseRequest)) continue;
            Enrollment e1 = assignment.getValue(r1);
            total += this.nrConflicts(e1);
            for (Request r2 : r1.getStudent().getRequests()) {
                Enrollment e2 = assignment.getValue(r2);
                if (e2 == null || r1.getId() >= r2.getId() || !(r2 instanceof CourseRequest)) continue;
                total += this.nrConflicts(e1, e2);
            }
        }
        return total;
    }

    public Set<Conflict> computeAllConflicts(Assignment<Request, Enrollment> assignment) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        for (Request r1 : this.getModel().variables()) {
            Enrollment e1 = assignment.getValue(r1);
            if (e1 == null || !(r1 instanceof CourseRequest)) continue;
            ret.addAll(this.conflicts(e1));
            for (Request r2 : r1.getStudent().getRequests()) {
                Enrollment e2 = assignment.getValue(r2);
                if (e2 == null || r1.getId() >= r2.getId() || !(r2 instanceof CourseRequest)) continue;
                ret.addAll(this.conflicts(e1, e2));
            }
        }
        return ret;
    }

    public Set<Conflict> getAllConflicts(Assignment<Request, Enrollment> assignment) {
        return ((DistanceConflictContext)this.getContext(assignment)).getAllConflicts();
    }

    @Override
    public void beforeAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
        ((DistanceConflictContext)this.getContext(assignment)).beforeAssigned(assignment, iteration, value);
    }

    @Override
    public void afterAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
        ((DistanceConflictContext)this.getContext(assignment)).afterAssigned(assignment, iteration, value);
    }

    @Override
    public void afterUnassigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
        ((DistanceConflictContext)this.getContext(assignment)).afterUnassigned(assignment, iteration, value);
    }

    @Override
    public DistanceConflictContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new DistanceConflictContext(assignment);
    }

    @Override
    public DistanceConflictContext inheritAssignmentContext(Assignment<Request, Enrollment> assignment, DistanceConflictContext parentContext) {
        return new DistanceConflictContext(parentContext);
    }

    public class DistanceConflictContext
    implements AssignmentConstraintContext<Request, Enrollment> {
        private Set<Conflict> iAllConflicts = new HashSet<Conflict>();
        private Request iOldVariable = null;
        private Enrollment iUnassignedValue = null;

        public DistanceConflictContext(Assignment<Request, Enrollment> assignment) {
            this.iAllConflicts = DistanceConflict.this.computeAllConflicts(assignment);
            StudentSectioningModel.StudentSectioningModelContext cx = (StudentSectioningModel.StudentSectioningModelContext)((StudentSectioningModel)DistanceConflict.this.getModel()).getContext((Assignment)assignment);
            for (Conflict c : this.iAllConflicts) {
                cx.add(assignment, c);
            }
        }

        public DistanceConflictContext(DistanceConflictContext parent) {
            this.iAllConflicts.addAll(parent.iAllConflicts);
            this.iOldVariable = parent.iOldVariable;
            this.iUnassignedValue = parent.iUnassignedValue;
        }

        public void beforeAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
            if (value != null) {
                Enrollment old = assignment.getValue((Request)value.variable());
                if (old != null) {
                    this.unassigned(assignment, old);
                    this.iUnassignedValue = old;
                }
                this.iOldVariable = (Request)value.variable();
            }
        }

        public void afterAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
            this.iOldVariable = null;
            this.iUnassignedValue = null;
            if (value != null) {
                this.assigned(assignment, value);
            }
        }

        public void afterUnassigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
            if (value != null && !value.equals(this.iUnassignedValue)) {
                this.unassigned(assignment, value);
            }
        }

        @Override
        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment value) {
            StudentSectioningModel.StudentSectioningModelContext cx = (StudentSectioningModel.StudentSectioningModelContext)((StudentSectioningModel)DistanceConflict.this.getModel()).getContext((Assignment)assignment);
            for (Conflict c : DistanceConflict.this.allConflicts(assignment, value)) {
                if (!this.iAllConflicts.add(c)) continue;
                cx.add(assignment, c);
            }
            if (sDebug) {
                sLog.debug((Object)("A:" + value.variable() + " := " + value));
                int inc = DistanceConflict.this.nrConflicts(value);
                if (inc != 0) {
                    sLog.debug((Object)("-- DC+" + inc + " A: " + value.variable() + " := " + value));
                    Iterator<Conflict> i = DistanceConflict.this.allConflicts(assignment, value).iterator();
                    while (i.hasNext()) {
                        sLog.debug((Object)("  -- " + i.next()));
                    }
                }
            }
        }

        @Override
        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment value) {
            if (((Request)value.variable()).equals(this.iOldVariable)) {
                return;
            }
            StudentSectioningModel.StudentSectioningModelContext cx = (StudentSectioningModel.StudentSectioningModelContext)((StudentSectioningModel)DistanceConflict.this.getModel()).getContext((Assignment)assignment);
            for (Conflict c : DistanceConflict.this.allConflicts(assignment, value)) {
                if (!this.iAllConflicts.remove(c)) continue;
                cx.remove(assignment, c);
            }
            if (sDebug) {
                sLog.debug((Object)("U:" + value.variable() + " := " + value));
                int dec = this.nrAllConflicts(assignment, value);
                if (dec != 0) {
                    sLog.debug((Object)("-- DC+" + dec + " U: " + value.variable() + " := " + value));
                    Set<Conflict> confs = DistanceConflict.this.allConflicts(assignment, value);
                    Iterator<Conflict> i = confs.iterator();
                    while (i.hasNext()) {
                        sLog.debug((Object)("  -- " + i.next()));
                    }
                }
            }
        }

        public void checkAllConflicts(Assignment<Request, Enrollment> assignment) {
            Set<Conflict> allConfs = DistanceConflict.this.computeAllConflicts(assignment);
            if (this.iAllConflicts.size() != allConfs.size()) {
                sLog.error((Object)("Different number of conflicts " + this.iAllConflicts.size() + "!=" + allConfs.size()));
                for (Conflict c : allConfs) {
                    if (this.iAllConflicts.contains(c)) continue;
                    sLog.debug((Object)("  +add+ " + c));
                }
                for (Conflict c : this.iAllConflicts) {
                    if (allConfs.contains(c)) continue;
                    sLog.debug((Object)("  -rem- " + c));
                }
                this.iAllConflicts = allConfs;
            }
        }

        public int getTotalNrConflicts() {
            return this.iAllConflicts.size();
        }

        public int getTotalNrShortConflicts() {
            int ret = 0;
            for (Conflict c : this.iAllConflicts) {
                if (!c.getStudent().isNeedShortDistances()) continue;
                ++ret;
            }
            return ret;
        }

        public Set<Conflict> getAllConflicts() {
            return this.iAllConflicts;
        }

        public int nrAllConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (!enrollment.isCourseRequest()) {
                return 0;
            }
            int cnt = DistanceConflict.this.nrConflicts(enrollment);
            Request old = this.iOldVariable;
            for (Request request : enrollment.getStudent().getRequests()) {
                if (request.equals(enrollment.getRequest()) || assignment.getValue(request) == null || request.equals(old)) continue;
                cnt += DistanceConflict.this.nrConflicts(enrollment, assignment.getValue(request));
            }
            return cnt;
        }
    }

    public static class Conflict {
        private Student iStudent;
        private Section iS1;
        private Section iS2;
        private Enrollment iE1;
        private Enrollment iE2;
        private int iHashCode;

        public Conflict(Student student, Enrollment e1, Section s1, Enrollment e2, Section s2) {
            this.iStudent = student;
            if (s1.getId() < s2.getId()) {
                this.iS1 = s1;
                this.iS2 = s2;
                this.iE1 = e1;
                this.iE2 = e2;
            } else {
                this.iS1 = s2;
                this.iS2 = s1;
                this.iE1 = e2;
                this.iE2 = e1;
            }
            this.iHashCode = (this.iStudent.getId() + ":" + this.iS1.getId() + ":" + this.iS2.getId()).hashCode();
        }

        public Student getStudent() {
            return this.iStudent;
        }

        public Section getS1() {
            return this.iS1;
        }

        public Section getS2() {
            return this.iS2;
        }

        public Request getR1() {
            return this.iE1.getRequest();
        }

        public Request getR2() {
            return this.iE2.getRequest();
        }

        public Enrollment getE1() {
            return this.iE1;
        }

        public Enrollment getE2() {
            return this.iE2;
        }

        public int hashCode() {
            return this.iHashCode;
        }

        public double getDistance(DistanceMetric dm) {
            return Placement.getDistanceInMeters(dm, this.getS1().getPlacement(), this.getS2().getPlacement());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Conflict)) {
                return false;
            }
            Conflict c = (Conflict)o;
            return this.getStudent().equals(c.getStudent()) && this.getS1().equals(c.getS1()) && this.getS2().equals(c.getS2());
        }

        public String toString() {
            return this.getStudent() + ": " + this.getS1() + " -- " + this.getS2();
        }
    }
}

