/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.csp;

import org.apache.log4j.BasicConfigurator;
import org.cpsolver.ifs.example.csp.CSPModel;
import org.cpsolver.ifs.example.csp.CSPValue;
import org.cpsolver.ifs.example.csp.CSPVariable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class SimpleTest {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        int nrVariables = 25;
        int nrValues = 12;
        int nrConstraints = 198;
        double tigtness = 0.25;
        int nrAllPairs = nrValues * nrValues;
        int nrCompatiblePairs = (int)((1.0 - tigtness) * (double)nrAllPairs);
        long seed = System.currentTimeMillis();
        System.out.println("CSP(" + nrVariables + "," + nrValues + "," + nrConstraints + "/" + nrVariables * (nrVariables - 1) / 2 + "," + (nrAllPairs - nrCompatiblePairs) + "/" + nrAllPairs + ")");
        DataProperties cfg = new DataProperties();
        cfg.setProperty("Termination.Class", "org.cpsolver.ifs.termination.GeneralTerminationCondition");
        cfg.setProperty("Termination.StopWhenComplete", "false");
        cfg.setProperty("Termination.TimeOut", "60");
        cfg.setProperty("Comparator.Class", "org.cpsolver.ifs.solution.GeneralSolutionComparator");
        cfg.setProperty("Value.Class", "org.cpsolver.ifs.heuristics.GeneralValueSelection");
        cfg.setProperty("Value.WeightConflicts", "1");
        cfg.setProperty("Variable.Class", "org.cpsolver.ifs.heuristics.GeneralVariableSelection");
        cfg.setProperty("Extensions.Classes", "org.cpsolver.ifs.extension.ConflictStatistics");
        CSPModel model = new CSPModel(nrVariables, nrValues, nrConstraints, nrCompatiblePairs, seed);
        Solver<CSPVariable, CSPValue> solver = new Solver<CSPVariable, CSPValue>(cfg);
        solver.setInitalSolution(model);
        solver.start();
        try {
            solver.getSolverThread().join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Solution solution = solver.lastSolution();
        solution.restoreBest();
        System.out.println("Best solution found after " + solution.getBestTime() + " seconds (" + solution.getBestIteration() + " iterations).");
        System.out.println("Number of assigned variables is " + solution.getAssignment().nrAssignedVariables());
        System.out.println("Total value of the solution is " + solution.getModel().getTotalValue(solution.getAssignment()));
        int idx = 1;
        for (CSPVariable v : solution.getModel().variables()) {
            CSPValue a = (CSPValue)solution.getAssignment().getValue(v);
            if (a == null) continue;
            System.out.println("Var" + idx++ + "=" + a.toDouble());
        }
    }
}

